static char SCCSID[] = "@(#)filledpoly.c	1.1 89/02/08";
/*
 * Copyright 1989 Siemens
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Siemens not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Siemens makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Claus Gittinger, Siemens Munich, unido!sinix!claus@uunet.uu.net
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "externals.h"

static GC drawWhite, drawBlack;

#define NPOINT  5
XPoint  points[NPOINT];

/*
 * filled polygons
 */
filledpoly_setup(dpy, win, vertlen)
Display *dpy;
Window win;
{
	int screen = DefaultScreen(dpy);

	drawWhite = XCreateGC(dpy, win, 0L, NULL);
	if (! drawWhite) return 1;
	XSetForeground(dpy, drawWhite, WhitePixel(dpy, screen));
	XSetBackground(dpy, drawWhite, BlackPixel(dpy, screen));

	drawBlack = XCreateGC(dpy, win, 0L, NULL);
	if (!drawBlack) return 1;
	XSetForeground(dpy, drawBlack, BlackPixel(dpy, screen));
	XSetBackground(dpy, drawBlack, WhitePixel(dpy, screen));

	points[0].x = vertlen/2;
	points[0].y = 0;

	points[1].x = 0;
	points[1].y = vertlen/2;

	points[2].x = 0;
	points[2].y = vertlen + vertlen/2;

	points[3].x = vertlen;
	points[3].y = vertlen + vertlen/2;

	points[4].x = vertlen;
	points[4].y = vertlen/2;

	return 0;
}

filledpoly_cleanup(dpy, win, dummy)
Display *dpy;
Window win;
{
	XFreeGC(dpy, drawWhite);
	XFreeGC(dpy, drawBlack);
}

filledpoly_bench(dpy, win, dummy)
Display *dpy;
Window win;
{
	int npoly;

	npoly = 0;
	while (benchRunning) {
	    XFillPolygon(dpy, win, drawWhite, points, NPOINT,
				       Convex, CoordModeOrigin);
	    XFillPolygon(dpy, win, drawBlack, points, NPOINT,
				       Convex, CoordModeOrigin);
	    if (sync) XSync(dpy, 0);
	    npoly += 2;
	}
	return npoly;
}

filledpoly_msg(deltaT, npoly, len, rate)
double rate;
{
	printf("FILLED POLYGONS\n");
	printf("\n");
	printf("%d filled polygons with %d points (size %d) in %d secs\n",
				npoly, NPOINT, len, deltaT);
	printf("rate = %8.2f filled polygons/sec\n", rate);
}
