/* cmdtab.c */

#include "sys.h"
#include <sys/types.h>
#include <sys/time.h>
#include "ftpdefs.h"
#include "cmds.h"
#include "main.h"
#include "ftp.h"
#include "ftprc.h"
#include "glob.h"
#include "copyright.h"

char	asciihelp[] = 	"transfer as text files";
char	binaryhelp[] =	"transfer as binary files";
char	cdhelp[] =		"change remote working directory";
char	cduphelp[] = 	"change remote working directory to parent directory";
char	createhelp[] =	"create an empty file on the remote host";
char	deletehelp[] =	"delete remote file";
char	debughelp[] =	"toggle/set debugging mode";
char	dirhelp[] =		"list contents of remote directory";
char	disconhelp[] =	"terminate ftp session";
char	domachelp[] = 	"execute macro";
char	helphelp[] =	"print local help information";
char	lcdhelp[] =		"change local working directory";
char	lshelp[] =		"list contents of remote directory";
char	lookuphelp[] =	"print IP addr given name, or name given IP";
char	macdefhelp[] =  "define a macro";
char	mdeletehelp[] =	"delete multiple files";
char	mdirhelp[] =	"list contents of multiple remote directories";
char	mgethelp[] =	"get multiple files";
char	mkdirhelp[] =	"make directory on the remote machine";
char	mlshelp[] =		"nlist contents of multiple remote directories";
char	modtimehelp[] = "show last modification time of remote file";
char	mputhelp[] =	"send multiple files";
char	openhelp[] =	"connect to remote ftp server (type 'open' for usage)";
char	pagehelp[] =	"display a remote file on your terminal";
char	plshelp[] =     "view contents of remote directory using your PAGER";
char	prompthelp[] =	"force interactive prompting on multiple commands";
char	pwdhelp[] =		"print working directory on remote machine";
char	quithelp[] =	"terminate ftp session and exit";
char	quotehelp[] =	"send arbitrary ftp command";
char	receivehelp[] =	"receive file";
#ifdef REDIR
char	predirhelp[] =	"view last ls, dir, list, or nlist with your PAGER";
char 	redirhelp[] = 	"re-show last ls, dir, list, or nlist.";
#endif
char	remotehelp[] =	"get help from remote server";
char	renamehelp[] =	"rename file";
char	rmdirhelp[] =	"remove directory on the remote machine";
char	rmtstatushelp[]="show status of remote machine";
char	sendhelp[] =	"send one file";
char	sethelp[] =		"set a variable's value; set alone shows all variables";
char	shellhelp[] =	"escape to the shell";
char	sizecmdhelp[] = "show size of remote file";
char	systemhelp[] =  "show remote system type";
char	typehelp[] =	"specify how to transfer files (ascii/binary)";
char	unsethelp[] =	"undefine a variable's value";
char	userhelp[] =	"send new user information";
char	verbosehelp[] =	"toggle verbose mode";
char	versionhelp[] =	"shows version information";
#ifdef TERM
char    compresshelp[]= "toggle term's compression mode";
#endif

struct cmd cmdtab[] = {
	/* name ; help ; bell-when-done ; must-be-connected ; proxy can ; hidden */
	{ "!",			shellhelp,			0,	0,	0,	0,	shell },
	{ "$",			domachelp,			1,	0,	0,	0,	domacro },
	{ "ascii",		asciihelp,			0,	1,	0,	1,	setascii },
	{ "binary",		binaryhelp,			0,	1,	0,	1,	setbinary },
	{ "bye",		quithelp,			0,	0,	0,	1,	quit },
	{ "cd",			cdhelp,				0,	1,	1,	0,	cd },
	{ "cdup",		cduphelp,			0,	1,	1,	0,	cdup },
	{ "chdir",		cdhelp,				0,	1,	1,	1,	cd },
	{ "close",		disconhelp,			0,	1,	1,	1,	disconnect },
#ifdef TERM
	{ "compress",           compresshelp,                   0,      0,      0,      0,      toggle_compress },
#endif
	{ "connect",	openhelp,			0,	0,	1,	1,	setpeer },
	{ "create",		createhelp,			0,	1,	0,	0,	create },
	{ "delete",		deletehelp,			0,	1,	1,	0,	do_delete },
	{ "debug",		debughelp,			0,	0,	0,	1,	setdebug },
	{ "erase",		deletehelp,			0,	1,	1,	1,	do_delete },
	{ "exit",		quithelp,			0,	0,	0,	1,	quit },
	{ "dir",		dirhelp,			1,	1,	1,	0,	ls },
	{ "get",		receivehelp,		1,	1,	1,	0,	get },
	{ "help",		helphelp,			0,	0,	1,	0,	help },
	{ "image",		binaryhelp,			0,	1,	0,	1,	setbinary },
	{ "lcd",		lcdhelp,			0,	0,	0,	0,	lcd },
	{ "lookup", 	lookuphelp, 		0,	0,	0,	0,  lookup },
	{ "ls",			lshelp,				1,	1,	1,	0,	ls },
	{ "macdef",		macdefhelp,			0,	0,	0,	0,	macdef },
	{ "mdelete",	mdeletehelp,		1,	1,	1,	0,	mdelete },
	{ "mdir",		mdirhelp,			1,	1,	1,	0,	mls },
	{ "mget",		mgethelp,			1,	1,	1,	0,	mget },
	{ "mkdir",		mkdirhelp,			0,	1,	1,	0,	makedir },
	{ "mls",		mlshelp,			1,	1,	1,	0,	mls },
	{ "modtime",	modtimehelp,		0,	1,	1,	0,	modtime },
	{ "more",       pagehelp,           1,  1,  1,  1,  get },
	{ "mput",		mputhelp,			1,	1,	1,	0,	mput },
	{ "nlist",		lshelp,				1,	1,	1,	1,	ls },
	{ "open",		openhelp,			0,	0,	1,	0,	setpeer },
	{ "page",		pagehelp,			1,	1,	1,	0,	get },
	{ "pdir",		plshelp,			1,	1,	1,	0,	ls },
	{ "pls",		plshelp,			1,	1,	1,	0,	ls },
#ifdef REDIR
	{ "predir",  	predirhelp,  		0, 	1, 	0,	0,	showlsbuffer },
#endif
	{ "prompt",		prompthelp,			0,	0,	0,	1,	setprompt },
	{ "put",		sendhelp,			1,	1,	1,	0,	put },
	{ "pwd",		pwdhelp,			0,	1,	1,	0,	pwd },
	{ "quit",		quithelp,			0,	0,	0,	0,	quit },
	{ "quote",		quotehelp,			1,	1,	1,	0,	quote },
#ifdef REDIR
	{ "redir",  	redirhelp,  		0, 	1, 	0,	0,	showlsbuffer },
#endif
	{ "remotehelp",	remotehelp,			0,	1,	1,	0,	rmthelp },
	{ "rm",			deletehelp,			0,	1,	1,	1,	do_delete },
	{ "rstatus",	rmtstatushelp,		0,	1,	1,	0,	rmtstatus },
	{ "rhelp",		remotehelp,			0,	1,	1,	0,	rmthelp },
	{ "rename",		renamehelp,			0,	1,	1,	0,	renamefile },
	{ "rmdir",		rmdirhelp,			0,	1,	1,	0,	removedir },
	{ "send",		sendhelp,			1,	1,	1,	1,	put },
	{ "set",		sethelp,			0,	0,	0,	0,	set },
	{ "size",		sizecmdhelp,		1,	1,	1,	0,	sizecmd },
	{ "system",		systemhelp,			0,	1,	1,	0,	syst },
	{ "unset",		unsethelp,			0,	0,	0,	0,	set },
	{ "user",		userhelp,			0,	1,	1,	0,	do_user },
	{ "type",		typehelp,			0,	1,	0,	0,	settype },
	{ "verbose",	verbosehelp,		0,	0,	0,	0,	setverbose },
	{ "version",	versionhelp,		0,	0,	0,	0,	show_version },
	{ "?",			helphelp,			0,	0,	1,	0,	help },
	{ NULL,			NULL,				0,	0,	0,	0,	NULL }
};

int	NCMDS = (sizeof (cmdtab) / sizeof (cmdtab[0])) - 1;

/* eof cmdtab.c */
