--- oldftp.c   Fri Jan 29 21:50:13 1993
+++ newftp.c   Fri Sep  3 20:16:50 1993
@@ -1316,8 +1316,9 @@
 
 
 #ifdef TERM
 
+#ifdef TERMPROXY
 
 /*
  * Need to start a listen on the data channel
  * before we send the command, otherwise the
@@ -1366,8 +1367,98 @@
 {
         return (fdopen(data, lmode));
 }
 
+#else /* TERMPROXY */
+
+/* Need to open a new listening port. This requires C_BINDN. 
+ * No provision for *not* giving each new connection a new PORT. -ot 
+ */
+
+int pending = -1;
+
+initconn()
+{
+      int s, p;
+      char port[64] = "PORT ";
+      
+      if (data != -1)
+              (void) close(data);
+      data = -1;
+      if (pending != -1)
+              (void) close(pending);
+      
+      lcompression = rcompression = compress_toggle;
+      if (debug)
+              printf("initconn...-");
+
+      if ((s = connect_server(0)) < 0) {
+              perror("initconn: connect to term server");
+              return 1;
+      }
+      if (debug)
+              printf("\b/");
+      if (send_command(s, C_BINDN, 0, 0, 0) < 0) {
+              printf("initconn:C_BINDN: %s\n", command_result);
+              return 1; 
+      }
+      if (debug)
+              printf("\b \n");
+      if (read(s, port+5, 58)<0) {
+              perror("initconn:read port");
+              return 1;
+      }
+      if ((p=command(port)) != COMPLETE) {
+              fprintf(stderr, "initconn:PORT command failed: %u\n", p);
+              return 1;
+      }
+      if (debug)
+              printf(" ...done\n");
+
+      pending = s;
+      return 0;
+}
+
+FILE *
+dataconn(lmode)
+      char *lmode;
+{
+      int s, p;
+      char port[10];
+      if (pending == -1) {
+              fprintf(stderr,"dataconn: bogus pending\n");
+              return NULL;
+      }
+      if (debug)
+              printf("Server connecting...-");
+      if (read(pending, port, 10)<0) {
+              perror("dataconn:read-accept");
+              return NULL;
+      }
+      p = atoi(port);
+      if (debug)
+              printf("\b/");
+      if ((s = connect_server(0)) < 0) {
+              perror("dataconn: connect to term server");
+              return NULL;
+      }
+      if (debug)
+              printf("\b|");
+      if (send_command(s, C_ACCEPT, 0, "%d", p) < 0) {
+              fprintf(stderr, "dataconn:C_ACCEPT: %s\n", command_result);
+              return NULL;
+      }
+
+      (void) close(pending);
+      pending = -1;
+      data = s;
+      if (debug)
+              printf("\b done\n");
+      return (fdopen(data, lmode));
+}
+
+#endif /* TERMPROXY */
+
 #else /* TERM */
 
 initconn(void)
 {
