/*
 * SMU_7_1_1 Register documentation
 *
 * Copyright (C) 2014  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef SMU_7_1_1_D_H
#define SMU_7_1_1_D_H

#define mmGCK_SMC_IND_INDEX                                                     0x80
#define mmGCK0_GCK_SMC_IND_INDEX                                                0x80
#define mmGCK1_GCK_SMC_IND_INDEX                                                0x82
#define mmGCK2_GCK_SMC_IND_INDEX                                                0x84
#define mmGCK3_GCK_SMC_IND_INDEX                                                0x86
#define mmGCK_SMC_IND_DATA                                                      0x81
#define mmGCK0_GCK_SMC_IND_DATA                                                 0x81
#define mmGCK1_GCK_SMC_IND_DATA                                                 0x83
#define mmGCK2_GCK_SMC_IND_DATA                                                 0x85
#define mmGCK3_GCK_SMC_IND_DATA                                                 0x87
#define ixCG_DCLK_CNTL                                                          0xc050009c
#define ixCG_DCLK_STATUS                                                        0xc05000a0
#define ixCG_VCLK_CNTL                                                          0xc05000a4
#define ixCG_VCLK_STATUS                                                        0xc05000a8
#define ixCG_ECLK_CNTL                                                          0xc05000ac
#define ixCG_ECLK_STATUS                                                        0xc05000b0
#define ixCG_ACLK_CNTL                                                          0xc05000dc
#define ixGCK_DFS_BYPASS_CNTL                                                   0xc0500118
#define ixCG_SPLL_FUNC_CNTL                                                     0xc0500140
#define ixCG_SPLL_FUNC_CNTL_2                                                   0xc0500144
#define ixCG_SPLL_FUNC_CNTL_3                                                   0xc0500148
#define ixCG_SPLL_FUNC_CNTL_4                                                   0xc050014c
#define ixCG_SPLL_FUNC_CNTL_5                                                   0xc0500150
#define ixCG_SPLL_FUNC_CNTL_6                                                   0xc0500154
#define ixCG_SPLL_FUNC_CNTL_7                                                   0xc0500158
#define ixSPLL_CNTL_MODE                                                        0xc0500160
#define ixCG_SPLL_SPREAD_SPECTRUM                                               0xc0500164
#define ixCG_SPLL_SPREAD_SPECTRUM_2                                             0xc0500168
#define ixMPLL_BYPASSCLK_SEL                                                    0xc050019c
#define ixCG_CLKPIN_CNTL                                                        0xc05001a0
#define ixCG_CLKPIN_CNTL_2                                                      0xc05001a4
#define ixCG_CLKPIN_CNTL_DC                                                     0xc0500204
#define ixTHM_CLK_CNTL                                                          0xc05001a8
#define ixMISC_CLK_CTRL                                                         0xc05001ac
#define ixGCK_PLL_TEST_CNTL                                                     0xc05001c0
#define ixGCK_PLL_TEST_CNTL_2                                                   0xc05001c4
#define ixGCK_ADFS_CLK_BYPASS_CNTL1                                             0xc05001c8
#define mmSMC_IND_INDEX                                                         0x80
#define mmSMC0_SMC_IND_INDEX                                                    0x80
#define mmSMC1_SMC_IND_INDEX                                                    0x82
#define mmSMC2_SMC_IND_INDEX                                                    0x84
#define mmSMC3_SMC_IND_INDEX                                                    0x86
#define mmSMC_IND_DATA                                                          0x81
#define mmSMC0_SMC_IND_DATA                                                     0x81
#define mmSMC1_SMC_IND_DATA                                                     0x83
#define mmSMC2_SMC_IND_DATA                                                     0x85
#define mmSMC3_SMC_IND_DATA                                                     0x87
#define mmSMC_IND_INDEX_0                                                       0x80
#define mmSMC_IND_DATA_0                                                        0x81
#define mmSMC_IND_INDEX_1                                                       0x82
#define mmSMC_IND_DATA_1                                                        0x83
#define mmSMC_IND_INDEX_2                                                       0x84
#define mmSMC_IND_DATA_2                                                        0x85
#define mmSMC_IND_INDEX_3                                                       0x86
#define mmSMC_IND_DATA_3                                                        0x87
#define mmSMC_IND_INDEX_4                                                       0x88
#define mmSMC_IND_DATA_4                                                        0x89
#define mmSMC_IND_INDEX_5                                                       0x8a
#define mmSMC_IND_DATA_5                                                        0x8b
#define mmSMC_IND_INDEX_6                                                       0x8c
#define mmSMC_IND_DATA_6                                                        0x8d
#define mmSMC_IND_INDEX_7                                                       0x8e
#define mmSMC_IND_DATA_7                                                        0x8f
#define mmSMC_IND_ACCESS_CNTL                                                   0x92
#define mmSMC_MESSAGE_0                                                         0x94
#define mmSMC_RESP_0                                                            0x95
#define mmSMC_MESSAGE_1                                                         0x96
#define mmSMC_RESP_1                                                            0x97
#define mmSMC_MESSAGE_2                                                         0x98
#define mmSMC_RESP_2                                                            0x99
#define mmSMC_MESSAGE_3                                                         0x9a
#define mmSMC_RESP_3                                                            0x9b
#define mmSMC_MESSAGE_4                                                         0x9c
#define mmSMC_RESP_4                                                            0x9d
#define mmSMC_MESSAGE_5                                                         0x9e
#define mmSMC_RESP_5                                                            0x9f
#define mmSMC_MESSAGE_6                                                         0xa0
#define mmSMC_RESP_6                                                            0xa1
#define mmSMC_MESSAGE_7                                                         0xa2
#define mmSMC_RESP_7                                                            0xa3
#define mmSMC_MSG_ARG_0                                                         0xa4
#define mmSMC_MSG_ARG_1                                                         0xa5
#define mmSMC_MSG_ARG_2                                                         0xa6
#define mmSMC_MSG_ARG_3                                                         0xa7
#define mmSMC_MSG_ARG_4                                                         0xa8
#define mmSMC_MSG_ARG_5                                                         0xa9
#define mmSMC_MSG_ARG_6                                                         0xaa
#define mmSMC_MSG_ARG_7                                                         0xab
#define mmSMC_MESSAGE_8                                                         0xb5
#define mmSMC_RESP_8                                                            0xb6
#define mmSMC_MESSAGE_9                                                         0xb7
#define mmSMC_RESP_9                                                            0xb8
#define mmSMC_MESSAGE_10                                                        0xb9
#define mmSMC_RESP_10                                                           0xba
#define mmSMC_MESSAGE_11                                                        0xbb
#define mmSMC_RESP_11                                                           0xbc
#define mmSMC_MSG_ARG_8                                                         0xbd
#define mmSMC_MSG_ARG_9                                                         0xbe
#define mmSMC_MSG_ARG_10                                                        0xbf
#define mmSMC_MSG_ARG_11                                                        0x93
#define ixSMC_SYSCON_RESET_CNTL                                                 0x80000000
#define ixSMC_SYSCON_CLOCK_CNTL_0                                               0x80000004
#define ixSMC_SYSCON_CLOCK_CNTL_1                                               0x80000008
#define ixSMC_SYSCON_CLOCK_CNTL_2                                               0x8000000c
#define ixSMC_SYSCON_MISC_CNTL                                                  0x80000010
#define ixSMC_SYSCON_MSG_ARG_0                                                  0x80000068
#define ixSMC_PC_C                                                              0x80000370
#define ixSMC_SCRATCH9                                                          0x80000424
#define mmGPIOPAD_SW_INT_STAT                                                   0x180
#define mmGPIOPAD_STRENGTH                                                      0x181
#define mmGPIOPAD_MASK                                                          0x182
#define mmGPIOPAD_A                                                             0x183
#define mmGPIOPAD_EN                                                            0x184
#define mmGPIOPAD_Y                                                             0x185
#define mmGPIOPAD_PINSTRAPS                                                     0x186
#define mmGPIOPAD_INT_STAT_EN                                                   0x187
#define mmGPIOPAD_INT_STAT                                                      0x188
#define mmGPIOPAD_INT_STAT_AK                                                   0x189
#define mmGPIOPAD_INT_EN                                                        0x18a
#define mmGPIOPAD_INT_TYPE                                                      0x18b
#define mmGPIOPAD_INT_POLARITY                                                  0x18c
#define mmGPIOPAD_EXTERN_TRIG_CNTL                                              0x18d
#define mmGPIOPAD_RCVR_SEL                                                      0x191
#define mmGPIOPAD_PU_EN                                                         0x192
#define mmGPIOPAD_PD_EN                                                         0x193
#define mmCG_FPS_CNT                                                            0x1b6
#define mmSMU_IND_INDEX_0                                                       0x1a6
#define mmSMU_IND_DATA_0                                                        0x1a7
#define mmSMU_IND_INDEX_1                                                       0x1a8
#define mmSMU_IND_DATA_1                                                        0x1a9
#define mmSMU_IND_INDEX_2                                                       0x1aa
#define mmSMU_IND_DATA_2                                                        0x1ab
#define mmSMU_IND_INDEX_3                                                       0x1ac
#define mmSMU_IND_DATA_3                                                        0x1ad
#define mmSMU_IND_INDEX_4                                                       0x1ae
#define mmSMU_IND_DATA_4                                                        0x1af
#define mmSMU_IND_INDEX_5                                                       0x1b0
#define mmSMU_IND_DATA_5                                                        0x1b1
#define mmSMU_IND_INDEX_6                                                       0x1b2
#define mmSMU_IND_DATA_6                                                        0x1b3
#define mmSMU_IND_INDEX_7                                                       0x1b4
#define mmSMU_IND_DATA_7                                                        0x1b5
#define mmSMU_SMC_IND_INDEX                                                     0x80
#define mmSMU0_SMU_SMC_IND_INDEX                                                0x80
#define mmSMU1_SMU_SMC_IND_INDEX                                                0x82
#define mmSMU2_SMU_SMC_IND_INDEX                                                0x84
#define mmSMU3_SMU_SMC_IND_INDEX                                                0x86
#define mmSMU_SMC_IND_DATA                                                      0x81
#define mmSMU0_SMU_SMC_IND_DATA                                                 0x81
#define mmSMU1_SMU_SMC_IND_DATA                                                 0x83
#define mmSMU2_SMU_SMC_IND_DATA                                                 0x85
#define mmSMU3_SMU_SMC_IND_DATA                                                 0x87
#define ixRCU_UC_EVENTS                                                         0xc0000004
#define ixRCU_MISC_CTRL                                                         0xc0000010
#define ixCC_RCU_FUSES                                                          0xc00c0000
#define ixCC_SMU_MISC_FUSES                                                     0xc00c0004
#define ixCC_SCLK_VID_FUSES                                                     0xc00c0008
#define ixCC_GIO_IOCCFG_FUSES                                                   0xc00c000c
#define ixCC_GIO_IOC_FUSES                                                      0xc00c0010
#define ixCC_SMU_TST_EFUSE1_MISC                                                0xc00c001c
#define ixCC_TST_ID_STRAPS                                                      0xc00c0020
#define ixCC_FCTRL_FUSES                                                        0xc00c0024
#define ixCC_HARVEST_FUSES                                                      0xc00c0028
#define ixSMU_MAIN_PLL_OP_FREQ                                                  0xe0003020
#define ixSMU_STATUS                                                            0xe0003088
#define ixSMU_FIRMWARE                                                          0xe00030a4
#define ixSMU_INPUT_DATA                                                        0xe00030b8
#define ixSMU_EFUSE_0                                                           0xc0100000
#define ixMCARB_DRAM_TIMING_TABLE_1                                             0x33018
#define ixMCARB_DRAM_TIMING_TABLE_2                                             0x3301c
#define ixMCARB_DRAM_TIMING_TABLE_3                                             0x33020
#define ixMCARB_DRAM_TIMING_TABLE_4                                             0x33024
#define ixMCARB_DRAM_TIMING_TABLE_5                                             0x33028
#define ixMCARB_DRAM_TIMING_TABLE_6                                             0x3302c
#define ixMCARB_DRAM_TIMING_TABLE_7                                             0x33030
#define ixMCARB_DRAM_TIMING_TABLE_8                                             0x33034
#define ixMCARB_DRAM_TIMING_TABLE_9                                             0x33038
#define ixMCARB_DRAM_TIMING_TABLE_10                                            0x3303c
#define ixMCARB_DRAM_TIMING_TABLE_11                                            0x33040
#define ixMCARB_DRAM_TIMING_TABLE_12                                            0x33044
#define ixMCARB_DRAM_TIMING_TABLE_13                                            0x33048
#define ixMCARB_DRAM_TIMING_TABLE_14                                            0x3304c
#define ixMCARB_DRAM_TIMING_TABLE_15                                            0x33050
#define ixMCARB_DRAM_TIMING_TABLE_16                                            0x33054
#define ixMCARB_DRAM_TIMING_TABLE_17                                            0x33058
#define ixMCARB_DRAM_TIMING_TABLE_18                                            0x3305c
#define ixMCARB_DRAM_TIMING_TABLE_19                                            0x33060
#define ixMCARB_DRAM_TIMING_TABLE_20                                            0x33064
#define ixMCARB_DRAM_TIMING_TABLE_21                                            0x33068
#define ixMCARB_DRAM_TIMING_TABLE_22                                            0x3306c
#define ixMCARB_DRAM_TIMING_TABLE_23                                            0x33070
#define ixMCARB_DRAM_TIMING_TABLE_24                                            0x33074
#define ixMCARB_DRAM_TIMING_TABLE_25                                            0x33078
#define ixMCARB_DRAM_TIMING_TABLE_26                                            0x3307c
#define ixMCARB_DRAM_TIMING_TABLE_27                                            0x33080
#define ixMCARB_DRAM_TIMING_TABLE_28                                            0x33084
#define ixMCARB_DRAM_TIMING_TABLE_29                                            0x33088
#define ixMCARB_DRAM_TIMING_TABLE_30                                            0x3308c
#define ixMCARB_DRAM_TIMING_TABLE_31                                            0x33090
#define ixMCARB_DRAM_TIMING_TABLE_32                                            0x33094
#define ixMCARB_DRAM_TIMING_TABLE_33                                            0x33098
#define ixMCARB_DRAM_TIMING_TABLE_34                                            0x3309c
#define ixMCARB_DRAM_TIMING_TABLE_35                                            0x330a0
#define ixMCARB_DRAM_TIMING_TABLE_36                                            0x330a4
#define ixMCARB_DRAM_TIMING_TABLE_37                                            0x330a8
#define ixMCARB_DRAM_TIMING_TABLE_38                                            0x330ac
#define ixMCARB_DRAM_TIMING_TABLE_39                                            0x330b0
#define ixMCARB_DRAM_TIMING_TABLE_40                                            0x330b4
#define ixMCARB_DRAM_TIMING_TABLE_41                                            0x330b8
#define ixMCARB_DRAM_TIMING_TABLE_42                                            0x330bc
#define ixMCARB_DRAM_TIMING_TABLE_43                                            0x330c0
#define ixMCARB_DRAM_TIMING_TABLE_44                                            0x330c4
#define ixMCARB_DRAM_TIMING_TABLE_45                                            0x330c8
#define ixMCARB_DRAM_TIMING_TABLE_46                                            0x330cc
#define ixMCARB_DRAM_TIMING_TABLE_47                                            0x330d0
#define ixMCARB_DRAM_TIMING_TABLE_48                                            0x330d4
#define ixMCARB_DRAM_TIMING_TABLE_49                                            0x330d8
#define ixMCARB_DRAM_TIMING_TABLE_50                                            0x330dc
#define ixMCARB_DRAM_TIMING_TABLE_51                                            0x330e0
#define ixMCARB_DRAM_TIMING_TABLE_52                                            0x330e4
#define ixMCARB_DRAM_TIMING_TABLE_53                                            0x330e8
#define ixMCARB_DRAM_TIMING_TABLE_54                                            0x330ec
#define ixMCARB_DRAM_TIMING_TABLE_55                                            0x330f0
#define ixMCARB_DRAM_TIMING_TABLE_56                                            0x330f4
#define ixMCARB_DRAM_TIMING_TABLE_57                                            0x330f8
#define ixMCARB_DRAM_TIMING_TABLE_58                                            0x330fc
#define ixMCARB_DRAM_TIMING_TABLE_59                                            0x33100
#define ixMCARB_DRAM_TIMING_TABLE_60                                            0x33104
#define ixMCARB_DRAM_TIMING_TABLE_61                                            0x33108
#define ixMCARB_DRAM_TIMING_TABLE_62                                            0x3310c
#define ixMCARB_DRAM_TIMING_TABLE_63                                            0x33110
#define ixMCARB_DRAM_TIMING_TABLE_64                                            0x33114
#define ixMCARB_DRAM_TIMING_TABLE_65                                            0x33118
#define ixMCARB_DRAM_TIMING_TABLE_66                                            0x3311c
#define ixMCARB_DRAM_TIMING_TABLE_67                                            0x33120
#define ixMCARB_DRAM_TIMING_TABLE_68                                            0x33124
#define ixMCARB_DRAM_TIMING_TABLE_69                                            0x33128
#define ixMCARB_DRAM_TIMING_TABLE_70                                            0x3312c
#define ixMCARB_DRAM_TIMING_TABLE_71                                            0x33130
#define ixMCARB_DRAM_TIMING_TABLE_72                                            0x33134
#define ixMCARB_DRAM_TIMING_TABLE_73                                            0x33138
#define ixMCARB_DRAM_TIMING_TABLE_74                                            0x3313c
#define ixMCARB_DRAM_TIMING_TABLE_75                                            0x33140
#define ixMCARB_DRAM_TIMING_TABLE_76                                            0x33144
#define ixMCARB_DRAM_TIMING_TABLE_77                                            0x33148
#define ixMCARB_DRAM_TIMING_TABLE_78                                            0x3314c
#define ixMCARB_DRAM_TIMING_TABLE_79                                            0x33150
#define ixMCARB_DRAM_TIMING_TABLE_80                                            0x33154
#define ixMCARB_DRAM_TIMING_TABLE_81                                            0x33158
#define ixMCARB_DRAM_TIMING_TABLE_82                                            0x3315c
#define ixMCARB_DRAM_TIMING_TABLE_83                                            0x33160
#define ixMCARB_DRAM_TIMING_TABLE_84                                            0x33164
#define ixMCARB_DRAM_TIMING_TABLE_85                                            0x33168
#define ixMCARB_DRAM_TIMING_TABLE_86                                            0x3316c
#define ixMCARB_DRAM_TIMING_TABLE_87                                            0x33170
#define ixMCARB_DRAM_TIMING_TABLE_88                                            0x33174
#define ixMCARB_DRAM_TIMING_TABLE_89                                            0x33178
#define ixMCARB_DRAM_TIMING_TABLE_90                                            0x3317c
#define ixMCARB_DRAM_TIMING_TABLE_91                                            0x33180
#define ixMCARB_DRAM_TIMING_TABLE_92                                            0x33184
#define ixMCARB_DRAM_TIMING_TABLE_93                                            0x33188
#define ixMCARB_DRAM_TIMING_TABLE_94                                            0x3318c
#define ixMCARB_DRAM_TIMING_TABLE_95                                            0x33190
#define ixMCARB_DRAM_TIMING_TABLE_96                                            0x33194
#define ixMC_REGISTERS_TABLE_1                                                  0x33198
#define ixMC_REGISTERS_TABLE_2                                                  0x3319c
#define ixMC_REGISTERS_TABLE_3                                                  0x331a0
#define ixMC_REGISTERS_TABLE_4                                                  0x331a4
#define ixMC_REGISTERS_TABLE_5                                                  0x331a8
#define ixMC_REGISTERS_TABLE_6                                                  0x331ac
#define ixMC_REGISTERS_TABLE_7                                                  0x331b0
#define ixMC_REGISTERS_TABLE_8                                                  0x331b4
#define ixMC_REGISTERS_TABLE_9                                                  0x331b8
#define ixMC_REGISTERS_TABLE_10                                                 0x331bc
#define ixMC_REGISTERS_TABLE_11                                                 0x331c0
#define ixMC_REGISTERS_TABLE_12                                                 0x331c4
#define ixMC_REGISTERS_TABLE_13                                                 0x331c8
#define ixMC_REGISTERS_TABLE_14                                                 0x331cc
#define ixMC_REGISTERS_TABLE_15                                                 0x331d0
#define ixMC_REGISTERS_TABLE_16                                                 0x331d4
#define ixMC_REGISTERS_TABLE_17                                                 0x331d8
#define ixMC_REGISTERS_TABLE_18                                                 0x331dc
#define ixMC_REGISTERS_TABLE_19                                                 0x331e0
#define ixMC_REGISTERS_TABLE_20                                                 0x331e4
#define ixMC_REGISTERS_TABLE_21                                                 0x331e8
#define ixMC_REGISTERS_TABLE_22                                                 0x331ec
#define ixMC_REGISTERS_TABLE_23                                                 0x331f0
#define ixMC_REGISTERS_TABLE_24                                                 0x331f4
#define ixMC_REGISTERS_TABLE_25                                                 0x331f8
#define ixMC_REGISTERS_TABLE_26                                                 0x331fc
#define ixMC_REGISTERS_TABLE_27                                                 0x33200
#define ixMC_REGISTERS_TABLE_28                                                 0x33204
#define ixMC_REGISTERS_TABLE_29                                                 0x33208
#define ixMC_REGISTERS_TABLE_30                                                 0x3320c
#define ixMC_REGISTERS_TABLE_31                                                 0x33210
#define ixMC_REGISTERS_TABLE_32                                                 0x33214
#define ixMC_REGISTERS_TABLE_33                                                 0x33218
#define ixMC_REGISTERS_TABLE_34                                                 0x3321c
#define ixMC_REGISTERS_TABLE_35                                                 0x33220
#define ixMC_REGISTERS_TABLE_36                                                 0x33224
#define ixMC_REGISTERS_TABLE_37                                                 0x33228
#define ixMC_REGISTERS_TABLE_38                                                 0x3322c
#define ixMC_REGISTERS_TABLE_39                                                 0x33230
#define ixMC_REGISTERS_TABLE_40                                                 0x33234
#define ixMC_REGISTERS_TABLE_41                                                 0x33238
#define ixMC_REGISTERS_TABLE_42                                                 0x3323c
#define ixMC_REGISTERS_TABLE_43                                                 0x33240
#define ixMC_REGISTERS_TABLE_44                                                 0x33244
#define ixMC_REGISTERS_TABLE_45                                                 0x33248
#define ixMC_REGISTERS_TABLE_46                                                 0x3324c
#define ixMC_REGISTERS_TABLE_47                                                 0x33250
#define ixMC_REGISTERS_TABLE_48                                                 0x33254
#define ixMC_REGISTERS_TABLE_49                                                 0x33258
#define ixMC_REGISTERS_TABLE_50                                                 0x3325c
#define ixMC_REGISTERS_TABLE_51                                                 0x33260
#define ixMC_REGISTERS_TABLE_52                                                 0x33264
#define ixMC_REGISTERS_TABLE_53                                                 0x33268
#define ixMC_REGISTERS_TABLE_54                                                 0x3326c
#define ixMC_REGISTERS_TABLE_55                                                 0x33270
#define ixMC_REGISTERS_TABLE_56                                                 0x33274
#define ixMC_REGISTERS_TABLE_57                                                 0x33278
#define ixMC_REGISTERS_TABLE_58                                                 0x3327c
#define ixMC_REGISTERS_TABLE_59                                                 0x33280
#define ixMC_REGISTERS_TABLE_60                                                 0x33284
#define ixMC_REGISTERS_TABLE_61                                                 0x33288
#define ixMC_REGISTERS_TABLE_62                                                 0x3328c
#define ixMC_REGISTERS_TABLE_63                                                 0x33290
#define ixMC_REGISTERS_TABLE_64                                                 0x33294
#define ixMC_REGISTERS_TABLE_65                                                 0x33298
#define ixMC_REGISTERS_TABLE_66                                                 0x3329c
#define ixMC_REGISTERS_TABLE_67                                                 0x332a0
#define ixMC_REGISTERS_TABLE_68                                                 0x332a4
#define ixMC_REGISTERS_TABLE_69                                                 0x332a8
#define ixMC_REGISTERS_TABLE_70                                                 0x332ac
#define ixMC_REGISTERS_TABLE_71                                                 0x332b0
#define ixMC_REGISTERS_TABLE_72                                                 0x332b4
#define ixMC_REGISTERS_TABLE_73                                                 0x332b8
#define ixMC_REGISTERS_TABLE_74                                                 0x332bc
#define ixMC_REGISTERS_TABLE_75                                                 0x332c0
#define ixMC_REGISTERS_TABLE_76                                                 0x332c4
#define ixMC_REGISTERS_TABLE_77                                                 0x332c8
#define ixMC_REGISTERS_TABLE_78                                                 0x332cc
#define ixMC_REGISTERS_TABLE_79                                                 0x332d0
#define ixMC_REGISTERS_TABLE_80                                                 0x332d4
#define ixMC_REGISTERS_TABLE_81                                                 0x332d8
#define ixDPM_TABLE_1                                                           0x332dc
#define ixDPM_TABLE_2                                                           0x332e0
#define ixDPM_TABLE_3                                                           0x332e4
#define ixDPM_TABLE_4                                                           0x332e8
#define ixDPM_TABLE_5                                                           0x332ec
#define ixDPM_TABLE_6                                                           0x332f0
#define ixDPM_TABLE_7                                                           0x332f4
#define ixDPM_TABLE_8                                                           0x332f8
#define ixDPM_TABLE_9                                                           0x332fc
#define ixDPM_TABLE_10                                                          0x33300
#define ixDPM_TABLE_11                                                          0x33304
#define ixDPM_TABLE_12                                                          0x33308
#define ixDPM_TABLE_13                                                          0x3330c
#define ixDPM_TABLE_14                                                          0x33310
#define ixDPM_TABLE_15                                                          0x33314
#define ixDPM_TABLE_16                                                          0x33318
#define ixDPM_TABLE_17                                                          0x3331c
#define ixDPM_TABLE_18                                                          0x33320
#define ixDPM_TABLE_19                                                          0x33324
#define ixDPM_TABLE_20                                                          0x33328
#define ixDPM_TABLE_21                                                          0x3332c
#define ixDPM_TABLE_22                                                          0x33330
#define ixDPM_TABLE_23                                                          0x33334
#define ixDPM_TABLE_24                                                          0x33338
#define ixDPM_TABLE_25                                                          0x3333c
#define ixDPM_TABLE_26                                                          0x33340
#define ixDPM_TABLE_27                                                          0x33344
#define ixDPM_TABLE_28                                                          0x33348
#define ixDPM_TABLE_29                                                          0x3334c
#define ixDPM_TABLE_30                                                          0x33350
#define ixDPM_TABLE_31                                                          0x33354
#define ixDPM_TABLE_32                                                          0x33358
#define ixDPM_TABLE_33                                                          0x3335c
#define ixDPM_TABLE_34                                                          0x33360
#define ixDPM_TABLE_35                                                          0x33364
#define ixDPM_TABLE_36                                                          0x33368
#define ixDPM_TABLE_37                                                          0x3336c
#define ixDPM_TABLE_38                                                          0x33370
#define ixDPM_TABLE_39                                                          0x33374
#define ixDPM_TABLE_40                                                          0x33378
#define ixDPM_TABLE_41                                                          0x3337c
#define ixDPM_TABLE_42                                                          0x33380
#define ixDPM_TABLE_43                                                          0x33384
#define ixDPM_TABLE_44                                                          0x33388
#define ixDPM_TABLE_45                                                          0x3338c
#define ixDPM_TABLE_46                                                          0x33390
#define ixDPM_TABLE_47                                                          0x33394
#define ixDPM_TABLE_48                                                          0x33398
#define ixDPM_TABLE_49                                                          0x3339c
#define ixDPM_TABLE_50                                                          0x333a0
#define ixDPM_TABLE_51                                                          0x333a4
#define ixDPM_TABLE_52                                                          0x333a8
#define ixDPM_TABLE_53                                                          0x333ac
#define ixDPM_TABLE_54                                                          0x333b0
#define ixDPM_TABLE_55                                                          0x333b4
#define ixDPM_TABLE_56                                                          0x333b8
#define ixDPM_TABLE_57                                                          0x333bc
#define ixDPM_TABLE_58                                                          0x333c0
#define ixDPM_TABLE_59                                                          0x333c4
#define ixDPM_TABLE_60                                                          0x333c8
#define ixDPM_TABLE_61                                                          0x333cc
#define ixDPM_TABLE_62                                                          0x333d0
#define ixDPM_TABLE_63                                                          0x333d4
#define ixDPM_TABLE_64                                                          0x333d8
#define ixDPM_TABLE_65                                                          0x333dc
#define ixDPM_TABLE_66                                                          0x333e0
#define ixDPM_TABLE_67                                                          0x333e4
#define ixDPM_TABLE_68                                                          0x333e8
#define ixDPM_TABLE_69                                                          0x333ec
#define ixDPM_TABLE_70                                                          0x333f0
#define ixDPM_TABLE_71                                                          0x333f4
#define ixDPM_TABLE_72                                                          0x333f8
#define ixDPM_TABLE_73                                                          0x333fc
#define ixDPM_TABLE_74                                                          0x33400
#define ixDPM_TABLE_75                                                          0x33404
#define ixDPM_TABLE_76                                                          0x33408
#define ixDPM_TABLE_77                                                          0x3340c
#define ixDPM_TABLE_78                                                          0x33410
#define ixDPM_TABLE_79                                                          0x33414
#define ixDPM_TABLE_80                                                          0x33418
#define ixDPM_TABLE_81                                                          0x3341c
#define ixDPM_TABLE_82                                                          0x33420
#define ixDPM_TABLE_83                                                          0x33424
#define ixDPM_TABLE_84                                                          0x33428
#define ixDPM_TABLE_85                                                          0x3342c
#define ixDPM_TABLE_86                                                          0x33430
#define ixDPM_TABLE_87                                                          0x33434
#define ixDPM_TABLE_88                                                          0x33438
#define ixDPM_TABLE_89                                                          0x3343c
#define ixDPM_TABLE_90                                                          0x33440
#define ixDPM_TABLE_91                                                          0x33444
#define ixDPM_TABLE_92                                                          0x33448
#define ixDPM_TABLE_93                                                          0x3344c
#define ixDPM_TABLE_94                                                          0x33450
#define ixDPM_TABLE_95                                                          0x33454
#define ixDPM_TABLE_96                                                          0x33458
#define ixDPM_TABLE_97                                                          0x3345c
#define ixDPM_TABLE_98                                                          0x33460
#define ixDPM_TABLE_99                                                          0x33464
#define ixDPM_TABLE_100                                                         0x33468
#define ixDPM_TABLE_101                                                         0x3346c
#define ixDPM_TABLE_102                                                         0x33470
#define ixDPM_TABLE_103                                                         0x33474
#define ixDPM_TABLE_104                                                         0x33478
#define ixDPM_TABLE_105                                                         0x3347c
#define ixDPM_TABLE_106                                                         0x33480
#define ixDPM_TABLE_107                                                         0x33484
#define ixDPM_TABLE_108                                                         0x33488
#define ixDPM_TABLE_109                                                         0x3348c
#define ixDPM_TABLE_110                                                         0x33490
#define ixDPM_TABLE_111                                                         0x33494
#define ixDPM_TABLE_112                                                         0x33498
#define ixDPM_TABLE_113                                                         0x3349c
#define ixDPM_TABLE_114                                                         0x334a0
#define ixDPM_TABLE_115                                                         0x334a4
#define ixDPM_TABLE_116                                                         0x334a8
#define ixDPM_TABLE_117                                                         0x334ac
#define ixDPM_TABLE_118                                                         0x334b0
#define ixDPM_TABLE_119                                                         0x334b4
#define ixDPM_TABLE_120                                                         0x334b8
#define ixDPM_TABLE_121                                                         0x334bc
#define ixDPM_TABLE_122                                                         0x334c0
#define ixDPM_TABLE_123                                                         0x334c4
#define ixDPM_TABLE_124                                                         0x334c8
#define ixDPM_TABLE_125                                                         0x334cc
#define ixDPM_TABLE_126                                                         0x334d0
#define ixDPM_TABLE_127                                                         0x334d4
#define ixDPM_TABLE_128                                                         0x334d8
#define ixDPM_TABLE_129                                                         0x334dc
#define ixDPM_TABLE_130                                                         0x334e0
#define ixDPM_TABLE_131                                                         0x334e4
#define ixDPM_TABLE_132                                                         0x334e8
#define ixDPM_TABLE_133                                                         0x334ec
#define ixDPM_TABLE_134                                                         0x334f0
#define ixDPM_TABLE_135                                                         0x334f4
#define ixDPM_TABLE_136                                                         0x334f8
#define ixDPM_TABLE_137                                                         0x334fc
#define ixDPM_TABLE_138                                                         0x33500
#define ixDPM_TABLE_139                                                         0x33504
#define ixDPM_TABLE_140                                                         0x33508
#define ixDPM_TABLE_141                                                         0x3350c
#define ixDPM_TABLE_142                                                         0x33510
#define ixDPM_TABLE_143                                                         0x33514
#define ixDPM_TABLE_144                                                         0x33518
#define ixDPM_TABLE_145                                                         0x3351c
#define ixDPM_TABLE_146                                                         0x33520
#define ixDPM_TABLE_147                                                         0x33524
#define ixDPM_TABLE_148                                                         0x33528
#define ixDPM_TABLE_149                                                         0x3352c
#define ixDPM_TABLE_150                                                         0x33530
#define ixDPM_TABLE_151                                                         0x33534
#define ixDPM_TABLE_152                                                         0x33538
#define ixDPM_TABLE_153                                                         0x3353c
#define ixDPM_TABLE_154                                                         0x33540
#define ixDPM_TABLE_155                                                         0x33544
#define ixDPM_TABLE_156                                                         0x33548
#define ixDPM_TABLE_157                                                         0x3354c
#define ixDPM_TABLE_158                                                         0x33550
#define ixDPM_TABLE_159                                                         0x33554
#define ixDPM_TABLE_160                                                         0x33558
#define ixDPM_TABLE_161                                                         0x3355c
#define ixDPM_TABLE_162                                                         0x33560
#define ixDPM_TABLE_163                                                         0x33564
#define ixDPM_TABLE_164                                                         0x33568
#define ixDPM_TABLE_165                                                         0x3356c
#define ixDPM_TABLE_166                                                         0x33570
#define ixDPM_TABLE_167                                                         0x33574
#define ixDPM_TABLE_168                                                         0x33578
#define ixDPM_TABLE_169                                                         0x3357c
#define ixDPM_TABLE_170                                                         0x33580
#define ixDPM_TABLE_171                                                         0x33584
#define ixDPM_TABLE_172                                                         0x33588
#define ixDPM_TABLE_173                                                         0x3358c
#define ixDPM_TABLE_174                                                         0x33590
#define ixDPM_TABLE_175                                                         0x33594
#define ixDPM_TABLE_176                                                         0x33598
#define ixDPM_TABLE_177                                                         0x3359c
#define ixDPM_TABLE_178                                                         0x335a0
#define ixDPM_TABLE_179                                                         0x335a4
#define ixDPM_TABLE_180                                                         0x335a8
#define ixDPM_TABLE_181                                                         0x335ac
#define ixDPM_TABLE_182                                                         0x335b0
#define ixDPM_TABLE_183                                                         0x335b4
#define ixDPM_TABLE_184                                                         0x335b8
#define ixDPM_TABLE_185                                                         0x335bc
#define ixDPM_TABLE_186                                                         0x335c0
#define ixDPM_TABLE_187                                                         0x335c4
#define ixDPM_TABLE_188                                                         0x335c8
#define ixDPM_TABLE_189                                                         0x335cc
#define ixDPM_TABLE_190                                                         0x335d0
#define ixDPM_TABLE_191                                                         0x335d4
#define ixDPM_TABLE_192                                                         0x335d8
#define ixDPM_TABLE_193                                                         0x335dc
#define ixDPM_TABLE_194                                                         0x335e0
#define ixDPM_TABLE_195                                                         0x335e4
#define ixDPM_TABLE_196                                                         0x335e8
#define ixDPM_TABLE_197                                                         0x335ec
#define ixDPM_TABLE_198                                                         0x335f0
#define ixDPM_TABLE_199                                                         0x335f4
#define ixDPM_TABLE_200                                                         0x335f8
#define ixDPM_TABLE_201                                                         0x335fc
#define ixDPM_TABLE_202                                                         0x33600
#define ixDPM_TABLE_203                                                         0x33604
#define ixDPM_TABLE_204                                                         0x33608
#define ixDPM_TABLE_205                                                         0x3360c
#define ixDPM_TABLE_206                                                         0x33610
#define ixDPM_TABLE_207                                                         0x33614
#define ixDPM_TABLE_208                                                         0x33618
#define ixDPM_TABLE_209                                                         0x3361c
#define ixDPM_TABLE_210                                                         0x33620
#define ixDPM_TABLE_211                                                         0x33624
#define ixDPM_TABLE_212                                                         0x33628
#define ixDPM_TABLE_213                                                         0x3362c
#define ixDPM_TABLE_214                                                         0x33630
#define ixDPM_TABLE_215                                                         0x33634
#define ixDPM_TABLE_216                                                         0x33638
#define ixDPM_TABLE_217                                                         0x3363c
#define ixDPM_TABLE_218                                                         0x33640
#define ixDPM_TABLE_219                                                         0x33644
#define ixDPM_TABLE_220                                                         0x33648
#define ixDPM_TABLE_221                                                         0x3364c
#define ixDPM_TABLE_222                                                         0x33650
#define ixDPM_TABLE_223                                                         0x33654
#define ixDPM_TABLE_224                                                         0x33658
#define ixDPM_TABLE_225                                                         0x3365c
#define ixDPM_TABLE_226                                                         0x33660
#define ixDPM_TABLE_227                                                         0x33664
#define ixDPM_TABLE_228                                                         0x33668
#define ixDPM_TABLE_229                                                         0x3366c
#define ixDPM_TABLE_230                                                         0x33670
#define ixDPM_TABLE_231                                                         0x33674
#define ixDPM_TABLE_232                                                         0x33678
#define ixDPM_TABLE_233                                                         0x3367c
#define ixDPM_TABLE_234                                                         0x33680
#define ixDPM_TABLE_235                                                         0x33684
#define ixDPM_TABLE_236                                                         0x33688
#define ixDPM_TABLE_237                                                         0x3368c
#define ixDPM_TABLE_238                                                         0x33690
#define ixDPM_TABLE_239                                                         0x33694
#define ixDPM_TABLE_240                                                         0x33698
#define ixDPM_TABLE_241                                                         0x3369c
#define ixDPM_TABLE_242                                                         0x336a0
#define ixDPM_TABLE_243                                                         0x336a4
#define ixDPM_TABLE_244                                                         0x336a8
#define ixDPM_TABLE_245                                                         0x336ac
#define ixDPM_TABLE_246                                                         0x336b0
#define ixDPM_TABLE_247                                                         0x336b4
#define ixDPM_TABLE_248                                                         0x336b8
#define ixDPM_TABLE_249                                                         0x336bc
#define ixDPM_TABLE_250                                                         0x336c0
#define ixDPM_TABLE_251                                                         0x336c4
#define ixDPM_TABLE_252                                                         0x336c8
#define ixDPM_TABLE_253                                                         0x336cc
#define ixDPM_TABLE_254                                                         0x336d0
#define ixDPM_TABLE_255                                                         0x336d4
#define ixDPM_TABLE_256                                                         0x336d8
#define ixDPM_TABLE_257                                                         0x336dc
#define ixDPM_TABLE_258                                                         0x336e0
#define ixDPM_TABLE_259                                                         0x336e4
#define ixDPM_TABLE_260                                                         0x336e8
#define ixDPM_TABLE_261                                                         0x336ec
#define ixDPM_TABLE_262                                                         0x336f0
#define ixDPM_TABLE_263                                                         0x336f4
#define ixDPM_TABLE_264                                                         0x336f8
#define ixDPM_TABLE_265                                                         0x336fc
#define ixDPM_TABLE_266                                                         0x33700
#define ixDPM_TABLE_267                                                         0x33704
#define ixDPM_TABLE_268                                                         0x33708
#define ixDPM_TABLE_269                                                         0x3370c
#define ixDPM_TABLE_270                                                         0x33710
#define ixDPM_TABLE_271                                                         0x33714
#define ixDPM_TABLE_272                                                         0x33718
#define ixDPM_TABLE_273                                                         0x3371c
#define ixDPM_TABLE_274                                                         0x33720
#define ixDPM_TABLE_275                                                         0x33724
#define ixDPM_TABLE_276                                                         0x33728
#define ixDPM_TABLE_277                                                         0x3372c
#define ixDPM_TABLE_278                                                         0x33730
#define ixDPM_TABLE_279                                                         0x33734
#define ixDPM_TABLE_280                                                         0x33738
#define ixDPM_TABLE_281                                                         0x3373c
#define ixDPM_TABLE_282                                                         0x33740
#define ixDPM_TABLE_283                                                         0x33744
#define ixDPM_TABLE_284                                                         0x33748
#define ixDPM_TABLE_285                                                         0x3374c
#define ixDPM_TABLE_286                                                         0x33750
#define ixDPM_TABLE_287                                                         0x33754
#define ixDPM_TABLE_288                                                         0x33758
#define ixDPM_TABLE_289                                                         0x3375c
#define ixDPM_TABLE_290                                                         0x33760
#define ixDPM_TABLE_291                                                         0x33764
#define ixDPM_TABLE_292                                                         0x33768
#define ixDPM_TABLE_293                                                         0x3376c
#define ixDPM_TABLE_294                                                         0x33770
#define ixDPM_TABLE_295                                                         0x33774
#define ixDPM_TABLE_296                                                         0x33778
#define ixDPM_TABLE_297                                                         0x3377c
#define ixDPM_TABLE_298                                                         0x33780
#define ixDPM_TABLE_299                                                         0x33784
#define ixDPM_TABLE_300                                                         0x33788
#define ixDPM_TABLE_301                                                         0x3378c
#define ixDPM_TABLE_302                                                         0x33790
#define ixDPM_TABLE_303                                                         0x33794
#define ixDPM_TABLE_304                                                         0x33798
#define ixDPM_TABLE_305                                                         0x3379c
#define ixDPM_TABLE_306                                                         0x337a0
#define ixDPM_TABLE_307                                                         0x337a4
#define ixDPM_TABLE_308                                                         0x337a8
#define ixDPM_TABLE_309                                                         0x337ac
#define ixDPM_TABLE_310                                                         0x337b0
#define ixDPM_TABLE_311                                                         0x337b4
#define ixDPM_TABLE_312                                                         0x337b8
#define ixDPM_TABLE_313                                                         0x337bc
#define ixDPM_TABLE_314                                                         0x337c0
#define ixDPM_TABLE_315                                                         0x337c4
#define ixDPM_TABLE_316                                                         0x337c8
#define ixDPM_TABLE_317                                                         0x337cc
#define ixDPM_TABLE_318                                                         0x337d0
#define ixDPM_TABLE_319                                                         0x337d4
#define ixDPM_TABLE_320                                                         0x337d8
#define ixDPM_TABLE_321                                                         0x337dc
#define ixDPM_TABLE_322                                                         0x337e0
#define ixDPM_TABLE_323                                                         0x337e4
#define ixDPM_TABLE_324                                                         0x337e8
#define ixDPM_TABLE_325                                                         0x337ec
#define ixDPM_TABLE_326                                                         0x337f0
#define ixDPM_TABLE_327                                                         0x337f4
#define ixDPM_TABLE_328                                                         0x337f8
#define ixDPM_TABLE_329                                                         0x337fc
#define ixDPM_TABLE_330                                                         0x33800
#define ixDPM_TABLE_331                                                         0x33804
#define ixDPM_TABLE_332                                                         0x33808
#define ixDPM_TABLE_333                                                         0x3380c
#define ixDPM_TABLE_334                                                         0x33810
#define ixDPM_TABLE_335                                                         0x33814
#define ixDPM_TABLE_336                                                         0x33818
#define ixDPM_TABLE_337                                                         0x3381c
#define ixDPM_TABLE_338                                                         0x33820
#define ixDPM_TABLE_339                                                         0x33824
#define ixDPM_TABLE_340                                                         0x33828
#define ixDPM_TABLE_341                                                         0x3382c
#define ixDPM_TABLE_342                                                         0x33830
#define ixDPM_TABLE_343                                                         0x33834
#define ixDPM_TABLE_344                                                         0x33838
#define ixDPM_TABLE_345                                                         0x3383c
#define ixDPM_TABLE_346                                                         0x33840
#define ixDPM_TABLE_347                                                         0x33844
#define ixDPM_TABLE_348                                                         0x33848
#define ixDPM_TABLE_349                                                         0x3384c
#define ixDPM_TABLE_350                                                         0x33850
#define ixDPM_TABLE_351                                                         0x33854
#define ixDPM_TABLE_352                                                         0x33858
#define ixDPM_TABLE_353                                                         0x3385c
#define ixDPM_TABLE_354                                                         0x33860
#define ixDPM_TABLE_355                                                         0x33864
#define ixDPM_TABLE_356                                                         0x33868
#define ixDPM_TABLE_357                                                         0x3386c
#define ixDPM_TABLE_358                                                         0x33870
#define ixDPM_TABLE_359                                                         0x33874
#define ixDPM_TABLE_360                                                         0x33878
#define ixDPM_TABLE_361                                                         0x3387c
#define ixDPM_TABLE_362                                                         0x33880
#define ixDPM_TABLE_363                                                         0x33884
#define ixDPM_TABLE_364                                                         0x33888
#define ixDPM_TABLE_365                                                         0x3388c
#define ixDPM_TABLE_366                                                         0x33890
#define ixDPM_TABLE_367                                                         0x33894
#define ixDPM_TABLE_368                                                         0x33898
#define ixDPM_TABLE_369                                                         0x3389c
#define ixDPM_TABLE_370                                                         0x338a0
#define ixSOFT_REGISTERS_TABLE_1                                                0x338c8
#define ixSOFT_REGISTERS_TABLE_2                                                0x338cc
#define ixSOFT_REGISTERS_TABLE_3                                                0x338d0
#define ixSOFT_REGISTERS_TABLE_4                                                0x338d4
#define ixSOFT_REGISTERS_TABLE_5                                                0x338d8
#define ixSOFT_REGISTERS_TABLE_6                                                0x338dc
#define ixSOFT_REGISTERS_TABLE_7                                                0x338e0
#define ixSOFT_REGISTERS_TABLE_8                                                0x338e4
#define ixSOFT_REGISTERS_TABLE_9                                                0x338e8
#define ixSOFT_REGISTERS_TABLE_10                                               0x338ec
#define ixSOFT_REGISTERS_TABLE_11                                               0x338f0
#define ixSOFT_REGISTERS_TABLE_12                                               0x338f4
#define ixSOFT_REGISTERS_TABLE_13                                               0x338f8
#define ixSOFT_REGISTERS_TABLE_14                                               0x338fc
#define ixSOFT_REGISTERS_TABLE_15                                               0x33900
#define ixSOFT_REGISTERS_TABLE_16                                               0x33904
#define ixSOFT_REGISTERS_TABLE_17                                               0x33908
#define ixSOFT_REGISTERS_TABLE_18                                               0x3390c
#define ixSOFT_REGISTERS_TABLE_19                                               0x33910
#define ixSOFT_REGISTERS_TABLE_20                                               0x33914
#define ixSOFT_REGISTERS_TABLE_21                                               0x33918
#define ixSOFT_REGISTERS_TABLE_22                                               0x3391c
#define ixSOFT_REGISTERS_TABLE_23                                               0x33920
#define ixSOFT_REGISTERS_TABLE_24                                               0x33924
#define ixSOFT_REGISTERS_TABLE_25                                               0x33928
#define ixSOFT_REGISTERS_TABLE_26                                               0x3392c
#define ixSOFT_REGISTERS_TABLE_27                                               0x33930
#define ixSOFT_REGISTERS_TABLE_28                                               0x33934
#define ixSOFT_REGISTERS_TABLE_29                                               0x33938
#define ixFIRMWARE_FLAGS                                                        0x33000
#define ixTDC_STATUS                                                            0x33004
#define ixTDC_MV_AVERAGE                                                        0x33008
#define ixTDC_VRM_LIMIT                                                         0x3300c
#define ixFEATURE_STATUS                                                        0x33010
#define ixENTITY_TEMPERATURES_1                                                 0x33014
#define ixPM_FUSES_1                                                            0x3394c
#define ixPM_FUSES_2                                                            0x33950
#define ixPM_FUSES_3                                                            0x33954
#define ixPM_FUSES_4                                                            0x33958
#define ixPM_FUSES_5                                                            0x3395c
#define ixPM_FUSES_6                                                            0x33960
#define ixPM_FUSES_7                                                            0x33964
#define ixPM_FUSES_8                                                            0x33968
#define ixPM_FUSES_9                                                            0x3396c
#define ixPM_FUSES_10                                                           0x33970
#define ixPM_FUSES_11                                                           0x33974
#define ixPM_FUSES_12                                                           0x33978
#define ixPM_FUSES_13                                                           0x3397c
#define ixPM_FUSES_14                                                           0x33980
#define ixPM_FUSES_15                                                           0x33984
#define ixPM_FUSES_16                                                           0x33988
#define ixPM_FUSES_17                                                           0x3398c
#define ixPM_FUSES_18                                                           0x33990
#define ixPM_FUSES_19                                                           0x33994
#define ixPM_FUSES_20                                                           0x33998
#define ixPM_FUSES_21                                                           0x3399c
#define ixSMU_PM_STATUS_0                                                       0x33e00
#define ixSMU_PM_STATUS_1                                                       0x33e04
#define ixSMU_PM_STATUS_2                                                       0x33e08
#define ixSMU_PM_STATUS_3                                                       0x33e0c
#define ixSMU_PM_STATUS_4                                                       0x33e10
#define ixSMU_PM_STATUS_5                                                       0x33e14
#define ixSMU_PM_STATUS_6                                                       0x33e18
#define ixSMU_PM_STATUS_7                                                       0x33e1c
#define ixSMU_PM_STATUS_8                                                       0x33e20
#define ixSMU_PM_STATUS_9                                                       0x33e24
#define ixSMU_PM_STATUS_10                                                      0x33e28
#define ixSMU_PM_STATUS_11                                                      0x33e2c
#define ixSMU_PM_STATUS_12                                                      0x33e30
#define ixSMU_PM_STATUS_13                                                      0x33e34
#define ixSMU_PM_STATUS_14                                                      0x33e38
#define ixSMU_PM_STATUS_15                                                      0x33e3c
#define ixSMU_PM_STATUS_16                                                      0x33e40
#define ixSMU_PM_STATUS_17                                                      0x33e44
#define ixSMU_PM_STATUS_18                                                      0x33e48
#define ixSMU_PM_STATUS_19                                                      0x33e4c
#define ixSMU_PM_STATUS_20                                                      0x33e50
#define ixSMU_PM_STATUS_21                                                      0x33e54
#define ixSMU_PM_STATUS_22                                                      0x33e58
#define ixSMU_PM_STATUS_23                                                      0x33e5c
#define ixSMU_PM_STATUS_24                                                      0x33e60
#define ixSMU_PM_STATUS_25                                                      0x33e64
#define ixSMU_PM_STATUS_26                                                      0x33e68
#define ixSMU_PM_STATUS_27                                                      0x33e6c
#define ixSMU_PM_STATUS_28                                                      0x33e70
#define ixSMU_PM_STATUS_29                                                      0x33e74
#define ixSMU_PM_STATUS_30                                                      0x33e78
#define ixSMU_PM_STATUS_31                                                      0x33e7c
#define ixSMU_PM_STATUS_32                                                      0x33e80
#define ixSMU_PM_STATUS_33                                                      0x33e84
#define ixSMU_PM_STATUS_34                                                      0x33e88
#define ixSMU_PM_STATUS_35                                                      0x33e8c
#define ixSMU_PM_STATUS_36                                                      0x33e90
#define ixSMU_PM_STATUS_37                                                      0x33e94
#define ixSMU_PM_STATUS_38                                                      0x33e98
#define ixSMU_PM_STATUS_39                                                      0x33e9c
#define ixSMU_PM_STATUS_40                                                      0x33ea0
#define ixSMU_PM_STATUS_41                                                      0x33ea4
#define ixSMU_PM_STATUS_42                                                      0x33ea8
#define ixSMU_PM_STATUS_43                                                      0x33eac
#define ixSMU_PM_STATUS_44                                                      0x33eb0
#define ixSMU_PM_STATUS_45                                                      0x33eb4
#define ixSMU_PM_STATUS_46                                                      0x33eb8
#define ixSMU_PM_STATUS_47                                                      0x33ebc
#define ixSMU_PM_STATUS_48                                                      0x33ec0
#define ixSMU_PM_STATUS_49                                                      0x33ec4
#define ixSMU_PM_STATUS_50                                                      0x33ec8
#define ixSMU_PM_STATUS_51                                                      0x33ecc
#define ixSMU_PM_STATUS_52                                                      0x33ed0
#define ixSMU_PM_STATUS_53                                                      0x33ed4
#define ixSMU_PM_STATUS_54                                                      0x33ed8
#define ixSMU_PM_STATUS_55                                                      0x33edc
#define ixSMU_PM_STATUS_56                                                      0x33ee0
#define ixSMU_PM_STATUS_57                                                      0x33ee4
#define ixSMU_PM_STATUS_58                                                      0x33ee8
#define ixSMU_PM_STATUS_59                                                      0x33eec
#define ixSMU_PM_STATUS_60                                                      0x33ef0
#define ixSMU_PM_STATUS_61                                                      0x33ef4
#define ixSMU_PM_STATUS_62                                                      0x33ef8
#define ixSMU_PM_STATUS_63                                                      0x33efc
#define ixSMU_PM_STATUS_64                                                      0x33f00
#define ixSMU_PM_STATUS_65                                                      0x33f04
#define ixSMU_PM_STATUS_66                                                      0x33f08
#define ixSMU_PM_STATUS_67                                                      0x33f0c
#define ixSMU_PM_STATUS_68                                                      0x33f10
#define ixSMU_PM_STATUS_69                                                      0x33f14
#define ixSMU_PM_STATUS_70                                                      0x33f18
#define ixSMU_PM_STATUS_71                                                      0x33f1c
#define ixSMU_PM_STATUS_72                                                      0x33f20
#define ixSMU_PM_STATUS_73                                                      0x33f24
#define ixSMU_PM_STATUS_74                                                      0x33f28
#define ixSMU_PM_STATUS_75                                                      0x33f2c
#define ixSMU_PM_STATUS_76                                                      0x33f30
#define ixSMU_PM_STATUS_77                                                      0x33f34
#define ixSMU_PM_STATUS_78                                                      0x33f38
#define ixSMU_PM_STATUS_79                                                      0x33f3c
#define ixSMU_PM_STATUS_80                                                      0x33f40
#define ixSMU_PM_STATUS_81                                                      0x33f44
#define ixSMU_PM_STATUS_82                                                      0x33f48
#define ixSMU_PM_STATUS_83                                                      0x33f4c
#define ixSMU_PM_STATUS_84                                                      0x33f50
#define ixSMU_PM_STATUS_85                                                      0x33f54
#define ixSMU_PM_STATUS_86                                                      0x33f58
#define ixSMU_PM_STATUS_87                                                      0x33f5c
#define ixSMU_PM_STATUS_88                                                      0x33f60
#define ixSMU_PM_STATUS_89                                                      0x33f64
#define ixSMU_PM_STATUS_90                                                      0x33f68
#define ixSMU_PM_STATUS_91                                                      0x33f6c
#define ixSMU_PM_STATUS_92                                                      0x33f70
#define ixSMU_PM_STATUS_93                                                      0x33f74
#define ixSMU_PM_STATUS_94                                                      0x33f78
#define ixSMU_PM_STATUS_95                                                      0x33f7c
#define ixSMU_PM_STATUS_96                                                      0x33f80
#define ixSMU_PM_STATUS_97                                                      0x33f84
#define ixSMU_PM_STATUS_98                                                      0x33f88
#define ixSMU_PM_STATUS_99                                                      0x33f8c
#define ixSMU_PM_STATUS_100                                                     0x33f90
#define ixSMU_PM_STATUS_101                                                     0x33f94
#define ixSMU_PM_STATUS_102                                                     0x33f98
#define ixSMU_PM_STATUS_103                                                     0x33f9c
#define ixSMU_PM_STATUS_104                                                     0x33fa0
#define ixSMU_PM_STATUS_105                                                     0x33fa4
#define ixSMU_PM_STATUS_106                                                     0x33fa8
#define ixSMU_PM_STATUS_107                                                     0x33fac
#define ixSMU_PM_STATUS_108                                                     0x33fb0
#define ixSMU_PM_STATUS_109                                                     0x33fb4
#define ixSMU_PM_STATUS_110                                                     0x33fb8
#define ixSMU_PM_STATUS_111                                                     0x33fbc
#define ixSMU_PM_STATUS_112                                                     0x33fc0
#define ixSMU_PM_STATUS_113                                                     0x33fc4
#define ixSMU_PM_STATUS_114                                                     0x33fc8
#define ixSMU_PM_STATUS_115                                                     0x33fcc
#define ixSMU_PM_STATUS_116                                                     0x33fd0
#define ixSMU_PM_STATUS_117                                                     0x33fd4
#define ixSMU_PM_STATUS_118                                                     0x33fd8
#define ixSMU_PM_STATUS_119                                                     0x33fdc
#define ixSMU_PM_STATUS_120                                                     0x33fe0
#define ixSMU_PM_STATUS_121                                                     0x33fe4
#define ixSMU_PM_STATUS_122                                                     0x33fe8
#define ixSMU_PM_STATUS_123                                                     0x33fec
#define ixSMU_PM_STATUS_124                                                     0x33ff0
#define ixSMU_PM_STATUS_125                                                     0x33ff4
#define ixSMU_PM_STATUS_126                                                     0x33ff8
#define ixSMU_PM_STATUS_127                                                     0x33ffc
#define ixCG_THERMAL_INT_ENA                                                    0xc2100024
#define ixCG_THERMAL_INT_CTRL                                                   0xc2100028
#define ixCG_THERMAL_INT_STATUS                                                 0xc210002c
#define ixCG_THERMAL_CTRL                                                       0xc0300004
#define ixCG_THERMAL_STATUS                                                     0xc0300008
#define ixCG_THERMAL_INT                                                        0xc030000c
#define ixCG_MULT_THERMAL_CTRL                                                  0xc0300010
#define ixCG_MULT_THERMAL_STATUS                                                0xc0300014
#define ixCG_FDO_CTRL0                                                          0xc0300064
#define ixCG_FDO_CTRL1                                                          0xc0300068
#define ixCG_FDO_CTRL2                                                          0xc030006c
#define ixCG_TACH_CTRL                                                          0xc0300070
#define ixCG_TACH_STATUS                                                        0xc0300074
#define ixCC_THM_STRAPS0                                                        0xc0300080
#define ixTHM_TMON0_RDIL0_DATA                                                  0xc0300100
#define ixTHM_TMON0_RDIL1_DATA                                                  0xc0300104
#define ixTHM_TMON0_RDIL2_DATA                                                  0xc0300108
#define ixTHM_TMON0_RDIL3_DATA                                                  0xc030010c
#define ixTHM_TMON0_RDIL4_DATA                                                  0xc0300110
#define ixTHM_TMON0_RDIL5_DATA                                                  0xc0300114
#define ixTHM_TMON0_RDIL6_DATA                                                  0xc0300118
#define ixTHM_TMON0_RDIL7_DATA                                                  0xc030011c
#define ixTHM_TMON0_RDIL8_DATA                                                  0xc0300120
#define ixTHM_TMON0_RDIL9_DATA                                                  0xc0300124
#define ixTHM_TMON0_RDIL10_DATA                                                 0xc0300128
#define ixTHM_TMON0_RDIL11_DATA                                                 0xc030012c
#define ixTHM_TMON0_RDIL12_DATA                                                 0xc0300130
#define ixTHM_TMON0_RDIL13_DATA                                                 0xc0300134
#define ixTHM_TMON0_RDIL14_DATA                                                 0xc0300138
#define ixTHM_TMON0_RDIL15_DATA                                                 0xc030013c
#define ixTHM_TMON0_RDIR0_DATA                                                  0xc0300140
#define ixTHM_TMON0_RDIR1_DATA                                                  0xc0300144
#define ixTHM_TMON0_RDIR2_DATA                                                  0xc0300148
#define ixTHM_TMON0_RDIR3_DATA                                                  0xc030014c
#define ixTHM_TMON0_RDIR4_DATA                                                  0xc0300150
#define ixTHM_TMON0_RDIR5_DATA                                                  0xc0300154
#define ixTHM_TMON0_RDIR6_DATA                                                  0xc0300158
#define ixTHM_TMON0_RDIR7_DATA                                                  0xc030015c
#define ixTHM_TMON0_RDIR8_DATA                                                  0xc0300160
#define ixTHM_TMON0_RDIR9_DATA                                                  0xc0300164
#define ixTHM_TMON0_RDIR10_DATA                                                 0xc0300168
#define ixTHM_TMON0_RDIR11_DATA                                                 0xc030016c
#define ixTHM_TMON0_RDIR12_DATA                                                 0xc0300170
#define ixTHM_TMON0_RDIR13_DATA                                                 0xc0300174
#define ixTHM_TMON0_RDIR14_DATA                                                 0xc0300178
#define ixTHM_TMON0_RDIR15_DATA                                                 0xc030017c
#define ixTHM_TMON0_INT_DATA                                                    0xc0300300
#define ixTHM_TMON0_DEBUG                                                       0xc0300310
#define ixTHM_TMON0_STATUS                                                      0xc0300320
#define ixGENERAL_PWRMGT                                                        0xc0200000
#define ixCNB_PWRMGT_CNTL                                                       0xc0200004
#define ixSCLK_PWRMGT_CNTL                                                      0xc0200008
#define ixTARGET_AND_CURRENT_PROFILE_INDEX                                      0xc0200014
#define ixPWR_PCC_CONTROL                                                       0xc0200018
#define ixPWR_PCC_GPIO_SELECT                                                   0xc020001c
#define ixCG_FREQ_TRAN_VOTING_0                                                 0xc02001a8
#define ixCG_FREQ_TRAN_VOTING_1                                                 0xc02001ac
#define ixCG_FREQ_TRAN_VOTING_2                                                 0xc02001b0
#define ixCG_FREQ_TRAN_VOTING_3                                                 0xc02001b4
#define ixCG_FREQ_TRAN_VOTING_4                                                 0xc02001b8
#define ixCG_FREQ_TRAN_VOTING_5                                                 0xc02001bc
#define ixCG_FREQ_TRAN_VOTING_6                                                 0xc02001c0
#define ixCG_FREQ_TRAN_VOTING_7                                                 0xc02001c4
#define ixPLL_TEST_CNTL                                                         0xc020003c
#define ixCG_STATIC_SCREEN_PARAMETER                                            0xc0200044
#define ixCG_DISPLAY_GAP_CNTL                                                   0xc0200060
#define ixCG_DISPLAY_GAP_CNTL2                                                  0xc0200230
#define ixCG_ACPI_CNTL                                                          0xc0200064
#define ixSCLK_DEEP_SLEEP_CNTL                                                  0xc0200080
#define ixSCLK_DEEP_SLEEP_CNTL2                                                 0xc0200084
#define ixSCLK_DEEP_SLEEP_CNTL3                                                 0xc020009c
#define ixSCLK_DEEP_SLEEP_MISC_CNTL                                             0xc0200088
#define ixLCLK_DEEP_SLEEP_CNTL                                                  0xc020008c
#define ixLCLK_DEEP_SLEEP_CNTL2                                                 0xc0200310
#define ixTARGET_AND_CURRENT_PROFILE_INDEX_1                                    0xc02000f0
#define ixCG_ULV_PARAMETER                                                      0xc020015c
#define ixSCLK_MIN_DIV                                                          0xc02003ac
#define ixPWR_DISP_TIMER_0_CONTROL                                              0xc0200390
#define ixPWR_DISP_TIMER_1_CONTROL                                              0xc020037c
#define ixPWR_DISP_TIMER_2_CONTROL                                              0xc02003d0
#define ixPWR_DISP_TIMER_3_CONTROL                                              0xc02003d4
#define ixPWR_DISP_TIMER_4_CONTROL                                              0xc02003d8
#define ixPWR_DISP_TIMER_5_CONTROL                                              0xc02003dc
#define ixPWR_DISP_TIMER_6_CONTROL                                              0xc02003e0
#define ixPWR_DISP_TIMER_7_CONTROL                                              0xc02003e4
#define ixPWR_DISP_TIMER_8_CONTROL                                              0xc02003e8
#define ixPWR_DISP_TIMER_9_CONTROL                                              0xc02003ec
#define ixPWR_DISP_TIMER_10_CONTROL                                             0xc02003f0
#define ixPWR_DISP_TIMER_11_CONTROL                                             0xc02003f4
#define ixPWR_DISP_TIMER_12_CONTROL                                             0xc02003f8
#define ixPWR_DISP_TIMER_13_CONTROL                                             0xc02003fc
#define ixPWR_DISP_TIMER_14_CONTROL                                             0xc0200074
#define ixPWR_DISP_TIMER_15_CONTROL                                             0xc0200078
#define ixPWR_DISP_TIMER_CONTROL2                                               0xc0200378
#define ixVDDGFX_IDLE_PARAMETER                                                 0xc020036c
#define ixVDDGFX_IDLE_CONTROL                                                   0xc0200370
#define ixVDDGFX_IDLE_EXIT                                                      0xc0200374
#define ixLCAC_MC0_CNTL                                                         0xc0400130
#define ixLCAC_MC0_OVR_SEL                                                      0xc0400134
#define ixLCAC_MC0_OVR_VAL                                                      0xc0400138
#define ixLCAC_MC1_CNTL                                                         0xc040013c
#define ixLCAC_MC1_OVR_SEL                                                      0xc0400140
#define ixLCAC_MC1_OVR_VAL                                                      0xc0400144
#define ixLCAC_MC2_CNTL                                                         0xc0400148
#define ixLCAC_MC2_OVR_SEL                                                      0xc040014c
#define ixLCAC_MC2_OVR_VAL                                                      0xc0400150
#define ixLCAC_MC3_CNTL                                                         0xc0400154
#define ixLCAC_MC3_OVR_SEL                                                      0xc0400158
#define ixLCAC_MC3_OVR_VAL                                                      0xc040015c
#define ixLCAC_CPL_CNTL                                                         0xc0400160
#define ixLCAC_CPL_OVR_SEL                                                      0xc0400164
#define ixLCAC_CPL_OVR_VAL                                                      0xc0400168
#define mmROM_SMC_IND_INDEX                                                     0x80
#define mmROM0_ROM_SMC_IND_INDEX                                                0x80
#define mmROM1_ROM_SMC_IND_INDEX                                                0x82
#define mmROM2_ROM_SMC_IND_INDEX                                                0x84
#define mmROM3_ROM_SMC_IND_INDEX                                                0x86
#define mmROM_SMC_IND_DATA                                                      0x81
#define mmROM0_ROM_SMC_IND_DATA                                                 0x81
#define mmROM1_ROM_SMC_IND_DATA                                                 0x83
#define mmROM2_ROM_SMC_IND_DATA                                                 0x85
#define mmROM3_ROM_SMC_IND_DATA                                                 0x87
#define ixROM_CNTL                                                              0xc0600000
#define ixPAGE_MIRROR_CNTL                                                      0xc0600004
#define ixROM_STATUS                                                            0xc0600008
#define ixCGTT_ROM_CLK_CTRL0                                                    0xc060000c
#define ixROM_INDEX                                                             0xc0600010
#define ixROM_DATA                                                              0xc0600014
#define ixROM_START                                                             0xc0600018
#define ixROM_SW_CNTL                                                           0xc060001c
#define ixROM_SW_STATUS                                                         0xc0600020
#define ixROM_SW_COMMAND                                                        0xc0600024
#define ixROM_SW_DATA_1                                                         0xc0600028
#define ixROM_SW_DATA_2                                                         0xc060002c
#define ixROM_SW_DATA_3                                                         0xc0600030
#define ixROM_SW_DATA_4                                                         0xc0600034
#define ixROM_SW_DATA_5                                                         0xc0600038
#define ixROM_SW_DATA_6                                                         0xc060003c
#define ixROM_SW_DATA_7                                                         0xc0600040
#define ixROM_SW_DATA_8                                                         0xc0600044
#define ixROM_SW_DATA_9                                                         0xc0600048
#define ixROM_SW_DATA_10                                                        0xc060004c
#define ixROM_SW_DATA_11                                                        0xc0600050
#define ixROM_SW_DATA_12                                                        0xc0600054
#define ixROM_SW_DATA_13                                                        0xc0600058
#define ixROM_SW_DATA_14                                                        0xc060005c
#define ixROM_SW_DATA_15                                                        0xc0600060
#define ixROM_SW_DATA_16                                                        0xc0600064
#define ixROM_SW_DATA_17                                                        0xc0600068
#define ixROM_SW_DATA_18                                                        0xc060006c
#define ixROM_SW_DATA_19                                                        0xc0600070
#define ixROM_SW_DATA_20                                                        0xc0600074
#define ixROM_SW_DATA_21                                                        0xc0600078
#define ixROM_SW_DATA_22                                                        0xc060007c
#define ixROM_SW_DATA_23                                                        0xc0600080
#define ixROM_SW_DATA_24                                                        0xc0600084
#define ixROM_SW_DATA_25                                                        0xc0600088
#define ixROM_SW_DATA_26                                                        0xc060008c
#define ixROM_SW_DATA_27                                                        0xc0600090
#define ixROM_SW_DATA_28                                                        0xc0600094
#define ixROM_SW_DATA_29                                                        0xc0600098
#define ixROM_SW_DATA_30                                                        0xc060009c
#define ixROM_SW_DATA_31                                                        0xc06000a0
#define ixROM_SW_DATA_32                                                        0xc06000a4
#define ixROM_SW_DATA_33                                                        0xc06000a8
#define ixROM_SW_DATA_34                                                        0xc06000ac
#define ixROM_SW_DATA_35                                                        0xc06000b0
#define ixROM_SW_DATA_36                                                        0xc06000b4
#define ixROM_SW_DATA_37                                                        0xc06000b8
#define ixROM_SW_DATA_38                                                        0xc06000bc
#define ixROM_SW_DATA_39                                                        0xc06000c0
#define ixROM_SW_DATA_40                                                        0xc06000c4
#define ixROM_SW_DATA_41                                                        0xc06000c8
#define ixROM_SW_DATA_42                                                        0xc06000cc
#define ixROM_SW_DATA_43                                                        0xc06000d0
#define ixROM_SW_DATA_44                                                        0xc06000d4
#define ixROM_SW_DATA_45                                                        0xc06000d8
#define ixROM_SW_DATA_46                                                        0xc06000dc
#define ixROM_SW_DATA_47                                                        0xc06000e0
#define ixROM_SW_DATA_48                                                        0xc06000e4
#define ixROM_SW_DATA_49                                                        0xc06000e8
#define ixROM_SW_DATA_50                                                        0xc06000ec
#define ixROM_SW_DATA_51                                                        0xc06000f0
#define ixROM_SW_DATA_52                                                        0xc06000f4
#define ixROM_SW_DATA_53                                                        0xc06000f8
#define ixROM_SW_DATA_54                                                        0xc06000fc
#define ixROM_SW_DATA_55                                                        0xc0600100
#define ixROM_SW_DATA_56                                                        0xc0600104
#define ixROM_SW_DATA_57                                                        0xc0600108
#define ixROM_SW_DATA_58                                                        0xc060010c
#define ixROM_SW_DATA_59                                                        0xc0600110
#define ixROM_SW_DATA_60                                                        0xc0600114
#define ixROM_SW_DATA_61                                                        0xc0600118
#define ixROM_SW_DATA_62                                                        0xc060011c
#define ixROM_SW_DATA_63                                                        0xc0600120
#define ixROM_SW_DATA_64                                                        0xc0600124

#endif /* SMU_7_1_1_D_H */
