/*
 * Copyright (c) 2005-2011 Atheros Communications Inc.
 * Copyright (c) 2011-2017 Qualcomm Atheros, Inc.
 * Copyright (c) 2018, The Linux Foundation. All rights reserved.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#ifndef _WMI_TLV_H
#define _WMI_TLV_H

#define WMI_TLV_CMD(grp_id) (((grp_id) << 12) | 0x1)
#define WMI_TLV_EV(grp_id) (((grp_id) << 12) | 0x1)
#define WMI_TLV_CMD_UNSUPPORTED 0
#define WMI_TLV_PDEV_PARAM_UNSUPPORTED 0
#define WMI_TLV_VDEV_PARAM_UNSUPPORTED 0
#define WMI_TLV_MGMT_TX_FRAME_MAX_LEN	64

enum wmi_tlv_grp_id {
	WMI_TLV_GRP_START = 0x3,
	WMI_TLV_GRP_SCAN = WMI_TLV_GRP_START,
	WMI_TLV_GRP_PDEV,
	WMI_TLV_GRP_VDEV,
	WMI_TLV_GRP_PEER,
	WMI_TLV_GRP_MGMT,
	WMI_TLV_GRP_BA_NEG,
	WMI_TLV_GRP_STA_PS,
	WMI_TLV_GRP_DFS,
	WMI_TLV_GRP_ROAM,
	WMI_TLV_GRP_OFL_SCAN,
	WMI_TLV_GRP_P2P,
	WMI_TLV_GRP_AP_PS,
	WMI_TLV_GRP_RATECTL,
	WMI_TLV_GRP_PROFILE,
	WMI_TLV_GRP_SUSPEND,
	WMI_TLV_GRP_BCN_FILTER,
	WMI_TLV_GRP_WOW,
	WMI_TLV_GRP_RTT,
	WMI_TLV_GRP_SPECTRAL,
	WMI_TLV_GRP_STATS,
	WMI_TLV_GRP_ARP_NS_OFL,
	WMI_TLV_GRP_NLO_OFL,
	WMI_TLV_GRP_GTK_OFL,
	WMI_TLV_GRP_CSA_OFL,
	WMI_TLV_GRP_CHATTER,
	WMI_TLV_GRP_TID_ADDBA,
	WMI_TLV_GRP_MISC,
	WMI_TLV_GRP_GPIO,
	WMI_TLV_GRP_FWTEST,
	WMI_TLV_GRP_TDLS,
	WMI_TLV_GRP_RESMGR,
	WMI_TLV_GRP_STA_SMPS,
	WMI_TLV_GRP_WLAN_HB,
	WMI_TLV_GRP_RMC,
	WMI_TLV_GRP_MHF_OFL,
	WMI_TLV_GRP_LOCATION_SCAN,
	WMI_TLV_GRP_OEM,
	WMI_TLV_GRP_NAN,
	WMI_TLV_GRP_COEX,
	WMI_TLV_GRP_OBSS_OFL,
	WMI_TLV_GRP_LPI,
	WMI_TLV_GRP_EXTSCAN,
	WMI_TLV_GRP_DHCP_OFL,
	WMI_TLV_GRP_IPA,
	WMI_TLV_GRP_MDNS_OFL,
	WMI_TLV_GRP_SAP_OFL,
};

enum wmi_tlv_cmd_id {
	WMI_TLV_INIT_CMDID = 0x1,
	WMI_TLV_START_SCAN_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_SCAN),
	WMI_TLV_STOP_SCAN_CMDID,
	WMI_TLV_SCAN_CHAN_LIST_CMDID,
	WMI_TLV_SCAN_SCH_PRIO_TBL_CMDID,
	WMI_TLV_SCAN_UPDATE_REQUEST_CMDID,
	WMI_TLV_SCAN_PROB_REQ_OUI_CMDID,
	WMI_TLV_PDEV_SET_REGDOMAIN_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_PDEV),
	WMI_TLV_PDEV_SET_CHANNEL_CMDID,
	WMI_TLV_PDEV_SET_PARAM_CMDID,
	WMI_TLV_PDEV_PKTLOG_ENABLE_CMDID,
	WMI_TLV_PDEV_PKTLOG_DISABLE_CMDID,
	WMI_TLV_PDEV_SET_WMM_PARAMS_CMDID,
	WMI_TLV_PDEV_SET_HT_CAP_IE_CMDID,
	WMI_TLV_PDEV_SET_VHT_CAP_IE_CMDID,
	WMI_TLV_PDEV_SET_DSCP_TID_MAP_CMDID,
	WMI_TLV_PDEV_SET_QUIET_MODE_CMDID,
	WMI_TLV_PDEV_GREEN_AP_PS_ENABLE_CMDID,
	WMI_TLV_PDEV_GET_TPC_CONFIG_CMDID,
	WMI_TLV_PDEV_SET_BASE_MACADDR_CMDID,
	WMI_TLV_PDEV_DUMP_CMDID,
	WMI_TLV_PDEV_SET_LED_CONFIG_CMDID,
	WMI_TLV_PDEV_GET_TEMPERATURE_CMDID,
	WMI_TLV_PDEV_SET_LED_FLASHING_CMDID,
	WMI_TLV_VDEV_CREATE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_VDEV),
	WMI_TLV_VDEV_DELETE_CMDID,
	WMI_TLV_VDEV_START_REQUEST_CMDID,
	WMI_TLV_VDEV_RESTART_REQUEST_CMDID,
	WMI_TLV_VDEV_UP_CMDID,
	WMI_TLV_VDEV_STOP_CMDID,
	WMI_TLV_VDEV_DOWN_CMDID,
	WMI_TLV_VDEV_SET_PARAM_CMDID,
	WMI_TLV_VDEV_INSTALL_KEY_CMDID,
	WMI_TLV_VDEV_WNM_SLEEPMODE_CMDID,
	WMI_TLV_VDEV_WMM_ADDTS_CMDID,
	WMI_TLV_VDEV_WMM_DELTS_CMDID,
	WMI_TLV_VDEV_SET_WMM_PARAMS_CMDID,
	WMI_TLV_VDEV_SET_GTX_PARAMS_CMDID,
	WMI_TLV_VDEV_IPSEC_NATKEEPALIVE_FILTER_CMDID,
	WMI_TLV_VDEV_PLMREQ_START_CMDID,
	WMI_TLV_VDEV_PLMREQ_STOP_CMDID,
	WMI_TLV_PEER_CREATE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_PEER),
	WMI_TLV_PEER_DELETE_CMDID,
	WMI_TLV_PEER_FLUSH_TIDS_CMDID,
	WMI_TLV_PEER_SET_PARAM_CMDID,
	WMI_TLV_PEER_ASSOC_CMDID,
	WMI_TLV_PEER_ADD_WDS_ENTRY_CMDID,
	WMI_TLV_PEER_REMOVE_WDS_ENTRY_CMDID,
	WMI_TLV_PEER_MCAST_GROUP_CMDID,
	WMI_TLV_PEER_INFO_REQ_CMDID,
	WMI_TLV_PEER_GET_ESTIMATED_LINKSPEED_CMDID,
	WMI_TLV_BCN_TX_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_MGMT),
	WMI_TLV_PDEV_SEND_BCN_CMDID,
	WMI_TLV_BCN_TMPL_CMDID,
	WMI_TLV_BCN_FILTER_RX_CMDID,
	WMI_TLV_PRB_REQ_FILTER_RX_CMDID,
	WMI_TLV_MGMT_TX_CMDID,
	WMI_TLV_PRB_TMPL_CMDID,
	WMI_TLV_MGMT_TX_SEND_CMD,
	WMI_TLV_ADDBA_CLEAR_RESP_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_BA_NEG),
	WMI_TLV_ADDBA_SEND_CMDID,
	WMI_TLV_ADDBA_STATUS_CMDID,
	WMI_TLV_DELBA_SEND_CMDID,
	WMI_TLV_ADDBA_SET_RESP_CMDID,
	WMI_TLV_SEND_SINGLEAMSDU_CMDID,
	WMI_TLV_STA_POWERSAVE_MODE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_STA_PS),
	WMI_TLV_STA_POWERSAVE_PARAM_CMDID,
	WMI_TLV_STA_MIMO_PS_MODE_CMDID,
	WMI_TLV_PDEV_DFS_ENABLE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_DFS),
	WMI_TLV_PDEV_DFS_DISABLE_CMDID,
	WMI_TLV_DFS_PHYERR_FILTER_ENA_CMDID,
	WMI_TLV_DFS_PHYERR_FILTER_DIS_CMDID,
	WMI_TLV_ROAM_SCAN_MODE = WMI_TLV_CMD(WMI_TLV_GRP_ROAM),
	WMI_TLV_ROAM_SCAN_RSSI_THRESHOLD,
	WMI_TLV_ROAM_SCAN_PERIOD,
	WMI_TLV_ROAM_SCAN_RSSI_CHANGE_THRESHOLD,
	WMI_TLV_ROAM_AP_PROFILE,
	WMI_TLV_ROAM_CHAN_LIST,
	WMI_TLV_ROAM_SCAN_CMD,
	WMI_TLV_ROAM_SYNCH_COMPLETE,
	WMI_TLV_ROAM_SET_RIC_REQUEST_CMDID,
	WMI_TLV_ROAM_INVOKE_CMDID,
	WMI_TLV_OFL_SCAN_ADD_AP_PROFILE = WMI_TLV_CMD(WMI_TLV_GRP_OFL_SCAN),
	WMI_TLV_OFL_SCAN_REMOVE_AP_PROFILE,
	WMI_TLV_OFL_SCAN_PERIOD,
	WMI_TLV_P2P_DEV_SET_DEVICE_INFO = WMI_TLV_CMD(WMI_TLV_GRP_P2P),
	WMI_TLV_P2P_DEV_SET_DISCOVERABILITY,
	WMI_TLV_P2P_GO_SET_BEACON_IE,
	WMI_TLV_P2P_GO_SET_PROBE_RESP_IE,
	WMI_TLV_P2P_SET_VENDOR_IE_DATA_CMDID,
	WMI_TLV_P2P_DISC_OFFLOAD_CONFIG_CMDID,
	WMI_TLV_P2P_DISC_OFFLOAD_APPIE_CMDID,
	WMI_TLV_P2P_DISC_OFFLOAD_PATTERN_CMDID,
	WMI_TLV_P2P_SET_OPPPS_PARAM_CMDID,
	WMI_TLV_AP_PS_PEER_PARAM_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_AP_PS),
	WMI_TLV_AP_PS_PEER_UAPSD_COEX_CMDID,
	WMI_TLV_PEER_RATE_RETRY_SCHED_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_RATECTL),
	WMI_TLV_WLAN_PROFILE_TRIGGER_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_PROFILE),
	WMI_TLV_WLAN_PROFILE_SET_HIST_INTVL_CMDID,
	WMI_TLV_WLAN_PROFILE_GET_PROFILE_DATA_CMDID,
	WMI_TLV_WLAN_PROFILE_ENABLE_PROFILE_ID_CMDID,
	WMI_TLV_WLAN_PROFILE_LIST_PROFILE_ID_CMDID,
	WMI_TLV_PDEV_SUSPEND_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_SUSPEND),
	WMI_TLV_PDEV_RESUME_CMDID,
	WMI_TLV_ADD_BCN_FILTER_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_BCN_FILTER),
	WMI_TLV_RMV_BCN_FILTER_CMDID,
	WMI_TLV_WOW_ADD_WAKE_PATTERN_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_WOW),
	WMI_TLV_WOW_DEL_WAKE_PATTERN_CMDID,
	WMI_TLV_WOW_ENABLE_DISABLE_WAKE_EVENT_CMDID,
	WMI_TLV_WOW_ENABLE_CMDID,
	WMI_TLV_WOW_HOSTWAKEUP_FROM_SLEEP_CMDID,
	WMI_TLV_WOW_ACER_IOAC_ADD_KEEPALIVE_CMDID,
	WMI_TLV_WOW_ACER_IOAC_DEL_KEEPALIVE_CMDID,
	WMI_TLV_WOW_ACER_IOAC_ADD_WAKE_PATTERN_CMDID,
	WMI_TLV_WOW_ACER_IOAC_DEL_WAKE_PATTERN_CMDID,
	WMI_TLV_D0_WOW_ENABLE_DISABLE_CMDID,
	WMI_TLV_EXTWOW_ENABLE_CMDID,
	WMI_TLV_EXTWOW_SET_APP_TYPE1_PARAMS_CMDID,
	WMI_TLV_EXTWOW_SET_APP_TYPE2_PARAMS_CMDID,
	WMI_TLV_RTT_MEASREQ_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_RTT),
	WMI_TLV_RTT_TSF_CMDID,
	WMI_TLV_SPECTRAL_SCAN_CONF_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_SPECTRAL),
	WMI_TLV_SPECTRAL_SCAN_ENABLE_CMDID,
	WMI_TLV_REQUEST_STATS_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_STATS),
	WMI_TLV_MCC_SCHED_TRAFFIC_STATS_CMDID,
	WMI_TLV_REQUEST_STATS_EXT_CMDID,
	WMI_TLV_REQUEST_LINK_STATS_CMDID,
	WMI_TLV_START_LINK_STATS_CMDID,
	WMI_TLV_CLEAR_LINK_STATS_CMDID,
	WMI_TLV_SET_ARP_NS_OFFLOAD_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_ARP_NS_OFL),
	WMI_TLV_ADD_PROACTIVE_ARP_RSP_PATTERN_CMDID,
	WMI_TLV_DEL_PROACTIVE_ARP_RSP_PATTERN_CMDID,
	WMI_TLV_NETWORK_LIST_OFFLOAD_CONFIG_CMDID =
			WMI_TLV_CMD(WMI_TLV_GRP_NLO_OFL),
	WMI_TLV_APFIND_CMDID,
	WMI_TLV_GTK_OFFLOAD_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_GTK_OFL),
	WMI_TLV_CSA_OFFLOAD_ENABLE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_CSA_OFL),
	WMI_TLV_CSA_OFFLOAD_CHANSWITCH_CMDID,
	WMI_TLV_CHATTER_SET_MODE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_CHATTER),
	WMI_TLV_CHATTER_ADD_COALESCING_FILTER_CMDID,
	WMI_TLV_CHATTER_DELETE_COALESCING_FILTER_CMDID,
	WMI_TLV_CHATTER_COALESCING_QUERY_CMDID,
	WMI_TLV_PEER_TID_ADDBA_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_TID_ADDBA),
	WMI_TLV_PEER_TID_DELBA_CMDID,
	WMI_TLV_STA_DTIM_PS_METHOD_CMDID,
	WMI_TLV_STA_UAPSD_AUTO_TRIG_CMDID,
	WMI_TLV_STA_KEEPALIVE_CMDID,
	WMI_TLV_BA_REQ_SSN_CMDID,
	WMI_TLV_ECHO_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_MISC),
	WMI_TLV_PDEV_UTF_CMDID,
	WMI_TLV_DBGLOG_CFG_CMDID,
	WMI_TLV_PDEV_QVIT_CMDID,
	WMI_TLV_PDEV_FTM_INTG_CMDID,
	WMI_TLV_VDEV_SET_KEEPALIVE_CMDID,
	WMI_TLV_VDEV_GET_KEEPALIVE_CMDID,
	WMI_TLV_FORCE_FW_HANG_CMDID,
	WMI_TLV_SET_MCASTBCAST_FILTER_CMDID,
	WMI_TLV_THERMAL_MGMT_CMDID,
	WMI_TLV_HOST_AUTO_SHUTDOWN_CFG_CMDID,
	WMI_TLV_TPC_CHAINMASK_CONFIG_CMDID,
	WMI_TLV_SET_ANTENNA_DIVERSITY_CMDID,
	WMI_TLV_GPIO_CONFIG_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_GPIO),
	WMI_TLV_GPIO_OUTPUT_CMDID,
	WMI_TLV_TXBF_CMDID,
	WMI_TLV_FWTEST_VDEV_MCC_SET_TBTT_MODE_CMDID =
			WMI_TLV_CMD(WMI_TLV_GRP_FWTEST),
	WMI_TLV_FWTEST_P2P_SET_NOA_PARAM_CMDID,
	WMI_TLV_UNIT_TEST_CMDID,
	WMI_TLV_TDLS_SET_STATE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_TDLS),
	WMI_TLV_TDLS_PEER_UPDATE_CMDID,
	WMI_TLV_TDLS_SET_OFFCHAN_MODE_CMDID,
	WMI_TLV_RESMGR_ADAPTIVE_OCS_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_RESMGR),
	WMI_TLV_RESMGR_SET_CHAN_TIME_QUOTA_CMDID,
	WMI_TLV_RESMGR_SET_CHAN_LATENCY_CMDID,
	WMI_TLV_STA_SMPS_FORCE_MODE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_STA_SMPS),
	WMI_TLV_STA_SMPS_PARAM_CMDID,
	WMI_TLV_HB_SET_ENABLE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_WLAN_HB),
	WMI_TLV_HB_SET_TCP_PARAMS_CMDID,
	WMI_TLV_HB_SET_TCP_PKT_FILTER_CMDID,
	WMI_TLV_HB_SET_UDP_PARAMS_CMDID,
	WMI_TLV_HB_SET_UDP_PKT_FILTER_CMDID,
	WMI_TLV_RMC_SET_MODE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_RMC),
	WMI_TLV_RMC_SET_ACTION_PERIOD_CMDID,
	WMI_TLV_RMC_CONFIG_CMDID,
	WMI_TLV_MHF_OFFLOAD_SET_MODE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_MHF_OFL),
	WMI_TLV_MHF_OFFLOAD_PLUMB_ROUTING_TBL_CMDID,
	WMI_TLV_BATCH_SCAN_ENABLE_CMDID =
			WMI_TLV_CMD(WMI_TLV_GRP_LOCATION_SCAN),
	WMI_TLV_BATCH_SCAN_DISABLE_CMDID,
	WMI_TLV_BATCH_SCAN_TRIGGER_RESULT_CMDID,
	WMI_TLV_OEM_REQ_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_OEM),
	WMI_TLV_NAN_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_NAN),
	WMI_TLV_MODEM_POWER_STATE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_COEX),
	WMI_TLV_CHAN_AVOID_UPDATE_CMDID,
	WMI_TLV_OBSS_SCAN_ENABLE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_OBSS_OFL),
	WMI_TLV_OBSS_SCAN_DISABLE_CMDID,
	WMI_TLV_LPI_MGMT_SNOOPING_CONFIG_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_LPI),
	WMI_TLV_LPI_START_SCAN_CMDID,
	WMI_TLV_LPI_STOP_SCAN_CMDID,
	WMI_TLV_EXTSCAN_START_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_EXTSCAN),
	WMI_TLV_EXTSCAN_STOP_CMDID,
	WMI_TLV_EXTSCAN_CONFIGURE_WLAN_CHANGE_MONITOR_CMDID,
	WMI_TLV_EXTSCAN_CONFIGURE_HOTLIST_MONITOR_CMDID,
	WMI_TLV_EXTSCAN_GET_CACHED_RESULTS_CMDID,
	WMI_TLV_EXTSCAN_GET_WLAN_CHANGE_RESULTS_CMDID,
	WMI_TLV_EXTSCAN_SET_CAPABILITIES_CMDID,
	WMI_TLV_EXTSCAN_GET_CAPABILITIES_CMDID,
	WMI_TLV_SET_DHCP_SERVER_OFFLOAD_CMDID =
			WMI_TLV_CMD(WMI_TLV_GRP_DHCP_OFL),
	WMI_TLV_IPA_OFFLOAD_ENABLE_DISABLE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_IPA),
	WMI_TLV_MDNS_OFFLOAD_ENABLE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_MDNS_OFL),
	WMI_TLV_MDNS_SET_FQDN_CMDID,
	WMI_TLV_MDNS_SET_RESPONSE_CMDID,
	WMI_TLV_MDNS_GET_STATS_CMDID,
	WMI_TLV_SAP_OFL_ENABLE_CMDID = WMI_TLV_CMD(WMI_TLV_GRP_SAP_OFL),
};

enum wmi_tlv_event_id {
	WMI_TLV_SERVICE_READY_EVENTID = 0x1,
	WMI_TLV_READY_EVENTID,
	WMI_TLV_SERVICE_AVAILABLE_EVENTID,
	WMI_TLV_SCAN_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_SCAN),
	WMI_TLV_PDEV_TPC_CONFIG_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_PDEV),
	WMI_TLV_CHAN_INFO_EVENTID,
	WMI_TLV_PHYERR_EVENTID,
	WMI_TLV_PDEV_DUMP_EVENTID,
	WMI_TLV_TX_PAUSE_EVENTID,
	WMI_TLV_DFS_RADAR_EVENTID,
	WMI_TLV_PDEV_L1SS_TRACK_EVENTID,
	WMI_TLV_PDEV_TEMPERATURE_EVENTID,
	WMI_TLV_VDEV_START_RESP_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_VDEV),
	WMI_TLV_VDEV_STOPPED_EVENTID,
	WMI_TLV_VDEV_INSTALL_KEY_COMPLETE_EVENTID,
	WMI_TLV_VDEV_MCC_BCN_INTERVAL_CHANGE_REQ_EVENTID,
	WMI_TLV_PEER_STA_KICKOUT_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_PEER),
	WMI_TLV_PEER_INFO_EVENTID,
	WMI_TLV_PEER_TX_FAIL_CNT_THR_EVENTID,
	WMI_TLV_PEER_ESTIMATED_LINKSPEED_EVENTID,
	WMI_TLV_PEER_STATE_EVENTID,
	WMI_TLV_MGMT_RX_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_MGMT),
	WMI_TLV_HOST_SWBA_EVENTID,
	WMI_TLV_TBTTOFFSET_UPDATE_EVENTID,
	WMI_TLV_OFFLOAD_BCN_TX_STATUS_EVENTID,
	WMI_TLV_OFFLOAD_PROB_RESP_TX_STATUS_EVENTID,
	WMI_TLV_MGMT_TX_COMPLETION_EVENTID,
	WMI_TLV_TX_DELBA_COMPLETE_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_BA_NEG),
	WMI_TLV_TX_ADDBA_COMPLETE_EVENTID,
	WMI_TLV_BA_RSP_SSN_EVENTID,
	WMI_TLV_AGGR_STATE_TRIG_EVENTID,
	WMI_TLV_ROAM_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_ROAM),
	WMI_TLV_PROFILE_MATCH,
	WMI_TLV_ROAM_SYNCH_EVENTID,
	WMI_TLV_P2P_DISC_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_P2P),
	WMI_TLV_P2P_NOA_EVENTID,
	WMI_TLV_PDEV_RESUME_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_SUSPEND),
	WMI_TLV_WOW_WAKEUP_HOST_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_WOW),
	WMI_TLV_D0_WOW_DISABLE_ACK_EVENTID,
	WMI_TLV_RTT_MEASUREMENT_REPORT_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_RTT),
	WMI_TLV_TSF_MEASUREMENT_REPORT_EVENTID,
	WMI_TLV_RTT_ERROR_REPORT_EVENTID,
	WMI_TLV_STATS_EXT_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_STATS),
	WMI_TLV_IFACE_LINK_STATS_EVENTID,
	WMI_TLV_PEER_LINK_STATS_EVENTID,
	WMI_TLV_RADIO_LINK_STATS_EVENTID,
	WMI_TLV_NLO_MATCH_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_NLO_OFL),
	WMI_TLV_NLO_SCAN_COMPLETE_EVENTID,
	WMI_TLV_APFIND_EVENTID,
	WMI_TLV_GTK_OFFLOAD_STATUS_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_GTK_OFL),
	WMI_TLV_GTK_REKEY_FAIL_EVENTID,
	WMI_TLV_CSA_HANDLING_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_CSA_OFL),
	WMI_TLV_CHATTER_PC_QUERY_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_CHATTER),
	WMI_TLV_ECHO_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_MISC),
	WMI_TLV_PDEV_UTF_EVENTID,
	WMI_TLV_DEBUG_MESG_EVENTID,
	WMI_TLV_UPDATE_STATS_EVENTID,
	WMI_TLV_DEBUG_PRINT_EVENTID,
	WMI_TLV_DCS_INTERFERENCE_EVENTID,
	WMI_TLV_PDEV_QVIT_EVENTID,
	WMI_TLV_WLAN_PROFILE_DATA_EVENTID,
	WMI_TLV_PDEV_FTM_INTG_EVENTID,
	WMI_TLV_WLAN_FREQ_AVOID_EVENTID,
	WMI_TLV_VDEV_GET_KEEPALIVE_EVENTID,
	WMI_TLV_THERMAL_MGMT_EVENTID,
	WMI_TLV_DIAG_DATA_CONTAINER_EVENTID,
	WMI_TLV_HOST_AUTO_SHUTDOWN_EVENTID,
	WMI_TLV_UPDATE_WHAL_MIB_STATS_EVENTID,
	WMI_TLV_UPDATE_VDEV_RATE_STATS_EVENTID,
	WMI_TLV_DIAG_EVENTID,
	WMI_TLV_GPIO_INPUT_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_GPIO),
	WMI_TLV_UPLOADH_EVENTID,
	WMI_TLV_CAPTUREH_EVENTID,
	WMI_TLV_RFKILL_STATE_CHANGE_EVENTID,
	WMI_TLV_TDLS_PEER_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_TDLS),
	WMI_TLV_BATCH_SCAN_ENABLED_EVENTID =
			WMI_TLV_EV(WMI_TLV_GRP_LOCATION_SCAN),
	WMI_TLV_BATCH_SCAN_RESULT_EVENTID,
	WMI_TLV_OEM_CAPABILITY_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_OEM),
	WMI_TLV_OEM_MEASUREMENT_REPORT_EVENTID,
	WMI_TLV_OEM_ERROR_REPORT_EVENTID,
	WMI_TLV_NAN_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_NAN),
	WMI_TLV_LPI_RESULT_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_LPI),
	WMI_TLV_LPI_STATUS_EVENTID,
	WMI_TLV_LPI_HANDOFF_EVENTID,
	WMI_TLV_EXTSCAN_START_STOP_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_EXTSCAN),
	WMI_TLV_EXTSCAN_OPERATION_EVENTID,
	WMI_TLV_EXTSCAN_TABLE_USAGE_EVENTID,
	WMI_TLV_EXTSCAN_CACHED_RESULTS_EVENTID,
	WMI_TLV_EXTSCAN_WLAN_CHANGE_RESULTS_EVENTID,
	WMI_TLV_EXTSCAN_HOTLIST_MATCH_EVENTID,
	WMI_TLV_EXTSCAN_CAPABILITIES_EVENTID,
	WMI_TLV_MDNS_STATS_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_MDNS_OFL),
	WMI_TLV_SAP_OFL_ADD_STA_EVENTID = WMI_TLV_EV(WMI_TLV_GRP_SAP_OFL),
	WMI_TLV_SAP_OFL_DEL_STA_EVENTID,
};

enum wmi_tlv_pdev_param {
	WMI_TLV_PDEV_PARAM_TX_CHAIN_MASK = 0x1,
	WMI_TLV_PDEV_PARAM_RX_CHAIN_MASK,
	WMI_TLV_PDEV_PARAM_TXPOWER_LIMIT2G,
	WMI_TLV_PDEV_PARAM_TXPOWER_LIMIT5G,
	WMI_TLV_PDEV_PARAM_TXPOWER_SCALE,
	WMI_TLV_PDEV_PARAM_BEACON_GEN_MODE,
	WMI_TLV_PDEV_PARAM_BEACON_TX_MODE,
	WMI_TLV_PDEV_PARAM_RESMGR_OFFCHAN_MODE,
	WMI_TLV_PDEV_PARAM_PROTECTION_MODE,
	WMI_TLV_PDEV_PARAM_DYNAMIC_BW,
	WMI_TLV_PDEV_PARAM_NON_AGG_SW_RETRY_TH,
	WMI_TLV_PDEV_PARAM_AGG_SW_RETRY_TH,
	WMI_TLV_PDEV_PARAM_STA_KICKOUT_TH,
	WMI_TLV_PDEV_PARAM_AC_AGGRSIZE_SCALING,
	WMI_TLV_PDEV_PARAM_LTR_ENABLE,
	WMI_TLV_PDEV_PARAM_LTR_AC_LATENCY_BE,
	WMI_TLV_PDEV_PARAM_LTR_AC_LATENCY_BK,
	WMI_TLV_PDEV_PARAM_LTR_AC_LATENCY_VI,
	WMI_TLV_PDEV_PARAM_LTR_AC_LATENCY_VO,
	WMI_TLV_PDEV_PARAM_LTR_AC_LATENCY_TIMEOUT,
	WMI_TLV_PDEV_PARAM_LTR_SLEEP_OVERRIDE,
	WMI_TLV_PDEV_PARAM_LTR_RX_OVERRIDE,
	WMI_TLV_PDEV_PARAM_LTR_TX_ACTIVITY_TIMEOUT,
	WMI_TLV_PDEV_PARAM_L1SS_ENABLE,
	WMI_TLV_PDEV_PARAM_DSLEEP_ENABLE,
	WMI_TLV_PDEV_PARAM_PCIELP_TXBUF_FLUSH,
	WMI_TLV_PDEV_PARAM_PCIELP_TXBUF_WATERMARK,
	WMI_TLV_PDEV_PARAM_PCIELP_TXBUF_TMO_EN,
	WMI_TLV_PDEV_PARAM_PCIELP_TXBUF_TMO_VALUE,
	WMI_TLV_PDEV_PARAM_PDEV_STATS_UPDATE_PERIOD,
	WMI_TLV_PDEV_PARAM_VDEV_STATS_UPDATE_PERIOD,
	WMI_TLV_PDEV_PARAM_PEER_STATS_UPDATE_PERIOD,
	WMI_TLV_PDEV_PARAM_BCNFLT_STATS_UPDATE_PERIOD,
	WMI_TLV_PDEV_PARAM_PMF_QOS,
	WMI_TLV_PDEV_PARAM_ARP_AC_OVERRIDE,
	WMI_TLV_PDEV_PARAM_DCS,
	WMI_TLV_PDEV_PARAM_ANI_ENABLE,
	WMI_TLV_PDEV_PARAM_ANI_POLL_PERIOD,
	WMI_TLV_PDEV_PARAM_ANI_LISTEN_PERIOD,
	WMI_TLV_PDEV_PARAM_ANI_OFDM_LEVEL,
	WMI_TLV_PDEV_PARAM_ANI_CCK_LEVEL,
	WMI_TLV_PDEV_PARAM_DYNTXCHAIN,
	WMI_TLV_PDEV_PARAM_PROXY_STA,
	WMI_TLV_PDEV_PARAM_IDLE_PS_CONFIG,
	WMI_TLV_PDEV_PARAM_POWER_GATING_SLEEP,
	WMI_TLV_PDEV_PARAM_RFKILL_ENABLE,
	WMI_TLV_PDEV_PARAM_BURST_DUR,
	WMI_TLV_PDEV_PARAM_BURST_ENABLE,
	WMI_TLV_PDEV_PARAM_HW_RFKILL_CONFIG,
	WMI_TLV_PDEV_PARAM_LOW_POWER_RF_ENABLE,
	WMI_TLV_PDEV_PARAM_L1SS_TRACK,
	WMI_TLV_PDEV_PARAM_HYST_EN,
	WMI_TLV_PDEV_PARAM_POWER_COLLAPSE_ENABLE,
	WMI_TLV_PDEV_PARAM_LED_SYS_STATE,
	WMI_TLV_PDEV_PARAM_LED_ENABLE,
	WMI_TLV_PDEV_PARAM_AUDIO_OVER_WLAN_LATENCY,
	WMI_TLV_PDEV_PARAM_AUDIO_OVER_WLAN_ENABLE,
	WMI_TLV_PDEV_PARAM_WHAL_MIB_STATS_UPDATE_ENABLE,
	WMI_TLV_PDEV_PARAM_VDEV_RATE_STATS_UPDATE_PERIOD,
	WMI_TLV_PDEV_PARAM_TXPOWER_REASON_NONE,
	WMI_TLV_PDEV_PARAM_TXPOWER_REASON_SAR,
	WMI_TLV_PDEV_PARAM_TXPOWER_REASON_MAX,
};

enum wmi_tlv_vdev_param {
	WMI_TLV_VDEV_PARAM_RTS_THRESHOLD = 0x1,
	WMI_TLV_VDEV_PARAM_FRAGMENTATION_THRESHOLD,
	WMI_TLV_VDEV_PARAM_BEACON_INTERVAL,
	WMI_TLV_VDEV_PARAM_LISTEN_INTERVAL,
	WMI_TLV_VDEV_PARAM_MULTICAST_RATE,
	WMI_TLV_VDEV_PARAM_MGMT_TX_RATE,
	WMI_TLV_VDEV_PARAM_SLOT_TIME,
	WMI_TLV_VDEV_PARAM_PREAMBLE,
	WMI_TLV_VDEV_PARAM_SWBA_TIME,
	WMI_TLV_VDEV_STATS_UPDATE_PERIOD,
	WMI_TLV_VDEV_PWRSAVE_AGEOUT_TIME,
	WMI_TLV_VDEV_HOST_SWBA_INTERVAL,
	WMI_TLV_VDEV_PARAM_DTIM_PERIOD,
	WMI_TLV_VDEV_OC_SCHEDULER_AIR_TIME_LIMIT,
	WMI_TLV_VDEV_PARAM_WDS,
	WMI_TLV_VDEV_PARAM_ATIM_WINDOW,
	WMI_TLV_VDEV_PARAM_BMISS_COUNT_MAX,
	WMI_TLV_VDEV_PARAM_BMISS_FIRST_BCNT,
	WMI_TLV_VDEV_PARAM_BMISS_FINAL_BCNT,
	WMI_TLV_VDEV_PARAM_FEATURE_WMM,
	WMI_TLV_VDEV_PARAM_CHWIDTH,
	WMI_TLV_VDEV_PARAM_CHEXTOFFSET,
	WMI_TLV_VDEV_PARAM_DISABLE_HTPROTECTION,
	WMI_TLV_VDEV_PARAM_STA_QUICKKICKOUT,
	WMI_TLV_VDEV_PARAM_MGMT_RATE,
	WMI_TLV_VDEV_PARAM_PROTECTION_MODE,
	WMI_TLV_VDEV_PARAM_FIXED_RATE,
	WMI_TLV_VDEV_PARAM_SGI,
	WMI_TLV_VDEV_PARAM_LDPC,
	WMI_TLV_VDEV_PARAM_TX_STBC,
	WMI_TLV_VDEV_PARAM_RX_STBC,
	WMI_TLV_VDEV_PARAM_INTRA_BSS_FWD,
	WMI_TLV_VDEV_PARAM_DEF_KEYID,
	WMI_TLV_VDEV_PARAM_NSS,
	WMI_TLV_VDEV_PARAM_BCAST_DATA_RATE,
	WMI_TLV_VDEV_PARAM_MCAST_DATA_RATE,
	WMI_TLV_VDEV_PARAM_MCAST_INDICATE,
	WMI_TLV_VDEV_PARAM_DHCP_INDICATE,
	WMI_TLV_VDEV_PARAM_UNKNOWN_DEST_INDICATE,
	WMI_TLV_VDEV_PARAM_AP_KEEPALIVE_MIN_IDLE_INACTIVE_TIME_SECS,
	WMI_TLV_VDEV_PARAM_AP_KEEPALIVE_MAX_IDLE_INACTIVE_TIME_SECS,
	WMI_TLV_VDEV_PARAM_AP_KEEPALIVE_MAX_UNRESPONSIVE_TIME_SECS,
	WMI_TLV_VDEV_PARAM_AP_ENABLE_NAWDS,
	WMI_TLV_VDEV_PARAM_ENABLE_RTSCTS,
	WMI_TLV_VDEV_PARAM_TXBF,
	WMI_TLV_VDEV_PARAM_PACKET_POWERSAVE,
	WMI_TLV_VDEV_PARAM_DROP_UNENCRY,
	WMI_TLV_VDEV_PARAM_TX_ENCAP_TYPE,
	WMI_TLV_VDEV_PARAM_AP_DETECT_OUT_OF_SYNC_SLEEPING_STA_TIME_SECS,
	WMI_TLV_VDEV_PARAM_EARLY_RX_ADJUST_ENABLE,
	WMI_TLV_VDEV_PARAM_EARLY_RX_TGT_BMISS_NUM,
	WMI_TLV_VDEV_PARAM_EARLY_RX_BMISS_SAMPLE_CYCLE,
	WMI_TLV_VDEV_PARAM_EARLY_RX_SLOP_STEP,
	WMI_TLV_VDEV_PARAM_EARLY_RX_INIT_SLOP,
	WMI_TLV_VDEV_PARAM_EARLY_RX_ADJUST_PAUSE,
	WMI_TLV_VDEV_PARAM_TX_PWRLIMIT,
	WMI_TLV_VDEV_PARAM_SNR_NUM_FOR_CAL,
	WMI_TLV_VDEV_PARAM_ROAM_FW_OFFLOAD,
	WMI_TLV_VDEV_PARAM_ENABLE_RMC,
	WMI_TLV_VDEV_PARAM_IBSS_MAX_BCN_LOST_MS,
	WMI_TLV_VDEV_PARAM_MAX_RATE,
	WMI_TLV_VDEV_PARAM_EARLY_RX_DRIFT_SAMPLE,
	WMI_TLV_VDEV_PARAM_SET_IBSS_TX_FAIL_CNT_THR,
	WMI_TLV_VDEV_PARAM_EBT_RESYNC_TIMEOUT,
	WMI_TLV_VDEV_PARAM_AGGR_TRIG_EVENT_ENABLE,
	WMI_TLV_VDEV_PARAM_IS_IBSS_POWER_SAVE_ALLOWED,
	WMI_TLV_VDEV_PARAM_IS_POWER_COLLAPSE_ALLOWED,
	WMI_TLV_VDEV_PARAM_IS_AWAKE_ON_TXRX_ENABLED,
	WMI_TLV_VDEV_PARAM_INACTIVITY_CNT,
	WMI_TLV_VDEV_PARAM_TXSP_END_INACTIVITY_TIME_MS,
	WMI_TLV_VDEV_PARAM_DTIM_POLICY,
	WMI_TLV_VDEV_PARAM_IBSS_PS_WARMUP_TIME_SECS,
	WMI_TLV_VDEV_PARAM_IBSS_PS_1RX_CHAIN_IN_ATIM_WINDOW_ENABLE,
};

enum wmi_tlv_peer_flags {
	WMI_TLV_PEER_AUTH = 0x00000001,
	WMI_TLV_PEER_QOS = 0x00000002,
	WMI_TLV_PEER_NEED_PTK_4_WAY = 0x00000004,
	WMI_TLV_PEER_NEED_GTK_2_WAY = 0x00000010,
	WMI_TLV_PEER_APSD = 0x00000800,
	WMI_TLV_PEER_HT = 0x00001000,
	WMI_TLV_PEER_40MHZ = 0x00002000,
	WMI_TLV_PEER_STBC = 0x00008000,
	WMI_TLV_PEER_LDPC = 0x00010000,
	WMI_TLV_PEER_DYN_MIMOPS = 0x00020000,
	WMI_TLV_PEER_STATIC_MIMOPS = 0x00040000,
	WMI_TLV_PEER_SPATIAL_MUX = 0x00200000,
	WMI_TLV_PEER_VHT = 0x02000000,
	WMI_TLV_PEER_80MHZ = 0x04000000,
	WMI_TLV_PEER_PMF = 0x08000000,
	WMI_TLV_PEER_160MHZ = 0x20000000,
};

enum wmi_tlv_tag {
	WMI_TLV_TAG_LAST_RESERVED = 15,

	WMI_TLV_TAG_FIRST_ARRAY_ENUM,
	WMI_TLV_TAG_ARRAY_UINT32 = WMI_TLV_TAG_FIRST_ARRAY_ENUM,
	WMI_TLV_TAG_ARRAY_BYTE,
	WMI_TLV_TAG_ARRAY_STRUCT,
	WMI_TLV_TAG_ARRAY_FIXED_STRUCT,
	WMI_TLV_TAG_LAST_ARRAY_ENUM = 31,

	WMI_TLV_TAG_STRUCT_SERVICE_READY_EVENT,
	WMI_TLV_TAG_STRUCT_HAL_REG_CAPABILITIES,
	WMI_TLV_TAG_STRUCT_WLAN_HOST_MEM_REQ,
	WMI_TLV_TAG_STRUCT_READY_EVENT,
	WMI_TLV_TAG_STRUCT_SCAN_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_TPC_CONFIG_EVENT,
	WMI_TLV_TAG_STRUCT_CHAN_INFO_EVENT,
	WMI_TLV_TAG_STRUCT_COMB_PHYERR_RX_HDR,
	WMI_TLV_TAG_STRUCT_VDEV_START_RESPONSE_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_STOPPED_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_INSTALL_KEY_COMPLETE_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_STA_KICKOUT_EVENT,
	WMI_TLV_TAG_STRUCT_MGMT_RX_HDR,
	WMI_TLV_TAG_STRUCT_TBTT_OFFSET_EVENT,
	WMI_TLV_TAG_STRUCT_TX_DELBA_COMPLETE_EVENT,
	WMI_TLV_TAG_STRUCT_TX_ADDBA_COMPLETE_EVENT,
	WMI_TLV_TAG_STRUCT_ROAM_EVENT,
	WMI_TLV_TAG_STRUCT_WOW_EVENT_INFO,
	WMI_TLV_TAG_STRUCT_WOW_EVENT_INFO_SECTION_BITMAP,
	WMI_TLV_TAG_STRUCT_RTT_EVENT_HEADER,
	WMI_TLV_TAG_STRUCT_RTT_ERROR_REPORT_EVENT,
	WMI_TLV_TAG_STRUCT_RTT_MEAS_EVENT,
	WMI_TLV_TAG_STRUCT_ECHO_EVENT,
	WMI_TLV_TAG_STRUCT_FTM_INTG_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_GET_KEEPALIVE_EVENT,
	WMI_TLV_TAG_STRUCT_GPIO_INPUT_EVENT,
	WMI_TLV_TAG_STRUCT_CSA_EVENT,
	WMI_TLV_TAG_STRUCT_GTK_OFFLOAD_STATUS_EVENT,
	WMI_TLV_TAG_STRUCT_IGTK_INFO,
	WMI_TLV_TAG_STRUCT_DCS_INTERFERENCE_EVENT,
	WMI_TLV_TAG_STRUCT_ATH_DCS_CW_INT,
	WMI_TLV_TAG_STRUCT_ATH_DCS_WLAN_INT_STAT,
	WMI_TLV_TAG_STRUCT_WLAN_PROFILE_CTX_T,
	WMI_TLV_TAG_STRUCT_WLAN_PROFILE_T,
	WMI_TLV_TAG_STRUCT_PDEV_QVIT_EVENT,
	WMI_TLV_TAG_STRUCT_HOST_SWBA_EVENT,
	WMI_TLV_TAG_STRUCT_TIM_INFO,
	WMI_TLV_TAG_STRUCT_P2P_NOA_INFO,
	WMI_TLV_TAG_STRUCT_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_AVOID_FREQ_RANGES_EVENT,
	WMI_TLV_TAG_STRUCT_AVOID_FREQ_RANGE_DESC,
	WMI_TLV_TAG_STRUCT_GTK_REKEY_FAIL_EVENT,
	WMI_TLV_TAG_STRUCT_INIT_CMD,
	WMI_TLV_TAG_STRUCT_RESOURCE_CONFIG,
	WMI_TLV_TAG_STRUCT_WLAN_HOST_MEMORY_CHUNK,
	WMI_TLV_TAG_STRUCT_START_SCAN_CMD,
	WMI_TLV_TAG_STRUCT_STOP_SCAN_CMD,
	WMI_TLV_TAG_STRUCT_SCAN_CHAN_LIST_CMD,
	WMI_TLV_TAG_STRUCT_CHANNEL,
	WMI_TLV_TAG_STRUCT_PDEV_SET_REGDOMAIN_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_PARAM_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_WMM_PARAMS_CMD,
	WMI_TLV_TAG_STRUCT_WMM_PARAMS,
	WMI_TLV_TAG_STRUCT_PDEV_SET_QUIET_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_CREATE_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_DELETE_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_START_REQUEST_CMD,
	WMI_TLV_TAG_STRUCT_P2P_NOA_DESCRIPTOR,
	WMI_TLV_TAG_STRUCT_P2P_GO_SET_BEACON_IE,
	WMI_TLV_TAG_STRUCT_GTK_OFFLOAD_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_UP_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_STOP_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_DOWN_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_SET_PARAM_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_INSTALL_KEY_CMD,
	WMI_TLV_TAG_STRUCT_PEER_CREATE_CMD,
	WMI_TLV_TAG_STRUCT_PEER_DELETE_CMD,
	WMI_TLV_TAG_STRUCT_PEER_FLUSH_TIDS_CMD,
	WMI_TLV_TAG_STRUCT_PEER_SET_PARAM_CMD,
	WMI_TLV_TAG_STRUCT_PEER_ASSOC_COMPLETE_CMD,
	WMI_TLV_TAG_STRUCT_VHT_RATE_SET,
	WMI_TLV_TAG_STRUCT_BCN_TMPL_CMD,
	WMI_TLV_TAG_STRUCT_PRB_TMPL_CMD,
	WMI_TLV_TAG_STRUCT_BCN_PRB_INFO,
	WMI_TLV_TAG_STRUCT_PEER_TID_ADDBA_CMD,
	WMI_TLV_TAG_STRUCT_PEER_TID_DELBA_CMD,
	WMI_TLV_TAG_STRUCT_STA_POWERSAVE_MODE_CMD,
	WMI_TLV_TAG_STRUCT_STA_POWERSAVE_PARAM_CMD,
	WMI_TLV_TAG_STRUCT_STA_DTIM_PS_METHOD_CMD,
	WMI_TLV_TAG_STRUCT_ROAM_SCAN_MODE,
	WMI_TLV_TAG_STRUCT_ROAM_SCAN_RSSI_THRESHOLD,
	WMI_TLV_TAG_STRUCT_ROAM_SCAN_PERIOD,
	WMI_TLV_TAG_STRUCT_ROAM_SCAN_RSSI_CHANGE_THRESHOLD,
	WMI_TLV_TAG_STRUCT_PDEV_SUSPEND_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_RESUME_CMD,
	WMI_TLV_TAG_STRUCT_ADD_BCN_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_RMV_BCN_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_WOW_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_WOW_HOSTWAKEUP_FROM_SLEEP_CMD,
	WMI_TLV_TAG_STRUCT_STA_UAPSD_AUTO_TRIG_CMD,
	WMI_TLV_TAG_STRUCT_STA_UAPSD_AUTO_TRIG_PARAM,
	WMI_TLV_TAG_STRUCT_SET_ARP_NS_OFFLOAD_CMD,
	WMI_TLV_TAG_STRUCT_ARP_OFFLOAD_TUPLE,
	WMI_TLV_TAG_STRUCT_NS_OFFLOAD_TUPLE,
	WMI_TLV_TAG_STRUCT_FTM_INTG_CMD,
	WMI_TLV_TAG_STRUCT_STA_KEEPALIVE_CMD,
	WMI_TLV_TAG_STRUCT_STA_KEEPALVE_ARP_RESPONSE,
	WMI_TLV_TAG_STRUCT_P2P_SET_VENDOR_IE_DATA_CMD,
	WMI_TLV_TAG_STRUCT_AP_PS_PEER_CMD,
	WMI_TLV_TAG_STRUCT_PEER_RATE_RETRY_SCHED_CMD,
	WMI_TLV_TAG_STRUCT_WLAN_PROFILE_TRIGGER_CMD,
	WMI_TLV_TAG_STRUCT_WLAN_PROFILE_SET_HIST_INTVL_CMD,
	WMI_TLV_TAG_STRUCT_WLAN_PROFILE_GET_PROF_DATA_CMD,
	WMI_TLV_TAG_STRUCT_WLAN_PROFILE_ENABLE_PROFILE_ID_CMD,
	WMI_TLV_TAG_STRUCT_WOW_DEL_PATTERN_CMD,
	WMI_TLV_TAG_STRUCT_WOW_ADD_DEL_EVT_CMD,
	WMI_TLV_TAG_STRUCT_RTT_MEASREQ_HEAD,
	WMI_TLV_TAG_STRUCT_RTT_MEASREQ_BODY,
	WMI_TLV_TAG_STRUCT_RTT_TSF_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_SPECTRAL_CONFIGURE_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_SPECTRAL_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_REQUEST_STATS_CMD,
	WMI_TLV_TAG_STRUCT_NLO_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_NLO_CONFIGURED_PARAMETERS,
	WMI_TLV_TAG_STRUCT_CSA_OFFLOAD_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_CSA_OFFLOAD_CHANSWITCH_CMD,
	WMI_TLV_TAG_STRUCT_CHATTER_SET_MODE_CMD,
	WMI_TLV_TAG_STRUCT_ECHO_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_SET_KEEPALIVE_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_GET_KEEPALIVE_CMD,
	WMI_TLV_TAG_STRUCT_FORCE_FW_HANG_CMD,
	WMI_TLV_TAG_STRUCT_GPIO_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_GPIO_OUTPUT_CMD,
	WMI_TLV_TAG_STRUCT_PEER_ADD_WDS_ENTRY_CMD,
	WMI_TLV_TAG_STRUCT_PEER_REMOVE_WDS_ENTRY_CMD,
	WMI_TLV_TAG_STRUCT_BCN_TX_HDR,
	WMI_TLV_TAG_STRUCT_BCN_SEND_FROM_HOST_CMD,
	WMI_TLV_TAG_STRUCT_MGMT_TX_HDR,
	WMI_TLV_TAG_STRUCT_ADDBA_CLEAR_RESP_CMD,
	WMI_TLV_TAG_STRUCT_ADDBA_SEND_CMD,
	WMI_TLV_TAG_STRUCT_DELBA_SEND_CMD,
	WMI_TLV_TAG_STRUCT_ADDBA_SETRESPONSE_CMD,
	WMI_TLV_TAG_STRUCT_SEND_SINGLEAMSDU_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_PKTLOG_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_PKTLOG_DISABLE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_HT_IE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_VHT_IE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_DSCP_TID_MAP_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_GREEN_AP_PS_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_GET_TPC_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_BASE_MACADDR_CMD,
	WMI_TLV_TAG_STRUCT_PEER_MCAST_GROUP_CMD,
	WMI_TLV_TAG_STRUCT_ROAM_AP_PROFILE,
	WMI_TLV_TAG_STRUCT_AP_PROFILE,
	WMI_TLV_TAG_STRUCT_SCAN_SCH_PRIORITY_TABLE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_DFS_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_DFS_DISABLE_CMD,
	WMI_TLV_TAG_STRUCT_WOW_ADD_PATTERN_CMD,
	WMI_TLV_TAG_STRUCT_WOW_BITMAP_PATTERN_T,
	WMI_TLV_TAG_STRUCT_WOW_IPV4_SYNC_PATTERN_T,
	WMI_TLV_TAG_STRUCT_WOW_IPV6_SYNC_PATTERN_T,
	WMI_TLV_TAG_STRUCT_WOW_MAGIC_PATTERN_CMD,
	WMI_TLV_TAG_STRUCT_SCAN_UPDATE_REQUEST_CMD,
	WMI_TLV_TAG_STRUCT_CHATTER_PKT_COALESCING_FILTER,
	WMI_TLV_TAG_STRUCT_CHATTER_COALESCING_ADD_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_CHATTER_COALESCING_DELETE_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_CHATTER_COALESCING_QUERY_CMD,
	WMI_TLV_TAG_STRUCT_TXBF_CMD,
	WMI_TLV_TAG_STRUCT_DEBUG_LOG_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_NLO_EVENT,
	WMI_TLV_TAG_STRUCT_CHATTER_QUERY_REPLY_EVENT,
	WMI_TLV_TAG_STRUCT_UPLOAD_H_HDR,
	WMI_TLV_TAG_STRUCT_CAPTURE_H_EVENT_HDR,
	WMI_TLV_TAG_STRUCT_VDEV_WNM_SLEEPMODE_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_IPSEC_NATKEEPALIVE_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_WMM_ADDTS_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_WMM_DELTS_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_SET_WMM_PARAMS_CMD,
	WMI_TLV_TAG_STRUCT_TDLS_SET_STATE_CMD,
	WMI_TLV_TAG_STRUCT_TDLS_PEER_UPDATE_CMD,
	WMI_TLV_TAG_STRUCT_TDLS_PEER_EVENT,
	WMI_TLV_TAG_STRUCT_TDLS_PEER_CAPABILITIES,
	WMI_TLV_TAG_STRUCT_VDEV_MCC_SET_TBTT_MODE_CMD,
	WMI_TLV_TAG_STRUCT_ROAM_CHAN_LIST,
	WMI_TLV_TAG_STRUCT_VDEV_MCC_BCN_INTVL_CHANGE_EVENT,
	WMI_TLV_TAG_STRUCT_RESMGR_ADAPTIVE_OCS_CMD,
	WMI_TLV_TAG_STRUCT_RESMGR_SET_CHAN_TIME_QUOTA_CMD,
	WMI_TLV_TAG_STRUCT_RESMGR_SET_CHAN_LATENCY_CMD,
	WMI_TLV_TAG_STRUCT_BA_REQ_SSN_CMD,
	WMI_TLV_TAG_STRUCT_BA_RSP_SSN_EVENT,
	WMI_TLV_TAG_STRUCT_STA_SMPS_FORCE_MODE_CMD,
	WMI_TLV_TAG_STRUCT_SET_MCASTBCAST_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_P2P_SET_OPPPS_CMD,
	WMI_TLV_TAG_STRUCT_P2P_SET_NOA_CMD,
	WMI_TLV_TAG_STRUCT_BA_REQ_SSN_CMD_SUB_STRUCT_PARAM,
	WMI_TLV_TAG_STRUCT_BA_REQ_SSN_EVENT_SUB_STRUCT_PARAM,
	WMI_TLV_TAG_STRUCT_STA_SMPS_PARAM_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_SET_GTX_PARAMS_CMD,
	WMI_TLV_TAG_STRUCT_MCC_SCHED_TRAFFIC_STATS_CMD,
	WMI_TLV_TAG_STRUCT_MCC_SCHED_STA_TRAFFIC_STATS,
	WMI_TLV_TAG_STRUCT_OFFLOAD_BCN_TX_STATUS_EVENT,
	WMI_TLV_TAG_STRUCT_P2P_NOA_EVENT,
	WMI_TLV_TAG_STRUCT_HB_SET_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_HB_SET_TCP_PARAMS_CMD,
	WMI_TLV_TAG_STRUCT_HB_SET_TCP_PKT_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_HB_SET_UDP_PARAMS_CMD,
	WMI_TLV_TAG_STRUCT_HB_SET_UDP_PKT_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_HB_IND_EVENT,
	WMI_TLV_TAG_STRUCT_TX_PAUSE_EVENT,
	WMI_TLV_TAG_STRUCT_RFKILL_EVENT,
	WMI_TLV_TAG_STRUCT_DFS_RADAR_EVENT,
	WMI_TLV_TAG_STRUCT_DFS_PHYERR_FILTER_ENA_CMD,
	WMI_TLV_TAG_STRUCT_DFS_PHYERR_FILTER_DIS_CMD,
	WMI_TLV_TAG_STRUCT_BATCH_SCAN_RESULT_SCAN_LIST,
	WMI_TLV_TAG_STRUCT_BATCH_SCAN_RESULT_NETWORK_INFO,
	WMI_TLV_TAG_STRUCT_BATCH_SCAN_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_BATCH_SCAN_DISABLE_CMD,
	WMI_TLV_TAG_STRUCT_BATCH_SCAN_TRIGGER_RESULT_CMD,
	WMI_TLV_TAG_STRUCT_BATCH_SCAN_ENABLED_EVENT,
	WMI_TLV_TAG_STRUCT_BATCH_SCAN_RESULT_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_PLMREQ_START_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_PLMREQ_STOP_CMD,
	WMI_TLV_TAG_STRUCT_THERMAL_MGMT_CMD,
	WMI_TLV_TAG_STRUCT_THERMAL_MGMT_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_INFO_REQ_CMD,
	WMI_TLV_TAG_STRUCT_PEER_INFO_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_INFO,
	WMI_TLV_TAG_STRUCT_PEER_TX_FAIL_CNT_THR_EVENT,
	WMI_TLV_TAG_STRUCT_RMC_SET_MODE_CMD,
	WMI_TLV_TAG_STRUCT_RMC_SET_ACTION_PERIOD_CMD,
	WMI_TLV_TAG_STRUCT_RMC_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_MHF_OFFLOAD_SET_MODE_CMD,
	WMI_TLV_TAG_STRUCT_MHF_OFFLOAD_PLUMB_ROUTING_TABLE_CMD,
	WMI_TLV_TAG_STRUCT_ADD_PROACTIVE_ARP_RSP_PATTERN_CMD,
	WMI_TLV_TAG_STRUCT_DEL_PROACTIVE_ARP_RSP_PATTERN_CMD,
	WMI_TLV_TAG_STRUCT_NAN_CMD_PARAM,
	WMI_TLV_TAG_STRUCT_NAN_EVENT_HDR,
	WMI_TLV_TAG_STRUCT_PDEV_L1SS_TRACK_EVENT,
	WMI_TLV_TAG_STRUCT_DIAG_DATA_CONTAINER_EVENT,
	WMI_TLV_TAG_STRUCT_MODEM_POWER_STATE_CMD_PARAM,
	WMI_TLV_TAG_STRUCT_PEER_GET_ESTIMATED_LINKSPEED_CMD,
	WMI_TLV_TAG_STRUCT_PEER_ESTIMATED_LINKSPEED_EVENT,
	WMI_TLV_TAG_STRUCT_AGGR_STATE_TRIG_EVENT,
	WMI_TLV_TAG_STRUCT_MHF_OFFLOAD_ROUTING_TABLE_ENTRY,
	WMI_TLV_TAG_STRUCT_ROAM_SCAN_CMD,
	WMI_TLV_TAG_STRUCT_REQ_STATS_EXT_CMD,
	WMI_TLV_TAG_STRUCT_STATS_EXT_EVENT,
	WMI_TLV_TAG_STRUCT_OBSS_SCAN_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_OBSS_SCAN_DISABLE_CMD,
	WMI_TLV_TAG_STRUCT_OFFLOAD_PRB_RSP_TX_STATUS_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_SET_LED_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_HOST_AUTO_SHUTDOWN_CFG_CMD,
	WMI_TLV_TAG_STRUCT_HOST_AUTO_SHUTDOWN_EVENT,
	WMI_TLV_TAG_STRUCT_UPDATE_WHAL_MIB_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_CHAN_AVOID_UPDATE_CMD_PARAM,
	WMI_TLV_TAG_STRUCT_WOW_ACER_IOAC_PKT_PATTERN_T,
	WMI_TLV_TAG_STRUCT_WOW_ACER_IOAC_TMR_PATTERN_T,
	WMI_TLV_TAG_STRUCT_WOW_IOAC_ADD_KEEPALIVE_CMD,
	WMI_TLV_TAG_STRUCT_WOW_IOAC_DEL_KEEPALIVE_CMD,
	WMI_TLV_TAG_STRUCT_WOW_IOAC_KEEPALIVE_T,
	WMI_TLV_TAG_STRUCT_WOW_ACER_IOAC_ADD_PATTERN_CMD,
	WMI_TLV_TAG_STRUCT_WOW_ACER_IOAC_DEL_PATTERN_CMD,
	WMI_TLV_TAG_STRUCT_START_LINK_STATS_CMD,
	WMI_TLV_TAG_STRUCT_CLEAR_LINK_STATS_CMD,
	WMI_TLV_TAG_STRUCT_REQUEST_LINK_STATS_CMD,
	WMI_TLV_TAG_STRUCT_IFACE_LINK_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_RADIO_LINK_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_CHANNEL_STATS,
	WMI_TLV_TAG_STRUCT_RADIO_LINK_STATS,
	WMI_TLV_TAG_STRUCT_RATE_STATS,
	WMI_TLV_TAG_STRUCT_PEER_LINK_STATS,
	WMI_TLV_TAG_STRUCT_WMM_AC_STATS,
	WMI_TLV_TAG_STRUCT_IFACE_LINK_STATS,
	WMI_TLV_TAG_STRUCT_LPI_MGMT_SNOOPING_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_LPI_START_SCAN_CMD,
	WMI_TLV_TAG_STRUCT_LPI_STOP_SCAN_CMD,
	WMI_TLV_TAG_STRUCT_LPI_RESULT_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_STATE_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_BUCKET_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_BUCKET_CHANNEL_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_START_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_STOP_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_CONFIGURE_WLAN_CHANGE_MONITOR_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_WLAN_CHANGE_BSSID_PARAM_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_CONFIGURE_HOTLIST_MONITOR_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_GET_CACHED_RESULTS_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_GET_WLAN_CHANGE_RESULTS_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_SET_CAPABILITIES_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_GET_CAPABILITIES_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_OPERATION_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_START_STOP_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_TABLE_USAGE_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_WLAN_DESCRIPTOR_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_RSSI_INFO_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_CACHED_RESULTS_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_WLAN_CHANGE_RESULTS_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_WLAN_CHANGE_RESULT_BSSID_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_HOTLIST_MATCH_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_CAPABILITIES_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_CACHE_CAPABILITIES_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_WLAN_CHANGE_MONITOR_CAPABILITIES_EVENT,
	WMI_TLV_TAG_STRUCT_EXTSCAN_HOTLIST_MONITOR_CAPABILITIES_EVENT,
	WMI_TLV_TAG_STRUCT_D0_WOW_ENABLE_DISABLE_CMD,
	WMI_TLV_TAG_STRUCT_D0_WOW_DISABLE_ACK_EVENT,
	WMI_TLV_TAG_STRUCT_UNIT_TEST_CMD,
	WMI_TLV_TAG_STRUCT_ROAM_OFFLOAD_TLV_PARAM,
	WMI_TLV_TAG_STRUCT_ROAM_11I_OFFLOAD_TLV_PARAM,
	WMI_TLV_TAG_STRUCT_ROAM_11R_OFFLOAD_TLV_PARAM,
	WMI_TLV_TAG_STRUCT_ROAM_ESE_OFFLOAD_TLV_PARAM,
	WMI_TLV_TAG_STRUCT_ROAM_SYNCH_EVENT,
	WMI_TLV_TAG_STRUCT_ROAM_SYNCH_COMPLETE,
	WMI_TLV_TAG_STRUCT_EXTWOW_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_EXTWOW_SET_APP_TYPE1_PARAMS_CMD,
	WMI_TLV_TAG_STRUCT_EXTWOW_SET_APP_TYPE2_PARAMS_CMD,
	WMI_TLV_TAG_STRUCT_LPI_STATUS_EVENT,
	WMI_TLV_TAG_STRUCT_LPI_HANDOFF_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_RATE_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_RATE_HT_INFO,
	WMI_TLV_TAG_STRUCT_RIC_REQUEST,
	WMI_TLV_TAG_STRUCT_PDEV_GET_TEMPERATURE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_TEMPERATURE_EVENT,
	WMI_TLV_TAG_STRUCT_SET_DHCP_SERVER_OFFLOAD_CMD,
	WMI_TLV_TAG_STRUCT_TPC_CHAINMASK_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_RIC_TSPEC,
	WMI_TLV_TAG_STRUCT_TPC_CHAINMASK_CONFIG,
	WMI_TLV_TAG_STRUCT_IPA_OFFLOAD_CMD,
	WMI_TLV_TAG_STRUCT_SCAN_PROB_REQ_OUI_CMD,
	WMI_TLV_TAG_STRUCT_KEY_MATERIAL,
	WMI_TLV_TAG_STRUCT_TDLS_SET_OFFCHAN_MODE_CMD,
	WMI_TLV_TAG_STRUCT_SET_LED_FLASHING_CMD,
	WMI_TLV_TAG_STRUCT_MDNS_OFFLOAD_CMD,
	WMI_TLV_TAG_STRUCT_MDNS_SET_FQDN_CMD,
	WMI_TLV_TAG_STRUCT_MDNS_SET_RESP_CMD,
	WMI_TLV_TAG_STRUCT_MDNS_GET_STATS_CMD,
	WMI_TLV_TAG_STRUCT_MDNS_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_ROAM_INVOKE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_RESUME_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_SET_ANTENNA_DIVERSITY_CMD,
	WMI_TLV_TAG_STRUCT_SAP_OFL_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_SAP_OFL_ADD_STA_EVENT,
	WMI_TLV_TAG_STRUCT_SAP_OFL_DEL_STA_EVENT,
	WMI_TLV_TAG_STRUCT_APFIND_CMD_PARAM,
	WMI_TLV_TAG_STRUCT_APFIND_EVENT_HDR,
	WMI_TLV_TAG_STRUCT_OCB_SET_SCHED_CMD,
	WMI_TLV_TAG_STRUCT_OCB_SET_SCHED_EVENT,
	WMI_TLV_TAG_STRUCT_OCB_SET_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_OCB_SET_CONFIG_RESP_EVENT,
	WMI_TLV_TAG_STRUCT_OCB_SET_UTC_TIME_CMD,
	WMI_TLV_TAG_STRUCT_OCB_START_TIMING_ADVERT_CMD,
	WMI_TLV_TAG_STRUCT_OCB_STOP_TIMING_ADVERT_CMD,
	WMI_TLV_TAG_STRUCT_OCB_GET_TSF_TIMER_CMD,
	WMI_TLV_TAG_STRUCT_OCB_GET_TSF_TIMER_RESP_EVENT,
	WMI_TLV_TAG_STRUCT_DCC_GET_STATS_CMD,
	WMI_TLV_TAG_STRUCT_DCC_CHANNEL_STATS_REQUEST,
	WMI_TLV_TAG_STRUCT_DCC_GET_STATS_RESP_EVENT,
	WMI_TLV_TAG_STRUCT_DCC_CLEAR_STATS_CMD,
	WMI_TLV_TAG_STRUCT_DCC_UPDATE_NDL_CMD,
	WMI_TLV_TAG_STRUCT_DCC_UPDATE_NDL_RESP_EVENT,
	WMI_TLV_TAG_STRUCT_DCC_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_OCB_CHANNEL,
	WMI_TLV_TAG_STRUCT_OCB_SCHEDULE_ELEMENT,
	WMI_TLV_TAG_STRUCT_DCC_NDL_STATS_PER_CHANNEL,
	WMI_TLV_TAG_STRUCT_DCC_NDL_CHAN,
	WMI_TLV_TAG_STRUCT_QOS_PARAMETER,
	WMI_TLV_TAG_STRUCT_DCC_NDL_ACTIVE_STATE_CONFIG,
	WMI_TLV_TAG_STRUCT_ROAM_SCAN_EXTENDED_THRESHOLD_PARAM,
	WMI_TLV_TAG_STRUCT_ROAM_FILTER_FIXED_PARAM,
	WMI_TLV_TAG_STRUCT_PASSPOINT_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_PASSPOINT_EVENT_HDR,
	WMI_TLV_TAG_STRUCT_EXTSCAN_CONFIGURE_HOTLIST_SSID_MONITOR_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_HOTLIST_SSID_MATCH_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_TSF_TSTAMP_ACTION_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_TSF_REPORT_EVENT,
	WMI_TLV_TAG_STRUCT_GET_FW_MEM_DUMP,
	WMI_TLV_TAG_STRUCT_UPDATE_FW_MEM_DUMP,
	WMI_TLV_TAG_STRUCT_FW_MEM_DUMP_PARAMS,
	WMI_TLV_TAG_STRUCT_DEBUG_MESG_FLUSH,
	WMI_TLV_TAG_STRUCT_DEBUG_MESG_FLUSH_COMPLETE,
	WMI_TLV_TAG_STRUCT_PEER_SET_RATE_REPORT_CONDITION,
	WMI_TLV_TAG_STRUCT_ROAM_SUBNET_CHANGE_CONFIG,
	WMI_TLV_TAG_STRUCT_VDEV_SET_IE_CMD,
	WMI_TLV_TAG_STRUCT_RSSI_BREACH_MONITOR_CONFIG,
	WMI_TLV_TAG_STRUCT_RSSI_BREACH_EVENT,
	WMI_TLV_TAG_STRUCT_EVENT_INITIAL_WAKEUP,
	WMI_TLV_TAG_STRUCT_SOC_SET_PCL_CMD,
	WMI_TLV_TAG_STRUCT_SOC_SET_HW_MODE_CMD,
	WMI_TLV_TAG_STRUCT_SOC_SET_HW_MODE_RESPONSE_EVENT,
	WMI_TLV_TAG_STRUCT_SOC_HW_MODE_TRANSITION_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_TXRX_STREAMS,
	WMI_TLV_TAG_STRUCT_SOC_SET_HW_MODE_RESPONSE_VDEV_MAC_ENTRY,
	WMI_TLV_TAG_STRUCT_SOC_SET_DUAL_MAC_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_SOC_SET_DUAL_MAC_CONFIG_RESPONSE_EVENT,
	WMI_TLV_TAG_STRUCT_IOAC_SOCK_PATTERN_T,
	WMI_TLV_TAG_STRUCT_WOW_ENABLE_ICMPV6_NA_FLT_CMD,
	WMI_TLV_TAG_STRUCT_DIAG_EVENT_LOG_CONFIG,
	WMI_TLV_TAG_STRUCT_DIAG_EVENT_LOG_SUPPORTED_EVENT,
	WMI_TLV_TAG_STRUCT_PACKET_FILTER_CONFIG,
	WMI_TLV_TAG_STRUCT_PACKET_FILTER_ENABLE,
	WMI_TLV_TAG_STRUCT_SAP_SET_BLACKLIST_PARAM_CMD,
	WMI_TLV_TAG_STRUCT_MGMT_TX_CMD,
	WMI_TLV_TAG_STRUCT_MGMT_TX_COMPL_EVENT,
	WMI_TLV_TAG_STRUCT_SOC_SET_ANTENNA_MODE_CMD,
	WMI_TLV_TAG_STRUCT_WOW_UDP_SVC_OFLD_CMD,
	WMI_TLV_TAG_STRUCT_LRO_INFO_CMD,
	WMI_TLV_TAG_STRUCT_ROAM_EARLYSTOP_RSSI_THRES_PARAM,
	WMI_TLV_TAG_STRUCT_SERVICE_READY_EXT_EVENT,
	WMI_TLV_TAG_STRUCT_MAWC_SENSOR_REPORT_IND_CMD,
	WMI_TLV_TAG_STRUCT_MAWC_ENABLE_SENSOR_EVENT,
	WMI_TLV_TAG_STRUCT_ROAM_CONFIGURE_MAWC_CMD,
	WMI_TLV_TAG_STRUCT_NLO_CONFIGURE_MAWC_CMD,
	WMI_TLV_TAG_STRUCT_EXTSCAN_CONFIGURE_MAWC_CMD,
	WMI_TLV_TAG_STRUCT_PEER_ASSOC_CONF_EVENT,
	WMI_TLV_TAG_STRUCT_WOW_HOSTWAKEUP_GPIO_PIN_PATTERN_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_AP_PS_EGAP_PARAM_CMD,
	WMI_TLV_TAG_STRUCT_AP_PS_EGAP_INFO_EVENT,
	WMI_TLV_TAG_STRUCT_PMF_OFFLOAD_SET_SA_QUERY_CMD,
	WMI_TLV_TAG_STRUCT_TRANSFER_DATA_TO_FLASH_CMD,
	WMI_TLV_TAG_STRUCT_TRANSFER_DATA_TO_FLASH_COMPLETE_EVENT,
	WMI_TLV_TAG_STRUCT_SCPC_EVENT,
	WMI_TLV_TAG_STRUCT_AP_PS_EGAP_INFO_CHAINMASK_LIST,
	WMI_TLV_TAG_STRUCT_STA_SMPS_FORCE_MODE_COMPLETE_EVENT,
	WMI_TLV_TAG_STRUCT_BPF_GET_CAPABILITY_CMD,
	WMI_TLV_TAG_STRUCT_BPF_CAPABILITY_INFO_EVT,
	WMI_TLV_TAG_STRUCT_BPF_GET_VDEV_STATS_CMD,
	WMI_TLV_TAG_STRUCT_BPF_VDEV_STATS_INFO_EVT,
	WMI_TLV_TAG_STRUCT_BPF_SET_VDEV_INSTRUCTIONS_CMD,
	WMI_TLV_TAG_STRUCT_BPF_DEL_VDEV_INSTRUCTIONS_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_DELETE_RESP_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_DELETE_RESP_EVENT,
	WMI_TLV_TAG_STRUCT_ROAM_DENSE_THRES_PARAM,
	WMI_TLV_TAG_STRUCT_ENLO_CANDIDATE_SCORE_PARAM,
	WMI_TLV_TAG_STRUCT_PEER_UPDATE_WDS_ENTRY_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_CONFIG_RATEMASK,
	WMI_TLV_TAG_STRUCT_PDEV_FIPS_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SMART_ANT_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SMART_ANT_SET_RX_ANTENNA_CMD,
	WMI_TLV_TAG_STRUCT_PEER_SMART_ANT_SET_TX_ANTENNA_CMD,
	WMI_TLV_TAG_STRUCT_PEER_SMART_ANT_SET_TRAIN_ANTENNA_CMD,
	WMI_TLV_TAG_STRUCT_PEER_SMART_ANT_SET_NODE_CONFIG_OPS_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_ANT_SWITCH_TBL_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_CTL_TABLE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_MIMOGAIN_TABLE_CMD,
	WMI_TLV_TAG_STRUCT_FWTEST_SET_PARAM_CMD,
	WMI_TLV_TAG_STRUCT_PEER_ATF_REQUEST,
	WMI_TLV_TAG_STRUCT_VDEV_ATF_REQUEST,
	WMI_TLV_TAG_STRUCT_PDEV_GET_ANI_CCK_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_GET_ANI_OFDM_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_INST_RSSI_STATS_RESP,
	WMI_TLV_TAG_STRUCT_MED_UTIL_REPORT_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_STA_PS_STATECHANGE_EVENT,
	WMI_TLV_TAG_STRUCT_WDS_ADDR_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_RATECODE_LIST_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_NFCAL_POWER_ALL_CHANNELS_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_TPC_EVENT,
	WMI_TLV_TAG_STRUCT_ANI_OFDM_EVENT,
	WMI_TLV_TAG_STRUCT_ANI_CCK_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_CHANNEL_HOPPING_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_FIPS_EVENT,
	WMI_TLV_TAG_STRUCT_ATF_PEER_INFO,
	WMI_TLV_TAG_STRUCT_PDEV_GET_TPC_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_FILTER_NRP_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_QBOOST_CFG_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SMART_ANT_GPIO_HANDLE,
	WMI_TLV_TAG_STRUCT_PEER_SMART_ANT_SET_TX_ANTENNA_SERIES,
	WMI_TLV_TAG_STRUCT_PEER_SMART_ANT_SET_TRAIN_ANTENNA_PARAM,
	WMI_TLV_TAG_STRUCT_PDEV_SET_ANT_CTRL_CHAIN,
	WMI_TLV_TAG_STRUCT_PEER_CCK_OFDM_RATE_INFO,
	WMI_TLV_TAG_STRUCT_PEER_MCS_RATE_INFO,
	WMI_TLV_TAG_STRUCT_PDEV_NFCAL_POWER_ALL_CHANNELS_NFDBR,
	WMI_TLV_TAG_STRUCT_PDEV_NFCAL_POWER_ALL_CHANNELS_NFDBM,
	WMI_TLV_TAG_STRUCT_PDEV_NFCAL_POWER_ALL_CHANNELS_FREQNUM,
	WMI_TLV_TAG_STRUCT_MU_REPORT_TOTAL_MU,
	WMI_TLV_TAG_STRUCT_VDEV_SET_DSCP_TID_MAP_CMD,
	WMI_TLV_TAG_STRUCT_ROAM_SET_MBO,
	WMI_TLV_TAG_STRUCT_MIB_STATS_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_NAN_DISC_IFACE_CREATED_EVENT,
	WMI_TLV_TAG_STRUCT_NAN_DISC_IFACE_DELETED_EVENT,
	WMI_TLV_TAG_STRUCT_NAN_STARTED_CLUSTER_EVENT,
	WMI_TLV_TAG_STRUCT_NAN_JOINED_CLUSTER_EVENT,
	WMI_TLV_TAG_STRUCT_NDI_GET_CAP_REQ,
	WMI_TLV_TAG_STRUCT_NDP_INITIATOR_REQ,
	WMI_TLV_TAG_STRUCT_NDP_RESPONDER_REQ,
	WMI_TLV_TAG_STRUCT_NDP_END_REQ,
	WMI_TLV_TAG_STRUCT_NDI_CAP_RSP_EVENT,
	WMI_TLV_TAG_STRUCT_NDP_INITIATOR_RSP_EVENT,
	WMI_TLV_TAG_STRUCT_NDP_RESPONDER_RSP_EVENT,
	WMI_TLV_TAG_STRUCT_NDP_END_RSP_EVENT,
	WMI_TLV_TAG_STRUCT_NDP_INDICATION_EVENT,
	WMI_TLV_TAG_STRUCT_NDP_CONFIRM_EVENT,
	WMI_TLV_TAG_STRUCT_NDP_END_INDICATION_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_SET_QUIET_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_PCL_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_HW_MODE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_MAC_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_ANTENNA_MODE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_HW_MODE_RESPONSE_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_HW_MODE_TRANSITION_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_SET_HW_MODE_RESPONSE_VDEV_MAC_ENTRY,
	WMI_TLV_TAG_STRUCT_PDEV_SET_MAC_CONFIG_RESPONSE_EVENT,
	WMI_TLV_TAG_STRUCT_COEX_CONFIG_CMD,
	WMI_TLV_TAG_STRUCT_CONFIG_ENHANCED_MCAST_FILTER,
	WMI_TLV_TAG_STRUCT_CHAN_AVOID_RPT_ALLOW_CMD,
	WMI_TLV_TAG_STRUCT_SET_PERIODIC_CHANNEL_STATS_CONFIG,
	WMI_TLV_TAG_STRUCT_VDEV_SET_CUSTOM_AGGR_SIZE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_WAL_POWER_DEBUG_CMD,
	WMI_TLV_TAG_STRUCT_MAC_PHY_CAPABILITIES,
	WMI_TLV_TAG_STRUCT_HW_MODE_CAPABILITIES,
	WMI_TLV_TAG_STRUCT_SOC_MAC_PHY_HW_MODE_CAPS,
	WMI_TLV_TAG_STRUCT_HAL_REG_CAPABILITIES_EXT,
	WMI_TLV_TAG_STRUCT_SOC_HAL_REG_CAPABILITIES,
	WMI_TLV_TAG_STRUCT_VDEV_WISA_CMD,
	WMI_TLV_TAG_STRUCT_TX_POWER_LEVEL_STATS_EVT,
	WMI_TLV_TAG_STRUCT_SCAN_ADAPTIVE_DWELL_PARAMETERS_TLV,
	WMI_TLV_TAG_STRUCT_SCAN_ADAPTIVE_DWELL_CONFIG,
	WMI_TLV_TAG_STRUCT_WOW_SET_ACTION_WAKE_UP_CMD,
	WMI_TLV_TAG_STRUCT_NDP_END_RSP_PER_NDI,
	WMI_TLV_TAG_STRUCT_PEER_BWF_REQUEST,
	WMI_TLV_TAG_STRUCT_BWF_PEER_INFO,
	WMI_TLV_TAG_STRUCT_DBGLOG_TIME_STAMP_SYNC_CMD,
	WMI_TLV_TAG_STRUCT_RMC_SET_LEADER_CMD,
	WMI_TLV_TAG_STRUCT_RMC_MANUAL_LEADER_EVENT,
	WMI_TLV_TAG_STRUCT_PER_CHAIN_RSSI_STATS,
	WMI_TLV_TAG_STRUCT_RSSI_STATS,
	WMI_TLV_TAG_STRUCT_P2P_LO_START_CMD,
	WMI_TLV_TAG_STRUCT_P2P_LO_STOP_CMD,
	WMI_TLV_TAG_STRUCT_P2P_LO_STOPPED_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_REORDER_QUEUE_SETUP_CMD,
	WMI_TLV_TAG_STRUCT_PEER_REORDER_QUEUE_REMOVE_CMD,
	WMI_TLV_TAG_STRUCT_SET_MULTIPLE_MCAST_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_MGMT_TX_COMPL_BUNDLE_EVENT,
	WMI_TLV_TAG_STRUCT_READ_DATA_FROM_FLASH_CMD,
	WMI_TLV_TAG_STRUCT_READ_DATA_FROM_FLASH_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_SET_REORDER_TIMEOUT_VAL_CMD,
	WMI_TLV_TAG_STRUCT_PEER_SET_RX_BLOCKSIZE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_SET_WAKEUP_CONFIG_CMDID,
	WMI_TLV_TAG_STRUCT_TLV_BUF_LEN_PARAM,
	WMI_TLV_TAG_STRUCT_SERVICE_AVAILABLE_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_ANTDIV_INFO_REQ_CMD,
	WMI_TLV_TAG_STRUCT_PEER_ANTDIV_INFO_EVENT,
	WMI_TLV_TAG_STRUCT_PEER_ANTDIV_INFO,
	WMI_TLV_TAG_STRUCT_PDEV_GET_ANTDIV_STATUS_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_ANTDIV_STATUS_EVENT,
	WMI_TLV_TAG_STRUCT_MNT_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_GET_CHIP_POWER_STATS_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_CHIP_POWER_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_COEX_GET_ANTENNA_ISOLATION_CMD,
	WMI_TLV_TAG_STRUCT_COEX_REPORT_ISOLATION_EVENT,
	WMI_TLV_TAG_STRUCT_CHAN_CCA_STATS,
	WMI_TLV_TAG_STRUCT_PEER_SIGNAL_STATS,
	WMI_TLV_TAG_STRUCT_TX_STATS,
	WMI_TLV_TAG_STRUCT_PEER_AC_TX_STATS,
	WMI_TLV_TAG_STRUCT_RX_STATS,
	WMI_TLV_TAG_STRUCT_PEER_AC_RX_STATS,
	WMI_TLV_TAG_STRUCT_REPORT_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_CHAN_CCA_STATS_THRESH,
	WMI_TLV_TAG_STRUCT_PEER_SIGNAL_STATS_THRESH,
	WMI_TLV_TAG_STRUCT_TX_STATS_THRESH,
	WMI_TLV_TAG_STRUCT_RX_STATS_THRESH,
	WMI_TLV_TAG_STRUCT_PDEV_SET_STATS_THRESHOLD_CMD,
	WMI_TLV_TAG_STRUCT_REQUEST_WLAN_STATS_CMD,
	WMI_TLV_TAG_STRUCT_RX_AGGR_FAILURE_EVENT,
	WMI_TLV_TAG_STRUCT_RX_AGGR_FAILURE_INFO,
	WMI_TLV_TAG_STRUCT_VDEV_ENCRYPT_DECRYPT_DATA_REQ_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_ENCRYPT_DECRYPT_DATA_RESP_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_BAND_TO_MAC,
	WMI_TLV_TAG_STRUCT_TBTT_OFFSET_INFO,
	WMI_TLV_TAG_STRUCT_TBTT_OFFSET_EXT_EVENT,
	WMI_TLV_TAG_STRUCT_SAR_LIMITS_CMD,
	WMI_TLV_TAG_STRUCT_SAR_LIMIT_CMD_ROW,
	WMI_TLV_TAG_STRUCT_PDEV_DFS_PHYERR_OFFLOAD_ENABLE_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_DFS_PHYERR_OFFLOAD_DISABLE_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_ADFS_CH_CFG_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_ADFS_OCAC_ABORT_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_DFS_RADAR_DETECTION_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_ADFS_OCAC_COMPLETE_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_DFS_CAC_COMPLETE_EVENT,
	WMI_TLV_TAG_STRUCT_VENDOR_OUI,
	WMI_TLV_TAG_STRUCT_REQUEST_RCPI_CMD,
	WMI_TLV_TAG_STRUCT_UPDATE_RCPI_EVENT,
	WMI_TLV_TAG_STRUCT_REQUEST_PEER_STATS_INFO_CMD,
	WMI_TLV_TAG_STRUCT_PEER_STATS_INFO,
	WMI_TLV_TAG_STRUCT_PEER_STATS_INFO_EVENT,
	WMI_TLV_TAG_STRUCT_PKGID_EVENT,
	WMI_TLV_TAG_STRUCT_CONNECTED_NLO_RSSI_PARAMS,
	WMI_TLV_TAG_STRUCT_SET_CURRENT_COUNTRY_CMD,
	WMI_TLV_TAG_STRUCT_REGULATORY_RULE_STRUCT,
	WMI_TLV_TAG_STRUCT_REG_CHAN_LIST_CC_EVENT,
	WMI_TLV_TAG_STRUCT_11D_SCAN_START_CMD,
	WMI_TLV_TAG_STRUCT_11D_SCAN_STOP_CMD,
	WMI_TLV_TAG_STRUCT_11D_NEW_COUNTRY_EVENT,
	WMI_TLV_TAG_STRUCT_REQUEST_RADIO_CHAN_STATS_CMD,
	WMI_TLV_TAG_STRUCT_RADIO_CHAN_STATS,
	WMI_TLV_TAG_STRUCT_RADIO_CHAN_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_ROAM_PER_CONFIG,
	WMI_TLV_TAG_STRUCT_VDEV_ADD_MAC_ADDR_TO_RX_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_ADD_MAC_ADDR_TO_RX_FILTER_STATUS_EVENT,
	WMI_TLV_TAG_STRUCT_BPF_SET_VDEV_ACTIVE_MODE_CMD,
	WMI_TLV_TAG_STRUCT_HW_DATA_FILTER_CMD,
	WMI_TLV_TAG_STRUCT_CONNECTED_NLO_BSS_BAND_RSSI_PREF,
	WMI_TLV_TAG_STRUCT_PEER_OPER_MODE_CHANGE_EVENT,
	WMI_TLV_TAG_STRUCT_CHIP_POWER_SAVE_FAILURE_DETECTED,
	WMI_TLV_TAG_STRUCT_PDEV_MULTIPLE_VDEV_RESTART_REQUEST_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_CSA_SWITCH_COUNT_STATUS_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_UPDATE_PKT_ROUTING_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_CHECK_CAL_VERSION_CMD,
	WMI_TLV_TAG_STRUCT_PDEV_CHECK_CAL_VERSION_EVENT,
	WMI_TLV_TAG_STRUCT_PDEV_SET_DIVERSITY_GAIN_CMD,
	WMI_TLV_TAG_STRUCT_MAC_PHY_CHAINMASK_COMBO,
	WMI_TLV_TAG_STRUCT_MAC_PHY_CHAINMASK_CAPABILITY,
	WMI_TLV_TAG_STRUCT_VDEV_SET_ARP_STATS_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_GET_ARP_STATS_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_GET_ARP_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_IFACE_OFFLOAD_STATS,
	WMI_TLV_TAG_STRUCT_REQUEST_STATS_CMD_SUB_STRUCT_PARAM,
	WMI_TLV_TAG_STRUCT_RSSI_CTL_EXT,
	WMI_TLV_TAG_STRUCT_SINGLE_PHYERR_EXT_RX_HDR,
	WMI_TLV_TAG_STRUCT_COEX_BT_ACTIVITY_EVENT,
	WMI_TLV_TAG_STRUCT_VDEV_GET_TX_POWER_CMD,
	WMI_TLV_TAG_STRUCT_VDEV_TX_POWER_EVENT,
	WMI_TLV_TAG_STRUCT_OFFCHAN_DATA_TX_COMPL_EVENT,
	WMI_TLV_TAG_STRUCT_OFFCHAN_DATA_TX_SEND_CMD,
	WMI_TLV_TAG_STRUCT_TX_SEND_PARAMS,
	WMI_TLV_TAG_STRUCT_HE_RATE_SET,
	WMI_TLV_TAG_STRUCT_CONGESTION_STATS,
	WMI_TLV_TAG_STRUCT_SET_INIT_COUNTRY_CMD,
	WMI_TLV_TAG_STRUCT_SCAN_DBS_DUTY_CYCLE,
	WMI_TLV_TAG_STRUCT_SCAN_DBS_DUTY_CYCLE_PARAM_TLV,
	WMI_TLV_TAG_STRUCT_PDEV_DIV_GET_RSSI_ANTID,
	WMI_TLV_TAG_STRUCT_THERM_THROT_CONFIG_REQUEST,
	WMI_TLV_TAG_STRUCT_THERM_THROT_LEVEL_CONFIG_INFO,
	WMI_TLV_TAG_STRUCT_THERM_THROT_STATS_EVENT,
	WMI_TLV_TAG_STRUCT_THERM_THROT_LEVEL_STATS_INFO,
	WMI_TLV_TAG_STRUCT_PDEV_DIV_RSSI_ANTID_EVENT,
	WMI_TLV_TAG_STRUCT_OEM_DMA_RING_CAPABILITIES,
	WMI_TLV_TAG_STRUCT_OEM_DMA_RING_CFG_REQ,
	WMI_TLV_TAG_STRUCT_OEM_DMA_RING_CFG_RSP,
	WMI_TLV_TAG_STRUCT_OEM_INDIRECT_DATA,
	WMI_TLV_TAG_STRUCT_OEM_DMA_BUF_RELEASE,
	WMI_TLV_TAG_STRUCT_OEM_DMA_BUF_RELEASE_ENTRY,
	WMI_TLV_TAG_STRUCT_PDEV_BSS_CHAN_INFO_REQUEST,
	WMI_TLV_TAG_STRUCT_PDEV_BSS_CHAN_INFO_EVENT,
	WMI_TLV_TAG_STRUCT_ROAM_LCA_DISALLOW_CONFIG_TLV_PARAM,
	WMI_TLV_TAG_STRUCT_VDEV_LIMIT_OFFCHAN_CMD,
	WMI_TLV_TAG_STRUCT_ROAM_RSSI_REJECTION_OCE_CONFIG_PARAM,
	WMI_TLV_TAG_STRUCT_UNIT_TEST_EVENT,
	WMI_TLV_TAG_STRUCT_ROAM_FILS_OFFLOAD_TLV_PARAM,
	WMI_TLV_TAG_STRUCT_PDEV_UPDATE_PMK_CACHE_CMD,
	WMI_TLV_TAG_STRUCT_PMK_CACHE,
	WMI_TLV_TAG_STRUCT_PDEV_UPDATE_FILS_HLP_PKT_CMD,
	WMI_TLV_