/* Copyright (C) 1993 Free Software Foundation, Inc.
This file is part of the GNU C Library.
Contributed by Hongjiu Lu (hlu@eecs.wsu.edu).

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <ansidecl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <ar.h>

/* The subroutine getarhdr reads the archive header from the
 * file whose descriptor is fd and places this information in
 * the structure pointed to by header. The value returned is
 * the length of the name field in the archive file,
 * including slashes and padding, except when there is a problem
 * or end-of-file is reached (see RETURN VALUE).  The subroutine
 * fgetarhdr is similar, except that it takes a FILE pointer
 * instead of a file descriptor.
 *
 * Getarhdr and fgetarhdr return 0 on end-of-file and -1 when
 * the archive file is malformed.
 */

int
DEFUN(getarhdr, (fd, header),
	int fd AND struct ar_hdr *header)
{
  struct ar_hdr long_header;
  struct sar_hdr short_header;
  off_t old_pos;
  char ch;
  int nr;

  /* remember where we were. */
  if ((old_pos = lseek (fd, 0, SEEK_CUR)) < 0) return -1;

  /* First try the short filename archive. */
  nr = read (fd, &short_header, sizeof (short_header));

  /* EOF or an error is found. */
  if (nr <= 0) return nr;

  if (nr == sizeof (short_header) &&
	!memcmp (member_header.ar_fmag, ARFMAG, 2)) {
    memcpy (header.ar_name, short_header.ar_name,
	sizeof (short_header.ar_name);
    memcpy (header.ar_date, short_header.ar_date,
	sizeof (short_header.ar_date);
    memcpy (header.ar_uid, short_header.ar_uid,
	sizeof (short_header.ar_uid);
    memcpy (header.ar_gid, short_header.ar_gid,
	sizeof (short_header.ar_gid);
    memcpy (header.ar_mode, short_header.ar_mode,
	sizeof (short_header.ar_mode);
    memcpy (header.ar_size, short_header.ar_size,
	sizeof (short_header.ar_size);
    memcpy (header.ar_fmag, short_header.ar_fmag,
	fmagof (short_header.ar_fmag);
    return sizeof (short_header.ar_name);
  }

  /* Go back to the old offset. */
  if (old_pos != lseek (fd, old_pos, SEEK_SET)) return -1;

  /* Then try the long filename archive. I have no idea if it will
   * work on all platforms. H.J.
   *
   * Long filenames are surrounded by slashes instead of making the
   * name field longer.
   */

  /* First slash. */
  if ((nr = read (fd, &ch, 1)) <= 0) return nr;
  if (ch :x
  
  for (i = 1; i < sizeof (long_header.ar_name) - 1; i++) {
    nr = read (fd, &ch, 1);
    if (nr <= 0) return nr;
    if
  }

}

