/*
 * NSM notify list handling.
 *
 * Copyright (c) 1995, 1997 Jeffrey A. Uphoff
 * Modified by Olaf Kirch Oct 1996.
 */

#include <dirent.h>
#include <errno.h>
#include <netdb.h>
#include <string.h>
#include <unistd.h>
#include "statd.h"
/* #include <rpc/pmap_clnt.h> */
#include "notlist.h"

#if DEBUG > 1
# include <arpa/inet.h>
#endif

#ifndef lint
static char vcid[] = "$Id: notify.c,v 2.2 1998/06/01 19:06:43 juphoff Exp $";
#endif

/*
 * Initial (startup) notify list.
 */
notify_list		*inl = NULL;


/* 
 * Get list of hosts from stable storage, build list of hosts to
 * contact. These hosts are added to the global RPC notify list
 * which is processed as soon as statd enters svc_run.
 */
void
notify_hosts(void)
{
	DIR            *nld;
	struct dirent  *de;
	notify_list    *call;

	if (!(nld = opendir(SM_BAK_DIR))) {
		perror("opendir");
		exit(errno);
	}

	while ((de = readdir(nld))) {
		if (de->d_name[0] == '.')
			continue;

		/* The following can happen for loopback NFS mounts
		 * (e.g. with cfsd) */
		if (!strcasecmp(de->d_name, MY_NAME)
		 || !strcasecmp(de->d_name, "localhost")) {
			char	fname[PATH_MAX];

			dprintf(L_DEBUG, "We're on our own notify list?!?");
			sprintf(fname, SM_BAK_DIR "/%s", de->d_name);
			unlink(fname);
			continue;
		}

		call = nlist_new(MY_NAME, de->d_name, -1);
		NL_TYPE(call) = NOTIFY_REBOOT;
		nlist_insert(&notify, call);
	}

	if (closedir(nld) == -1) {
		perror("closedir");
		exit(1);
	}
}
