#ifndef _BASIC_H_
#define _BASIC_H_

typedef enum { False = 0,
               True = !False } Bool;

/* 
Status blub(void);

..

if (blub()) printf("blub returned error");
*/

typedef enum { Fail = True,
               Ok   = False } Status;

#define min(a,b) \
       ({typedef _ta = (a), _tb = (b);  \
         _ta _a = (a); _tb _b = (b);     \
         _a < _b ? _a : _b; })
#define max(a,b) \
       ({typedef _ta = (a), _tb = (b);  \
         _ta _a = (a); _tb _b = (b);     \
         _a > _b ? _a : _b; })

#if DEBUG > 0
#include <string.h>
#define cmalloc(s) \
({void *__s = malloc(s); if (__s) { memset(__s, 0xfe, s); } __s;})
#else
#define cmalloc(s) calloc(1,(s))
#endif

#endif /* _BASIC_H_ */
