#ifndef _PSTR_H_
#define _PSTR_H_

#include <malloc.h>
#include <string.h>

typedef const char * pstr;

pstr
pstr_create(const char *s1, ...);

void
pstr_delete(pstr);

#define pstr_1(s1)\
(pstr_create((s1), NULL))
#define pstr_2(s1,s2)\
(pstr_create((s1), (s2), NULL))
#define pstr_3(s1,s2,s3)\
(pstr_create((s1), (s2), (s3), NULL))
#define pstr_4(s1,s2,s3,s4)\
(pstr_create((s1), (s2), (s3), (s4), NULL))

#define temp_pstr_1(s1)\
({ char *__r = alloca(strlen(s1)+1); strcpy(__r, s1); (pstr)__r;})
#define temp_pstr_2(s1, s2)\
({ char *__r = alloca(strlen(s1)+strlen(s2)+1);\
     strcpy(__r, s1); strcat(__r, s2); (pstr)__r;})
#define temp_pstr_3(s1,s2,s3)\
({ char *__r = alloca(strlen(s1)+strlen(s2)+strlen(s3)+1);\
     strcpy(__r, s1); strcat(__r, s2); strcat(__r, s3); (pstr)__r;})
#define temp_pstr_4(s1,s2,s3,s4)\
({ char *__r = alloca(strlen(s1)+strlen(s2)+strlen(s3)+strlen(s4)+1);\
  strcpy(__r,s1); strcat(__r,s2); strcat(__r,s3); strcat(__r, s4); (pstr)__r;})

void
pstr_lower(pstr s);
void
pstr_upper(pstr s);
void
strlower(char *s);
void
strupper(char *s);

#endif /* _PSTR_H_ */
