/*
-- ----------------------------------------------------------------------------
--
--  Object name : filconst.h
--  Revision    : 1.0
--
--  Copyright (c) Inmos Ltd, 1987.
--  All Rights Reserved.
--
--  DESCRIPTION
--    TDS Server Constants for Host Filer.
--
--  NOTES
--
--  HISTORY
--     ibm-pc  3-Apr-86  CREATION.
--     ibm-pc 16-Apr-88  RJO - Added 'rwresult' to FILER_SPACE_DEF for
--                       read ahead/write behind operations.
-- ----------------------------------------------------------------------------
*/
/*
-- ----------------------------------------------------------------------------
-- Filer Defs - Def to the filer..
-- ----------------------------------------------------------------------------
*/
#define RECORDS_IN_BUFFER        1  /* Number of data records held in a    */
                                    /* filer's buffer */
#define BUFFER_LENGTH            (RECORDS_IN_BUFFER * RECORD_LENGTH)
                                    /* Length of a filer's buffer */
#define SR_STACK_DEPTH           20 /* Number of entries in a filer's      */
                                    /* suspend/resume stack                */
#define EXTN_STR_LENGTH          5  /* Length of a filename extension,     */
                                    /* includes '.' and '\0'               */
#define F_LENGTH                 8  /* Length of filename (less extension) */
#define MAX_FILE_CONTENTS        32 /* Maximum value of file contents      */
                                    /* attribute                           */
#define MOVE_FILE_EXTN           ".mov"
                                    /* Default extension for move buffer   */
#define S_BEGINNING              0  /* Parameters to fseek stdio routine   */
#define S_CURRENT                1
#define S_END                    2
#define WRITE_PERMISSION         2  /* Parameter to access routine         */
#define VARIANT_LENGTH           2  /* Number of characters in variant for */
                                    /* Copy File                           */
#define MAX_SEARCH_COUNT         99 /* Maximum number of file variants     */
#define CHRC_NAME_LENGTH         20 /* Length of file characteristic name  */
#define NUMBER_OF_CHRC           3  /* Number of file characteristics      */
#define FILETIMECHRC             1  /* File creation time characteristic   */
#define FILESIZECHRC             2  /* File length characteristic          */
#define READONLYCHRC             3  /* Read-only protection characteristic */
/*
-- ----------------------------------------------------------------------------
-- Filer states.
-- ----------------------------------------------------------------------------
*/

#define FS_IDLE                  0
#define FS_OPEN_FOR_READING      1
#define FS_OPEN_FOR_WRITING      2
#define FS_OPEN_READ_CHRC        3
#define FS_OPEN_WRITE_CHRC       4
#define FS_OPEN_FOR_READING_TEXT 5
#define FS_OPEN_FOR_WRITING_TEXT 6
#define FS_OPEN_BLOCK_READ       7
#define FS_OPEN_BLOCK_WRITE      8
#define FS_OPEN_BLOCK_UPDATE     9
/*
-- ----------------------------------------------------------------------------
-- Values taken by last_op in FILER_SPACE_DEF
-- ----------------------------------------------------------------------------
*/

#define READ   0
#define WRITE  1
/*
-- ----------------------------------------------------------------------------
-- OPS Constants.
-- ----------------------------------------------------------------------------
*/

#define STRING_BYTE              0
#define START_LIST_BYTE          0x80
#define END_LIST_BYTE            0x81
#define START_FILED_BYTE         0x84
#define END_FILED_BYTE           0x85
#define PREFIX_BYTE              0xC0
#define TOP_LEVEL_ATTR1          0x40
#define TOP_LEVEL_ATTR2          0x41
#define TOP_LEVEL_ATTR3          0x40
#define DATA_FIELD_SIZE          6
struct SR_STACK_ENTRY
  {
    char file_str[FILE_NAME_LENGTH];   /* Name of suspended file */
    int  file_mode;                    /* Mode of suspended file */
  };
struct FILER_SPACE_DEF
  {
    int state;                 /* Filer's state                            */
    int result;                /* Result of last filer operation           */
    int rwresult;              /* Read ahead/ Write behind result          */
    int host_error;            /* Last generated host error                */
    FILE *handle;              /* Handle to file open on this filer        */
    int buffer_count;          /* Count of buffer space                    */
    int buffer_ptr;            /* Next space in buffer                     */
    char file_name[FILE_NAME_LENGTH]; /* Name of file open on this filer   */
    char buffer[BUFFER_LENGTH];
                               /* Filer data buffer                        */
    int sr_stack_ptr;          /* Next free entry in suspend/resume stack  */
    struct SR_STACK_ENTRY sr_stack[SR_STACK_DEPTH];
                               /* The suspend/resume stack                 */
    int block_posn;            /* Position within block when accessing in
                                  block mode */
    int last_op;               /* Last file access type when in block mode */
  };
struct FILE_ID_STRUCT
  {
    char name[FILE_NAME_LENGTH];
    int type_attr;
    int contents_attr;
  };
struct ASCII_ID_STRUCT
  {
    char name[FILE_NAME_LENGTH];
    int type_attr;
    int contents_attr;
  };
struct ATT_TABLE_STRUCT
  {
    char extn[EXTN_STR_LENGTH];
    int type;
  };
struct ATTR_STRUCT
  {
    int type;
    int contents;
  };
struct CHRC_TABLE_STRUCT
  {
    char name [CHRC_NAME_LENGTH];
    int changeable;
  };

/*
--
--     End of File.
--
*/
