# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AzureAsyncOperationResult(Model):
    """The response body contains the status of the specified asynchronous
    operation, indicating whether it has succeeded, is in progress, or has
    failed. Note that this status is distinct from the HTTP status code
    returned for the Get Operation Status operation itself. If the asynchronous
    operation succeeded, the response body includes the HTTP status code for
    the successful request. If the asynchronous operation failed, the response
    body includes the HTTP status code for the failed request and error
    information regarding the failure.

    :param status: Status of the Azure async operation. Possible values are:
     'InProgress', 'Succeeded', and 'Failed'. Possible values include:
     'InProgress', 'Succeeded', 'Failed'
    :type status: str or ~azure.mgmt.frontdoor.models.NetworkOperationStatus
    :param error:
    :type error: ~azure.mgmt.frontdoor.models.Error
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
    }

    def __init__(self, *, status=None, error=None, **kwargs) -> None:
        super(AzureAsyncOperationResult, self).__init__(**kwargs)
        self.status = status
        self.error = error


class Backend(Model):
    """Backend address of a frontDoor load balancer.

    :param address: Location of the backend (IP address or FQDN)
    :type address: str
    :param http_port: The HTTP TCP port number. Must be between 1 and 65535.
    :type http_port: int
    :param https_port: The HTTPS TCP port number. Must be between 1 and 65535.
    :type https_port: int
    :param enabled_state: Whether to enable use of this backend. Permitted
     values are 'Enabled' or 'Disabled'. Possible values include: 'Enabled',
     'Disabled'
    :type enabled_state: str or
     ~azure.mgmt.frontdoor.models.BackendEnabledState
    :param priority: Priority to use for load balancing. Higher priorities
     will not be used for load balancing if any lower priority backend is
     healthy.
    :type priority: int
    :param weight: Weight of this endpoint for load balancing purposes.
    :type weight: int
    :param backend_host_header: The value to use as the host header sent to
     the backend. If blank or unspecified, this defaults to the incoming host.
    :type backend_host_header: str
    """

    _validation = {
        'http_port': {'maximum': 65535, 'minimum': 1},
        'https_port': {'maximum': 65535, 'minimum': 1},
        'priority': {'maximum': 5, 'minimum': 1},
        'weight': {'maximum': 1000, 'minimum': 1},
    }

    _attribute_map = {
        'address': {'key': 'address', 'type': 'str'},
        'http_port': {'key': 'httpPort', 'type': 'int'},
        'https_port': {'key': 'httpsPort', 'type': 'int'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'weight': {'key': 'weight', 'type': 'int'},
        'backend_host_header': {'key': 'backendHostHeader', 'type': 'str'},
    }

    def __init__(self, *, address: str=None, http_port: int=None, https_port: int=None, enabled_state=None, priority: int=None, weight: int=None, backend_host_header: str=None, **kwargs) -> None:
        super(Backend, self).__init__(**kwargs)
        self.address = address
        self.http_port = http_port
        self.https_port = https_port
        self.enabled_state = enabled_state
        self.priority = priority
        self.weight = weight
        self.backend_host_header = backend_host_header


class SubResource(Model):
    """Reference to another subresource.

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(SubResource, self).__init__(**kwargs)
        self.id = id


class BackendPool(SubResource):
    """A backend pool is a collection of backends that can be routed to.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param backends: The set of backends for this pool
    :type backends: list[~azure.mgmt.frontdoor.models.Backend]
    :param load_balancing_settings: Load balancing settings for a backend pool
    :type load_balancing_settings: ~azure.mgmt.frontdoor.models.SubResource
    :param health_probe_settings: L7 health probe settings for a backend pool
    :type health_probe_settings: ~azure.mgmt.frontdoor.models.SubResource
    :param resource_state: Resource status. Possible values include:
     'Creating', 'Enabling', 'Enabled', 'Disabling', 'Disabled', 'Deleting'
    :type resource_state: str or
     ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    :param name: Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'backends': {'key': 'properties.backends', 'type': '[Backend]'},
        'load_balancing_settings': {'key': 'properties.loadBalancingSettings', 'type': 'SubResource'},
        'health_probe_settings': {'key': 'properties.healthProbeSettings', 'type': 'SubResource'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, backends=None, load_balancing_settings=None, health_probe_settings=None, resource_state=None, name: str=None, **kwargs) -> None:
        super(BackendPool, self).__init__(id=id, **kwargs)
        self.backends = backends
        self.load_balancing_settings = load_balancing_settings
        self.health_probe_settings = health_probe_settings
        self.resource_state = resource_state
        self.name = name
        self.type = None


class BackendPoolListResult(Model):
    """Result of the request to list Backend Pools. It contains a list of Backend
    Pools objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: List of Backend Pools within a Front Door.
    :vartype value: list[~azure.mgmt.frontdoor.models.BackendPool]
    :param next_link: URL to get the next set of BackendPool objects if there
     are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BackendPool]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, *, next_link: str=None, **kwargs) -> None:
        super(BackendPoolListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class BackendPoolsSettings(Model):
    """Settings that apply to all backend pools.

    :param enforce_certificate_name_check: Whether to enforce certificate name
     check on HTTPS requests to all backend pools. No effect on non-HTTPS
     requests. Possible values include: 'Enabled', 'Disabled'. Default value:
     "Enabled" .
    :type enforce_certificate_name_check: str or
     ~azure.mgmt.frontdoor.models.EnforceCertificateNameCheckEnabledState
    :param send_recv_timeout_seconds: Send and receive timeout on forwarding
     request to the backend. When timeout is reached, the request fails and
     returns.
    :type send_recv_timeout_seconds: int
    """

    _validation = {
        'send_recv_timeout_seconds': {'minimum': 16},
    }

    _attribute_map = {
        'enforce_certificate_name_check': {'key': 'enforceCertificateNameCheck', 'type': 'str'},
        'send_recv_timeout_seconds': {'key': 'sendRecvTimeoutSeconds', 'type': 'int'},
    }

    def __init__(self, *, enforce_certificate_name_check="Enabled", send_recv_timeout_seconds: int=None, **kwargs) -> None:
        super(BackendPoolsSettings, self).__init__(**kwargs)
        self.enforce_certificate_name_check = enforce_certificate_name_check
        self.send_recv_timeout_seconds = send_recv_timeout_seconds


class BackendPoolUpdateParameters(Model):
    """A collection of backends that can be routed to.

    :param backends: The set of backends for this pool
    :type backends: list[~azure.mgmt.frontdoor.models.Backend]
    :param load_balancing_settings: Load balancing settings for a backend pool
    :type load_balancing_settings: ~azure.mgmt.frontdoor.models.SubResource
    :param health_probe_settings: L7 health probe settings for a backend pool
    :type health_probe_settings: ~azure.mgmt.frontdoor.models.SubResource
    """

    _attribute_map = {
        'backends': {'key': 'backends', 'type': '[Backend]'},
        'load_balancing_settings': {'key': 'loadBalancingSettings', 'type': 'SubResource'},
        'health_probe_settings': {'key': 'healthProbeSettings', 'type': 'SubResource'},
    }

    def __init__(self, *, backends=None, load_balancing_settings=None, health_probe_settings=None, **kwargs) -> None:
        super(BackendPoolUpdateParameters, self).__init__(**kwargs)
        self.backends = backends
        self.load_balancing_settings = load_balancing_settings
        self.health_probe_settings = health_probe_settings


class CacheConfiguration(Model):
    """Caching settings for a caching-type route. To disable caching, do not
    provide a cacheConfiguration object.

    :param query_parameter_strip_directive: Treatment of URL query terms when
     forming the cache key. Possible values include: 'StripNone', 'StripAll'
    :type query_parameter_strip_directive: str or
     ~azure.mgmt.frontdoor.models.FrontDoorQuery
    :param dynamic_compression: Whether to use dynamic compression for cached
     content. Possible values include: 'Enabled', 'Disabled'
    :type dynamic_compression: str or
     ~azure.mgmt.frontdoor.models.DynamicCompressionEnabled
    """

    _attribute_map = {
        'query_parameter_strip_directive': {'key': 'queryParameterStripDirective', 'type': 'str'},
        'dynamic_compression': {'key': 'dynamicCompression', 'type': 'str'},
    }

    def __init__(self, *, query_parameter_strip_directive=None, dynamic_compression=None, **kwargs) -> None:
        super(CacheConfiguration, self).__init__(**kwargs)
        self.query_parameter_strip_directive = query_parameter_strip_directive
        self.dynamic_compression = dynamic_compression


class CheckNameAvailabilityInput(Model):
    """Input of CheckNameAvailability API.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The resource name to validate.
    :type name: str
    :param type: Required. The type of the resource whose name is to be
     validated. Possible values include: 'Microsoft.Network/frontDoors',
     'Microsoft.Network/frontDoors/frontendEndpoints'
    :type type: str or ~azure.mgmt.frontdoor.models.ResourceType
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'ResourceType'},
    }

    def __init__(self, *, name: str, type, **kwargs) -> None:
        super(CheckNameAvailabilityInput, self).__init__(**kwargs)
        self.name = name
        self.type = type


class CheckNameAvailabilityOutput(Model):
    """Output of check name availability API.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name_availability: Indicates whether the name is available. Possible
     values include: 'Available', 'Unavailable'
    :vartype name_availability: str or
     ~azure.mgmt.frontdoor.models.Availability
    :ivar reason: The reason why the name is not available.
    :vartype reason: str
    :ivar message: The detailed error message describing why the name is not
     available.
    :vartype message: str
    """

    _validation = {
        'name_availability': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_availability': {'key': 'nameAvailability', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(CheckNameAvailabilityOutput, self).__init__(**kwargs)
        self.name_availability = None
        self.reason = None
        self.message = None


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class CustomHttpsConfiguration(Model):
    """Https settings for a domain.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param certificate_source: Required. Defines the source of the SSL
     certificate. Possible values include: 'AzureKeyVault', 'FrontDoor'
    :type certificate_source: str or
     ~azure.mgmt.frontdoor.models.FrontDoorCertificateSource
    :ivar protocol_type: Required. Defines the TLS extension protocol that is
     used for secure delivery. Default value: "ServerNameIndication" .
    :vartype protocol_type: str
    :param minimum_tls_version: Required. The minimum TLS version required
     from the clients to establish an SSL handshake with Front Door. Possible
     values include: '1.0', '1.2'
    :type minimum_tls_version: str or
     ~azure.mgmt.frontdoor.models.MinimumTLSVersion
    :param vault: The Key Vault containing the SSL certificate
    :type vault:
     ~azure.mgmt.frontdoor.models.KeyVaultCertificateSourceParametersVault
    :param secret_name: The name of the Key Vault secret representing the full
     certificate PFX
    :type secret_name: str
    :param secret_version: The version of the Key Vault secret representing
     the full certificate PFX
    :type secret_version: str
    :param certificate_type: Defines the type of the certificate used for
     secure connections to a frontendEndpoint. Possible values include:
     'Dedicated'
    :type certificate_type: str or
     ~azure.mgmt.frontdoor.models.FrontDoorCertificateType
    """

    _validation = {
        'certificate_source': {'required': True},
        'protocol_type': {'required': True, 'constant': True},
        'minimum_tls_version': {'required': True},
    }

    _attribute_map = {
        'certificate_source': {'key': 'certificateSource', 'type': 'str'},
        'protocol_type': {'key': 'protocolType', 'type': 'str'},
        'minimum_tls_version': {'key': 'minimumTlsVersion', 'type': 'str'},
        'vault': {'key': 'keyVaultCertificateSourceParameters.vault', 'type': 'KeyVaultCertificateSourceParametersVault'},
        'secret_name': {'key': 'keyVaultCertificateSourceParameters.secretName', 'type': 'str'},
        'secret_version': {'key': 'keyVaultCertificateSourceParameters.secretVersion', 'type': 'str'},
        'certificate_type': {'key': 'frontDoorCertificateSourceParameters.certificateType', 'type': 'str'},
    }

    protocol_type = "ServerNameIndication"

    def __init__(self, *, certificate_source, minimum_tls_version, vault=None, secret_name: str=None, secret_version: str=None, certificate_type=None, **kwargs) -> None:
        super(CustomHttpsConfiguration, self).__init__(**kwargs)
        self.certificate_source = certificate_source
        self.minimum_tls_version = minimum_tls_version
        self.vault = vault
        self.secret_name = secret_name
        self.secret_version = secret_version
        self.certificate_type = certificate_type


class CustomRule(Model):
    """Defines contents of a web application rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Describes the name of the rule.
    :type name: str
    :param priority: Required. Describes priority of the rule. Rules with a
     lower value will be evaluated before rules with a higher value.
    :type priority: int
    :param enabled_state: Describes if the custom rule is in enabled or
     disabled state. Defaults to Enabled if not specified. Possible values
     include: 'Disabled', 'Enabled'
    :type enabled_state: str or
     ~azure.mgmt.frontdoor.models.CustomRuleEnabledState
    :param rule_type: Required. Describes type of rule. Possible values
     include: 'MatchRule', 'RateLimitRule'
    :type rule_type: str or ~azure.mgmt.frontdoor.models.RuleType
    :param rate_limit_duration_in_minutes: Time window for resetting the rate
     limit count. Default is 1 minute.
    :type rate_limit_duration_in_minutes: int
    :param rate_limit_threshold: Number of allowed requests per client within
     the time window.
    :type rate_limit_threshold: int
    :param match_conditions: Required. List of match conditions.
    :type match_conditions: list[~azure.mgmt.frontdoor.models.MatchCondition]
    :param action: Required. Describes what action to be applied when rule
     matches. Possible values include: 'Allow', 'Block', 'Log', 'Redirect'
    :type action: str or ~azure.mgmt.frontdoor.models.ActionType
    """

    _validation = {
        'name': {'max_length': 128},
        'priority': {'required': True},
        'rule_type': {'required': True},
        'rate_limit_duration_in_minutes': {'maximum': 5, 'minimum': 0},
        'rate_limit_threshold': {'minimum': 0},
        'match_conditions': {'required': True},
        'action': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'rule_type': {'key': 'ruleType', 'type': 'str'},
        'rate_limit_duration_in_minutes': {'key': 'rateLimitDurationInMinutes', 'type': 'int'},
        'rate_limit_threshold': {'key': 'rateLimitThreshold', 'type': 'int'},
        'match_conditions': {'key': 'matchConditions', 'type': '[MatchCondition]'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(self, *, priority: int, rule_type, match_conditions, action, name: str=None, enabled_state=None, rate_limit_duration_in_minutes: int=None, rate_limit_threshold: int=None, **kwargs) -> None:
        super(CustomRule, self).__init__(**kwargs)
        self.name = name
        self.priority = priority
        self.enabled_state = enabled_state
        self.rule_type = rule_type
        self.rate_limit_duration_in_minutes = rate_limit_duration_in_minutes
        self.rate_limit_threshold = rate_limit_threshold
        self.match_conditions = match_conditions
        self.action = action


class CustomRuleList(Model):
    """Defines contents of custom rules.

    :param rules: List of rules
    :type rules: list[~azure.mgmt.frontdoor.models.CustomRule]
    """

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[CustomRule]'},
    }

    def __init__(self, *, rules=None, **kwargs) -> None:
        super(CustomRuleList, self).__init__(**kwargs)
        self.rules = rules


class Endpoint(Model):
    """Defines the endpoint properties.

    :param name: The name of the endpoint
    :type name: str
    :param endpoint: The endpoint URL
    :type endpoint: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, endpoint: str=None, **kwargs) -> None:
        super(Endpoint, self).__init__(**kwargs)
        self.name = name
        self.endpoint = endpoint


class Error(Model):
    """Error.

    :param code:
    :type code: str
    :param message:
    :type message: str
    :param target:
    :type target: str
    :param details:
    :type details: list[~azure.mgmt.frontdoor.models.ErrorDetails]
    :param inner_error:
    :type inner_error: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetails]'},
        'inner_error': {'key': 'innerError', 'type': 'str'},
    }

    def __init__(self, *, code: str=None, message: str=None, target: str=None, details=None, inner_error: str=None, **kwargs) -> None:
        super(Error, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.inner_error = inner_error


class ErrorDetails(Model):
    """ErrorDetails.

    :param code:
    :type code: str
    :param target:
    :type target: str
    :param message:
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, code: str=None, target: str=None, message: str=None, **kwargs) -> None:
        super(ErrorDetails, self).__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class ErrorResponse(Model):
    """Error response indicates Front Door service is not able to process the
    incoming request. The reason is provided in the error message.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class Resource(Model):
    """Common resource representation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, location: str=None, tags=None, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class Experiment(Resource):
    """Defines the properties of an Experiment.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param description: The description of the details or intents of the
     Experiment
    :type description: str
    :param endpoint_a: The endpoint A of an experiment
    :type endpoint_a: ~azure.mgmt.frontdoor.models.Endpoint
    :param endpoint_b: The endpoint B of an experiment
    :type endpoint_b: ~azure.mgmt.frontdoor.models.Endpoint
    :param enabled_state: The state of the Experiment. Possible values
     include: 'Enabled', 'Disabled'
    :type enabled_state: str or ~azure.mgmt.frontdoor.models.State
    :param resource_state: Resource status. Possible values include:
     'Creating', 'Enabling', 'Enabled', 'Disabling', 'Disabled', 'Deleting'
    :type resource_state: str or
     ~azure.mgmt.frontdoor.models.NetworkExperimentResourceState
    :ivar status: The description of Experiment status from the server side
    :vartype status: str
    :ivar script_file_uri: The uri to the Script used in the Experiment
    :vartype script_file_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'script_file_uri': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'endpoint_a': {'key': 'properties.endpointA', 'type': 'Endpoint'},
        'endpoint_b': {'key': 'properties.endpointB', 'type': 'Endpoint'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'script_file_uri': {'key': 'properties.scriptFileUri', 'type': 'str'},
    }

    def __init__(self, *, location: str=None, tags=None, description: str=None, endpoint_a=None, endpoint_b=None, enabled_state=None, resource_state=None, **kwargs) -> None:
        super(Experiment, self).__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.endpoint_a = endpoint_a
        self.endpoint_b = endpoint_b
        self.enabled_state = enabled_state
        self.resource_state = resource_state
        self.status = None
        self.script_file_uri = None


class ExperimentUpdateModel(Model):
    """Defines modifiable attributes of an Experiment.

    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param description: The description of the intent or details of the
     Experiment
    :type description: str
    :param enabled_state: The state of the Experiment. Possible values
     include: 'Enabled', 'Disabled'
    :type enabled_state: str or ~azure.mgmt.frontdoor.models.State
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
    }

    def __init__(self, *, tags=None, description: str=None, enabled_state=None, **kwargs) -> None:
        super(ExperimentUpdateModel, self).__init__(**kwargs)
        self.tags = tags
        self.description = description
        self.enabled_state = enabled_state


class RouteConfiguration(Model):
    """Base class for all types of Route.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ForwardingConfiguration, RedirectConfiguration

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration': 'ForwardingConfiguration', '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration': 'RedirectConfiguration'}
    }

    def __init__(self, **kwargs) -> None:
        super(RouteConfiguration, self).__init__(**kwargs)
        self.odatatype = None


class ForwardingConfiguration(RouteConfiguration):
    """Describes Forwarding Route.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param custom_forwarding_path: A custom path used to rewrite resource
     paths matched by this rule. Leave empty to use incoming path.
    :type custom_forwarding_path: str
    :param forwarding_protocol: Protocol this rule will use when forwarding
     traffic to backends. Possible values include: 'HttpOnly', 'HttpsOnly',
     'MatchRequest'
    :type forwarding_protocol: str or
     ~azure.mgmt.frontdoor.models.FrontDoorForwardingProtocol
    :param cache_configuration: The caching configuration associated with this
     rule.
    :type cache_configuration: ~azure.mgmt.frontdoor.models.CacheConfiguration
    :param backend_pool: A reference to the BackendPool which this rule routes
     to.
    :type backend_pool: ~azure.mgmt.frontdoor.models.SubResource
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'custom_forwarding_path': {'key': 'customForwardingPath', 'type': 'str'},
        'forwarding_protocol': {'key': 'forwardingProtocol', 'type': 'str'},
        'cache_configuration': {'key': 'cacheConfiguration', 'type': 'CacheConfiguration'},
        'backend_pool': {'key': 'backendPool', 'type': 'SubResource'},
    }

    def __init__(self, *, custom_forwarding_path: str=None, forwarding_protocol=None, cache_configuration=None, backend_pool=None, **kwargs) -> None:
        super(ForwardingConfiguration, self).__init__(**kwargs)
        self.custom_forwarding_path = custom_forwarding_path
        self.forwarding_protocol = forwarding_protocol
        self.cache_configuration = cache_configuration
        self.backend_pool = backend_pool
        self.odatatype = '#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration'


class FrontDoor(Resource):
    """Front Door represents a collection of backend endpoints to route traffic to
    along with rules that specify how traffic is sent there.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param friendly_name: A friendly name for the frontDoor
    :type friendly_name: str
    :param routing_rules: Routing rules associated with this Front Door.
    :type routing_rules: list[~azure.mgmt.frontdoor.models.RoutingRule]
    :param load_balancing_settings: Load balancing settings associated with
     this Front Door instance.
    :type load_balancing_settings:
     list[~azure.mgmt.frontdoor.models.LoadBalancingSettingsModel]
    :param health_probe_settings: Health probe settings associated with this
     Front Door instance.
    :type health_probe_settings:
     list[~azure.mgmt.frontdoor.models.HealthProbeSettingsModel]
    :param backend_pools: Backend pools available to routing rules.
    :type backend_pools: list[~azure.mgmt.frontdoor.models.BackendPool]
    :param frontend_endpoints: Frontend endpoints available to routing rules.
    :type frontend_endpoints:
     list[~azure.mgmt.frontdoor.models.FrontendEndpoint]
    :param backend_pools_settings: Settings for all backendPools
    :type backend_pools_settings:
     ~azure.mgmt.frontdoor.models.BackendPoolsSettings
    :param enabled_state: Operational status of the Front Door load balancer.
     Permitted values are 'Enabled' or 'Disabled'. Possible values include:
     'Enabled', 'Disabled'
    :type enabled_state: str or
     ~azure.mgmt.frontdoor.models.FrontDoorEnabledState
    :param resource_state: Resource status of the Front Door. Possible values
     include: 'Creating', 'Enabling', 'Enabled', 'Disabling', 'Disabled',
     'Deleting'
    :type resource_state: str or
     ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    :ivar provisioning_state: Provisioning state of the Front Door.
    :vartype provisioning_state: str
    :ivar cname: The host that each frontendEndpoint must CNAME to.
    :vartype cname: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'cname': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'routing_rules': {'key': 'properties.routingRules', 'type': '[RoutingRule]'},
        'load_balancing_settings': {'key': 'properties.loadBalancingSettings', 'type': '[LoadBalancingSettingsModel]'},
        'health_probe_settings': {'key': 'properties.healthProbeSettings', 'type': '[HealthProbeSettingsModel]'},
        'backend_pools': {'key': 'properties.backendPools', 'type': '[BackendPool]'},
        'frontend_endpoints': {'key': 'properties.frontendEndpoints', 'type': '[FrontendEndpoint]'},
        'backend_pools_settings': {'key': 'properties.backendPoolsSettings', 'type': 'BackendPoolsSettings'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'cname': {'key': 'properties.cname', 'type': 'str'},
    }

    def __init__(self, *, location: str=None, tags=None, friendly_name: str=None, routing_rules=None, load_balancing_settings=None, health_probe_settings=None, backend_pools=None, frontend_endpoints=None, backend_pools_settings=None, enabled_state=None, resource_state=None, **kwargs) -> None:
        super(FrontDoor, self).__init__(location=location, tags=tags, **kwargs)
        self.friendly_name = friendly_name
        self.routing_rules = routing_rules
        self.load_balancing_settings = load_balancing_settings
        self.health_probe_settings = health_probe_settings
        self.backend_pools = backend_pools
        self.frontend_endpoints = frontend_endpoints
        self.backend_pools_settings = backend_pools_settings
        self.enabled_state = enabled_state
        self.resource_state = resource_state
        self.provisioning_state = None
        self.cname = None


class FrontDoorUpdateParameters(Model):
    """The properties needed to update a Front Door.

    :param friendly_name: A friendly name for the frontDoor
    :type friendly_name: str
    :param routing_rules: Routing rules associated with this Front Door.
    :type routing_rules: list[~azure.mgmt.frontdoor.models.RoutingRule]
    :param load_balancing_settings: Load balancing settings associated with
     this Front Door instance.
    :type load_balancing_settings:
     list[~azure.mgmt.frontdoor.models.LoadBalancingSettingsModel]
    :param health_probe_settings: Health probe settings associated with this
     Front Door instance.
    :type health_probe_settings:
     list[~azure.mgmt.frontdoor.models.HealthProbeSettingsModel]
    :param backend_pools: Backend pools available to routing rules.
    :type backend_pools: list[~azure.mgmt.frontdoor.models.BackendPool]
    :param frontend_endpoints: Frontend endpoints available to routing rules.
    :type frontend_endpoints:
     list[~azure.mgmt.frontdoor.models.FrontendEndpoint]
    :param backend_pools_settings: Settings for all backendPools
    :type backend_pools_settings:
     ~azure.mgmt.frontdoor.models.BackendPoolsSettings
    :param enabled_state: Operational status of the Front Door load balancer.
     Permitted values are 'Enabled' or 'Disabled'. Possible values include:
     'Enabled', 'Disabled'
    :type enabled_state: str or
     ~azure.mgmt.frontdoor.models.FrontDoorEnabledState
    """

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'routing_rules': {'key': 'routingRules', 'type': '[RoutingRule]'},
        'load_balancing_settings': {'key': 'loadBalancingSettings', 'type': '[LoadBalancingSettingsModel]'},
        'health_probe_settings': {'key': 'healthProbeSettings', 'type': '[HealthProbeSettingsModel]'},
        'backend_pools': {'key': 'backendPools', 'type': '[BackendPool]'},
        'frontend_endpoints': {'key': 'frontendEndpoints', 'type': '[FrontendEndpoint]'},
        'backend_pools_settings': {'key': 'backendPoolsSettings', 'type': 'BackendPoolsSettings'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
    }

    def __init__(self, *, friendly_name: str=None, routing_rules=None, load_balancing_settings=None, health_probe_settings=None, backend_pools=None, frontend_endpoints=None, backend_pools_settings=None, enabled_state=None, **kwargs) -> None:
        super(FrontDoorUpdateParameters, self).__init__(**kwargs)
        self.friendly_name = friendly_name
        self.routing_rules = routing_rules
        self.load_balancing_settings = load_balancing_settings
        self.health_probe_settings = health_probe_settings
        self.backend_pools = backend_pools
        self.frontend_endpoints = frontend_endpoints
        self.backend_pools_settings = backend_pools_settings
        self.enabled_state = enabled_state


class FrontendEndpoint(SubResource):
    """A frontend endpoint used for routing.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param host_name: The host name of the frontendEndpoint. Must be a domain
     name.
    :type host_name: str
    :param session_affinity_enabled_state: Whether to allow session affinity
     on this host. Valid options are 'Enabled' or 'Disabled'. Possible values
     include: 'Enabled', 'Disabled'
    :type session_affinity_enabled_state: str or
     ~azure.mgmt.frontdoor.models.SessionAffinityEnabledState
    :param session_affinity_ttl_seconds: UNUSED. This field will be ignored.
     The TTL to use in seconds for session affinity, if applicable.
    :type session_affinity_ttl_seconds: int
    :param web_application_firewall_policy_link: Defines the Web Application
     Firewall policy for each host (if applicable)
    :type web_application_firewall_policy_link:
     ~azure.mgmt.frontdoor.models.FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink
    :param resource_state: Resource status. Possible values include:
     'Creating', 'Enabling', 'Enabled', 'Disabling', 'Disabled', 'Deleting'
    :type resource_state: str or
     ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    :ivar custom_https_provisioning_state: Provisioning status of Custom Https
     of the frontendEndpoint. Possible values include: 'Enabling', 'Enabled',
     'Disabling', 'Disabled', 'Failed'
    :vartype custom_https_provisioning_state: str or
     ~azure.mgmt.frontdoor.models.CustomHttpsProvisioningState
    :ivar custom_https_provisioning_substate: Provisioning substate shows the
     progress of custom HTTPS enabling/disabling process step by step. Possible
     values include: 'SubmittingDomainControlValidationRequest',
     'PendingDomainControlValidationREquestApproval',
     'DomainControlValidationRequestApproved',
     'DomainControlValidationRequestRejected',
     'DomainControlValidationRequestTimedOut', 'IssuingCertificate',
     'DeployingCertificate', 'CertificateDeployed', 'DeletingCertificate',
     'CertificateDeleted'
    :vartype custom_https_provisioning_substate: str or
     ~azure.mgmt.frontdoor.models.CustomHttpsProvisioningSubstate
    :ivar custom_https_configuration: The configuration specifying how to
     enable HTTPS
    :vartype custom_https_configuration:
     ~azure.mgmt.frontdoor.models.CustomHttpsConfiguration
    :param name: Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'custom_https_provisioning_state': {'readonly': True},
        'custom_https_provisioning_substate': {'readonly': True},
        'custom_https_configuration': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'session_affinity_enabled_state': {'key': 'properties.sessionAffinityEnabledState', 'type': 'str'},
        'session_affinity_ttl_seconds': {'key': 'properties.sessionAffinityTtlSeconds', 'type': 'int'},
        'web_application_firewall_policy_link': {'key': 'properties.webApplicationFirewallPolicyLink', 'type': 'FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'custom_https_provisioning_state': {'key': 'properties.customHttpsProvisioningState', 'type': 'str'},
        'custom_https_provisioning_substate': {'key': 'properties.customHttpsProvisioningSubstate', 'type': 'str'},
        'custom_https_configuration': {'key': 'properties.customHttpsConfiguration', 'type': 'CustomHttpsConfiguration'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, host_name: str=None, session_affinity_enabled_state=None, session_affinity_ttl_seconds: int=None, web_application_firewall_policy_link=None, resource_state=None, name: str=None, **kwargs) -> None:
        super(FrontendEndpoint, self).__init__(id=id, **kwargs)
        self.host_name = host_name
        self.session_affinity_enabled_state = session_affinity_enabled_state
        self.session_affinity_ttl_seconds = session_affinity_ttl_seconds
        self.web_application_firewall_policy_link = web_application_firewall_policy_link
        self.resource_state = resource_state
        self.custom_https_provisioning_state = None
        self.custom_https_provisioning_substate = None
        self.custom_https_configuration = None
        self.name = name
        self.type = None


class FrontendEndpointLink(Model):
    """Defines the Resource ID for a Frontend Endpoint.

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(FrontendEndpointLink, self).__init__(**kwargs)
        self.id = id


class FrontendEndpointUpdateParameters(Model):
    """Frontend endpoint used in routing rule.

    :param host_name: The host name of the frontendEndpoint. Must be a domain
     name.
    :type host_name: str
    :param session_affinity_enabled_state: Whether to allow session affinity
     on this host. Valid options are 'Enabled' or 'Disabled'. Possible values
     include: 'Enabled', 'Disabled'
    :type session_affinity_enabled_state: str or
     ~azure.mgmt.frontdoor.models.SessionAffinityEnabledState
    :param session_affinity_ttl_seconds: UNUSED. This field will be ignored.
     The TTL to use in seconds for session affinity, if applicable.
    :type session_affinity_ttl_seconds: int
    :param web_application_firewall_policy_link: Defines the Web Application
     Firewall policy for each host (if applicable)
    :type web_application_firewall_policy_link:
     ~azure.mgmt.frontdoor.models.FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink
    """

    _attribute_map = {
        'host_name': {'key': 'hostName', 'type': 'str'},
        'session_affinity_enabled_state': {'key': 'sessionAffinityEnabledState', 'type': 'str'},
        'session_affinity_ttl_seconds': {'key': 'sessionAffinityTtlSeconds', 'type': 'int'},
        'web_application_firewall_policy_link': {'key': 'webApplicationFirewallPolicyLink', 'type': 'FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink'},
    }

    def __init__(self, *, host_name: str=None, session_affinity_enabled_state=None, session_affinity_ttl_seconds: int=None, web_application_firewall_policy_link=None, **kwargs) -> None:
        super(FrontendEndpointUpdateParameters, self).__init__(**kwargs)
        self.host_name = host_name
        self.session_affinity_enabled_state = session_affinity_enabled_state
        self.session_affinity_ttl_seconds = session_affinity_ttl_seconds
        self.web_application_firewall_policy_link = web_application_firewall_policy_link


class FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink(Model):
    """Defines the Web Application Firewall policy for each host (if applicable).

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink, self).__init__(**kwargs)
        self.id = id


class HealthProbeSettingsListResult(Model):
    """Result of the request to list HealthProbeSettings. It contains a list of
    HealthProbeSettings objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: List of HealthProbeSettings within a Front Door.
    :vartype value:
     list[~azure.mgmt.frontdoor.models.HealthProbeSettingsModel]
    :param next_link: URL to get the next set of HealthProbeSettings objects
     if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[HealthProbeSettingsModel]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, *, next_link: str=None, **kwargs) -> None:
        super(HealthProbeSettingsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class HealthProbeSettingsModel(SubResource):
    """Load balancing settings for a backend pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param path: The path to use for the health probe. Default is /
    :type path: str
    :param protocol: Protocol scheme to use for this probe. Possible values
     include: 'Http', 'Https'
    :type protocol: str or ~azure.mgmt.frontdoor.models.FrontDoorProtocol
    :param interval_in_seconds: The number of seconds between health probes.
    :type interval_in_seconds: int
    :param health_probe_method: Configures which HTTP method to use to probe
     the backends defined under backendPools. Possible values include: 'GET',
     'HEAD'. Default value: "HEAD" .
    :type health_probe_method: str or
     ~azure.mgmt.frontdoor.models.FrontDoorHealthProbeMethod
    :param enabled_state: Whether to enable health probes to be made against
     backends defined under backendPools. Health probes can only be disabled if
     there is a single enabled backend in single enabled backend pool. Possible
     values include: 'Enabled', 'Disabled'
    :type enabled_state: str or
     ~azure.mgmt.frontdoor.models.HealthProbeEnabled
    :param resource_state: Resource status. Possible values include:
     'Creating', 'Enabling', 'Enabled', 'Disabling', 'Disabled', 'Deleting'
    :type resource_state: str or
     ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    :param name: Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'interval_in_seconds': {'key': 'properties.intervalInSeconds', 'type': 'int'},
        'health_probe_method': {'key': 'properties.healthProbeMethod', 'type': 'str'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, path: str=None, protocol=None, interval_in_seconds: int=None, health_probe_method="HEAD", enabled_state=None, resource_state=None, name: str=None, **kwargs) -> None:
        super(HealthProbeSettingsModel, self).__init__(id=id, **kwargs)
        self.path = path
        self.protocol = protocol
        self.interval_in_seconds = interval_in_seconds
        self.health_probe_method = health_probe_method
        self.enabled_state = enabled_state
        self.resource_state = resource_state
        self.name = name
        self.type = None


class HealthProbeSettingsUpdateParameters(Model):
    """L7 health probe settings for a backend pool.

    :param path: The path to use for the health probe. Default is /
    :type path: str
    :param protocol: Protocol scheme to use for this probe. Possible values
     include: 'Http', 'Https'
    :type protocol: str or ~azure.mgmt.frontdoor.models.FrontDoorProtocol
    :param interval_in_seconds: The number of seconds between health probes.
    :type interval_in_seconds: int
    :param health_probe_method: Configures which HTTP method to use to probe
     the backends defined under backendPools. Possible values include: 'GET',
     'HEAD'. Default value: "HEAD" .
    :type health_probe_method: str or
     ~azure.mgmt.frontdoor.models.FrontDoorHealthProbeMethod
    :param enabled_state: Whether to enable health probes to be made against
     backends defined under backendPools. Health probes can only be disabled if
     there is a single enabled backend in single enabled backend pool. Possible
     values include: 'Enabled', 'Disabled'
    :type enabled_state: str or
     ~azure.mgmt.frontdoor.models.HealthProbeEnabled
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'interval_in_seconds': {'key': 'intervalInSeconds', 'type': 'int'},
        'health_probe_method': {'key': 'healthProbeMethod', 'type': 'str'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
    }

    def __init__(self, *, path: str=None, protocol=None, interval_in_seconds: int=None, health_probe_method="HEAD", enabled_state=None, **kwargs) -> None:
        super(HealthProbeSettingsUpdateParameters, self).__init__(**kwargs)
        self.path = path
        self.protocol = protocol
        self.interval_in_seconds = interval_in_seconds
        self.health_probe_method = health_probe_method
        self.enabled_state = enabled_state


class KeyVaultCertificateSourceParametersVault(Model):
    """The Key Vault containing the SSL certificate.

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(KeyVaultCertificateSourceParametersVault, self).__init__(**kwargs)
        self.id = id


class LatencyMetric(Model):
    """Defines the properties of a latency metric used in the latency scorecard.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name of the Latency Metric
    :vartype name: str
    :ivar end_date_time_utc: The end time of the Latency Scorecard in UTC
    :vartype end_date_time_utc: str
    :ivar a_value: The metric value of the A endpoint
    :vartype a_value: float
    :ivar b_value: The metric value of the B endpoint
    :vartype b_value: float
    :ivar delta: The difference in value between endpoint A and B
    :vartype delta: float
    :ivar delta_percent: The percent difference between endpoint A and B
    :vartype delta_percent: float
    :ivar a_clower95_ci: The lower end of the 95% confidence interval for
     endpoint A
    :vartype a_clower95_ci: float
    :ivar a_hupper95_ci: The upper end of the 95% confidence interval for
     endpoint A
    :vartype a_hupper95_ci: float
    :ivar b_clower95_ci: The lower end of the 95% confidence interval for
     endpoint B
    :vartype b_clower95_ci: float
    :ivar b_upper95_ci: The upper end of the 95% confidence interval for
     endpoint B
    :vartype b_upper95_ci: float
    """

    _validation = {
        'name': {'readonly': True},
        'end_date_time_utc': {'readonly': True},
        'a_value': {'readonly': True},
        'b_value': {'readonly': True},
        'delta': {'readonly': True},
        'delta_percent': {'readonly': True},
        'a_clower95_ci': {'readonly': True},
        'a_hupper95_ci': {'readonly': True},
        'b_clower95_ci': {'readonly': True},
        'b_upper95_ci': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'end_date_time_utc': {'key': 'endDateTimeUTC', 'type': 'str'},
        'a_value': {'key': 'aValue', 'type': 'float'},
        'b_value': {'key': 'bValue', 'type': 'float'},
        'delta': {'key': 'delta', 'type': 'float'},
        'delta_percent': {'key': 'deltaPercent', 'type': 'float'},
        'a_clower95_ci': {'key': 'aCLower95CI', 'type': 'float'},
        'a_hupper95_ci': {'key': 'aHUpper95CI', 'type': 'float'},
        'b_clower95_ci': {'key': 'bCLower95CI', 'type': 'float'},
        'b_upper95_ci': {'key': 'bUpper95CI', 'type': 'float'},
    }

    def __init__(self, **kwargs) -> None:
        super(LatencyMetric, self).__init__(**kwargs)
        self.name = None
        self.end_date_time_utc = None
        self.a_value = None
        self.b_value = None
        self.delta = None
        self.delta_percent = None
        self.a_clower95_ci = None
        self.a_hupper95_ci = None
        self.b_clower95_ci = None
        self.b_upper95_ci = None


class LatencyScorecard(Resource):
    """Defines the LatencyScorecard.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar latency_scorecard_id: The unique identifier of the Latency Scorecard
    :vartype latency_scorecard_id: str
    :ivar latency_scorecard_name: The name of the Latency Scorecard
    :vartype latency_scorecard_name: str
    :ivar description: The description of the Latency Scorecard
    :vartype description: str
    :ivar endpoint_a: The A endpoint in the scorecard
    :vartype endpoint_a: str
    :ivar endpoint_b: The B endpoint in the scorecard
    :vartype endpoint_b: str
    :ivar start_date_time_utc: The start time of the Latency Scorecard in UTC
    :vartype start_date_time_utc: datetime
    :ivar end_date_time_utc: The end time of the Latency Scorecard in UTC
    :vartype end_date_time_utc: datetime
    :ivar country: The country associated with the Latency Scorecard. Values
     are country ISO codes as specified here-
     https://www.iso.org/iso-3166-country-codes.html
    :vartype country: str
    :param latency_metrics: The latency metrics of the Latency Scorecard
    :type latency_metrics: list[~azure.mgmt.frontdoor.models.LatencyMetric]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'latency_scorecard_id': {'readonly': True},
        'latency_scorecard_name': {'readonly': True},
        'description': {'readonly': True},
        'endpoint_a': {'readonly': True},
        'endpoint_b': {'readonly': True},
        'start_date_time_utc': {'readonly': True},
        'end_date_time_utc': {'readonly': True},
        'country': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'latency_scorecard_id': {'key': 'properties.id', 'type': 'str'},
        'latency_scorecard_name': {'key': 'properties.name', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'endpoint_a': {'key': 'properties.endpointA', 'type': 'str'},
        'endpoint_b': {'key': 'properties.endpointB', 'type': 'str'},
        'start_date_time_utc': {'key': 'properties.startDateTimeUTC', 'type': 'iso-8601'},
        'end_date_time_utc': {'key': 'properties.endDateTimeUTC', 'type': 'iso-8601'},
        'country': {'key': 'properties.country', 'type': 'str'},
        'latency_metrics': {'key': 'properties.latencyMetrics', 'type': '[LatencyMetric]'},
    }

    def __init__(self, *, location: str=None, tags=None, latency_metrics=None, **kwargs) -> None:
        super(LatencyScorecard, self).__init__(location=location, tags=tags, **kwargs)
        self.latency_scorecard_id = None
        self.latency_scorecard_name = None
        self.description = None
        self.endpoint_a = None
        self.endpoint_b = None
        self.start_date_time_utc = None
        self.end_date_time_utc = None
        self.country = None
        self.latency_metrics = latency_metrics


class LoadBalancingSettingsListResult(Model):
    """Result of the request to list load balancing settings. It contains a list
    of load balancing settings objects and a URL link to get the next set of
    results.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: List of Backend Pools within a Front Door.
    :vartype value:
     list[~azure.mgmt.frontdoor.models.LoadBalancingSettingsModel]
    :param next_link: URL to get the next set of LoadBalancingSettings objects
     if there are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LoadBalancingSettingsModel]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, *, next_link: str=None, **kwargs) -> None:
        super(LoadBalancingSettingsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class LoadBalancingSettingsModel(SubResource):
    """Load balancing settings for a backend pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param sample_size: The number of samples to consider for load balancing
     decisions
    :type sample_size: int
    :param successful_samples_required: The number of samples within the
     sample period that must succeed
    :type successful_samples_required: int
    :param additional_latency_milliseconds: The additional latency in
     milliseconds for probes to fall into the lowest latency bucket
    :type additional_latency_milliseconds: int
    :param resource_state: Resource status. Possible values include:
     'Creating', 'Enabling', 'Enabled', 'Disabling', 'Disabled', 'Deleting'
    :type resource_state: str or
     ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    :param name: Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'sample_size': {'key': 'properties.sampleSize', 'type': 'int'},
        'successful_samples_required': {'key': 'properties.successfulSamplesRequired', 'type': 'int'},
        'additional_latency_milliseconds': {'key': 'properties.additionalLatencyMilliseconds', 'type': 'int'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, sample_size: int=None, successful_samples_required: int=None, additional_latency_milliseconds: int=None, resource_state=None, name: str=None, **kwargs) -> None:
        super(LoadBalancingSettingsModel, self).__init__(id=id, **kwargs)
        self.sample_size = sample_size
        self.successful_samples_required = successful_samples_required
        self.additional_latency_milliseconds = additional_latency_milliseconds
        self.resource_state = resource_state
        self.name = name
        self.type = None


class LoadBalancingSettingsUpdateParameters(Model):
    """Round-Robin load balancing settings for a backend pool.

    :param sample_size: The number of samples to consider for load balancing
     decisions
    :type sample_size: int
    :param successful_samples_required: The number of samples within the
     sample period that must succeed
    :type successful_samples_required: int
    :param additional_latency_milliseconds: The additional latency in
     milliseconds for probes to fall into the lowest latency bucket
    :type additional_latency_milliseconds: int
    """

    _attribute_map = {
        'sample_size': {'key': 'sampleSize', 'type': 'int'},
        'successful_samples_required': {'key': 'successfulSamplesRequired', 'type': 'int'},
        'additional_latency_milliseconds': {'key': 'additionalLatencyMilliseconds', 'type': 'int'},
    }

    def __init__(self, *, sample_size: int=None, successful_samples_required: int=None, additional_latency_milliseconds: int=None, **kwargs) -> None:
        super(LoadBalancingSettingsUpdateParameters, self).__init__(**kwargs)
        self.sample_size = sample_size
        self.successful_samples_required = successful_samples_required
        self.additional_latency_milliseconds = additional_latency_milliseconds


class ManagedRuleDefinition(Model):
    """Describes a managed rule definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar rule_id: Identifier for the managed rule.
    :vartype rule_id: str
    :ivar default_state: Describes the default state for the managed rule.
     Possible values include: 'Disabled', 'Enabled'
    :vartype default_state: str or
     ~azure.mgmt.frontdoor.models.ManagedRuleEnabledState
    :ivar default_action: Describes the default action to be applied when the
     managed rule matches. Possible values include: 'Allow', 'Block', 'Log',
     'Redirect'
    :vartype default_action: str or ~azure.mgmt.frontdoor.models.ActionType
    :ivar description: Describes the functionality of the managed rule.
    :vartype description: str
    """

    _validation = {
        'rule_id': {'readonly': True},
        'default_state': {'readonly': True},
        'default_action': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'rule_id': {'key': 'ruleId', 'type': 'str'},
        'default_state': {'key': 'defaultState', 'type': 'str'},
        'default_action': {'key': 'defaultAction', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ManagedRuleDefinition, self).__init__(**kwargs)
        self.rule_id = None
        self.default_state = None
        self.default_action = None
        self.description = None


class ManagedRuleExclusion(Model):
    """Exclude variables from managed rule evaluation.

    All required parameters must be populated in order to send to Azure.

    :param match_variable: Required. The variable type to be excluded.
     Possible values include: 'RequestHeaderNames', 'RequestCookieNames',
     'QueryStringArgNames', 'RequestBodyPostArgNames'
    :type match_variable: str or
     ~azure.mgmt.frontdoor.models.ManagedRuleExclusionMatchVariable
    :param selector_match_operator: Required. Comparison operator to apply to
     the selector when specifying which elements in the collection this
     exclusion applies to. Possible values include: 'Equals', 'Contains',
     'StartsWith', 'EndsWith', 'EqualsAny'
    :type selector_match_operator: str or
     ~azure.mgmt.frontdoor.models.ManagedRuleExclusionSelectorMatchOperator
    :param selector: Required. Selector value for which elements in the
     collection this exclusion applies to.
    :type selector: str
    """

    _validation = {
        'match_variable': {'required': True},
        'selector_match_operator': {'required': True},
        'selector': {'required': True},
    }

    _attribute_map = {
        'match_variable': {'key': 'matchVariable', 'type': 'str'},
        'selector_match_operator': {'key': 'selectorMatchOperator', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
    }

    def __init__(self, *, match_variable, selector_match_operator, selector: str, **kwargs) -> None:
        super(ManagedRuleExclusion, self).__init__(**kwargs)
        self.match_variable = match_variable
        self.selector_match_operator = selector_match_operator
        self.selector = selector


class ManagedRuleGroupDefinition(Model):
    """Describes a managed rule group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar rule_group_name: Name of the managed rule group.
    :vartype rule_group_name: str
    :ivar description: Description of the managed rule group.
    :vartype description: str
    :ivar rules: List of rules within the managed rule group.
    :vartype rules: list[~azure.mgmt.frontdoor.models.ManagedRuleDefinition]
    """

    _validation = {
        'rule_group_name': {'readonly': True},
        'description': {'readonly': True},
        'rules': {'readonly': True},
    }

    _attribute_map = {
        'rule_group_name': {'key': 'ruleGroupName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[ManagedRuleDefinition]'},
    }

    def __init__(self, **kwargs) -> None:
        super(ManagedRuleGroupDefinition, self).__init__(**kwargs)
        self.rule_group_name = None
        self.description = None
        self.rules = None


class ManagedRuleGroupOverride(Model):
    """Defines a managed rule group override setting.

    All required parameters must be populated in order to send to Azure.

    :param rule_group_name: Required. Describes the managed rule group to
     override.
    :type rule_group_name: str
    :param exclusions: Describes the exclusions that are applied to all rules
     in the group.
    :type exclusions: list[~azure.mgmt.frontdoor.models.ManagedRuleExclusion]
    :param rules: List of rules that will be disabled. If none specified, all
     rules in the group will be disabled.
    :type rules: list[~azure.mgmt.frontdoor.models.ManagedRuleOverride]
    """

    _validation = {
        'rule_group_name': {'required': True},
    }

    _attribute_map = {
        'rule_group_name': {'key': 'ruleGroupName', 'type': 'str'},
        'exclusions': {'key': 'exclusions', 'type': '[ManagedRuleExclusion]'},
        'rules': {'key': 'rules', 'type': '[ManagedRuleOverride]'},
    }

    def __init__(self, *, rule_group_name: str, exclusions=None, rules=None, **kwargs) -> None:
        super(ManagedRuleGroupOverride, self).__init__(**kwargs)
        self.rule_group_name = rule_group_name
        self.exclusions = exclusions
        self.rules = rules


class ManagedRuleOverride(Model):
    """Defines a managed rule group override setting.

    All required parameters must be populated in order to send to Azure.

    :param rule_id: Required. Identifier for the managed rule.
    :type rule_id: str
    :param enabled_state: Describes if the managed rule is in enabled or
     disabled state. Defaults to Disabled if not specified. Possible values
     include: 'Disabled', 'Enabled'
    :type enabled_state: str or
     ~azure.mgmt.frontdoor.models.ManagedRuleEnabledState
    :param action: Describes the override action to be applied when rule
     matches. Possible values include: 'Allow', 'Block', 'Log', 'Redirect'
    :type action: str or ~azure.mgmt.frontdoor.models.ActionType
    :param exclusions: Describes the exclusions that are applied to this
     specific rule.
    :type exclusions: list[~azure.mgmt.frontdoor.models.ManagedRuleExclusion]
    """

    _validation = {
        'rule_id': {'required': True},
    }

    _attribute_map = {
        'rule_id': {'key': 'ruleId', 'type': 'str'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'exclusions': {'key': 'exclusions', 'type': '[ManagedRuleExclusion]'},
    }

    def __init__(self, *, rule_id: str, enabled_state=None, action=None, exclusions=None, **kwargs) -> None:
        super(ManagedRuleOverride, self).__init__(**kwargs)
        self.rule_id = rule_id
        self.enabled_state = enabled_state
        self.action = action
        self.exclusions = exclusions


class ManagedRuleSet(Model):
    """Defines a managed rule set.

    All required parameters must be populated in order to send to Azure.

    :param rule_set_type: Required. Defines the rule set type to use.
    :type rule_set_type: str
    :param rule_set_version: Required. Defines the version of the rule set to
     use.
    :type rule_set_version: str
    :param exclusions: Describes the exclusions that are applied to all rules
     in the set.
    :type exclusions: list[~azure.mgmt.frontdoor.models.ManagedRuleExclusion]
    :param rule_group_overrides: Defines the rule group overrides to apply to
     the rule set.
    :type rule_group_overrides:
     list[~azure.mgmt.frontdoor.models.ManagedRuleGroupOverride]
    """

    _validation = {
        'rule_set_type': {'required': True},
        'rule_set_version': {'required': True},
    }

    _attribute_map = {
        'rule_set_type': {'key': 'ruleSetType', 'type': 'str'},
        'rule_set_version': {'key': 'ruleSetVersion', 'type': 'str'},
        'exclusions': {'key': 'exclusions', 'type': '[ManagedRuleExclusion]'},
        'rule_group_overrides': {'key': 'ruleGroupOverrides', 'type': '[ManagedRuleGroupOverride]'},
    }

    def __init__(self, *, rule_set_type: str, rule_set_version: str, exclusions=None, rule_group_overrides=None, **kwargs) -> None:
        super(ManagedRuleSet, self).__init__(**kwargs)
        self.rule_set_type = rule_set_type
        self.rule_set_version = rule_set_version
        self.exclusions = exclusions
        self.rule_group_overrides = rule_group_overrides


class ManagedRuleSetDefinition(Resource):
    """Describes the a managed rule set definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar provisioning_state: Provisioning state of the managed rule set.
    :vartype provisioning_state: str
    :ivar rule_set_type: Type of the managed rule set.
    :vartype rule_set_type: str
    :ivar rule_set_version: Version of the managed rule set type.
    :vartype rule_set_version: str
    :ivar rule_groups: Rule groups of the managed rule set.
    :vartype rule_groups:
     list[~azure.mgmt.frontdoor.models.ManagedRuleGroupDefinition]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'rule_set_type': {'readonly': True},
        'rule_set_version': {'readonly': True},
        'rule_groups': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'rule_set_type': {'key': 'properties.ruleSetType', 'type': 'str'},
        'rule_set_version': {'key': 'properties.ruleSetVersion', 'type': 'str'},
        'rule_groups': {'key': 'properties.ruleGroups', 'type': '[ManagedRuleGroupDefinition]'},
    }

    def __init__(self, *, location: str=None, tags=None, **kwargs) -> None:
        super(ManagedRuleSetDefinition, self).__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.rule_set_type = None
        self.rule_set_version = None
        self.rule_groups = None


class ManagedRuleSetList(Model):
    """Defines the list of managed rule sets for the policy.

    :param managed_rule_sets: List of rule sets.
    :type managed_rule_sets: list[~azure.mgmt.frontdoor.models.ManagedRuleSet]
    """

    _attribute_map = {
        'managed_rule_sets': {'key': 'managedRuleSets', 'type': '[ManagedRuleSet]'},
    }

    def __init__(self, *, managed_rule_sets=None, **kwargs) -> None:
        super(ManagedRuleSetList, self).__init__(**kwargs)
        self.managed_rule_sets = managed_rule_sets


class MatchCondition(Model):
    """Define a match condition.

    All required parameters must be populated in order to send to Azure.

    :param match_variable: Required. Request variable to compare with.
     Possible values include: 'RemoteAddr', 'RequestMethod', 'QueryString',
     'PostArgs', 'RequestUri', 'RequestHeader', 'RequestBody', 'Cookies',
     'SocketAddr'
    :type match_variable: str or ~azure.mgmt.frontdoor.models.MatchVariable
    :param selector: Match against a specific key from the QueryString,
     PostArgs, RequestHeader or Cookies variables. Default is null.
    :type selector: str
    :param operator: Required. Comparison type to use for matching with the
     variable value. Possible values include: 'Any', 'IPMatch', 'GeoMatch',
     'Equal', 'Contains', 'LessThan', 'GreaterThan', 'LessThanOrEqual',
     'GreaterThanOrEqual', 'BeginsWith', 'EndsWith', 'RegEx'
    :type operator: str or ~azure.mgmt.frontdoor.models.Operator
    :param negate_condition: Describes if the result of this condition should
     be negated.
    :type negate_condition: bool
    :param match_value: Required. List of possible match values.
    :type match_value: list[str]
    :param transforms: List of transforms.
    :type transforms: list[str or ~azure.mgmt.frontdoor.models.TransformType]
    """

    _validation = {
        'match_variable': {'required': True},
        'operator': {'required': True},
        'match_value': {'required': True},
    }

    _attribute_map = {
        'match_variable': {'key': 'matchVariable', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_value': {'key': 'matchValue', 'type': '[str]'},
        'transforms': {'key': 'transforms', 'type': '[str]'},
    }

    def __init__(self, *, match_variable, operator, match_value, selector: str=None, negate_condition: bool=None, transforms=None, **kwargs) -> None:
        super(MatchCondition, self).__init__(**kwargs)
        self.match_variable = match_variable
        self.selector = selector
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_value = match_value
        self.transforms = transforms


class PolicySettings(Model):
    """Defines top-level WebApplicationFirewallPolicy configuration settings.

    :param enabled_state: Describes if the policy is in enabled or disabled
     state. Defaults to Enabled if not specified. Possible values include:
     'Disabled', 'Enabled'
    :type enabled_state: str or
     ~azure.mgmt.frontdoor.models.PolicyEnabledState
    :param mode: Describes if it is in detection mode or prevention mode at
     policy level. Possible values include: 'Prevention', 'Detection'
    :type mode: str or ~azure.mgmt.frontdoor.models.PolicyMode
    :param redirect_url: If action type is redirect, this field represents
     redirect URL for the client.
    :type redirect_url: str
    :param custom_block_response_status_code: If the action type is block,
     customer can override the response status code.
    :type custom_block_response_status_code: int
    :param custom_block_response_body: If the action type is block, customer
     can override the response body. The body must be specified in base64
     encoding.
    :type custom_block_response_body: str
    """

    _validation = {
        'custom_block_response_body': {'pattern': r'^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})$'},
    }

    _attribute_map = {
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'mode': {'key': 'mode', 'type': 'str'},
        'redirect_url': {'key': 'redirectUrl', 'type': 'str'},
        'custom_block_response_status_code': {'key': 'customBlockResponseStatusCode', 'type': 'int'},
        'custom_block_response_body': {'key': 'customBlockResponseBody', 'type': 'str'},
    }

    def __init__(self, *, enabled_state=None, mode=None, redirect_url: str=None, custom_block_response_status_code: int=None, custom_block_response_body: str=None, **kwargs) -> None:
        super(PolicySettings, self).__init__(**kwargs)
        self.enabled_state = enabled_state
        self.mode = mode
        self.redirect_url = redirect_url
        self.custom_block_response_status_code = custom_block_response_status_code
        self.custom_block_response_body = custom_block_response_body


class PreconfiguredEndpoint(Resource):
    """Defines the properties of a preconfigured endpoint.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param description: The description of the endpoint
    :type description: str
    :param endpoint: The endpoint that is preconfigured
    :type endpoint: str
    :param endpoint_type: The type of endpoint. Possible values include:
     'AFD', 'AzureRegion', 'CDN', 'ATM'
    :type endpoint_type: str or ~azure.mgmt.frontdoor.models.EndpointType
    :param backend: The preconfigured endpoint backend
    :type backend: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
        'endpoint_type': {'key': 'properties.endpointType', 'type': 'str'},
        'backend': {'key': 'properties.backend', 'type': 'str'},
    }

    def __init__(self, *, location: str=None, tags=None, description: str=None, endpoint: str=None, endpoint_type=None, backend: str=None, **kwargs) -> None:
        super(PreconfiguredEndpoint, self).__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.endpoint = endpoint
        self.endpoint_type = endpoint_type
        self.backend = backend


class Profile(Resource):
    """Defines an Network Experiment Profile and lists of Experiments.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param resource_state: Resource status. Possible values include:
     'Creating', 'Enabling', 'Enabled', 'Disabling', 'Disabled', 'Deleting'
    :type resource_state: str or
     ~azure.mgmt.frontdoor.models.NetworkExperimentResourceState
    :param enabled_state: The state of the Experiment. Possible values
     include: 'Enabled', 'Disabled'
    :type enabled_state: str or ~azure.mgmt.frontdoor.models.State
    :param etag: Gets a unique read-only string that changes whenever the
     resource is updated.
    :type etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, location: str=None, tags=None, resource_state=None, enabled_state=None, etag: str=None, **kwargs) -> None:
        super(Profile, self).__init__(location=location, tags=tags, **kwargs)
        self.resource_state = resource_state
        self.enabled_state = enabled_state
        self.etag = etag


class ProfileUpdateModel(Model):
    """Defines modifiable attributes of a Profile.

    :param enabled_state: The enabled state of the Profile. Possible values
     include: 'Enabled', 'Disabled'
    :type enabled_state: str or ~azure.mgmt.frontdoor.models.State
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, enabled_state=None, tags=None, **kwargs) -> None:
        super(ProfileUpdateModel, self).__init__(**kwargs)
        self.enabled_state = enabled_state
        self.tags = tags


class PurgeParameters(Model):
    """Parameters required for content purge.

    All required parameters must be populated in order to send to Azure.

    :param content_paths: Required. The path to the content to be purged. Can
     describe a file path or a wild card directory.
    :type content_paths: list[str]
    """

    _validation = {
        'content_paths': {'required': True},
    }

    _attribute_map = {
        'content_paths': {'key': 'contentPaths', 'type': '[str]'},
    }

    def __init__(self, *, content_paths, **kwargs) -> None:
        super(PurgeParameters, self).__init__(**kwargs)
        self.content_paths = content_paths


class RedirectConfiguration(RouteConfiguration):
    """Describes Redirect Route.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param redirect_type: The redirect type the rule will use when redirecting
     traffic. Possible values include: 'Moved', 'Found', 'TemporaryRedirect',
     'PermanentRedirect'
    :type redirect_type: str or
     ~azure.mgmt.frontdoor.models.FrontDoorRedirectType
    :param redirect_protocol: The protocol of the destination to where the
     traffic is redirected. Possible values include: 'HttpOnly', 'HttpsOnly',
     'MatchRequest'
    :type redirect_protocol: str or
     ~azure.mgmt.frontdoor.models.FrontDoorRedirectProtocol
    :param custom_host: Host to redirect. Leave empty to use the incoming host
     as the destination host.
    :type custom_host: str
    :param custom_path: The full path to redirect. Path cannot be empty and
     must start with /. Leave empty to use the incoming path as destination
     path.
    :type custom_path: str
    :param custom_fragment: Fragment to add to the redirect URL. Fragment is
     the part of the URL that comes after #. Do not include the #.
    :type custom_fragment: str
    :param custom_query_string: The set of query strings to be placed in the
     redirect URL. Setting this value would replace any existing query string;
     leave empty to preserve the incoming query string. Query string must be in
     <key>=<value> format. The first ? and & will be added automatically so do
     not include them in the front, but do separate multiple query strings with
     &.
    :type custom_query_string: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'redirect_type': {'key': 'redirectType', 'type': 'str'},
        'redirect_protocol': {'key': 'redirectProtocol', 'type': 'str'},
        'custom_host': {'key': 'customHost', 'type': 'str'},
        'custom_path': {'key': 'customPath', 'type': 'str'},
        'custom_fragment': {'key': 'customFragment', 'type': 'str'},
        'custom_query_string': {'key': 'customQueryString', 'type': 'str'},
    }

    def __init__(self, *, redirect_type=None, redirect_protocol=None, custom_host: str=None, custom_path: str=None, custom_fragment: str=None, custom_query_string: str=None, **kwargs) -> None:
        super(RedirectConfiguration, self).__init__(**kwargs)
        self.redirect_type = redirect_type
        self.redirect_protocol = redirect_protocol
        self.custom_host = custom_host
        self.custom_path = custom_path
        self.custom_fragment = custom_fragment
        self.custom_query_string = custom_query_string
        self.odatatype = '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration'


class RoutingRule(SubResource):
    """A routing rule represents a specification for traffic to treat and where to
    send it, along with health probe information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param frontend_endpoints: Frontend endpoints associated with this rule
    :type frontend_endpoints: list[~azure.mgmt.frontdoor.models.SubResource]
    :param accepted_protocols: Protocol schemes to match for this rule
    :type accepted_protocols: list[str or
     ~azure.mgmt.frontdoor.models.FrontDoorProtocol]
    :param patterns_to_match: The route patterns of the rule.
    :type patterns_to_match: list[str]
    :param enabled_state: Whether to enable use of this rule. Permitted values
     are 'Enabled' or 'Disabled'. Possible values include: 'Enabled',
     'Disabled'
    :type enabled_state: str or
     ~azure.mgmt.frontdoor.models.RoutingRuleEnabledState
    :param route_configuration: A reference to the routing configuration.
    :type route_configuration: ~azure.mgmt.frontdoor.models.RouteConfiguration
    :param resource_state: Resource status. Possible values include:
     'Creating', 'Enabling', 'Enabled', 'Disabling', 'Disabled', 'Deleting'
    :type resource_state: str or
     ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    :param name: Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'frontend_endpoints': {'key': 'properties.frontendEndpoints', 'type': '[SubResource]'},
        'accepted_protocols': {'key': 'properties.acceptedProtocols', 'type': '[str]'},
        'patterns_to_match': {'key': 'properties.patternsToMatch', 'type': '[str]'},
        'enabled_state': {'key': 'properties.enabledState', 'type': 'str'},
        'route_configuration': {'key': 'properties.routeConfiguration', 'type': 'RouteConfiguration'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, frontend_endpoints=None, accepted_protocols=None, patterns_to_match=None, enabled_state=None, route_configuration=None, resource_state=None, name: str=None, **kwargs) -> None:
        super(RoutingRule, self).__init__(id=id, **kwargs)
        self.frontend_endpoints = frontend_endpoints
        self.accepted_protocols = accepted_protocols
        self.patterns_to_match = patterns_to_match
        self.enabled_state = enabled_state
        self.route_configuration = route_configuration
        self.resource_state = resource_state
        self.name = name
        self.type = None


class RoutingRuleListResult(Model):
    """Result of the request to list Routing Rules. It contains a list of Routing
    Rule objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: List of Routing Rules within a Front Door.
    :vartype value: list[~azure.mgmt.frontdoor.models.RoutingRule]
    :param next_link: URL to get the next set of RoutingRule objects if there
     are any.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RoutingRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, *, next_link: str=None, **kwargs) -> None:
        super(RoutingRuleListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class RoutingRuleUpdateParameters(Model):
    """Routing rules to apply to an endpoint.

    :param frontend_endpoints: Frontend endpoints associated with this rule
    :type frontend_endpoints: list[~azure.mgmt.frontdoor.models.SubResource]
    :param accepted_protocols: Protocol schemes to match for this rule
    :type accepted_protocols: list[str or
     ~azure.mgmt.frontdoor.models.FrontDoorProtocol]
    :param patterns_to_match: The route patterns of the rule.
    :type patterns_to_match: list[str]
    :param enabled_state: Whether to enable use of this rule. Permitted values
     are 'Enabled' or 'Disabled'. Possible values include: 'Enabled',
     'Disabled'
    :type enabled_state: str or
     ~azure.mgmt.frontdoor.models.RoutingRuleEnabledState
    :param route_configuration: A reference to the routing configuration.
    :type route_configuration: ~azure.mgmt.frontdoor.models.RouteConfiguration
    """

    _attribute_map = {
        'frontend_endpoints': {'key': 'frontendEndpoints', 'type': '[SubResource]'},
        'accepted_protocols': {'key': 'acceptedProtocols', 'type': '[str]'},
        'patterns_to_match': {'key': 'patternsToMatch', 'type': '[str]'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
        'route_configuration': {'key': 'routeConfiguration', 'type': 'RouteConfiguration'},
    }

    def __init__(self, *, frontend_endpoints=None, accepted_protocols=None, patterns_to_match=None, enabled_state=None, route_configuration=None, **kwargs) -> None:
        super(RoutingRuleUpdateParameters, self).__init__(**kwargs)
        self.frontend_endpoints = frontend_endpoints
        self.accepted_protocols = accepted_protocols
        self.patterns_to_match = patterns_to_match
        self.enabled_state = enabled_state
        self.route_configuration = route_configuration


class TagsObject(Model):
    """Tags object for patch operations.

    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, tags=None, **kwargs) -> None:
        super(TagsObject, self).__init__(**kwargs)
        self.tags = tags


class Timeseries(Resource):
    """Defines the Timeseries.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param endpoint: The endpoint associated with the Timeseries data point
    :type endpoint: str
    :param start_date_time_utc: The start DateTime of the Timeseries in UTC
    :type start_date_time_utc: str
    :param end_date_time_utc: The end DateTime of the Timeseries in UTC
    :type end_date_time_utc: str
    :param aggregation_interval: The aggregation interval of the Timeseries.
     Possible values include: 'Hourly', 'Daily'
    :type aggregation_interval: str or
     ~azure.mgmt.frontdoor.models.AggregationInterval
    :param timeseries_type: The type of Timeseries. Possible values include:
     'MeasurementCounts', 'LatencyP50', 'LatencyP75', 'LatencyP95'
    :type timeseries_type: str or ~azure.mgmt.frontdoor.models.TimeseriesType
    :param country: The country associated with the Timeseries. Values are
     country ISO codes as specified here-
     https://www.iso.org/iso-3166-country-codes.html
    :type country: str
    :param timeseries_data: The set of data points for the timeseries
    :type timeseries_data:
     list[~azure.mgmt.frontdoor.models.TimeseriesDataPoint]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
        'start_date_time_utc': {'key': 'properties.startDateTimeUTC', 'type': 'str'},
        'end_date_time_utc': {'key': 'properties.endDateTimeUTC', 'type': 'str'},
        'aggregation_interval': {'key': 'properties.aggregationInterval', 'type': 'str'},
        'timeseries_type': {'key': 'properties.timeseriesType', 'type': 'str'},
        'country': {'key': 'properties.country', 'type': 'str'},
        'timeseries_data': {'key': 'properties.timeseriesData', 'type': '[TimeseriesDataPoint]'},
    }

    def __init__(self, *, location: str=None, tags=None, endpoint: str=None, start_date_time_utc: str=None, end_date_time_utc: str=None, aggregation_interval=None, timeseries_type=None, country: str=None, timeseries_data=None, **kwargs) -> None:
        super(Timeseries, self).__init__(location=location, tags=tags, **kwargs)
        self.endpoint = endpoint
        self.start_date_time_utc = start_date_time_utc
        self.end_date_time_utc = end_date_time_utc
        self.aggregation_interval = aggregation_interval
        self.timeseries_type = timeseries_type
        self.country = country
        self.timeseries_data = timeseries_data


class TimeseriesDataPoint(Model):
    """Defines a timeseries datapoint used in a timeseries.

    :param date_time_utc: The DateTime of the Timeseries data point in UTC
    :type date_time_utc: str
    :param value: The Value of the Timeseries data point
    :type value: float
    """

    _attribute_map = {
        'date_time_utc': {'key': 'dateTimeUTC', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(self, *, date_time_utc: str=None, value: float=None, **kwargs) -> None:
        super(TimeseriesDataPoint, self).__init__(**kwargs)
        self.date_time_utc = date_time_utc
        self.value = value


class ValidateCustomDomainInput(Model):
    """Input of the custom domain to be validated for DNS mapping.

    All required parameters must be populated in order to send to Azure.

    :param host_name: Required. The host name of the custom domain. Must be a
     domain name.
    :type host_name: str
    """

    _validation = {
        'host_name': {'required': True},
    }

    _attribute_map = {
        'host_name': {'key': 'hostName', 'type': 'str'},
    }

    def __init__(self, *, host_name: str, **kwargs) -> None:
        super(ValidateCustomDomainInput, self).__init__(**kwargs)
        self.host_name = host_name


class ValidateCustomDomainOutput(Model):
    """Output of custom domain validation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar custom_domain_validated: Indicates whether the custom domain is
     valid or not.
    :vartype custom_domain_validated: bool
    :ivar reason: The reason why the custom domain is not valid.
    :vartype reason: str
    :ivar message: Error message describing why the custom domain is not
     valid.
    :vartype message: str
    """

    _validation = {
        'custom_domain_validated': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'custom_domain_validated': {'key': 'customDomainValidated', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ValidateCustomDomainOutput, self).__init__(**kwargs)
        self.custom_domain_validated = None
        self.reason = None
        self.message = None


class WebApplicationFirewallPolicy(Resource):
    """Defines web application firewall policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param policy_settings: Describes settings for the policy.
    :type policy_settings: ~azure.mgmt.frontdoor.models.PolicySettings
    :param custom_rules: Describes custom rules inside the policy.
    :type custom_rules: ~azure.mgmt.frontdoor.models.CustomRuleList
    :param managed_rules: Describes managed rules inside the policy.
    :type managed_rules: ~azure.mgmt.frontdoor.models.ManagedRuleSetList
    :ivar frontend_endpoint_links: Describes Frontend Endpoints associated
     with this Web Application Firewall policy.
    :vartype frontend_endpoint_links:
     list[~azure.mgmt.frontdoor.models.FrontendEndpointLink]
    :ivar provisioning_state: Provisioning state of the policy.
    :vartype provisioning_state: str
    :ivar resource_state: Resource status of the policy. Possible values
     include: 'Creating', 'Enabling', 'Enabled', 'Disabling', 'Disabled',
     'Deleting'
    :vartype resource_state: str or
     ~azure.mgmt.frontdoor.models.PolicyResourceState
    :param etag: Gets a unique read-only string that changes whenever the
     resource is updated.
    :type etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'frontend_endpoint_links': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'resource_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'policy_settings': {'key': 'properties.policySettings', 'type': 'PolicySettings'},
        'custom_rules': {'key': 'properties.customRules', 'type': 'CustomRuleList'},
        'managed_rules': {'key': 'properties.managedRules', 'type': 'ManagedRuleSetList'},
        'frontend_endpoint_links': {'key': 'properties.frontendEndpointLinks', 'type': '[FrontendEndpointLink]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, *, location: str=None, tags=None, policy_settings=None, custom_rules=None, managed_rules=None, etag: str=None, **kwargs) -> None:
        super(WebApplicationFirewallPolicy, self).__init__(location=location, tags=tags, **kwargs)
        self.policy_settings = policy_settings
        self.custom_rules = custom_rules
        self.managed_rules = managed_rules
        self.frontend_endpoint_links = None
        self.provisioning_state = None
        self.resource_state = None
        self.etag = etag
