/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi;

import alt.jiapi.JiapiException;
import alt.jiapi.Runtime;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Category;

public class Rule
implements Comparable {
    private static Category log = Runtime.getLogCategory(Rule.class);
    private Pattern pattern;
    private double precedence;
    private String ruleString;
    private int[] SUMS = new int[]{0, 1, 3, 6, 10, 15, 21, 28, 36, 45, 55};

    public Rule(String rule) throws JiapiException {
        this.ruleString = rule;
        StringBuffer _rule = new StringBuffer(rule);
        _rule = this.replaceText(_rule, ".", "\\.");
        _rule = this.replaceText(_rule, "*", ".*");
        _rule.insert(0, "^");
        _rule.append("$");
        this.precedence = this.countPrecedence(this.ruleString);
        try {
            this.pattern = Pattern.compile(_rule.toString());
        }
        catch (PatternSyntaxException se) {
            throw new JiapiException("invalid rule syntax: " + this.ruleString, se);
        }
    }

    public boolean match(String s) {
        boolean b = this.pattern.matcher(s).matches();
        log.debug((Object)("matching " + s + " to " + this.pattern.pattern() + ": " + b));
        return b;
    }

    public double getPrecedence() {
        return this.precedence;
    }

    public boolean isMoreSignificant(Rule other) {
        log.error((Object)("isMoreSignificant : this(" + this.ruleString + ") " + this.precedence + ", other(" + other.getRuleString() + " " + other.getPrecedence()));
        return this.compareTo(other) > 0;
    }

    public int compareTo(Object o) {
        Rule other = (Rule)o;
        if (this.precedence > other.getPrecedence()) {
            return 1;
        }
        if (this.precedence < other.getPrecedence()) {
            return -1;
        }
        if (this.equals(other)) {
            return 0;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (o instanceof Rule) {
            return this.ruleString.equals(((Rule)o).getRuleString());
        }
        return false;
    }

    public int hashCode() {
        return this.ruleString.hashCode();
    }

    public String toString() {
        return this.ruleString;
    }

    String getRuleString() {
        return this.ruleString;
    }

    private StringBuffer replaceText(StringBuffer sb, String old, String replace) {
        int a = sb.length();
        String s = sb.toString();
        int len = old.length();
        while (a >= 0) {
            if ((a = s.lastIndexOf(old, a)) < 0) continue;
            sb.replace(a, a + len, replace);
            a -= len;
        }
        return sb;
    }

    private double countPrecedence(String r) {
        double s = 0.0;
        ArrayList<String> parts = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(r, ".");
        while (st.hasMoreTokens()) {
            parts.add(st.nextToken());
        }
        int divider = this.countSum(parts.size());
        int j = parts.size();
        for (String part : parts) {
            if (part.indexOf(42) == -1) {
                s += (double)j / (double)divider;
            }
            --j;
        }
        return s;
    }

    private int countSum(int n) {
        if (n < 0) {
            throw new RuntimeException("invalid argument:" + n);
        }
        if (n <= 10) {
            return this.SUMS[n];
        }
        int total = 0;
        for (int i = 1; i < n; ++i) {
            total += i;
        }
        return total;
    }
}

