/* --------------------------------- term.c --------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* shutdown code.
*/

#include "fly.h"


#define LFRAC_RES	1000L

LOCAL_FUNC char * NEAR
lfrac (long a, long b, long ldiv)
{
	int		s, f;
	long		l;
	static char	buf[20];

	if (a < 0x7fffffffL/ldiv)
		l = a * ldiv / b;
	else if (b >= ldiv)
		l = a / (b / ldiv);
	else
		return ("999.999");			/* see LFRAC_RES */
	if (l) {
		if (T(s = l < 0)) {
			f = (int)((-l)%LFRAC_RES);
			l = -((-l)/LFRAC_RES);
		} else {
			f = (int)(l%LFRAC_RES);
			l = l/LFRAC_RES;
		}
		if (s && !l)
			sprintf (buf, "  -0.%03d", f);	/* see LFRAC_RES */
		else
			sprintf (buf, "%4ld.%03d", l, f); /* see LFRAC_RES */
		return (buf);
	} else
		return ("0");
}
#undef LFRAC_RES

extern void FAR
terminate (int StackUsed)
{
	Ulong		lt;
	struct netname	*nn;
	static int	depth = 0;

	if (++depth > 4)	/* must be looping, can't tell the world :-( */
		return;

	log_flush (1);

	st.flags &= ~SF_INITED;

	if (Tm) {
		lt = st.present / 1000L;
		LogPrintf ("Time     %lu:%02lu\n", lt/60L, lt%60L);
	}

	if (STATS_FRAMESCOUNT) {
		LogPrintf ("nFrames  %s\n", show_l (STATS_FRAMESCOUNT));
		if (T(lt = STATS_TIMETOTAL / 1000L))
			LogPrintf ("frm/sec %s\n",
				lfrac (STATS_FRAMESCOUNT, lt, 10000L));
		LogPrintf ("           ms/frm\n");
		LogPrintf ("Total    %s\n",
			lfrac (STATS_TIMETOTAL, STATS_FRAMESCOUNT, 100L));
		LogPrintf ("Video    %s\n",
			lfrac (STATS_TIMEVIDEO, STATS_FRAMESCOUNT, 100L));
		LogPrintf ("3D       %s\n",
			lfrac (STATS_TTIME3D, STATS_FRAMESCOUNT, 100L));
		LogPrintf ("2D       %s\n",
			lfrac (STATS_TTIMEHDD, STATS_FRAMESCOUNT, 100L));
		LogPrintf ("Simulate %s\n",
			lfrac (STATS_TTIMESIM, STATS_FRAMESCOUNT, 100L));
		LogPrintf ("PageFlip %s\n",
			lfrac (STATS_TTIMESYNC, STATS_FRAMESCOUNT, 100L));
		LogPrintf ("Balance  %s\n",
			lfrac (STATS_TIMETOTAL - STATS_TIMEVIDEO -
					STATS_TTIME3D -STATS_TTIMESIM -
					STATS_TTIMESYNC - STATS_TTIMEHDD,
				STATS_FRAMESCOUNT, 100L));
	}

	stats_show ();

	nav_term ();

	remote_term ();

	if (CC)
		LogPrintf ("score    %u\n", (int)CC->score);
	CV = CC = 0;

	list_clear (&CO);

	land_term ();

	LogPrintf ("bullets  %s\n", show_l (st.nbullets));
	LogPrintf ("last obj %s\n", show_l (st.object_id));

	bodies_term ();

	buffers_term ();

	pointers_term ();

	funcs_term ();

	if (Snd) {
		Snd->Term ();
		sound_term ();
		Snd = &SndNone;
	}

	mac_term ();

	if (Kbd) {
		Kbd->Term ();
		kbrd_term ();
		Kbd = &KbdNone;
	}

	DEL0 (CW);
	DEL0 (CP);
	if (CS) {
		if (CS->device) {
			if (Gr) {
				if (Gr->Shutters)
					Gr->Shutters (-2);	/* turn off */
				Gr->Term (CS->device);
			}
			CS->device = 0;
		}
		DEL0 (CS);
	}

	windows_term ();

	devices_release ();
	devices_term ();

	st.iname = STRfree (st.iname);
	st.mname = STRfree (st.mname);
	st.fname = STRfree (st.fname);
	st.vmdname = STRfree (st.vmdname);
	st.navname = STRfree (st.navname);
	st.lndname = STRfree (st.lndname);
	st.fdir = STRfree (st.fdir);
	st.ptrname = STRfree (st.ptrname);
	st.grname = STRfree (st.grname);
	st.grmname = STRfree (st.grmname);
	st.sndname = STRfree (st.sndname);
	st.kbdname = STRfree (st.kbdname);
	st.nikname = STRfree (st.nikname);
	st.teamname = STRfree (st.teamname);
	st.homename = STRfree (st.homename);
	st.timeropts = STRfree (st.timeropts);
	st.ptype = STRfree (st.ptype);
	st.dtype = STRfree (st.dtype);
	st.initkeys = STRfree (st.initkeys);

	for (nn = st.netnames; nn;) {
		STRfree (nn->name);
		nn = DEL (nn);
	}

	if (st.flags & SF_SKY)
		sky_term ();

	edit_term ();

	msg_term ();

/* We terminate the memory mgr before the log mgr to allow logging of stats.
*/
	mem_term ();

	LogPrintf ("stack used: %d bytes\n", StackUsed);
	LogPrintf ("Fly8 end: %s\n", Tm->Ctime ());

	log_term ();
	st.lname = xfree (st.lname);

	if (Tm) {
		Tm->Term ();
		Tm = &TmNone;
	}

	if (Sys) {
		Sys->Term ();
		Sys = &SysNone;
	}
	--depth;
}

extern void FAR
die (void)
{
	st.flags &= ~(SF_INITED|SF_INTERACTIVE);
	LogPrintf ("Aborting...\n");
	terminate (0);
	exit (1);
}
