/* MiscSpaceMouseDriver.h				 
 *
 * The MetaDriver is a driver wrapper. It will transparently switch between
 * drivers taking care that there will be no conflicts. It is not a real driver
 * and so all standard events will be passed to the realDriver. (Confuising ?!)
 *
 * Usage: You should not have to worry about this class. It will be transparent
 *		  to the apps and drivers.
 *
 * Notes: This class was designed to allow the 3DDeviceServer to switch
 *		  between devices while they are in use.
 *		  This is the reason why you have to use the realDirver method when
 *		  you want to contact the device directly.
 *		  I do not really recommend this but in very rare case it might make
 *		  sense to have direct access to a driver.
 *
 *		  Our Metadriver tries to track all the driver settings to ensure that
 *		  they can be passen to a new driver even when there was no active
 *		  driver at the time those setting where done.
 *
 * Written by: 		Thomas Engel
 * Created:    		10.04.1994 (Copyleft)
 * Last modified: 	10.04.1994
 */

#import "Misc3DDeviceDriver.h"

@interface Misc3DMetaDriver:Misc3DDeviceDriver
{
	id	realDriver;
}

// All the methods are overridden. They simply pass the methods to the
// realDriver and return what the real driver would;

- setTarget:anObject;
- target;

// Oneway may not be used in interfaces. But to remind you that I do override
// those methods here I will include them like this...
//
// - (oneway void)enableEvents;
// - (oneway void)disableEvents;
// - (oneway void)syncEvents;

- setUseExternalSync:(BOOL)aFlag;
- (BOOL)doesUseExternalSync;
- (BOOL)areEventsEnabled;

// By default the realDriver is nil. So no big problem.
// Driver will be only accepted if the conform to the 
// Misc3DDeviceDriverProtocol.

- setRealDriver:aDriver;
- realDriver;

@end

/*
 * History: 10.04.94 Invented to allow device switching while device is in
 *					 use. 
 *
 *
 * Bugs: - Hmm. well not a bug but using the Obj-C forward: facility would be
 *		   nice to help forget use about the realDriver method.
 *		   I might implement this someday.
 */