/* Misc3DMouseDriver.h				 
 *
 * The MouseDriver is the a basic 3DMouse dirver class. It provide some simple
 * methods to handle the event composition and sending. 
 *
 * Usage: Create a subclass and use the deliver... methods. But be careful!
 *		  We assume that all the values we get in our deliver method are from
 *		  a rightHanded device. Please ensure that they match this orientation! 
 *		  AND angles are in degree (0-360).
 *
 * Notes: setTarget takes care that only object that conform to the 
 *		  Misc3DMouseTarget protocol will really become a target.
 *
 *		  In the none existing case that a target might decide to switch its
 *		  world handedness from left to right handed (or visa-versa) it HAS TO
 *		  set the mouses target again. There is no other way to set the
 *		  handedness. Sorry.
 *
 * Attention: When you use the deliverTransl..Rot.. method be sure that when
 *			  using more than one angle value it does comform to the way or
 *			  MiscRtMatrix does init them!!!!
 *			  For more details please read the MiscRtMatrix header.
 *
 * Written by: 		Thomas Engel
 * Created:    		11.04.1994 (Copyleft)
 * Last modified: 	11.04.1994
 */

#import "Misc3DDeviceDriver.h"
#import <misckit/MiscRtMatrix.h>

// Targets of a 3DMouse have to implement the following protocol.
// This will allow the driver to adjust the events to fit the programms
// needs.
// The transformationWill-Did stuff will not be handled automatically by the
// basic Mousedriver. It is not easy do fnd the right point when to send those
// messages. Ever mouse river has to do that on his own!
// Those messages are ment to allow the target to switch to a faster display
// style for the manipulations. It is not wise to wrap every single event that
// way. You should wrap 'transformation sessions'.

@protocol Misc3DMouseTarget

- (BOOL)worldIsRightHanded;

- (oneway void)transformationEvent:(bycopy id)aMatrix;
- (oneway void)transformationWillStart:sender;
- (oneway void)transformationDidEnd:sender;

- (oneway void)keyEvent:(char *)theKeys;

@end


@interface Misc3DMouseDriver:Misc3DDeviceDriver
{
	BOOL	targetIsRightHanded;
	id		transformMatrix;
}

- setTarget:anObject;

- (BOOL)deliverTranslation:(float)x :(float)y :(float)z
	  	 	   andRotation:(float)a :(float)b :(float)c;
- (BOOL)deliverKeyPress:(char *)keys;

@end

/*
 * History: 11.04.94 Should simplify the other mouse drivers. 
 *
 *
 * Bugs: - Yes. deliverKeys does nothing right now. It should check the sting
 *		   and ensure that the ASCII codes are sorted lowest first.
 */