/* MiscSpaceMouseDriver.h				 
 *
 * This is a 3DMouse adaptor that will handle the SpaceMouse (produced by
 * SpaceControl & DLR Germany).
 *
 * Usage: The general usage is as with every Misc3DMouseDriver.
 *		  It should be quite easy to control the rest if you have the
 *		  real SpaceMouse manual.
 *		  Otherwise you should not deal with this object directly but use the 
 *		  GUI instead.
 *
 * Notes: Even though this class provides all the possible settings a
 *		  SpaceControls SpaceMouse allows it is not the frontend to all
 *		  the settings!
 *		  Every set command interrogates the resulting settings to ensure
 *		  consitency.
 *
 *		  I don't support the 2D mouse mode because it does not seam to make
 *		  sense anyway.
 *
 * Written by: 		Thomas Engel
 * Created:    		23.03.1994 (Copyleft)
 * Last modified: 	18.04.1994
 */

#import "Misc3DMouseDriver.h"

@interface MiscSpaceMouseDriver:Misc3DMouseDriver
{
	id		frontend;
	id		port;

	char	smSendBuffer[10];
	char	smEventBuffer[200];
	int		errorFlag;

	BOOL	translationOn;
	BOOL	rotationOn;
	BOOL	dominantModeOn;
	int		rotationQuality;
	int		translationQuality;
	int		nullRadius;
	int		minDataRate;
	int		maxDataRate;

	float	rotScale;
	float	transScale;
	id		version;

	BOOL			isActive;
	BOOL			newActions;
	DPSTimedEntry	tentry;		
}

// Some methods to handle the device. Basic IO stuff.
// setTarget will add the timed entry check when becomeing active/idle

- setTarget:anObject;
- setFrontend:anObject;

- checkActivity;
- (BOOL)connectToDevice:(const char *)device;
- disconnectFromDevice;
- (BOOL)isConnectedToDevice;

- receiveChars:(char *)buffer length:(int)length;

// The following are SpaceMouse specific methods. They are used to parse the
// data and to set the mouse states.

- setMouseInDominantMode:(BOOL)domFlag 
		  withTranslationEnabled:(BOOL)transFlag
	      andRotationEnabled:(BOOL)rotFlag;
- (BOOL)hasTranslationEnabled;
- (BOOL)hasRotationEnabled;
- (BOOL)isInDominantMode;

- setQualityForTranslation:(int)transInt andRotation:(int)rotInt;
- (int)translationQuality;
- (int)rotationQuality;
- setNullRadius:(int)anInt;
- (int)nullRadius;
- setDataRateMin:(int)minRate max:(int)maxRate;
- (int)minDataRate;
- (int)maxDataRate;

- setRotScale:(float)aFloat;
- (float)rotScale;
- setTransScale:(float)aFloat;
- (float)transScale;

- queryDeviceVersion;
- beepWithDuration:(int)anInt;
- zeroMouseData;

- setErrorFlag:(int)flag;

- parseCommand:(const char *)buffer;
- parseModeEvent:(const char *)buffer;
- parseVersionEvent:(const char *)buffer;
- parseErrorEvent:(const char *)buffer;
- parseDataRateEvent:(const char *)buffer;
- parseQualityEvent:(const char *)buffer;
- parseNullRadiusEvent:(const char *)buffer;
- parseKeyEvent:(const char *)buffer;
- parseTransformationEvent:(const char *)buffer;

@end

/*
 * History: 18.04.94 Added the timed entry to find start and end of actions.
 *
 *			15.04.94 Included support for two seperate scales.
 *
 *			11.04.94 Changes to support the Misc3DMouseDriver.
 *
 *			08.04.94 The code is somewhat 
 *
 *			02.04.94 Started to add some methods.
 *
 *			23.03.94 First code written.
 *
 *
 * Bugs: - Does not read the mouse version. It will need a MiscString someday.
 */