/* DensView.h  Copyright 1992 Steve Ludtke */
/* This object does a density plot of a 3d data set */

/* Connect "delegate" to an object that can recieve "zoomTo:xmin :ymin :xmax */
/* :ymax   messages (or leave it disconnected). Send setData::::: messages   */
/* to pass data and render image. Send display messages to redisplay rendered*/
/* image. */

#import <appkit/View.h>

#define DM_DENSITY	1
#define DM_CONTOUR	2
#define DM_MESH		4
#define DM_DMESH	8
#define DM_LABEL	16

typedef struct { char *data; int n,al; } String;

@interface DensView:View
{
id delegate;	/* who to send -zoomTo messages to */
id image;	/* image used to store the density plot */
id tiffRes;		/* resolution for tiff saves */
NXPoint point;	/* origin of image in view */
NXSize size;	/* size of image */
NXRect ticks;	/* Tick origin/spacing */
float *data;	/* points to array of Z values to plot */
RtColor *color;
String buf;		/* postscript command buffer */
int nx,ny;	/* number of data points = nx*ny */
float Zlim[4]; /* used to determine max and min brightness */
NXRect rec,rec2;	/* rec=limits of data, rec2=limits of "real" data */
char mode,dmode;
float lev0,lev1;	/* contour start and spacing */
}

/* initialization */
-initFrame:(NXRect *)myrect;
/* composites the image to the screen */
-drawSelf:(NXRect *)rects :(int)rectCount;
/* resize the view */
-superviewSizeChanged:(const NXSize *)oldsize;
/* allows user to select zoom area */
-mouseDown:(NXEvent *)oevent;
-(int)acceptsFirstMouse;

/* This routine passes the actual data to be plotted to the DensView */
/* It also does all of the actual drawing (into an Image) */
-setData:(int)Nx :(int)Ny :(float *)Data :(float *)Zlim :(NXRect)Ticks :(NXRect)rec :(NXRect)rec2 :(float)Lev0 :(float)Lev1 :(RtColor *)color;

-setDenFlag:sender;

-saveTiff:sender;
-savePS:sender;
-printPSCode:sender;
@end

