
/* Generated by Interface Builder */

#import "WindowManager.h"
#import <appkit/Application.h>
#import <appkit/ScrollView.h>
#import <appkit/Text.h>
#import <appkit/TextField.h>
#import <appkit/OpenPanel.h>
#import <libc.h>
#import <strings.h>

@implementation WindowManager

- (char *) extension ;
{ // subclasses should override to provide file extension
  // for saving window
  return "" ;
}

- fileName: (char *) fname ;
{ // copy fname into ivar, set the
  // window's title to fname, with the
  // filename followed by the path
  char fullName[128], *name ;
  strncpy(fileName, fname, 127) ;
  strncpy(fullName, fileName, 127) ;
  name = rindex(fullName,'/') ;
  if(name != NULL) // is there is a path,
  { char title[129] ;
    name[0] = '\0' ; // split string into 2 pieces
    name++ ;
    sprintf(title,"%s  %s",name,fullName) ;
    [self setTitle: title] ;
  }
  else // no path, just use the filename
    [self setTitle: fname] ;
  return self ;
}

- message: (char *) aMsg ;
{ // show aMsg in the msgField
  [msgField setStringValue: aMsg] ;
  [self flushWindow] ;
  return self ;
}

-revert:sender ;
{ return [self readFile] ;
}

- readFile ;
// read "fileName" into the text object 
{ NXStream *fileStream ;
  if(fileName[0] == '\0')
    return self ; // no file to read!
  [self message: "Reading file..."] ;
  if((fileStream = NXMapFile(fileName,NX_READONLY)) != NULL)
  { [textView readText: fileStream] ;
    NXCloseMemory(fileStream,NX_FREEBUFFER);
    [self setDocEdited: NO] ;
  }
  else
    NXRunAlertPanel("CB", "Error, couldn't read: %s",
        NULL,NULL,NULL,fileName) ;
  [self message: ""] ;
  return self ;
}

-(BOOL) save:sender ;
{ if([self isDocEdited])
  { if(fileName[0] == '\0') 
      return [self saveAs: sender] ;
    else
      return [self saveTextToFileName] ;
  }
  return YES ;
}


-(BOOL) saveAs:sender ;
{ id savePanel = [SavePanel new] ;
  [savePanel setRequiredFileType: [self extension]] ;
  if([savePanel runModalForDirectory: NULL file: fileName])
  { [self fileName: (char *) [savePanel filename]] ;
    return [self saveTextToFileName] ;
  }
  else
    return NO ;
}

-(BOOL) saveTextToFileName ;
// pre:  -ivar fileName contains a valid
//       file pathname.
//       -ivar textView contains a TextView object
// post: if file can be opened or created, with mode
//       644: text of textView is written out to the
//       file named by fileName; file is closed, and
//       YES is returned.
//       otherwise returns NO
{ int fd ;
  NXStream *fileStream ;
  [self message: "Saving file..."] ;
  fd = open(fileName, O_WRONLY|O_CREAT|O_TRUNC, 0644) ;
  if(fd != -1)
  { fileStream = NXOpenFile(fd, NX_WRITEONLY) ;
    [textView writeText: fileStream] ;
    NXClose(fileStream) ;
   [self setDocEdited:NO];
  }
  else
  { NXRunAlertPanel("Error","Could not save file:%s",
      NULL,NULL,NULL,fileName) ;
    [self message: ""] ;
    return NO ;
  }
  [self message: ""] ;
  return YES ;
}

- setTextView: sender ;
{ // get a handle on the text in the scrolling window.
  // make ourselves its delegate, so we know when the 
  // text has been edited. 
  textView = [sender docView] ;
  [textView setDelegate: self] ;
  return self ;
}


- text:text isEmpty:(BOOL)empty
{ // this is a delegate message for the textView
  if(![self isDocEdited])
     [self setDocEdited: YES] ;
  return NO;
}

- textView ;
{ return textView ;
}


@end
