#pragma once

/* POSIX allows any type to be declared here, as long as the name ends in _t */

/* Convenience types: */
typedef unsigned char u_char_t;
typedef unsigned short u_short_t;
typedef unsigned int u_int_t;
typedef unsigned long u_long_t;
typedef struct { long val[2]; } quad_t;
typedef struct { u_long_t val[2]; } u_quad_t;

#ifndef _POSIX_SOURCE
typedef u_char_t u_char;
typedef u_short_t u_short;
typedef u_int_t u_int;
typedef u_long_t u_long;
typedef quad_t quad;
typedef u_quad_t u_quad;
#endif

/* Types required by POSIX.1 section 2.6 */

typedef u_short_t dev_t;
typedef u_short_t gid_t;
typedef u_long_t ino_t;
typedef u_short_t mode_t;
typedef u_short_t nlink_t;
typedef u_long off_t;
typedef long pid_t;
typedef u_short_t uid_t;

/* Everythin' else */

typedef long daddr_t;
typedef void *caddr_t;
typedef long swblk_t;		/* NU */
typedef off_t size_t;
typedef long time_t;
typedef quad_t fsid_t;		/* ID of a filesystem */
typedef long error_t;
