# Hyperlink-Men fr TeX/LaTeX-Syntax-Help
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen
# Copyright (C) 1996  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University

proc TeX_syntax_help  {format raise} {# Hypertext version of xtem-syntax-help

proc hlpWinFill {window filedir entry} {
 global Wh hlp_dir hlpStack hlpFiledir hlp_bmlist

 if ![winfo exists $window] return

 $Wh.a.2.b configure -state disabled; $Wh.a.2.t configure -state disabled; update
 if {$filedir=="miscellaneous/mainhelp"} {set hlpStack ""}
 lvarpush hlpStack $entry;  lvarpush hlpStack $filedir
 set c_filedir $filedir
 set c_entry   $entry
 if {"$c_filedir"==""} {set c_filedir "???"}
 if {![file exists "${hlp_dir}${c_filedir}.htx"]} {
   set hlpFiledir $c_filedir
   set c_filedir "miscellaneous/missing_file";  set c_entry "missing_file"
 }
 # remove old tags, clear window etc.
 $window configure -state normal; update
 $window delete 0.0 end; update
 set hlp_bmlist ""; $Wh.a.4.r configure -state disabled; update
 foreach tn [$window tag names] {if {$tn!="sel"} {$window tag delete $tn}}
 $Wh.a.1.e configure -state disabled
 update
 hlpWinFillFile $window "$c_filedir" "$c_entry"
 if {$hlp_bmlist!=""} {$Wh.a.4.r configure -state normal; update}
 $Wh.a.1.e configure -state normal; $window configure -state disabled
 if {[llength $hlpStack]>2} \
	{$Wh.a.2.b configure -state normal; $Wh.a.2.t configure -state normal}
 update
}

proc hlpWinBitmap {w filedir} {
 global vv Wbm hlp_dir hlp_pid hlpCBM hlp_wgmdxy hlp_wgmx hlp_bmlist hlp_bmsuppr hlp_thisbm
 global geom tsFgr tsBgr

 update

 if {[lsearch $hlp_bmlist $filedir]==-1} {set hlp_bmlist "$hlp_bmlist $filedir "}
 if  {($hlp_bmsuppr)&&(!$hlp_thisbm)} return
 set file [string range $filedir [string last "/" "/$filedir"] end]
 incr hlpCBM;  set dx [expr 250+20*$hlpCBM]; set dy [expr 180+20*$hlpCBM]
 set hlp_wgmdxy +${dx}+${dy}; set hlp_wgmx 600
 if {[catch "which gunzip" m1]==0} {set gunzip_installed 1} else {set gunzip_installed 0}

 ####################################################################################
 # if you have to modify the following code in order to display the bitmaps         #
 # (neither gunzip nor xdvi available), please inform us so that we can modify      #
 # this procedure for future releases of xtem:   weibezahn@iwd.uni-bremen.de        #
 ####################################################################################
 if {([file exists $hlp_dir${filedir}.xbm]) || \
     ([file exists $hlp_dir${filedir}.xbm.gz] && $gunzip_installed)} {# display bitmap

   if {[file exists $hlp_dir${filedir}.xbm.gz]} {# bitmap is packed
     set xbmfile ".xtem_hlpxbm$hlpCBM";    unlink -nocomplain $xbmfile
     TestPut 4 "unpack&display bitmap <$filedir><$xbmfile>"
     SigChldB; exec gunzip -c $hlp_dir${filedir}.xbm.gz > $xbmfile; SigChldU
   } else {
     TestPut 4 "display bitmap"
     set xbmfile "$hlp_dir${filedir}.xbm"
   }
   set w $Wbm$hlpCBM;    if {[winfo exists $w]} {destros $w}
   toplevel $w;  wm title $w "$vv(tshlp) $file";  wm iconname $w "$file"
   wm minsize $w 15 10
   if [info exists geom($w)] {wm geometry $w $geom($w)} else {wm geometry $w =$hlp_wgmdxy}
   frame     $w.1;  pack $w.1 -anchor nw
   button    $w.1.e -text "$vv(ae)" -command "destros $w"; pack $w.1.e -pady 2 -side left
   label     $w.1.l -text "$vv(tsex)";			   pack $w.1.l -padx 10 -side left
   scrollbar $w.sb -command "$w.bm yview" -relief sunken;  pack $w.sb -side right -fill y
   canvas    $w.bm -yscrollcommand "$w.sb set" -relief raised -borderwidth 1 -width $hlp_wgmx
						pack $w.bm -side left -fill both -expand yes
   if ![file exists $xbmfile] {after 2000; TestPut 4 "@@@@@ NF<$xbmfile><$filedir>; mybell 4"}
   if [file exists $xbmfile] {
     $w.bm create bitmap 2 2 -bitmap "@$xbmfile" -anchor nw -tags item \
		-foreground $tsFgr -background $tsBgr
     $w.bm config -scrollregion [$w.bm bbox all]
   }
   if {$xbmfile==".xtem_hlpxbm$hlpCBM"} {unlink -nocomplain $xbmfile}

 } elseif {[file exists $hlp_dir${filedir}.dvi]} {#bitmap not found, but dvi exists
   TestPut 4 "display dvi-file"
   set x [expr $hlp_wgmx+100]
   SigChldB; set hlp_pid "$hlp_pid [exec xdvi $hlp_dir${filedir}.dvi \
		-geometry ${x}x400$hlp_wgmdxy -sidemargin 4.0cm -topmargin 4.3cm &]"; SigChldU

 } else {# neither bitmap nor dvi exists
   hlpWinInsertInline $w "\n$vv(tsbtm) $hlp_dir$filedir\n" normal
 }
}

proc hlpWinDelBitmaps {} {global Wbm hlp_pid hlpCBM geom

 foreach i [string trim $hlp_pid] {killprocess $i}
 for {set i 1} {$i<=$hlpCBM} {incr i} {if {[winfo exists $Wbm$i]} {destros $Wbm$i}}
 set hlp_pid "";  set hlpCBM 0

}

proc hlpWinRefreshBitmaps {w} {global hlp_bmlist hlp_thisbm

 hlpWinDelBitmaps
 set hlp_thisbm 1;  foreach i $hlp_bmlist {hlpWinBitmap $w $i};  set hlp_thisbm 0

}

proc hlpWinFillAlph {w filedir entry} {# read+analyze an AlphabeticalList.htx, fill into w
 global  vv hlp_dir tsBgr tsFgr hlpU

 set tnr 0
 set fid [open "${hlp_dir}${filedir}.htx" r]
 while {([getscl0 $fid line]!=-1)&&([lindex $line 0]!="@@linktag")} {
   if {[lindex $line 0]=="@title"} \
	{$w insert insert "[string range $line 7 end]\n$hlpU\n" boldlrge} \
   else {$w insert insert "$line\n" normal}
 }  
 while {[string trim $line]!="@eof"} {
   if {[lindex $line 0]=="@@linktag"} {
     while {[lindex $line 0]!=""} {
	incr tnr
        set tp1 [$w index insert]; set l1 "[lindex $line 1]"
	$w tag bind $tnr <Button-1> "hlpWinFill $w [lindex "$l1" 1] [lindex "$l1" 2]"
	$w tag bind $tnr <Enter> "$w tag configure $tnr -foreground $tsBgr -background $tsFgr"
	$w tag bind $tnr <Leave> "$w tag configure $tnr -foreground $tsFgr -background $tsBgr"
	$w insert insert [lindex "$l1" 4] [list telesmll $tnr]
	set line [lrange $line 2 end]
     }
     $w insert insert "\n"
   } else {update; # update screen} 
   if {[getscl0 $fid line]==-1} {break}
 }  
 close $fid
 return
}

proc hlpWinFillFile {w filedir entry} {# read+analyze help-file, fill into window w
 global Wh vv hlp_dir hlpC hlpCNr hlpTNr hlpLine hlpUndLine hlpU
 global syntaxmark
 TestPut 4 "<$w><$filedir><$entry>"

 $w tag configure normal   -font [option get $Wh.normal font text]
 $w tag configure tag      -font [option get $Wh.tag font text]
 $w tag configure italic   -font [option get $Wh.italic font text]
 $w tag configure bold     -font [option get $Wh.bold font text]
 $w tag configure boldlrge -font [option get $Wh.boldlrge font text]
 $w tag configure title    -font [option get $Wh.title font text]
 $w tag configure teletype -font [option get $Wh.teletype font text]
 $w tag configure telelrge -font [option get $Wh.telelrge font text]
 $w tag configure telesmll -font [option get $Wh.telesmll font text]

 set hlpCNr 0; set hlpTNr 0; set type normal; set hlpUndLine 0; set evaluate 0; set hlpMarkL 0
 hlpWinDelBitmaps
 if {[string match "*/Alphabetical_List" "$filedir"]} \
	{hlpWinFillAlph $w $filedir $entry; return}
 set fid [open "${hlp_dir}${filedir}.htx" r]
 while {([getscl0 $fid line]!=-1)&&([string trim $line]!="@eof")} {
   set l [string trim $line]; set p [string first " " $l]
   if {$p>0} {set first [string range $l 0 [expr $p-1]]} else {set first $l}
   set eoltext "\n"; set ctype $type

   if       {$first == "@entries"} {# skip entry line
     set eoltext "";   set hlpLine ""

   } elseif {$first == "@title"} {# prepare title
     set eoltext ""
     set eoltext "${eoltext}\n$hlpU\n"; set ctype boldlrge
     set hlpLine [string range $line 7 end]

   } elseif {$first == "@update"} {# update screen
     set eoltext ""; update

   } elseif {$first == "@mark"} {# check mark with entry
     set eoltext "";   set hlpLine ""
     if {($entry=="[lindex $line 1]")&&($syntaxmark>0)} \
	{set hlpMarkL [lindex [split [$w index insert] "."] 0]}
     

   } elseif {$first == "@section"} {# prepare section-title
     set eoltext "\n"; set ctype bold; set hlpLine [string range $line 9 end]

   } elseif {$first == "@bitmap"} {# prepare bitmap
     set eoltext "";  set hlpLine ""
     set f ""; set p [string last "/" $filedir]
     if {$p>=0} {set f "[string range $filedir 0 $p]"}
     hlpWinBitmap "$w" "$f[string range $line 8 end]";

   } elseif {$first == "@begdescription"} {# prepare description
     set eoltext "\n"; lvarpush typestack $type; set type normal;  set ctype bold
     set hlpLine "$vv(tsdes)"
   } elseif {$first == "@enddescription"} {#
     set eoltext "";   set type [lvarpop typestack]

   } elseif {$first == "@begteletype"} {# prepare teletype
     set eoltext ""; lvarpush typestack $type; set type teletype; set ctype $type
   } elseif {$first == "@endteletype"} {#
     set eoltext "";   set type [lvarpop typestack]

   } elseif {$first == "@begsyntax"} {# prepare syntax description
     set eoltext "\n"; lvarpush typestack $type; set type teletype; set ctype bold
     set hlpLine "$vv(tssyn)"
   } elseif {$first == "@endsyntax"} {#
     set eoltext "";   set type [lvarpop typestack]

   } elseif {$first == "@begexamples"} {# prepare examples      
     set eoltext "\n"; lvarpush typestack $type; set type telesmll; set ctype bold
     set hlpLine "$vv(tsexa)"
   } elseif {$first == "@endexamples"} {#
     set eoltext "";   set type [lvarpop typestack]
     if {[lindex $line 1]!="no_bitmap"} {hlpWinBitmap "$w" "$filedir"}

   } elseif {$first == "@begeval"} {# starts evaluation of each text-line before output
     set eoltext "";  set evaluate 1
   } elseif {$first == "@endeval"} {# ends   evaluation of each text-line before output
     set eoltext "";  set evaluate 0

   } else {
     set hlpLine $line
   }
   if {$evaluate} {eval set hlpLine "\"$hlpLine\""}
   while {$hlpLine != ""} {hlpWinInsertInline $w [hlpWinStrPart] $ctype}
   $w insert insert "$eoltext";  set eoltext "\n"
   # the following line must be done "in retard" because of an Tk-error (Tcl version 3.6)
   for {set i 1} {$i<=$hlpCNr} {incr i} {set res [eval $hlpC($i)]}; # run tag commands
   set hlpCNr 0
 }  
 close $fid
 if {$hlpMarkL>1} {set hlpMarkL [expr $hlpMarkL-1]}; $w yview -pickplace $hlpMarkL; update
}


proc hlpWinInsertInline {w text type} {# fills text t into window w with font type
 global Wh hlpLine  hlpC hlpCNr hlpTNr hlpBdw hlpUndLine tsFgr tsBgr

 set pf [string first "@@" $text];# look for inline-command
 if {$pf<0} {# "text" contains no inline-command
   set tp1 [$w index insert]; $w insert insert "$text"; set tp2 [$w index insert]
   if {$hlpUndLine} {
     $w tag configure underline -font [option get $Wh.$type font text] -underline on;
     set type underline
   }
   incr hlpCNr; set hlpC($hlpCNr) "$w tag add $type $tp1 $tp2"
 } elseif {$pf>0} {# "text" starts with normal text, followed by inline-command
   set string [string range $text 0 [expr $pf-1]]
   set tp1 [$w index insert]; $w insert insert "$string"; set tp2 [$w index insert]
   incr hlpCNr; set hlpC($hlpCNr) "$w tag add $type $tp1 $tp2"
   hlpWinInsertInline $w [string range $text $pf end] $type
 } else           {# "text" starts with inline-command
   TestPut 4 "iii-1 <$text>"
   set com  [lindex $text 0]; set l [string length $com]
   set text [string trimleft [string range $text [expr $l+1] end]]
   set arg  [lindex $text 0]; set l [string length $arg]
   if {[string first "\{" $text]==0} {set rest [string range $text [expr $l+3] end]} \
   else {set rest [string range $text [expr $l+1] end]}
   TestPut 4 "iii-6 <$com><$arg><$rest>"
   if {$com=="@@linktag"} {# prepare LinkTag
     set hlpBdw 1; set hlpUndLine 0
     if {[regsub "@@bdw" $arg "" arg]} {
	set hlpBdw [string index $arg 0]; set arg [string range $arg 2 end]
	if {$hlpBdw=="_"} {set hlpBdw 0; set hlpUndLine 1}
     }
     set arg  [string trimleft $arg]
     set tdir [lindex "$arg" 0]; set l [string length $tdir]
     set arg  [string trimleft [string range $arg [expr $l+1] end]]
     set tent [list [lindex "$arg" 0]]; set l [string length $tent]
     set t    [string range "$arg" [expr $l+1] end]
     if {[string first "\{" $t]==0} {set t [lindex $t 0]}
     set tp1 [$w index insert]; hlpWinInsertInline $w "$t" tag; set tp2 [$w index insert]
     incr hlpTNr 
     incr hlpCNr; set hlpC($hlpCNr) \
	"$w tag configure $hlpTNr -relief raised -borderwidth $hlpBdw -background $tsBgr"
     incr hlpCNr; set hlpC($hlpCNr) "$w tag add $hlpTNr $tp1 $tp2"
     incr hlpCNr; set hlpC($hlpCNr) \
	"$w tag bind $hlpTNr <Button-1> \"hlpWinFill $w $tdir $tent\""
     incr hlpCNr; set hlpC($hlpCNr) \
	"$w tag bind $hlpTNr <Leave> \"$w tag configure $hlpTNr -foreground $tsFgr \
								-background $tsBgr\""
     incr hlpCNr; set hlpC($hlpCNr) \
	"$w tag bind $hlpTNr <Enter> \"$w tag configure $hlpTNr -foreground $tsBgr \
								-background $tsFgr\""
     set hlpUndLine 0
   } elseif	{$com=="@@tt"}	{hlpWinInsertInline $w "$arg" teletype} \
     elseif	{$com=="@@tl"}	{hlpWinInsertInline $w "$arg" telelrge} \
     elseif	{$com=="@@ts"}	{hlpWinInsertInline $w "$arg" telesmll} \
     elseif	{$com=="@@em"}	{hlpWinInsertInline $w "$arg" italic} \
     elseif	{$com=="@@bf"}	{hlpWinInsertInline $w "$arg" bold} \
     elseif	{$com=="@@bl"}	{hlpWinInsertInline $w "$arg" boldlrge} \
     elseif	{$com=="@@rm"}	{hlpWinInsertInline $w "$arg" normal
   } else {# is not an implemented inline-command!
     puts stdout "*** xtem-Error (ts.tcl): inline-command \"$com\" not implemented!"; 
     flush stdout; mybell 4
   }
   if {$rest!=""} { hlpWinInsertInline $w "$rest" $type}
 }
}


proc hlpWinStrPart {} {# returns next part of "hlpLine":
#                            pure text up to next inline-command        or
#                            inline-command together with its argument
 global hlpLine

 set pf [string first "@@" "$hlpLine"]
 TestPut 4 "\tstart <$pf> <$hlpLine>"
 if {$pf<0} {# no inline-command
   set strpart $hlpLine; set hlpLine ""
 } elseif {$pf==0} {# starts with inline command
   set strpart [lrange $hlpLine 0 1]; set l [string length $strpart]
   if {$strpart!=[string range $hlpLine 0 [expr $l-1]]} {incr l 2};# tclversion>=8.0 needs
   # this line (trailing braces deleted from [second] list element deleted if no separators
   # such like blanks in this element!)
   set hlpLine [string range $hlpLine [expr $l+1] end]
 } else   {# $pf>0 --> starts with pure text, followed by inline-command
   set strpart [string range $hlpLine 0 [expr $pf-1]]
   set hlpLine [string range $hlpLine $pf end]
 }
 TestPut 4 "\tende  <$strpart> <$hlpLine>"
 return $strpart
}


global vv Wh Wbm geom edsyntaxhelp tssk edsyntaxchg hlpU hlpWin
global hlp_dir hlp_width tsFgr tsBgr hlp_pid hlpCBM hlp_bmsuppr hlp_thisbm


if [winfo exists $Wh] {
 if {$raise} {
   if {[wm state $Wh]=="normal"} {raise $Wh} else {wm deiconify $Wh}
 } else {
   if {$edsyntaxchg} {
	if {([wm state $Wh]=="normal")&&($edsyntaxhelp==$tssk(1))} {raise $Wh}
	if {([wm state $Wh]=="normal")&&($edsyntaxhelp==$tssk(2))} {wm iconify $Wh}
	if {([wm state $Wh]=="iconic")&&($edsyntaxhelp==$tssk(1))} {wm deiconify $Wh}
	if {($edsyntaxhelp==$tssk(3))} {wm destroy $Wh}
   }
 }
 set edsyntaxchg 0
 return
}
if {($edsyntaxhelp==$tssk(3))&&(!$raise)} {return}


toplevel $Wh;  wm title $Wh "$vv(tsvor)";  wm minsize $Wh 15 10
if {($edsyntaxhelp=="$tssk(2)")&&(!$raise)} {wm iconify $Wh}
if [info exists geom($Wh)] {wm geometry $Wh $geom($Wh)}

set hlp_pid ""; set hlpCBM 0; set edsyntaxchg 0; set hlpWin $Wh.li.t


label $Wh.normal; label $Wh.tag; label $Wh.italic; label $Wh.bold; label $Wh.boldlrge
label $Wh.title; label $Wh.teletype; label $Wh.telelrge; label $Wh.telesmll

# top buttons

frame $Wh.a -relief raised -borderwidth 1; pack configure $Wh.a -pady 2 -anchor w

frame $Wh.a.1; frame $Wh.a.2; frame $Wh.a.3 -borderwidth 2; frame $Wh.a.4
pack configure $Wh.a.1 $Wh.a.2 $Wh.a.3 $Wh.a.4 -pady 2 -side left -anchor n

button $Wh.a.1.e -text "$vv(ae)" -command {destros $Wh; hlpWinDelBitmaps; set texfmtts ""}
Bind3P $Wh.a.1.e 1 hlpWinFill $hlpWin miscellaneous/w_end end
pack configure $Wh.a.1.e -side left -padx 5 -pady 3

button $Wh.a.2.t -text "$vv(tsat)" -command \
	{global hlpWin; hlpWinFill $hlpWin "miscellaneous/mainhelp" "mainhelp"}
Bind3P $Wh.a.2.t 1 hlpWinFill $hlpWin miscellaneous/w_top top
button $Wh.a.2.b -text "$vv(tsab)" -command {
  lvarpop hlpStack;  lvarpop hlpStack; global hlpWin
  set filedir [lvarpop hlpStack]; set entry [lvarpop hlpStack]
  if {($filedir!="")&&($entry!="")} {hlpWinFill $hlpWin "$filedir" "$entry"}
}
Bind3P $Wh.a.2.b 1 hlpWinFill $hlpWin miscellaneous/w_back back
pack configure $Wh.a.2.t $Wh.a.2.b -side top -anchor w -padx 5 -pady 3

set hlp_thisbm 0
frame $Wh.a.3.bm -relief raised -borderwidth 2
pack configure $Wh.a.3.bm -side top -anchor w -padx 5 -pady 0
checkbutton $Wh.a.3.bm.i -borderwidth 2 -variable hlp_bmsuppr -text "$vv(tsbm)" -command {
 global hlp_bmsuppr; if {$hlp_bmsuppr} {hlpWinDelBitmaps} {hlpWinRefreshBitmaps $hlpWin}
}
Bind3P $Wh.a.3.bm.i 1 hlpWinFill $hlpWin miscellaneous/w_bitmap bitmap
pack configure $Wh.a.3.bm.i -side top -anchor w -padx 5 -pady 3

button $Wh.a.4.r -text "$vv(tsbmr)" -command {hlpWinRefreshBitmaps $hlpWin}
Bind3P $Wh.a.4.r 1 hlpWinFill $hlpWin miscellaneous/w_bitmap_r refresh
pack configure $Wh.a.4.r -side top -anchor w -padx 5 -pady 3

if {![info exists hlp_width]} {set hlp_width 80 }
scrollbar $Wh.sb -command "$Wh.li.t yview" -relief sunken
Bind3P $Wh.sb 1 hlpWinFill $hlpWin miscellaneous/w_text text
frame $Wh.li -relief raised -borderwidth 1 
text $Wh.li.t -yscrollcommand "$Wh.sb set" -width $hlp_width -height 32 -padx 3 -pady 2
bind CmdXNoWh <Key-Up>		"$Wh.li.t yview scroll -1 units"
bind CmdXNoWh <Key-Down>	"$Wh.li.t yview scroll  1 units"
bind CmdXNoWh <Button-3>	"hlpWinFill $hlpWin miscellaneous/w_text text"
bindtags $Wh.li.t "CmdXNo CmdXNoWh . all"; focus $Wh.li.t
pack $Wh.sb -side left -fill y
pack $Wh.li $Wh.li.t -side right -fill both -expand yes
set tsFgr [lindex [$hlpWin configure -foreground] 4]
set tsBgr [lindex [$hlpWin configure -background] 4]

set hlpU "___________________________________________________________________"

hlpWinFill $hlpWin "miscellaneous/mainhelp" "mainhelp"
bind $Wh.a.4.r <Unmap> \
    {for {set i 1} {$i<=$hlpCBM} {incr i} {if {[winfo exists $Wbm$i]} {destros $Wbm$i}}}
bind $Wh.a.4.r <Map> {$Wh.a.4.r invoke}

}
