/**************************************************************************
 * 
 * A conference which just displays its name in a glyph.  Used for the
 * facilitated conference slave side.
 *
 **************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */


#include <gk/groupsession.h>
#include <InterViews/window.h>
#include <stdio.h>
#include <gk/confglyph.h>
#include <IV-look/kit.h>
#include <InterViews/layout.h>
#include <InterViews/style.h>
#include <OS/string.h>

int main(int argc, char** argv) {
  GroupSession* session = new GroupSession("Conference", argc, argv);
  WidgetKit& kit = *WidgetKit::instance();
  LayoutKit& layout = *LayoutKit::instance();
  String conf_name;
  session->style()->find_attribute( "ConferenceName", conf_name );
  session->run_window(
    new ApplicationWindow(
      new ConferenceGlyph(
			  kit.inset_frame(
			    layout.margin(
			       kit.label( conf_name.string() )
                              , 5.0
                            )	   
			  )
			  ,session->style(), session->conference())
    )
  );
}

