/**************************************************************************
 * 
 * Glyph with just empty space.
 *
 **************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#include "emptyglyph.h"
#include <InterViews/background.h>
#include <IV-look/kit.h>
#include <InterViews/layout.h>

EmptyGlyph::EmptyGlyph(Style* style, Conference* conf, int x, int y) : ConferenceGlyph(nil, style, conf){
  LayoutKit& layout = *LayoutKit::instance();
  WidgetKit& kit = *WidgetKit::instance();
  body( new Background( layout.vbox_first_aligned( layout.vspace(y), 
						  layout.hspace(x) ), 
		       kit.background()));
}


