/****************************************************************************
 *
 * Classes: MasterRegClient
 * Author:  Mark Roseman
 *
 * Do a "master" registrar client, suitable for use by a facilitator in a 
 * strictly facilitated conference.
 *
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 10/13/92 MR        initial version
 *
 ****************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */

#ifndef __masterrc_h
#define __masterrc_h

#include <gk-reg/regclient.h>

class MasterRegClient : public RegistrarClient {
public:
  MasterRegClient(const char* host, int port, class Coordinator*);
  virtual void userLeft(int conf_id, int user_id);
protected:
  friend class MasterDisplay;
  virtual void foundNewConference(AttributeList*);
  virtual void foundDeletedConference(int);
  virtual void foundNewUser(AttributeList*);
  virtual void foundDeletedUser(int,int);

  void nameok(class FieldEditor*);

  class MasterDisplay* disp_;
  char name_[100];
  int confnum_;
  class Dialog* dlg_;
  class WidgetKit* kit_;
};

#endif
