/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.pad;

import gnu.crypto.pad.BasePad;
import gnu.crypto.pad.WrongPaddingException;

public class SSL3
extends BasePad {
    public void setup() {
        if (this.blockSize <= 0 || this.blockSize > 255) {
            throw new IllegalArgumentException("invalid block size: " + this.blockSize);
        }
    }

    public byte[] pad(byte[] in, int off, int len) {
        int padlen = this.blockSize - len % this.blockSize;
        byte[] pad = new byte[padlen];
        pad[padlen - 1] = (byte)(padlen - 1);
        return pad;
    }

    public int unpad(byte[] in, int off, int len) throws WrongPaddingException {
        int padlen = in[off + len - 1] & 0xFF;
        if (padlen >= this.blockSize) {
            throw new WrongPaddingException();
        }
        return padlen + 1;
    }

    public SSL3() {
        super("ssl3");
    }
}

