/* header file for program "support".   version 1.0   10 June 1993 */
/*                                                 */ 
/* by Richard Alan Peters II                       */
/* Department of Electrical Engineering            */
/* Vanderbilt University School of Engineering     */ 
/* Nashville, TN 37235                             */ 
/* rap2@vuse.vanderbilt.edu                        */ 
/*                                                 */ 
/* This software is freely redistributable if      */ 
/* the author's name and affiliation are included. */


#define SEPATH "SEPATH"    /* structuring element directory env. var */
#define SEMASK  0x0100     /* structuring element (SE) type bit */
#define GRASE   0x0000     /* gray-level SE */
#define BINSE   0x0100     /* binary SE */
#define SFMASK  0x0400     /* set / function mask */
#define SET     0x0000     /* set operation */
#define FUNCT   0x0400     /* function operation */



#define AUTO      1        /* make disk SE */
#define PLUS      2        /* use 3 by 3 "+" shaped SE */
#define S3X3      3        /* use 3 by 3 square SE */
#define S5X5      4        /* use 5 by 5 quasi disk SE */
#define PLUS3D    5        /* use 3 by 3 by 3 3D "+" shaped SE */
#define S3X3X3    6        /* use 3 by 3 by 3 cube SE */
#define S5X5X5    7        /* use 5 by 5 by 5 quasi sphere SE */
#define CONE      8        /* make a conical SE */
#define CYLINDER  9        /* make cylindrical SE */
#define SPHERE   10        /* make spherical SE */

#define BLACK    0
#define WHITE  255
#define TRUE     1
#define FALSE    0
#define ZERO     0
#define NSIZE  256
#define ALLOC TRUE

#define MIN(a,b) ((a<b)?(a):(b))
#define MAX(a,b) ((a>b)?(a):(b))

/* typedefs */

#ifndef BYTE
typedef unsigned char byte;
#define BYTE 1
#endif

#ifndef WORD
typedef short int word;
#define WORD
#endif

/* canned structuring elements */

int SEplus[9] = {   -1, BLACK,    -1, 
                 BLACK, BLACK, BLACK, 
                    -1, BLACK,    -1};

int SE3x3[9]  = {BLACK, BLACK, BLACK, 
                 BLACK, BLACK, BLACK, 
                 BLACK, BLACK, BLACK};

int SE5x5[25] = {   -1, BLACK, BLACK, BLACK,    -1,
                 BLACK, BLACK, BLACK, BLACK, BLACK, 
                 BLACK, BLACK, BLACK, BLACK, BLACK, 
                 BLACK, BLACK, BLACK, BLACK, BLACK, 
                    -1, BLACK, BLACK, BLACK,    -1};


int SEplus3D[27] = {   -1,    -1,    -1, 
                       -1, BLACK,    -1, 
                       -1,    -1,    -1,
                       -1, BLACK,    -1, 
                    BLACK, BLACK, BLACK, 
                       -1, BLACK,    -1,
                       -1,    -1,    -1, 
                       -1, BLACK,    -1, 
                       -1,    -1,    -1};


int SE3x3x3[27]  = {BLACK, BLACK, BLACK, 
                    BLACK, BLACK, BLACK, 
                    BLACK, BLACK, BLACK, 
                    BLACK, BLACK, BLACK, 
                    BLACK, BLACK, BLACK, 
                    BLACK, BLACK, BLACK, 
                    BLACK, BLACK, BLACK, 
                    BLACK, BLACK, BLACK, 
                    BLACK, BLACK, BLACK};


int SE5x5x5[125] = {   -1,    -1,    -1,    -1,    -1,
                       -1, BLACK, BLACK, BLACK,    -1,
                       -1, BLACK, BLACK, BLACK,    -1,
                       -1, BLACK, BLACK, BLACK,    -1,
                       -1,    -1,    -1,    -1,    -1,
                       -1, BLACK, BLACK, BLACK,    -1,
                    BLACK, BLACK, BLACK, BLACK, BLACK, 
                    BLACK, BLACK, BLACK, BLACK, BLACK, 
                    BLACK, BLACK, BLACK, BLACK, BLACK, 
                       -1, BLACK, BLACK, BLACK,    -1,
                       -1, BLACK, BLACK, BLACK,    -1,
                    BLACK, BLACK, BLACK, BLACK, BLACK, 
                    BLACK, BLACK, BLACK, BLACK, BLACK, 
                    BLACK, BLACK, BLACK, BLACK, BLACK, 
                       -1, BLACK, BLACK, BLACK,    -1,
                       -1, BLACK, BLACK, BLACK,    -1,
                    BLACK, BLACK, BLACK, BLACK, BLACK, 
                    BLACK, BLACK, BLACK, BLACK, BLACK, 
                    BLACK, BLACK, BLACK, BLACK, BLACK, 
                       -1, BLACK, BLACK, BLACK,    -1,
                       -1,    -1,    -1,    -1,    -1,
                       -1, BLACK, BLACK, BLACK,    -1,
                       -1, BLACK, BLACK, BLACK,    -1,
                       -1, BLACK, BLACK, BLACK,    -1,
                       -1,    -1,    -1,    -1,    -1};


/* function declarations */

int *ReadSE2D();
int *ReadSE3D();
int *MakeSE();
int *MakeDisk();
int *GetSE3D();
int *LoadSE3D();
int *MakeSE3D();
int *MakeCylinder();
int *MakeCone();
int *MakeSphere();
int GetSupport();
int GetSupport3D();
