
; Music .INC interface for the PS16 drivers.
;
; NOTE: This file is subject to change up until the initial release of the PS16
;       tools.

Mus_Init        =       0
Mus_Close	=	1
Mus_PlayMusic   =       2
Mus_StopMusic   =       3
Mus_SpeakerOn   =       4
Mus_SpeakerOff  =       5
Mus_RetVoice    =       6
Mus_LoadSample  =       7
Mus_Poll        =       8
Mus_StartSample =       9
Mus_StopSample  =      10

PS_NoLoop       =       0
PS_Loop         =       1

struc   SC
ioPort		dw	?	; card port
cardIRQ 	dw	?	; Either DMA IRQ (SB) or GF1 IRQ (GUS)
midiIRQ 	dw	?	; GUS Only
dmaChannelIn	dw	?	; For GUS only
dmaChannelOut	dw	?	; SB out DMA channel
mixvolseg       dw      ?       ; 4k/8k/16k volume table and 2-4k buffer.
sizebuf         dw      ?       ; Size of mixing buffer.
ends    SC

struc           pt_Offsets
pt_doramp       dd      ?
pt_volequ       dd      ?
pt_SetVoice     dd      ?
pt_PlayVol      dd      ?
pt_PlayNote     dd      ?
pt_PerNop       dd      ?
pt_PerNop2      dd      ?
pt_StartChannel dd      ?
pt_StartOver    dd      ?
pt_ExtTempo     dd      ?
ends            pt_Offsets

; This structure is passed to the play music routine.

struc           PM
stereoOn        db      0 ; I   ; 0-Off, 1-On
SamplingRate    dw      0 ; I   ; Current sampling rate.  Ignore on GUS.
MStatus         db      0 ;  O  ; Music status (0=Playing, 1=Stop/Stopped)
MaxVolume       db    240 ; IO  ; Max volume of song.
SongLen         db      0 ; I   ; Length of song, from PS16Header.
NumChannels     dw      4 ; I   ; Number of module channels (MOD - 4).
MaxChannels     dw      4 ; I   ; Maximum channels to mix.
CallsPerSec     dw     70 ; I   ; Times mixer will be called(>50).Ignore on GUS.
TruePanning     db      1 ; I   ; Turns on balanced left/right panning (1-On)
SequencesLoc    dd      0 ; I   ; Location of sequences, in PS16Header.
SamplesLoc      dd      0 ; I   ; Location of sample structures, in PS16Header.
InsLoc          dd      0 ; I   ; Location of samples in RAM/DRAM.
PatternsLoc     dd      0 ; I   ; Location of the patterns segments.
ChannelsLoc     dd      0 ; I   ; Location of channel MS structs = NumChannels.
                ;  Protracker specific stuff.
mt_speed        db      6 ; IO  ; Current speed (Cmd F).
mt_counter      db      0 ; IO  ; Current counter.
mt_SongPos      db      0 ; IO  ; Current song position.
mt_PatternPos   dw      0 ; IO  ; Current pattern position.
mt_PatternPosSeg dw     0 ; I   ; Location of 3k pattern decompression buffer.
mt_SavePPos     dw      0 ;  O  ; Actual pattern position aligned to 48.
mt_PlayStatus   db      0 ; IO  ; Current playing status (0-Quit music at end).
                                ;                        (1-Loop music).
mt_EditPat      dw      0 ;  O  ; Current editing pattern.
mt_EditSeg      dw      0 ;  O  ; Current editing segment.
mt_EditOfs      dw      0 ;  O  ; Current editing offset.
mt_PeriodTable  dd      0 ;  O  ; Location of the Period Table.
ends            PM

struc	CD
sofs		dw	?
sseg		dw	?
srepeat 	dw	?
sreplen 	dw	?
slen		dw	?
sRemainder      dw      ?
sStep           dw      ?
sOffsetR        dw      ?
sLoopEnd        dw      ?
svol            db      ?
sactive         db      ?
sspeaker        dw      ?
ends    CD

struc   PS16Sample
bitstruc        db      ?
                ; 7 6 5 4 3 2 1 0
                ;             0 - Digital, 1 - Synthesized
                ;            (if bit 0=1) 0 - FM, 1 - Waveform
                ;           0 - 8-bit, 1 - 16-bit.
                ;          0 - Signed, 1 - Unsigned
volume          db      ?
finetune        db      ?
length          dd      ?
repeat          dd      ?
replen          dd      ?
c2freq          dw      ?
ends    PS16Sample

struc   PS16Header
Sig             db      5 dup (0)
SongName        db      75 dup (0)
TypeOfFile      db      0       ; 0 - Module, 1 - Song
commentofs      dd      0
sversion        db      0
numpatterns     db      0
totalPatternSize dd     0
SongLen         db      0
Sequences       db      128 dup (0)
Samples         db      31*size PS16Sample dup (0)
ends    PS16Header


; Original Amiga equates by Lars "Zap" Hamre.  Converted to IBM structure   
; by Joshua C. Jensen.                                                      
struc           MS
note            db      0
cmd             db      0
cmdlo           db      0
start           dd      0
length          dd      0
loopstart       dd      0
replen          dd      0
period          dw      0
volume          db      0
finetune        db      0
toneportdirec   db      0
toneportspeed   db      0
wantedperiod    dw      0
vibratocmd      db      0
vibratopos      db      0
tremolocmd      db      0
tremolopos      db      0
wavecontrol     db      0
glissfunk       db      0
sampleoffset    db      0
pattpos         db      0
loopcount       db      0
funkoffset      db      0
wavestart       dd      0
reallength      dw      0
MasterVolume    db      0
SampleNum       db      0
sc_Mode         db      0
sc_PanPosition  db      0
sc_Voice        db      0
sc_Vol          dw      0
sc_Note         dw      0
sc_Repeat       dw      0
sc_Replen       dw      0
DecVolume       db      0
ends            MS

segment         PTSeg
ends            PTSeg

segment         GUSSeg
ends            GUSSeg

segment         SBSeg
ends            SBSeg
