/*
 * XaAES - XaAES Ain't the AES
 *
 * A multitasking AES replacement for MiNT
 *
 */

#include <stdlib.h>
#include <osbind.h>
#ifdef LATTICE
#undef abs		/* MiNTlib (PL46) #define is buggy! */
#define abs(i)	__builtin_abs(i)
#endif
#include "XA_DEFS.H"
#include "XA_TYPES.H"
#include "XA_GLOBL.H"
#include "K_DEFS.H"
#include "RECTLIST.H"
#include "BOX3D.H"
#include "objects.h"
#include "objects.src/box.h"
#include "objects.src/boxchar.h"
#include "objects.src/boxtext.h"
#include "objects.src/button.h"
#include "objects.src/cicon.h"
#include "objects.src/ftext.h"
#include "objects.src/fboxtext.h"
#include "objects.src/ibox.h"
#include "objects.src/icon.h"
#include "objects.src/image.h"
#include "objects.src/progdef.h"
#include "objects.src/slist.h"
#include "objects.src/string.h"
#include "objects.src/text.h"

/*
	OBJECT TREE ROUTINES
	- new version of the object display routine modularises the whole system.
*/


ObjectDisplayCallback objc_jump_table[G_MAX];

#if 0
void my_draw_2d_box(short x, short y, short w, short h, short border_thick, short colour)
{
	short coords[10];
	short x2,y2;

	if ( border_thick<0 )	/* outside border */
	{
		border_thick = -border_thick;
		x -= border_thick;
		y -= border_thick;
		w += 2*border_thick;
		h += 2*border_thick;
	}

	vsl_color(V_handle, colour);

	x2=x+w-1;
	y2=y+h-1;
	do {
		coords[0]=coords[6]=coords[8]=x++;
		coords[1]=coords[3]=coords[9]=y++;
		coords[2]=coords[4]=x2--;
		coords[5]=coords[7]=y2--;
		v_pline(V_handle, 5, coords);
	} while (--border_thick);
}
#endif

const short selected_colour[]={1,0,13,15,14,10,12,11,8,9,5,7,6,2,4,3};
const short selected3D_colour[]={1,0,13,15,14,10,12,11,9,8,5,7,6,2,4,3};

short global_clip[4];	/* Bloody progdefs need to know the clip rectangle */

void set_clip(short x, short y, short w, short h)
{
	global_clip[0]=x;
	global_clip[1]=y;
	global_clip[2]=x+w-1;
	global_clip[3]=y+h-1;
	vs_clip(V_handle,1,global_clip);
}

/* Set clipping to entire screen */
void clear_clip(void)
{
	global_clip[0]=display.x;
	global_clip[1]=display.y;
	global_clip[2]=display.x+display.w-1;
	global_clip[3]=display.y+display.h-1;
	vs_clip(V_handle,1,global_clip);
}

/*
	Draw a 2d box outline (allows 'proper' thickness - 1,2,3,etc)
	Note: expects writing mode to be set up by caller.
*/
void draw_2d_box(short x, short y, short w, short h, short border_thick, short colour)
{
	short coords[4];
	short vo;
	
	if (border_thick<0)
	{
		border_thick++;
		vo=-border_thick-1;
	}else{
		border_thick--;
		vo=border_thick+1;
	}

	if (border_thick>5)
		border_thick=0;

	vsf_interior(V_handle, FIS_SOLID);
	vsf_color(V_handle, colour);
			
	coords[0]=x;
	coords[1]=y-vo;
	coords[2]=x+border_thick;
	coords[3]=y+h+vo;
	v_bar(V_handle, coords);
	coords[0]=x+w;
	coords[1]=y-vo;
	coords[2]=x+w-border_thick;
	coords[3]=y+h+vo;
	v_bar(V_handle, coords);
	coords[0]=x;
	coords[1]=y;
	coords[2]=x+w;
	coords[3]=y+border_thick;
	v_bar(V_handle, coords);
	coords[0]=x;
	coords[1]=y+h;
	coords[2]=x+w;
	coords[3]=y+h-border_thick;
	v_bar(V_handle, coords);

}

#if 0
#define draw_2d_box(x,y,w,h,t,c)	if ( (Kbshift(-1)&3)==0 ) \
	my_draw_2d_box(x,y,w,h,t,c) ; else draw_2d_box(x,y,w,h,t,c)
#endif

/*
	Format a G_FTEXT type text string from it's template,
	and return the real position of the text cursor in this
*/
short format_dialog_text(char *text_out, char *template, char *text_in,short edit_pos)
{
	short index=0,edit_index,tpos=0;
	
	while(*template)
	{
		switch(*template)
		{
			case '_':				/* Found text field */
				if (tpos==edit_pos)
					edit_index=index;
				
				if (*text_in)
				{
					*text_out=*text_in;
					text_in++;
				}else{
					*text_out='_';
				}
				tpos++;
				
				text_out++;
				template++;
				break;
			default:				/* Formatting characters */
				*text_out=*template;
				text_out++;
				template++;
				break;
		}
		index++;
	}
	*text_out='\0';
	
	return edit_index;
}

void shadow_object(OBJECT *ob, short parent_x, short parent_y, OBJC_COLORWORD *colourword, short border_thick)
{
	short coords[4];
	short offset, increase;
	
	/*	Are we shadowing this object? (Borderless objects aren't shadowed!) */
	if (border_thick && (ob->ob_state&SHADOWED))
	{

		if (border_thick>0)
			{ offset=border_thick ; increase=border_thick-1 ; }
		else
			{ offset=0 ; increase=-3*border_thick-1 ; }

		vsf_color(V_handle,colourword->borderc);
		vsf_interior(V_handle, FIS_SOLID);
		coords[0]=parent_x+ob->ob_x+offset;
		coords[1]=parent_y+ob->ob_y+offset;
		coords[2]=coords[0]+ob->ob_width+increase;
		coords[3]=coords[1]+ob->ob_height+increase;
		v_bar(V_handle, coords);
	}
}

void set_colours(OBJECT *ob, OBJC_COLORWORD *colourword)
{
	short colourmode=(display.colours>=16) ;
	
	/* Note: `colourword->opaque' applies *only* to the text
		part of an object!!!!!! */
	vswr_mode(V_handle, MD_REPLACE);

	vsf_interior(V_handle, FIS_PATTERN);
	if (colourword->pattern==7)
	{
		vsf_style(V_handle, 8);
	}else{
		if (colourword->pattern==0)
		{
			vsf_style(V_handle, 8);
			if ((colourword->fillc==0)&&(ob->ob_flags&FLD3DANY))	/* Object inherits default dialog background colour? */
			{
				vswr_mode(V_handle, MD_TRANS);
				colourword->fillc=display.dial_colours.bg_col;
			}else{
				colourword->fillc=WHITE;
			}
		}else{
			vsf_style(V_handle, colourword->pattern);
		}
	}

	if (colourmode && (ob->ob_state&SELECTED))
	{
		if (ob->ob_flags&FLD3DANY)		/* Allow a different colour set for 3d push  */
			vsf_color(V_handle, selected3D_colour[colourword->fillc]);
		else
			vsf_color(V_handle, selected_colour[colourword->fillc]);
	}else{
		vsf_color(V_handle, colourword->fillc);
	}
	vst_color(V_handle, colourword->textc);
	
	vsf_perimeter(V_handle, 0);
}

GRECT set_text(OBJECT *ob, OBJC_COLORWORD *colourword, short *border_thick, short parent_x, short parent_y)
{
	TEDINFO *textblk=(TEDINFO*)ob->ob_spec;
	GRECT rtn;
	short temp;
	unsigned short *t=(unsigned short*)colourword;
	
	*t=(unsigned short)textblk->te_color;
	
	*border_thick=textblk->te_thickness;

	if (ob->ob_state&IS_EDIT)
		rtn.g_x=textblk->te_tmplen;
	else
		rtn.g_x=0;
			
	switch(textblk->te_just)			/*Set text alignment - why on earth did */
	{									/* atari use a different horizontal alignment */
		case 0:							/* code for GEM to the one the VDI uses? */
			vst_alignment(V_handle,0,5,&temp,&temp);
			break;
		case 1:
			vst_alignment(V_handle,2,5,&temp,&temp);
			break;
		case 2:
			vst_alignment(V_handle,1,5,&temp,&temp);
			break;
	}
			
	switch(textblk->te_font)	/* Set the correct text size & font */
	{
		case TE_GDOS_PROP:		/* Use a proportional SPEEDOGDOS font (AES4.1 style) */
		case TE_GDOS_MONO:		/* Use a monospaced SPEEDOGDOS font (AES4.1 style) */
		case TE_GDOS_BITM:		/* Use a GDOS bitmap font (AES4.1 style) */
			vst_font(V_handle,textblk->te_fontid);
			vst_point(V_handle,textblk->te_fontsize,&temp,&temp,&temp,&temp);
			rtn.g_w=display.c_max_w;
			rtn.g_h=display.c_max_h;
			rtn.g_y=parent_y + ob->ob_y + ((ob->ob_height-display.c_max_h)/2);
			break;
		case TE_STANDARD:		/* Use the standard system font (probably 10 point) */
			vst_font(V_handle,display.standard_font_id);
			vst_point(V_handle,display.standard_font_point,&temp,&temp,&temp,&temp);
			rtn.g_w=display.c_max_w;
			rtn.g_h=display.c_max_h;
			rtn.g_y=parent_y + ob->ob_y + ((ob->ob_height-display.c_max_h)/2);
			break;
		case TE_SMALL:			/* Use the small syatem font (probably 8 point) */
			vst_font(V_handle,display.small_font_id);
			vst_point(V_handle,display.small_font_point,&temp,&temp,&temp,&temp);
			rtn.g_w=display.c_min_w;
			rtn.g_h=display.c_min_h;
			rtn.g_y=parent_y + ob->ob_y + ((ob->ob_height-display.c_min_h)/2);
			break;
	}
	
	return rtn;
}

void d_g_title(ODC_PARM *odc_p)
{
}

/*
	Initialise the object display jump table
*/
void init_objects(void)
{
	short f;

	for(f=0; f<G_MAX; f++)
		objc_jump_table[f]=NULL;			/* Anything with a NULL pointer won't get called */
	
	objc_jump_table[G_BOX]=&d_g_box;
	objc_jump_table[G_TEXT]=&d_g_text;
	objc_jump_table[G_BOXTEXT]=&d_g_boxtext;
	objc_jump_table[G_IMAGE]=&d_g_image;
	objc_jump_table[G_PROGDEF]=&d_g_progdef;
	objc_jump_table[G_IBOX]=&d_g_ibox;
	objc_jump_table[G_BUTTON]=&d_g_button;
	objc_jump_table[G_BOXCHAR]=&d_g_boxchar;
	objc_jump_table[G_STRING]=&d_g_string;
	objc_jump_table[G_FTEXT]=&d_g_ftext;
	objc_jump_table[G_FBOXTEXT]=&d_g_fboxtext;
	objc_jump_table[G_ICON]=&d_g_icon;
	objc_jump_table[G_TITLE]=&d_g_title;
	objc_jump_table[G_CICON]=&d_g_cicon;
	objc_jump_table[G_SLIST]=&d_g_slist;
	
}

/*
	Display a primitive object
*/
void display_object(OBJECT *tree,short object,short parent_x,short parent_y)
{
	OBJC_COLORWORD *colourword;
	OBJECT *ob=tree+object;
	ObjectDisplayCallback display_routine;
	ODC_PARM odc_p;
	unsigned short zap;
	short border_thick=0,coords[10];
	short temp;
	short colourmode=(display.colours>=16) ;
	short state_mask=(SELECTED|CROSSED|CHECKED|DISABLED); /* -> G_PROGDEF */
	short obx=parent_x+ob->ob_x;
	short oby=parent_y+ob->ob_y;
	short obx2=obx+ob->ob_width-1;
	short oby2=oby+ob->ob_height-1;
	short t;

	if ((obx>global_clip[2])			/* Exit immediately if object is totally outside clip area */
		||((obx2<global_clip[0])
		||((oby>global_clip[3])
		||(oby2<global_clip[1]))))
	{
		return;
	}

	t=ob->ob_type&0xff;
	colourword=(OBJC_COLORWORD*)&zap;

	if ((ob->ob_flags&DEFAULT) &&	/* Default exit object */
		(t==G_BUTTON) &&			/* Only BUTTONS change appearance! */
		(ob->ob_flags&FLD3DANY))	/* 2D buttons are handled elsewhere */
	{
		vsf_color(V_handle,BLACK);
		vsf_interior(V_handle, FIS_SOLID);
		coords[0]=parent_x+ob->ob_x-2;
		coords[1]=parent_y+ob->ob_y-2;
		coords[2]=coords[0]+ob->ob_width+3;
		coords[3]=coords[1]+ob->ob_height+3;
		v_bar(V_handle, coords);
	}

	display_routine=objc_jump_table[t];	/* Get display routine for this type of object from jump table */

	if (display_routine==NULL)			/* If we don't have a display routine for a given object type, draw a box instead */
		display_routine=objc_jump_table[G_IBOX];

	odc_p.tree=tree;					/* fill in the object display parameter structure */
	odc_p.object=object;					
	odc_p.parent_x=parent_x;
	odc_p.parent_y=parent_y;
	odc_p.state_mask=&state_mask;

	(*display_routine)(&odc_p);			/* call the appropriate display routine */

	if (ob->ob_state&CROSSED)
	{
		vsl_color(V_handle,colourword->borderc);
		coords[0]=parent_x+ob->ob_x;
		coords[1]=parent_y+ob->ob_y;
		coords[2]=parent_x+ob->ob_x+ob->ob_width-1;
		coords[3]=parent_y+ob->ob_y+ob->ob_height-1;
		v_pline(V_handle,2,coords);
		coords[0]=parent_x+ob->ob_x+ob->ob_width-1;
		coords[2]=parent_x+ob->ob_x;
		v_pline(V_handle,2,coords);
	}
	
	/* Handle CHECKED object state: */
	if ( ob->ob_state & state_mask & CHECKED )
	{
		vst_font(V_handle,display.standard_font_id);
		vst_point(V_handle,display.standard_font_point,&temp,&temp,&temp,&temp);
		vswr_mode(V_handle, MD_TRANS);
		vst_alignment(V_handle,0,5,&temp,&temp);
		vst_color(V_handle, BLACK);
		v_gtext(V_handle, obx+2, oby, "\10");	/* ASCII 8 = checkmark */
	}

	/* Handle CROSSED object state: */
	if ( ob->ob_state & state_mask & CROSSED )
	{
		coords[0]=coords[4]=obx-border_thick;
		coords[1]=coords[7]=oby-border_thick;
		coords[2]=coords[6]=obx2+border_thick;
		coords[3]=coords[5]=oby2+border_thick;

		vswr_mode(V_handle, MD_TRANS);
		vsl_color(V_handle, WHITE);
		vsl_width(V_handle, 1);
		vsl_type(V_handle, 1);
		v_pline(V_handle, 2, &coords[0]);
		v_pline(V_handle, 2, &coords[4]);
	}

	coords[0]=obx;
	coords[1]=oby;
	coords[2]=obx2;
	coords[3]=oby2;
	if (border_thick > 0)		/* Inside border */
	{
		coords[0]+=border_thick;
		coords[1]+=border_thick;
		coords[2]-=border_thick;
		coords[3]-=border_thick;
	}

	/* Handle DISABLED state: */
	/* (May not look too hot in colour mode, but it's better than
		no disabling at all...) */
	if ( ob->ob_state & state_mask & DISABLED )
	{
		static short pattern[16]={
			0x5555, 0xaaaa, 0x5555, 0xaaaa,
			0x5555, 0xaaaa, 0x5555, 0xaaaa,
			0x5555, 0xaaaa, 0x5555, 0xaaaa,
			0x5555, 0xaaaa, 0x5555, 0xaaaa };

		vswr_mode(V_handle, MD_TRANS);
		vsf_color(V_handle, WHITE);
		vsf_udpat(V_handle, pattern, 1);
		vsf_interior(V_handle, FIS_USER);
		vr_recfl(V_handle, coords);
	}

	/* Handle SELECTED state only in non-colour mode: */
	if (!colourmode && ((ob->ob_state&state_mask)&SELECTED))
	{
		vswr_mode(V_handle, MD_XOR);
		vsf_color(V_handle, BLACK);
		vsf_interior(V_handle, FIS_SOLID);
		vr_recfl(V_handle, coords);
	}

	vswr_mode(V_handle,MD_TRANS);
}


/*
	Walk an object tree, calling display for each object
*/
short draw_object_tree(OBJECT *tree, short object, short depth)
{
	short next;
	short current=0,rel_depth=1,head;
	short x=0,y=0,start_drawing=FALSE;
	
	depth++;
	
	do {
		
		if (current==object)
		{
			start_drawing=TRUE;
			rel_depth=0;
		}
		
		if ((start_drawing)&&(!(tree[current].ob_flags&HIDETREE)))
		{
			display_object(tree,current,x,y);	/* Display this object */
		}

		head=tree[current].ob_head;
										/* Any non-hidden children? */
		if (((head!=-1)&&(!(tree[current].ob_flags&HIDETREE)))
			&&((!start_drawing)||((start_drawing)&&(rel_depth<depth))))
		{
		
			x+=tree[current].ob_x; y+=tree[current].ob_y;
			rel_depth++;
			current=head;
		
		}else{

			next=tree[current].ob_next;		/* Try for a sibling */
	
			while((next!=-1)				/* Trace back up tree if no more siblings */
					&&(tree[next].ob_tail==current))
			{
				current=next;
				x-=tree[current].ob_x;
				y-=tree[current].ob_y;
				next=tree[current].ob_next;
				rel_depth--;
			}
			current=next;
		}
	
	}while((current!=-1)&&(!((start_drawing)&&(rel_depth<1))));

	vst_alignment(V_handle,0,5,&x,&x);
	vswr_mode(V_handle, MD_TRANS);
	vst_font(V_handle,display.standard_font_id);
	vst_point(V_handle,display.standard_font_point,&next,&next,&next,&next);
	vsf_interior(V_handle, FIS_SOLID);

	return TRUE;
}

/*
	Get the true screen coords of an object
*/
short object_abs_coords(OBJECT *tree, short object, short *obx, short *oby)
{
	short next;
	short current=0;
	short x=0,y=0;
	
	do {
		if (current==object)	/* Found the object in the tree? cool, return the coords */
		{
			*obx=x+tree[current].ob_x;
			*oby=y+tree[current].ob_y;
			return 1;
		}
		
		if (tree[current].ob_head!=-1)		/* Any children? */
		{
			x+=tree[current].ob_x; y+=tree[current].ob_y;
			current=tree[current].ob_head;
		}else{
			next=tree[current].ob_next;							/* Try for a sibling */

			while((next!=-1)&&(tree[next].ob_tail==current))	/* Trace back up tree if no more siblings */
			{
				current=next;
				x-=tree[current].ob_x;
				y-=tree[current].ob_y;
				next=tree[current].ob_next;
			}
			current=next;
		}
	} while(current!=-1);		/* If 'current' is -1 then we have finished */

	return 0;	/* Bummer - didn't find the object, so return error */
}

/*
	Find which object is at a given location
*/
short find_object(OBJECT *tree, short object, short depth, short obx, short oby)
{
	short next;
	short current=0,rel_depth=1;
	short x=0,y=0,start_checking=FALSE;
	short pos_object=-1;
	
	do {
		if (current==object)	/* We can start considering objects at this point */
		{
			start_checking=TRUE;
			rel_depth=0;
		}
		
		if (start_checking)
		{
			if ((tree[current].ob_x+x<=obx)
				&&((tree[current].ob_y+y<=oby)
				&&((tree[current].ob_x+x+tree[current].ob_width>=obx)
				&&(tree[current].ob_y+y+tree[current].ob_height>=oby))))
			{
				pos_object=current;	/* This is only a possible object, as it may have children on top of it. */
			}
		}

		if (((!start_checking)||(rel_depth<depth))&&(tree[current].ob_head!=-1))		/* Any children? */
		{
			x+=tree[current].ob_x; y+=tree[current].ob_y;
			rel_depth++;
			current=tree[current].ob_head;
		}else{
			next=tree[current].ob_next;							/* Try for a sibling */

			while((next!=-1)&&(tree[next].ob_tail==current))	/* Trace back up tree if no more siblings */
			{
				current=next;
				x-=tree[current].ob_x;
				y-=tree[current].ob_y;
				next=tree[current].ob_next;
				rel_depth--;
			}
			current=next;
		}
		
	} while((current!=-1)&&(rel_depth>0));

	return pos_object;
}

/*
	Perform a few fixes on a menu tree prior to installing it
	(ensure title spacing & items fit into their menus)
*/
void fix_menu(OBJECT *root)
{
	short pxy[8];
	short title,mnx=0,mnh,mnw,temp;
	short surround,text;

	title=root[root[root[0].ob_head].ob_head].ob_head;
	surround=root[root[0].ob_tail].ob_head;
	
	while(title!=root[root[0].ob_head].ob_head)		/* Fix title spacings (some resource editors don't set them up right) */
	{
		root[title].ob_x=mnx;
		root[surround].ob_x=mnx;

		vqt_extent(V_handle,(char*)root[title].ob_spec,pxy);
		mnw=(abs(pxy[2]-pxy[0])+4);
		mnx+=mnw;
		root[title].ob_width=mnw;
		root[title].ob_height=display.c_max_h;

		mnw=mnh=0;
		
		for(text=root[surround].ob_head; text!=surround; text=root[text].ob_next)
		{
			vqt_extent(V_handle,(char*)root[text].ob_spec,pxy);
			temp=abs(pxy[2]-pxy[0]);

			if (temp>mnw)
				mnw=temp;
				
			mnh+=display.c_max_h;
		}
		
		root[surround].ob_width=mnw;
		root[surround].ob_height=mnh;

		title=root[title].ob_next;
		surround=root[surround].ob_next;
	}
	
	root[0].ob_width=mnx;
	root[0].ob_height=display.c_max_h;
	root[root[0].ob_head].ob_width=mnx;
	root[root[0].ob_head].ob_height=display.c_max_h;
	root[root[0].ob_tail].ob_width=mnx;
	root[root[0].ob_tail].ob_height=display.c_max_h;
}
