/*
 * XaAES - XaAES Ain't the AES
 *
 * A multitasking AES replacement for MiNT
 *
 */

#include <stdlib.h>
#include <osbind.h>
#include <mintbind.h>
#ifdef LATTICE
#undef abs		/* MiNTlib (PL46) #define is buggy! */
#define abs(i)	__builtin_abs(i)
#endif
#include "XA_DEFS.H"
#include "XA_TYPES.H"
#include "XA_GLOBL.H"
#include "K_DEFS.H"
#include "RECTLIST.H"
#include "BOX3D.H"
#include "objects.h"
#include "FRM_ALRT.H"

/*
	Setup a scrolling list structure for an object
	- I've provided this as I don't expect any resource editor to support
	XaAES' extentions to the object types....
*/

short set_scroll(OBJECT *form, short objc, char *title)
{
	OBJECT *ob=form+objc;
	SCROLL_INFO *sinfo;
	
	sinfo=(SCROLL_INFO*)malloc(sizeof(SCROLL_INFO));

	if (!sinfo)
		return FALSE;
	
	sinfo->scrl_current=NULL;
	sinfo->scrl_dstart=NULL;
	sinfo->scrl_start=NULL;
	sinfo->scrl_title=title;
	sinfo->scrl_count=0;
	sinfo->scrl_colour.borderc=BLACK;
	sinfo->scrl_colour.textc=BLACK;
	sinfo->scrl_colour.opaque=0;
	sinfo->scrl_colour.pattern=IP_HOLLOW;
	sinfo->scrl_colour.fillc=WHITE;
	sinfo->scrl_status=0;
	sinfo->scrl_f_click=NULL;
	sinfo->scrl_f_dclick=NULL;
	
	ob->ob_spec=(void*)sinfo;
	ob->ob_type=G_SLIST;
	
	return TRUE;
}

short add_scroll_entry(OBJECT *form, short objc, SCROLL_ENTRY *entry)
{
	SCROLL_INFO *list;
	SCROLL_ENTRY *last,*new_entry;
	OBJECT *ob=form+objc;
	
	list=(SCROLL_INFO*)ob->ob_spec;
	new_entry=(SCROLL_ENTRY*)malloc(sizeof(SCROLL_ENTRY));
	
	if (!new_entry)
	{
		return FALSE;
	}
	
	new_entry->next=NULL;
	last=list->scrl_start;
	if (last)
	{
		while(last->next)
			last=last->next;
		last->next=new_entry;
		new_entry->prev=last;
	}else{
		new_entry->prev=NULL;
		list->scrl_start=list->scrl_current=list->scrl_dstart=new_entry;
	}
	new_entry->text=entry->text;
	new_entry->icon=entry->icon;
	if (entry->icon)
	{
		new_entry->icon->ob_x=0;
		new_entry->icon->ob_y=0;
		new_entry->icon->ob_flags|=HIDETREE;
	}
	
	return TRUE;
}

void empty_scroll_list(OBJECT *form, short objc)
{
	SCROLL_INFO *list;
	SCROLL_ENTRY *this,*next;
	OBJECT *ob=form+objc;

	list=(SCROLL_INFO*)ob->ob_spec;
	this=next=list->scrl_start;
	
	while(this)
	{
		next=this->next;
		free(this);
		this=next;
	}
	
	list->scrl_start=list->scrl_current=list->scrl_dstart=NULL;
}

void click_scroll_list(OBJECT *form, short objc, short cx, short cy)
{
	SCROLL_INFO *list;
	SCROLL_ENTRY *this;
	OBJECT *ob=form+objc;
	short mx,my,mb,y;	

	list=(SCROLL_INFO*)ob->ob_spec;
	
	object_abs_coords(form, objc, &mx, &my);

	cx-=mx;	/* Get click position relative to the scroller */
	cy-=my;

	if (cy<display.c_max_h)
		return;

	if (cx>ob->ob_width - display.c_max_w - 4)
	{
		DIAGS(("click_scroll: cy=%x\n",cy));
		
		if ((cy>display.c_max_h+1)&&(cy<display.c_max_h*2+4))
		{
			list->scrl_status=SCRLSTAT_UP;
		}else{
			if(cy>ob->ob_height-display.c_max_h-1)
			{
				list->scrl_status=SCRLSTAT_DOWN;
			}
		}			

		vq_mouse(V_handle, &mb, &mx, &my);
		
		do{

			if ((list->scrl_status==SCRLSTAT_UP)&&(list->scrl_dstart!=list->scrl_start))
			{
				list->scrl_dstart=list->scrl_dstart->prev;
				v_hide_c(V_handle);
				draw_object_tree(form, objc, 1);
				v_show_c(V_handle, 1);
			}

			if ((list->scrl_status==SCRLSTAT_DOWN)&&(list->scrl_dstart->next))
			{
				list->scrl_dstart=list->scrl_dstart->next;
				v_hide_c(V_handle);
				draw_object_tree(form, objc, 1);
				v_show_c(V_handle, 1);
			}
		
			Fselect(20,NULL,NULL,NULL);	/* Wait a while to slow the scrolling down */

			vq_mouse(V_handle, &mb, &mx, &my);
		}while(mb);
	
		list->scrl_status=SCRLSTAT_RDB;

	}else{
		
		y=5+2*display.c_max_h; this=list->scrl_dstart;
		while((this)&&(y<cy))
		{
				this=this->next;
				y+=display.c_max_h;
		}

		if (this)
		{
			list->scrl_current=this;
			list->scrl_status=0;
			
			if (list->scrl_f_click)			/* Call the new object selected callback */
				(*(list->scrl_f_click))(form,objc);
			
		}else{
			list->scrl_status=SCRLSTAT_RDB;
		}
		
	}
	
	v_hide_c(V_handle);
	draw_object_tree(form, objc, 1);
	v_show_c(V_handle, 1);
	list->scrl_status=0;
	
}

void dclick_scroll_list(OBJECT *form, short objc, short cx, short cy)
{
	SCROLL_INFO *list;
	SCROLL_ENTRY *this;
	OBJECT *ob=form+objc;
	short mx,my,mb,y;	

	list=(SCROLL_INFO*)ob->ob_spec;
	
	object_abs_coords(form, objc, &mx, &my);

	cx-=mx;	/* Get click position relative to the scroller */
	cy-=my;

	if (cy<display.c_max_h)
		return;

	if (cx>ob->ob_width - display.c_max_w - 4)
		return;

	y=5+2*display.c_max_h; this=list->scrl_dstart;
	while((this)&&(y<cy))
	{
			this=this->next;
			y+=display.c_max_h;
	}

	if (this)
	{
		list->scrl_current=this;
		list->scrl_status=0;
	}else{
		list->scrl_status=SCRLSTAT_RDB;
	}
	
	v_hide_c(V_handle);
	draw_object_tree(form, objc, 1);
	v_show_c(V_handle, 1);
	list->scrl_status=0;
	
	if (list->scrl_f_dclick)
		(*(list->scrl_f_dclick))(form,objc);
	
}

