/*
 * XaAES - XaAES Ain't the AES
 *
 * A multitasking AES replacement for MiNT
 *
 */

#include <OSBIND.H>
#include <MINTBIND.H>
#include <VDI.H>
#include "XA_TYPES.H"
#include "XA_DEFS.H"
#include "XA_GLOBL.H"
#include "KERNAL.H"
#include "K_DEFS.H"
#include "GRAF_MOU.H"
#include "MESSAGES.H"
#include "C_WINDOW.H"
#include "RECTLIST.H"
#include "ALL_WIDG.H"
#include "STD_WIDG.H"
#include "drag_box.h"
#include "SYSTEM.H"
#include "OBJECTS.H"
#include "BOX3D.H"

/*======================================================
	TITLE WIDGET BEHAVIOUR
========================================================*/
short display_title(XA_WINDOW *wind, XA_WIDGET *widg)
{
	short x,y,pnt[6];

	rp_2_ap(wind, widg, &x, &y);	/* Convert relative coords and window location to absolute screen location */

	vswr_mode(V_handle, MD_TRANS);

#if DISPLAY_LOGO_IN_TITLE_BAR
	if (widg->stat==XAW_PLAIN)
		def_widgets[WIDG_LOGO].ob_state&=~SELECTED;
	else
		def_widgets[WIDG_LOGO].ob_state|=SELECTED;
	
	display_object(def_widgets,WIDG_LOGO,x,y);

	x+=ICON_W+3;

	pnt[0]=x; pnt[1]=y; pnt[2]=x+widg->w-ICON_W-6; pnt[3]=y+widg->h;
#else
	pnt[0]=x; pnt[1]=y; pnt[2]=x+widg->w-3; pnt[3]=y+widg->h;
#endif

#if 0
	if (window_list==wind)	/* Highlight the title bar of the top window */
	{
		vsf_color(V_handle,LBLUE);
		vsf_interior(V_handle,FIS_SOLID);
		v_bar(V_handle,pnt);
		vst_color(V_handle,WHITE);
	}else{
		vst_color(V_handle,BLACK);
	}
#else
	if (window_list==wind)	/* Highlight the title bar of the top window */
		vst_color(V_handle,BLACK);
	else
		vst_color(V_handle,WHITE);
	
	if (widg->stat==XAW_PLAIN)
		vsl_color(V_handle,display.dial_colours.t_l_col);
	else
		vsl_color(V_handle,display.dial_colours.b_r_col);

	pnt[0]=x+widg->w; pnt[1]=y;
	pnt[2]=x; pnt[3]=y;
	pnt[4]=x; pnt[5]=y+widg->h;
	v_pline(V_handle,3,pnt);

	if (widg->stat==XAW_PLAIN)
		vsl_color(V_handle,display.dial_colours.b_r_col);
	else
		vsl_color(V_handle,display.dial_colours.t_l_col);

	pnt[2]=x+widg->w; pnt[3]=y+widg->h;
	v_pline(V_handle,3,pnt);
#endif

	v_gtext(V_handle, x+5,y, (char*)widg->stuff);

	return TRUE;
}

/* Click & drag on the title bar - does a move window */
short drag_title(XA_WINDOW *wind, XA_WIDGET *widg)
{
	short x,y;
	XA_WINDOW *scan_wind;

	if (wind!=window_list)	/* Don't allow windows below a STORE_BACK to move */
	{
		for(scan_wind=wind->prev; scan_wind; scan_wind=scan_wind->prev)
		{
			if (scan_wind->active_widgets&STORE_BACK)
				return TRUE;
		}
	}

	if (wind->active_widgets&MOVER)			/* You can only move a window if it's MOVER attribute is set */
	{
		vs_clip(V_handle, 0, NULL);

		graf_mouse(XACRS_MOVER, NULL);		/* Always have a nice consistent MOVER when dragging a box */
		drag_box(wind->w, wind->h, wind->x, wind->y, -display.x, display.y, display.w*4, display.h*2, &x, &y);
		
		graf_mouse(clients[window_list->owner].client_mouse, clients[window_list->owner].client_mouse_form);	/* Restore the mouse now we've done the drag */

		if ((x!=wind->x)||(y!=wind->y))
		{
			if (wind->active_widgets&NO_MESSAGES)	/* Just move these windows, they can handle it.... */
			{
			
				move_window(wind,x,y,wind->w,wind->h);
				
			}else{	/* Send a message to a client to say that the AES would like the window moving (if the window has moved) */

				send_app_message(wind->owner, WM_MOVED, 0, wind->handle, x, y, wind->w, wind->h);

			}
		}
	}
	
	return TRUE;
}

/* Single click title bar sends window to the back */
short click_title(XA_WINDOW *wind, XA_WIDGET *widg)
{
	short clipV[4];
	XA_WINDOW *wl;
	GRECT clip,our_win;

	if (window_list!=wind)	/* If window isn't top then top it */
	{
	
		if (wind->active_widgets&NO_MESSAGES)	/* Just top these windows, they can handle it.... */
		{
			pull_wind_to_top(wind);	/* Top the window */

			for(wl=wind; wl; wl=wl->next)
				generate_rect_list(wl);

			clipV[0]=wind->x; clipV[1]=wind->y;
			clipV[2]=wind->x+wind->w; clipV[3]=wind->y+wind->h;
			vs_clip(V_handle,1,clipV);

			v_hide_c(V_handle);
			display_window(wind);	/* Display the window (clip to it's size) */
			v_show_c(V_handle,1);
			
			vs_clip(V_handle,0,clipV);
	
		}else{
	
			send_app_message(wind->owner, WM_TOPPED, 0, wind->handle, 0, 0, 0, 0);
	
		}
	
	}else{		/* If window is already top, then send it to the back */

		if (!(wind->active_widgets&STORE_BACK))	/* Don't bottom STORE_BACK windows */
		{
			if (wind->active_widgets&NO_MESSAGES)
			{
				v_hide_c(V_handle);
				Psemaphore(2,WIN_LIST_SEMAPHORE,-1L);

				send_wind_to_bottom(wind);			/* Send it to the back */
						
				display_non_topped_window(wind, NULL);	/* Re-display new top window */

				v_show_c(V_handle,1);

				our_win.g_x=wind->x; our_win.g_y=wind->y;
				our_win.g_w=wind->w; our_win.g_h=wind->h;
			
				for(wl=wind->prev; wl->prev; wl=wl->prev)
				{
					clip.g_x=wl->x; clip.g_y=wl->y;
					clip.g_w=wl->w; clip.g_h=wl->h;
				
					if (rc_intersect(&our_win,&clip))
					{
						display_non_topped_window(wl,&clip);	/* Re-display any revealed windows */			
						send_app_message(wl->owner, WM_REDRAW, 0, wl->handle, clip.g_x, clip.g_y, clip.g_w, clip.g_h);
					}
				}
				display_non_topped_window(wl, NULL);	/* Re-display new top window */

			}else{

				send_app_message(wind->owner, WM_BOTTOMED, 0, wind->handle, 0, 0, 0, 0);

			}
		}
	}
	
	return TRUE;
}

/* Double click title bar of iconified window - sends a restore message */
short dclick_title(XA_WINDOW *wind, XA_WIDGET *widg)
{
	if (wind->active_widgets&NO_MESSAGES)
	{
		return FALSE;
	}
	
/* If window is iconified - send request to restore it */
	if (wind->window_status==XAWS_ICONIFIED)
	{
		send_app_message(wind->owner, WM_UNICONIFY, 0, wind->handle, wind->prev_x, wind->prev_y, wind->prev_w, wind->prev_h);
	}
	
	return TRUE;
}

