/*
 * this points to the structure that has all the useful functions that
 * the kernel told us about
 */

#ifndef _kernel_h
#define _kernel_h

#ifndef P_
# ifdef __STDC__
#  define P_(x) x
# else
#  define P_(x) ()
# endif
#endif

#ifndef _wORD
#ifdef _SHORTINT	/* 16 bit integers? */
#define _wORD int
#endif
#ifdef __MSHORT__	/* 16 bit integers? */
#define _wORD int
#endif
#ifndef _wORD
#define _wORD short
#endif
#endif

extern struct kerinfo *kernel;

/* BIOS entry points */
#define drvmap()	((*(unsigned long (*)P_((void)))kernel->bios_tab[10])())

/* GEMDOS entry points */
#define c_conws(s)	((*(long (*)P_((const char *)))kernel->dos_tab[0x09])(s))
#define f_getdta()	((*(void *(*)P_((void)))kernel->dos_tab[0x2f])())
#define c_conout(a)	((*(long (*)P_((int)))kernel->dos_tab[0x2])(a))
#define t_getdate()	((*(_wORD (*)P_((void)))kernel->dos_tab[0x2a])())
#define t_gettime()	((*(_wORD (*)P_((void)))kernel->dos_tab[0x2c])())
#define p_termres(a,b)	((*(void (*)P_((long,int)))kernel->dos_tab[0x31])(a,b))
#define m_alloc(a)	((*(void *(*)P_((long)))kernel->dos_tab[0x48])(a))
#define f_select(a,b,c,d)	((*(long (*)P_((unsigned,long *,long *,long *)))kernel->dos_tab[0x11d])(a,b,c,d))
#define d_cntl(a,b,c)	((*(long (*)P_((int,const char *,void *)))kernel->dos_tab[0x130])(a,b,c))
#define p_getpid()	((*(_wORD (*)P_((void)))kernel->dos_tab[0x10b])())
#define p_getppid()	((*(_wORD (*)P_((void)))kernel->dos_tab[0x10c])())
#define p_getpgrp()	((*(_wORD (*)P_((void)))kernel->dos_tab[0x10d])())
#define p_getuid()	((*(_wORD (*)P_((void)))kernel->dos_tab[0x10f])())
#define p_getgid()	((*(_wORD (*)P_((void)))kernel->dos_tab[0x114])())
#define p_geteuid()	((*(_wORD (*)P_((void)))kernel->dos_tab[0x138])())
#define p_getegid()	((*(_wORD (*)P_((void)))kernel->dos_tab[0x139])())

/* Kernel entry points */

/* media change vector */
#define drvchng	(*kernel->drvchng)

/* Debugging stuff */
#define TRACE(x)	(*kernel->trace) x
#define DEBUG(x)	(*kernel->debug) x
#define ALERT(x)	(*kernel->alert) x
#define FATAL(x)	(*kernel->fatal) x

/* memory allocation functions */
#define kmalloc	(*kernel->kmalloc)
#define kfree	(*kernel->kfree)
#define umalloc	(*kernel->umalloc)
#define ufree	(*kernel->ufree)

/* utility functions for string manipulation */
#define strnicmp	(*kernel->strnicmp)
#define stricmp	(*kernel->stricmp)
#define strlwr	(*kernel->strlwr)
#define strupr	(*kernel->strupr)
#define sprintf	(*kernel->sprintf)

/* utility functions for manipulating time */
#define millis_time	(*kernel->millis_time)
#define unixtim	(*kernel->unixtim)
#define dostim	(*kernel->dostim)

/* utility functions for dealing with pauses */
#define nap	(*kernel->nap)
#define sleep	(*kernel->sleep)
#define wake	(*kernel->wake)
#define wakeselect	(*kernel->wakeselect)

/* file system utility functions */
#define denyshare	(*kernel->denyshare)
#define denylock	(*kernel->denylock)

/* functions for adding/cancelling timeouts */
#define addtimeout	(*kernel->addtimeout)
#define canceltimeout	(*kernel->canceltimeout)

/* Some useful kernel defines */
#define CURPROC_Q	0
#define READY_Q		1
#define WAIT_Q		2
#define IO_Q		3
#define ZOMBIE_Q	4
#define TSR_Q		5
#define STOP_Q		6
#define SELECT_Q	7

#endif /* _kernel_h */
