Hi all,

This is a port of libg++, version 2.7.1, the standard and class library 
for the GNU-C++ 2.7.x compiler.  It's intended to be a supplement for the
GNU-C++ 2.7.2 distribution on CD from `Software Service Seidel', which
claims to be a complete C++ development system, but is in fact far from 
complete.

This archive (`libgp271b.tgz') contains the libraries, compiled with the
2.7.2 compiler (32 bit, no -mbaserel), the header files, the prototype
templates including the necessary script to create concrete templates,
some README files and the complete documentation in dvi and info format.
Also there is `gperf' and two other programs, which may serve as a proof that
the libraries work.

Although I had some memory problems (4MB MegaSTE; there is no way to get
GNU-C++ running with less memory) all library files were compiled with 
-O2 -fno-implicit-templates.  All tests were successful, except for a very 
small number of tests I couldn't compile due to lack of memory.

The Makefiles are for my purpose only.  I included them only because
I wanted to have all files together.  They are *not* suitable for recompiling
the complete sources (E.g. I had to compile several files separately),
so it's best to ignore them.

The only ATARI specific changes I made were to disable long double i/o and
long double complex functions, because the MiNT lib has no runtime support
for long double.

I couldn't compile the `CursesW' class from libg++, because the `curses.h'
file from the MiNT lib has conflicting prototype declarations for most
functions.


The libraries
-------------
`libstdc++.a': This is the main library, which includes, apart from some other
files, the C++ -style stream-i/o.  Most of the time this lib is all you need.
The standard streams `cin', `cout' and `cerr' use the underlying C FILEs
`stdin', `stdout' and `stderr' and the functions fgetc(), fread() etc.  Thus
the C++ standard streams are in binary or text mode depending on the mode of
the C files.  But the C++ file streams use direct i/o with read() and write(),
so there is no translation of the type of line-ending and several of the
stream functions to act on lines of text depend on LF being the only
line delimiter.  Thus, to avoid problems, you should use only files with
Unix-style line-endings.

`libstdio++.a': If you want to do standard C i/o, e.g. printf(), on top of
the C++ stream-io, you can add this lib to linker input.  Using this lib
you can switch between C- and C++ -style i/o on a per-character basis
without synchronising.  Note that you have to mention this lib before
libstdc++ on the command line.

`libio.a': I think this was only needed for testing the i/o libraries, but
I'm not sure, so it's included (just in case).

`libg++.a': This is the GNU-C++ class library, providing many useful classes.
I added a newer version of librx to libg++.  Note that you need at least
32kB of stack size if you want to use regular expressions; this applies
especially to class `String' which uses librx.


Installation
------------
Copy the libraries into the same directory that contains your C libraries;
the environment variable `GNULIB' points to it.  Depending on the linker 
version you're using you may have to remove the `lib' prefix from the
library names and/or replace the `.a' suffix with `.olb'.  The `g++'
(`gplus') compiler driver automatically links [lib]g++, [lib]stdc++ and
[lib]m (pml), whereas `gcc' doesn't link any C++ specific libraries itself,
you can specify the ones you need yourself.

The header files from `g++-include' (including subdirectories) have to be
copied to a directory on a case sensitive file system that allows more
than 8+3 character file names.  You probably can use a TOS file system if
you rename `iostreamP.h' to `xiostrea.h' and `String.h' to `xstring.h'
*and* replace all occurences of these files in other files accordingly. 
The environment variable `CPLUS_INCLUDE_PATH' points to this directory;
alternatively you can use `GXXINC'.
If you want to use the script `genclass' to generate class files from
the prototypes, you first have to adjust the internal variable `PROTODIR'
to the full path of the directory which contains the prototype files
(.../gen/*).
The two ordinary C header files `rx.h' and `iso646.h' belong to your other
C headers; the environment variable `GCCINC' or `C_INCLUDE_PATH' points
to the relevant directory.



Although version 2.7.2 of the C++ compiler has support for exceptions
you cannot actually use them, because the relevant function 
(--> __unwind_function()) from the new `libgcc2.c' of the compiler source
distribution hasn't been ported to ATARI or any other m68k-based system.
(doesn't belong porting libgcc to a "complete development system"...?)
If someone managed to implement this function, please send me a mail!



Holger Kleinschmidt
Promenadenstr. 11 B
D-12207 Berlin

holgerkl@cs.tu-berlin.de
