/* An example of Cookie Jar access using Ssystem() */
/* Lists all present tag ids and corresponding values. Draco, 7.XII.1997. */

#include <stdio.h>
#include <mintbind.h>
#include <ssystem.h>

int main()
{
	unsigned long count = 1;
	unsigned long cjaradr;
	int r = 0;
	unsigned long jarsize, tag_id, value;

	printf("\nA simple Cookie Jar lister for MiNT versions >= 1.14.6\nDone by Draco, Warszawa, 7.XII.1997.\n\n");

	r = (int)Ssystem(-1, NULL, NULL);

	if (r) {
		printf("No kernel support to perform this action.\n");
		return r;
	}

	printf("ID   Hex val   Dec val\n---- --------- -------\n");

	/* Notice the first slot has number 1. Given 0 you'll get the
	   value of the LAST slot (i.e. NULL cookie) */

	while((tag_id = Ssystem(GETCOOKIE, count, NULL)) != -1) {
		count++;
		value = Ssystem(GETCOOKIE, tag_id, NULL);
		if (tag_id)
			printf("%s $%08lx %10ld\n", (char *)&tag_id, value, value);
		else {
			printf("NULL $%08lx %10ld\n", value, value);
			jarsize = value;
		}
	}
	/* Here's an example of obtaining Cookie Jar address */
	cjaradr = Ssystem(GET_LVAL, 0x000005a0L, NULL);

	printf("\nThe Cookie Jar lives at $%08lx,\nits total size is %ld slots, %ld slots are free.\n\n", cjaradr, jarsize, jarsize-count+1);  
	return r;
}
