/*
 * net/if_arp.h for MintNet, (w) 1994 Kay Roemer.
 */

#ifndef _NET_IF_ARP_H
#define _NET_IF_ARP_H

/* ARP hardware types */
#define ARPHDR_ETHER	1

/* structure passed on SIOC?ARP ioctl's */
struct arpreq {
	struct sockaddr	arp_pa;		/* protocol address */
	struct sockaddr	arp_ha;		/* hardware address */
	short		arp_flags;	/* ATF_* flags */
};

#define ATF_PRCOM	0x01		/* pr address valid */
#define ATF_COM		0x02		/* hw address valid */
#define ATF_PERM	0x04		/* static entry */
#define ATF_PUBL	0x08		/* proxy entry */
#define ATF_USETRAILERS	0x10		/* not implemented */
#define ATF_NORARP	0x20		/* don't use for answering RARP req */

#endif
