/* MD5 interface function MD5String()
 * implemented according rfc1321 and example in mddriver.c:
 *  (Copyright (C) 1990-2, RSA Data Security, Inc. Created 1990. All
 *   rights reserved.)
 * (C) jerry g geiger 1995
 */


#include <string.h>
#include "global.h"
#include "md5.h"

/* Digests a string and returns the result.
 * <result> maybe NULL - then an internal buffer is used and returned
 * or a pointer to a 16 unsigned chars array.
 */
static unsigned char mydigest[16];

unsigned char *MD5String (char *string, unsigned char *result)
{
	MD5_CTX context;
	unsigned char *digest;
	unsigned int len = strlen (string);
	bzero(&context, sizeof(MD5_CTX));
	if(!(digest = result) )
		digest = mydigest;
	
	MD5Init (&context);
	MD5Update (&context, string, len);
	MD5Final (digest, &context);

	return(digest);
}


/* Digests a string and returns the result as string of hex bytes,
 * 32 bytes long, with lowercase letters.
 * <buf> maybe NULL - then an internal buffer is used and returned
 * or a pointer to an array of at least 33 chars.
 */

static char mystring[34];

char *MD5digest(char *string, char *buf)
{
	char *d_string, *p, v;
	int i;
	
	if(!(d_string = buf) )
		d_string = mystring;

	MD5String(string, NULL);
	p = d_string;

	for (i = 0; i < 16; i++) {
#if 1
		v = (mydigest[i]>>4)&0xf;
		*p++ = v + (v > 9 ? 87 : '0');
		v = mydigest[i]&0xf;
		*p++ = v + (v > 9 ? 87 : '0');
#else
		sprintf(p,"%02x", mydigest[i]);
		p += 2;
#endif
		mydigest[i] = 0;
	}
	*p = 0;	
	return(d_string);
}
/* eof */
