/* @(#)main.c, pop3 
 * Copyright (c) 1994/95/96 jerry g geiger
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms.
 * This program my not be sold in any way!
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * This program's code is based on ftp-client code 
 * ftp Copyright (c) 1985, 1989 Regents of the University of California.
 *
 * This code implements the Post Office Protocol version 3 (rfc 1725).
 * It handles incomming mails according rfc 822.
 *
 * pop3 history:
 * vers 1.0 : rfc1725
 * vers 0.8 : rfc1460
 * vers 0.5 : rfc1225
 *
 * pop3 future: ??
 * vers 1.1 : rfc1725, rfc1734
 */

#define _mainPOP3

char copyright[] =
"@(#) Copyright (c) 1994,95,96 jerry g geiger\n\
 All rights reserved.\n";

#define PATCHLEV "6"
#define MINVERS	"0"
#define MAJVERS	"1"

char Version[] = MAJVERS "." MINVERS "." PATCHLEV ;

static char Sccsid[] = "@(" "#)pop3, v " MAJVERS "." MINVERS "." PATCHLEV " jerry g geiger " __DATE__;
static char ID[] = "$" "Id: pop3 v" MAJVERS "." MINVERS "." PATCHLEV " (c) j g geiger " __DATE__ " $";
#ifdef SCCS
static char sccsid[] = "@(#)main.c, pop3 jerry g geiger Jan 18 1996";
#endif 
static char progname[] = "pop3";

char *myname = progname;

/*
 * pop3 client -- User Program -- Command Interface.
 */
#include "pop3.h"

#include <pwd.h>



#if defined(sun) && !defined(FD_SET)
typedef int uid_t;
#endif

uid_t	getuid();
sig_t	intr();
sig_t	lostpeer();
extern	char *home;
char	*getlogin();

struct servent *sp = NULL;
static char username[80] = "";	/* this process' user's name	*/
static char localhostname[MAXDOMAINNAMELEN+1] = "";
char *the_user = NULL;			/* -> username */
char *the_host;					/* -> localhost 	*/
static char *recipient;	/* name used for non interactive auto-mail-delivery	*/
static int recip_uid;
static char *deliver_box = NULL;	/* use mailbox instead of maildir/user */
static char *deliver_cmd = NULL;	/* cmd used but _PATH_DELIVER */
char logfile[] = pop3LOG;			/* see pathnames.h	*/
char spooldir[] = pop3SPOOLDIR;
/* char maildir[] = _PATH_MAIL; */
char id_prefix[] = "YYMMDDhhmmsspppppppp"; /* ->make_id_prefix()*/


#ifdef __MINT__
	extern int __default_mode__;
#endif

void usagehelp() 
{
	fprintf(stderr, "%s: usage\n", myname);
	fprintf(stderr, 
		"%s [-hvdib] {-no[login]|[deliver]|[delete]} [-t <name>]\n"
		"\t [-Dcmd <cmd>] [-onlydeliver] [host]\n",
/*		"\t [-Dmbox <path>]|[-D <cmd>] [host]\n", */
		myname);
	exit(0);
}	
void usage( char c, char *arg )
{
	fprintf(stderr,
	  "%s: <%c> unknown option in '%s'\n\ttry -h\n", myname, c, arg);
	exit(1);
}

void myerror(char *msg, int num)
{
	if(interactive > 1)
		printf("%s error: %s\n", msg, num ? strerror(num): "");
	else
		fprintf(stderr, "%s(%d): %s: %s\n", myname, getpid(), msg,
						 num ? strerror(num): "");
}

static int nest = 0;

void fatal(char *msg, char *msg2, int error)
{
	nest++;
	fprintf(stderr, "%s(%d):fatal %s(%s): %s\n", myname, getpid(), msg,
				msg2, error ? strerror(error) : "");

	if(nest < 2)
		logmessage(LOGFATAL, msg, msg2, error ? strerror(error) : "");

	if(nest < 2 && connected)
		disconnect();

	if(nest < 2 && recmsgs)
		savelist();

	exit(1);
}


void getmydomain()
{
	char *cp1; int i;
	char buf[MAXDOMAINNAMELEN+1];
	
	if(!gethostname(buf, MAXDOMAINNAMELEN)) {
		cp1 = buf + (i = strlen(buf));
		*cp1++ = '.'; i++;
		if(getdomainname(cp1, MAXDOMAINNAMELEN-i))
			*--cp1 = '\0';
		else
			buf[MAXDOMAINNAMELEN] = '\0';
		strcpy(localhostname, buf);
	} else
		*localhostname = '\0';
}




main(argc, argv)
	char *argv[];
{
	register char *cp;
	int top; int succ = 0; 	int deletemails, deliveronly, fd;
	struct passwd *pwent;
	
	if(*argv && **argv) {
		if(cp = strrchr(*argv, '/'))
			myname = ++cp;
		else
			myname = *argv;
	}

	setgid(getegid());
	/* check log file */
	if( (fd = open(logfile, O_RDWR|O_EXCL|O_CREAT, 0664)) > 0 ) {
		close(fd);
		chown(logfile, geteuid(), getegid());
	} else {
		if (access(logfile, W_OK))
			fatal("log file", logfile, errno);
	}
	if (access(spooldir, W_OK))
		fatal("spool dir", spooldir, errno);

	
	make_id_prefix();

	getmydomain();
	the_host = 	localhostname;
	the_user = strncpy(username, getlogin(), 80);

#ifdef __MINT__
	__default_mode__ |= _IOBIN;
#endif

	sp = getservbyname("pop3", "tcp");
	if (sp == 0)
		fatal("pop3/tcp: unknown service", "", 0 );


	/* default setup:
		auto login on arg <host> from '$HOME/.netrc'
		get mails from host to login user($HOME/.netrc) and delete 
		  them on remote host <host> 
		  - if succesfull received & stored
		deliver the mails on local host using 
			'/usr/lib/sendmail <USER> < received mail'
	*/
	interactive = 0;
	verbose = 0;
	autologin = TRUE;
	autodeliver = TRUE;
	deletemails = TRUE;
	deliveronly = FALSE;
	keepbadmsgs = FALSE;
	getmails4host = FALSE;

	argc--, argv++;
	while (argc > 0 && **argv == '-') {
		for (cp = *argv + 1; *cp; ) {
			switch (*cp++) {
			case 'd':
				options |= SO_DEBUG;
				debug++;
				break;
			case 'v':
				verbose++;
				break;
			case 'i':
				interactive = 1;
				break;
			case 'b':
				bell = 1;
				break;
			case 'n':
				if(*cp == 'o') {
					if( !strcmp(++cp,"login") )
						autologin = FALSE;
					else if( !strcmp(cp,"deliver") )
						autodeliver = FALSE;
					else if( !strcmp(cp,"delete") )
						deletemails = FALSE;
					else
						usage(' ', cp);
				} else
					usage(*--cp, *argv);
				cp = "";
				break;
			case 'o':
				if(!strcmp(--cp, "onlydeliver")) {
					deliveronly = TRUE;
					cp = "";
				} else
					usage(*--cp, *argv);
				break;				
			case 'h':
				usagehelp();
				break;
			case 't':
				if(*cp) {
					recipient = cp;
				} else {
					if(argc > 1) {
						argc--; argv++;
						recipient = *argv;
					} else {
						fprintf(stderr,
							"%s: missing username '-t <name>'\n", 
							myname);
						exit(1);
					}
				}
				cp = "";
				break;
				case 'D':
					if(argc > 1) {
						if( !strcmp(cp,"cmd") )
							deliver_cmd = *++argv;
						else if( !strcmp(cp,"box") )
							deliver_box = *++argv;
						else
							usage(' ', cp);
						argc--;
					} else {
						fprintf(stderr,
							"%s: missing argument '-D... <arg>'\n", 
							myname);
						exit(1);
					}
					cp = "";
				break;
			default:
				usage(*--cp, *argv);
			}
		}
		argc--, argv++;
	}

	fromatty = isatty(fileno(stdin));

	if(recipient) {
		if(pwent = getpwnam(recipient))
			recip_uid = pwent->pw_uid;
		else {
			recip_uid = geteuid();
			myerror("no passwd entry for recipient", 0);
		}
	}

	if(interactive) {
		if (fromatty) {
			verbose++;
			interactive = 2;
			printf("%s: started on %s\n", myname, localhostname);
		}
	}
	if(deliveronly) {
		succ = do_deliverqueue(recipient ? recipient : the_user,
							recipient ? recip_uid : getuid(),
							deliver_box ? deliver_box : NULL,
							deliver_cmd ? deliver_cmd : _PATH_DELIVER);
		exit(succ ? 0 : 1);
	}

	if ((argc > 0) || !interactive ) {
		if (setjmp(toplevel))
			exit(0);
		(void) signal(SIGINT, intr);
		(void) signal(SIGPIPE, lostpeer);
		if(argc > 0)
			setpeer(argc + 1, argv - 1);
		else {
			if( hookup(NULL, sp->s_port) && autologin )
				(void) login(hostname);
		}
		if(!interactive) { 
			if( connected < TRANSACT) {
				myerror("Auto-Login failed - exit.", 0);
				exit(1);
			}
			succ = get_mails(deletemails);
			disconnect();
			if(succ) {
				if(autodeliver) {
					succ = do_deliver(recipient ? recipient : the_user,
							recipient ? recip_uid : getuid(),
							deliver_box ? deliver_box : NULL,
							deliver_cmd ? deliver_cmd : _PATH_DELIVER);
					if(!succ)
						savelist();
				} else
					savelist();
			}
			exit(succ ? 0 : 1);	
		}	/* else: intercative */
	}

	if(verbose)
		showstatus(0, NULL);
	top = setjmp(toplevel) == 0;
	if (top) {
		(void) signal(SIGINT, intr);
		(void) signal(SIGPIPE, lostpeer);
	}

	for (;;) {
		cmdscanner(top);
		top = 1;
	}
	return(0);	/* NOTREACHED	*/
}

sig_t
intr()
{

	longjmp(toplevel, 1);
}

sig_t
lostpeer()
{
	extern FILE *cout;

	if (connected) {
		if (cout != NULL) {
			(void) shutdown(fileno(cout), 1+1);
			(void) fclose(cout);
			cout = NULL;
		}
		connected = 0;
	}
	if (verbose) {
		printf("remote server has closed connection\n");
		(void) fflush(stdout);
	} else
		myerror("EOF on socket! - lost peer", 0);

	logmessage(LOGLOSTPEER);
}

/*
 * Command parser.
 */
void cmdscanner(top)
	int top;
{
	register struct cmd *c;
	struct cmd *getcmd();
	extern int help();

	if (!top)
		(void) putchar('\n');
	for (;;) {
		if (fromatty) {
			printf("pop3> ");
			(void) fflush(stdout);
		}
		if (gets(line) == 0) {
			if (feof(stdin) || ferror(stdin))
				quit();
			break;
		}
		if (line[0] == 0)
			break;
		if (line[0] == '#')
			continue;
		makeargv();
		if (margc == 0) {
			continue;
		}
		c = getcmd(margv[0]);
		if (c == (struct cmd *)-1) {
			printf("?Ambiguous command\n");
			continue;
		}
		if (c == 0) {
			printf("?Invalid command\n");
			continue;
		}
		if (c->c_conn && (connected < c->c_conn) ){
			if(! connected)
				printf ("Not connected.\n");
			else if(connected < TRANSACT)
				printf ("Not in TRANSACTION state.\n");
			else
				printf ("Command not available now.\n");
			continue;
		}
		if (connected > c->c_mstate) {
			if(connected == TRANSACT)
				printf("Already logged in.\n");
			else
				printf ("Already connected.\n");
			continue;
		}

		(*c->c_handler)(margc, margv);
		if (bell && c->c_bell)
			if(c->c_bell == 1 || (c->c_bell > 1 && margc != c->c_bell))
				(void) putchar('\007');
		if (c->c_handler != help)
			break;
	}

	(void) signal(SIGINT, intr);
	(void) signal(SIGPIPE, lostpeer);
}

struct cmd *
getcmd(name)
	register char *name;
{
	extern struct cmd cmdtab[];
	register char *p, *q;
	register struct cmd *c, *found;
	register int nmatches, longest;

	longest = 0;
	nmatches = 0;
	found = 0;
	for (c = cmdtab; p = c->c_name; c++) {
		for (q = name; *q == *p++; q++)
			if (*q == 0)		/* exact match? */
				return (c);
		if (!*q) {			/* the name was a prefix */
			if (q - name > longest) {
				longest = q - name;
				nmatches = 1;
				found = c;
			} else if (q - name == longest)
				nmatches++;
		}
	}
	if (nmatches > 1)
		return ((struct cmd *)-1);
	return (found);
}

/*
 * Slice a string up into argc/argv.
 */

int slrflag;

void makeargv()
{
	char **argp;
	char *slurpstring();

	margc = 0;
	argp = margv;
	stringbase = line;		/* scan from first of buffer */
	argbase = argbuf;		/* store from first of buffer */
	slrflag = 0;
	while (*argp++ = slurpstring())
		margc++;
}

/*
 * Parse string into argbuf;
 * implemented with FSM to
 * handle quoting and strings
 */
char *
slurpstring()
{
	int got_one = 0;
	register char *sb = stringbase;
	register char *ap = argbase;
	char *tmp = argbase;		/* will return this if token found */

	if (*sb == '!' || *sb == '$') {	/* recognize ! as a token for shell */
		switch (slrflag) {	/* and $ as token for macro invoke */
			case 0:
				slrflag++;
				stringbase++;
				return ((*sb == '!') ? "!" : "$");
				/* NOTREACHED */
			case 1:
				slrflag++;
				altarg = stringbase;
				break;
			default:
				break;
		}
	}

S0:
	switch (*sb) {

	case '\0':
		goto OUT;

	case ' ':
	case '\t':
		sb++; goto S0;

	default:
		switch (slrflag) {
			case 0:
				slrflag++;
				break;
			case 1:
				slrflag++;
				altarg = sb;
				break;
			default:
				break;
		}
		goto S1;
	}

S1:
	switch (*sb) {

	case ' ':
	case '\t':
	case '\0':
		goto OUT;	/* end of token */

	case '\\':
		sb++; goto S2;	/* slurp next character */

	case '"':
		sb++; goto S3;	/* slurp quoted string */

	default:
		*ap++ = *sb++;	/* add character to token */
		got_one = 1;
		goto S1;
	}

S2:
	switch (*sb) {

	case '\0':
		goto OUT;

	default:
		*ap++ = *sb++;
		got_one = 1;
		goto S1;
	}

S3:
	switch (*sb) {

	case '\0':
		goto OUT;

	case '"':
		sb++; goto S1;

	default:
		*ap++ = *sb++;
		got_one = 1;
		goto S3;
	}

OUT:
	if (got_one)
		*ap++ = '\0';
	argbase = ap;			/* update storage pointer */
	stringbase = sb;		/* update scan pointer */
	if (got_one) {
		return(tmp);
	}
	switch (slrflag) {
		case 0:
			slrflag++;
			break;
		case 1:
			slrflag++;
			altarg = (char *) 0;
			break;
		default:
			break;
	}
	return((char *)0);
}



/*
 * Help command.
 * print all commands (no args) or the help string for alls args
 * define TEST_HWIDTH if pop3 should calculate a columns related
 * output in args mode
 */
#if TEST_HWIDTH
static int hwidth = 0;
#define HWIDTH  hwidth
#else
#define HWIDTH  21
#endif

int help(argc, argv)
	int argc;
	char *argv[];
{
	extern struct cmd cmdtab[];
	register struct cmd *c; char *np; int columns, i, j;
	extern int NCMDS;

	if(np = getenv("COLUMNS"))
		columns = atoi(np);
	else
		columns = 80;

	if (argc == 1) {
		register int w, k;
		int width = 0, lines;

		printf("Commands may be abbreviated.  Commands are:\n\n");
		for (c = cmdtab; c < &cmdtab[NCMDS]; c++) {
			int len = strlen(c->c_name)+1;

			if (len > width)
				width = len;
		}
		width = (width + 8) &~ 7;
		if(np = getenv("COLUMNS"))
			columns = atoi(np) / width;
		else
		columns /= width;
		if (columns == 0)
			columns = 1;
		lines = (NCMDS + columns - 1) / columns;
		for (i = 0; i < lines; i++) {
			char cstat;
			for (j = 0; j < columns; j++) {
				c = cmdtab + j * lines + i;
				if (c->c_name) {
					if(c->c_conn == NOTIMPL)
						cstat = '*';
					else if((c->c_conn == ISLOCKED) ||
							(c->c_conn > connected) ||
							(c->c_mstate < connected) )
						cstat = '#';
					else
						cstat = ' ';
					printf("%c%s", cstat, c->c_name);
#if 0
					for (k=0; k < (int)strlen(c->c_name); k++) {
						(void) putchar(' ');
					}
#endif
				}
				if (c + lines >= &cmdtab[NCMDS]) {
					printf("\n");
					break;
				}
				w = strlen(c->c_name)+1;
				while (w < width) {
					w = (w + 8) &~ 7;
					(void) putchar('\t');
				}
			}
		}
		printf("\n'*': not implemented; '#': not in current status\n");
		return(0);
	}
#if TEST_HWIDTH
	if(!hwidth) {
		for (c = cmdtab; c < &cmdtab[NCMDS]; c++) {
			int len = strlen(c->c_name) +strlen(c->c_help[0]) +5;
			if((np = strchr(c->c_help[1],'\n')))
				i = np - c->c_help[1];
			else
				i = strlen(c->c_help[1]);
			if(len < columns - i) {
				if (len > hwidth)
					hwidth = len;
			}
		}
		hwidth -= 5;
		if(debug)
			printf("Hwidth = %d\n", hwidth);
	}
#endif
	while (--argc > 0) {
		register char *arg;
		arg = *++argv;
		c = getcmd(arg);
		if (c == (struct cmd *)-1)
			printf("?Ambiguous help command %s\n", arg);
		else if (c == (struct cmd *)0)
			printf("?Invalid help command %s\n", arg);
		else {
			if((np = strchr(c->c_help[1],'\n')))
				i = columns - (np - c->c_help[1]);
			else
				i = columns - strlen(c->c_help[1]);
			i -= 5;
			if((j = strlen(c->c_name) + strlen(c->c_help[0])) < HWIDTH)
				j = HWIDTH;
			if(i >= j )
				printf("%s %-*s    %s\n", c->c_name, HWIDTH - strlen(c->c_name),
					c->c_help[0], c->c_help[1]);				
			else
				printf("%s %s\n\t%s\n", c->c_name, c->c_help[0], c->c_help[1]);

		}
	}
	return(0);
}

/* 
 * we need the local date for the id_prefix string
 * and we check the paths here
 * and we make the rfc0822 TimeZone string for later usage here.
 */
static char tzstring[20];

void make_id_prefix()
{
	char buf[80];
	char *pn, *s, *p;
	int sign, h, m, fd;
	time_t ti;
	struct tm *titm;
	
	time(&ti);
	titm = localtime(&ti);
	/* In file systems with very restricted filenames id_prefix
	 * has to be small enough! The spool file names get a suffix, too!
	 * Maybe in future I will add some testing mechanism. 
	 * I think more than one connection per second won't happen.
	 */
	sprintf(id_prefix, "%02d%c%02d%c%02d%02d%04d", titm->tm_year, 
		titm->tm_mon+'a', titm->tm_mday, titm->tm_hour+'a', titm->tm_min, 
		titm->tm_sec, getpid() );

	if(*tzstring)
		return;
	
	if(s = getenv("TZ")) {
		s = strncpy(buf, s, 80);
		pn = s;
		while(isalpha(*s))
			s++;
		if(!*s)	/* no UT-west-offset	*/
			strcpy(tzstring, pn);
		else {
			if(*s == '-')	/* TZ: hh:mm west of UT --> offset UT	*/
				sign = '+';
			else
				sign = '-';
			p = s;	/* this char terminates TZ name	*/
			if((*s == '+')||(*s == '-'))
				s++;
			h = m = 0;
			while(isdigit(*s))
				h = h * 10 + (*s++ - '0');
			if(*s == ':')
				s++;
			while(isdigit(*s))
				m = m * 10 + (*s++ - '0');

			if(titm->tm_isdst > 0) { /* isdaylightsaving */
				h += 1;	/* we have to add some daylight-saving-time 	*/
				if(isalpha(*s)) { /* and another time-zone name */
					pn = s;
					while(isalpha(*s))
						s++;
					p = s;
				}
			}

			*p = '\0';
			sprintf(tzstring, "%c%02d%02d (%s)", sign, h, m, pn);
			/* time-zone is a comment if we have the UT offset	*/
		}
	} else {
		strcpy(tzstring, "UT");
	}

	return;
}

static char *month[] = {"Jan", "Feb", "Mar", "Apr",
		"May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
static char *wday[] = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };


char *rfc822_time(char *buf)
{
	time_t cur_time;
	struct tm *tm_t;

//	if(!*tzstring)
//		make_tzstring();
	
	/* the current time	*/
	time(&cur_time);
	tm_t = localtime(&cur_time);

	
	sprintf(buf, "%s, %d %s %d %02d:%02d:%02d %s", wday[tm_t->tm_wday],
			tm_t->tm_mday, month[tm_t->tm_mon], tm_t->tm_year,
			tm_t->tm_hour, tm_t->tm_min, tm_t->tm_sec, tzstring);
	
	return(buf);
}
