
/*
**
*/

#include "config.h"

	/* This is just to help track what is always being included */
#ifndef I_ALWAYS
# define I_ALWAYS
#endif

#ifndef I_TIME
# ifdef I_SYS
#  define I_TIME
# endif
#endif

	/* This helps avoid conflicts when using libtermnet.a */
#if defined(I_ERRNO)
# include <errno.h>
#endif

#ifdef I_CTYPE
# include <ctype.h>
#endif

#ifdef I_ALWAYS
# ifdef __MINT__
#  include <support.h>
#  include "portlib.h"
# endif
# ifndef titan
#  include <sys/types.h>
#  ifdef ISC
#   include <sys/bsdtypes.h>
#   include <net/errno.h>
#  endif /* ISC */
# else
#  include <types.h>
# endif
#endif

#ifdef I_IOCTL
# if !defined(I_TTY) || !defined(sun) || defined(SVR4)
#  include <sys/ioctl.h>
# endif
# if defined(SVR4)
#  include <sys/filio.h>		/* FIONREAD */
# endif
# include <fcntl.h>
# ifndef FD_CLOEXEC
#  define FD_CLOEXEC 1
# endif
#endif

#ifdef I_STRING
# include <string.h>
#endif

#ifdef I_ALWAYS
# if !defined(NO_UNIX_DOMAIN)
#  include <sys/un.h>
# endif
# include <netinet/in.h>
# include <netdb.h>
# include <sys/socket.h>
# ifdef SYSV
#  include <sys/utsname.h>
# endif
# ifdef SVR4
   int accept(int, struct sockaddr *, int *);
   int bind(int, struct sockaddr *, int);
   int connect(int, struct sockaddr *, int);
   int listen(int, int);
   int socket(int, int, int);
   int socketpair(int, int, int, int[]);
   int shutdown(int, int);
   int gethostname(char *, size_t);
#ifdef UNIX_SV
   int recvfrom(int,char *,int,struct sockaddr *,int);
   int sendto(int,char *,int,struct sockaddr *,int);
   int getpeername(int, struct sockaddr *, int);
   int getsockname(int, struct sockaddr *, int);
   int rcmd(char **,unsigned short, char *, char *, char *, int *);
#endif
# endif
# ifdef SVR3
#  define socketpair term_socketpair
# endif
# ifndef NO_UNIX_DOMAIN
#  define S_Pipe(soc) socketpair(AF_UNIX, SOCK_STREAM, 0, soc) 
# else
#  ifndef SCO
#   define S_Pipe(soc) socketpair(AF_INET, SOCK_STREAM, 0, soc)
#  else
#   define S_Pipe(soc) s_pipe(soc)
#  endif
# endif
#endif

#ifdef I_GETOPT
  int term_getopt(int argc, char *argv[], char *optstring);
  extern char *term_optarg;
  extern int term_optind, term_opterr, term_optopt;
#endif

#ifdef I_TTY
# ifdef USE_TERMIOS
#   include <termios.h>
# else
#  include <sgtty.h>
# endif
#endif

#ifdef I_ALWAYS
# include <stdio.h>
# ifndef titan
#  include <stdlib.h>
# else
   extern char *getenv(char *name);
#  include <malloc.h>
# endif /* titan */
# ifndef NeXT
#  include <unistd.h>
# endif
# if defined(ultrix) || defined(NeXT)
#  include <sys/file.h>
# endif
# ifndef R_OK
#  define R_OK 4
# endif
# ifndef W_OK
#  define W_OK 2
# endif
# ifndef X_OK
#  define X_OK 1
# endif
# ifndef IXANY
#  define IXANY 0
# endif
# if !defined(ONLCR) && defined(__QNX__)
#  define ONLCR OPOST
# endif
# ifndef STDIN_FILENO
#  define STDIN_FILENO 0
# endif
# ifndef USE_HERROR
#  define herror term_herror
void term_herror(char *);
# endif
# ifdef NO_VFORK
#  define vfork fork
# endif
# ifdef USE_ONEXIT
#  define atexit(procp) on_exit(procp, 0)
# endif
# ifdef NO_ATEXIT
#  define atexit(procp) while(0)
# endif
#endif

#ifdef I_SIGNAL
# include <signal.h>
# ifndef SIGWINCH
#  define SIGWINCH SIGWINDOW 
# endif
#endif

#ifdef I_TIMES
# include <sys/times.h>
#endif

#ifdef I_TIME
# include <sys/time.h>
# ifdef USE_STIME
#  define gettime(a) get_process_stats(a,getpid(),0,0)
#  define settime(a) stime(a)
# else
#  ifdef SVR4
    int gettimeofday(struct timeval *);
    int settimeofday(struct timeval *);
#   define gettime gettimeofday
#   define settime settimeofday
#  else
#   define gettime(a) gettimeofday((a), (struct timezone *)0)
#   define settime(a) settimeofday((a), (struct timezone *)0)
#  endif
# endif
#endif

#ifdef I_UTIME
# if !defined(titan) && !defined(NeXT)
#  include <utime.h>
# else
          struct    utimbuf        {
               time_t      actime; /* access time */
               time_t      modtime;/* modification time */
          };
# endif
#endif


#ifdef I_ARGS
# ifndef NO_VSPRINTF
#  ifndef USE_VARARGS
#   include <stdarg.h>
#  else /* USE_VARARGS */
#   include <varargs.h>
#  endif /* USE_VARARGS */
# else /* NO_VSPRINTF */
#  define va_alist a1,a2,a3,a4,a5,a6,a7,a8,a9
#  define va_dcl long a1,a2,a3,a4,a5,a6,a7,a8,a9;
#  define vsprintf(buf,fmt,v) sprintf((buf),(fmt),a1,a2,a3,a4,a5,a6,a7,a8,a9)
#  define va_list int
#  define va_start(v)
#  define va_end(v)
#  define USE_VARARGS
# endif /* NO_VSPRINTF */
#endif /* I_ARGS */

#ifdef I_SYS
# if defined (_AIX) || defined(__QNX__) || defined(DYNIXPTX)
#  include <sys/select.h>
# endif
# if defined(DYNIXPTX) || defined(SVR4)
   int select(int, fd_set *, fd_set *, fd_set *, struct timeval *);
# endif
#endif

#ifdef I_INET
# include <arpa/inet.h>
#endif

#ifdef I_PARAM
# include <sys/param.h>
#endif

#ifdef I_MEMORY
# ifndef convex
#  include <memory.h>
# endif
#endif

#ifdef I_PWD
# include <pwd.h>
#endif

#ifdef I_PROCESS
# ifdef __QNX__
#  include <process.h>
# endif
#endif

#ifdef I_WAIT
# include <sys/wait.h>
#endif

#ifdef I_STROPT
# if defined(SCO) || defined(SYSV) || defined(SVR3)
#  include <stropts.h>
# endif
#endif

#ifdef I_POLL
# ifdef SVR3
#   include <poll.h>
# endif
#endif

#ifdef I_STREAM
# include <sys/stream.h>
#endif

#ifdef I_STAT
# include <sys/stat.h>
# ifndef S_ISREG
#  define S_ISREG(a) (((a) & S_IFMT) == S_IFREG)
#  define S_ISDIR(a) (((a) & S_IFMT) == S_IFDIR)
# endif
#endif

#ifdef I_LIMITS
# include <limits.h> 
# include <sys/param.h> 
# ifndef _POSIX_PIPE_BUF
#  define _POSIX_PIPE_BUF 512
# endif
# ifndef PIPE_BUF
#  define PIPE_BUF 4096
# endif
# define PIPE_BUFFER ((PIPE_BUF<30720&&PIPE_BUF>0)?PIPE_BUF:30720)
# ifndef PATH_MAX
#  define PATH_MAX 1024
# endif
#endif

#include "term_main.h"

