/*
 * simple html browser.
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <Wlib.h>
#include <Wt.h>

static widget_t *top, *shell, *viewp, *html, *hpane;
static widget_t *urlbox, *urllabel, *urltext;

char *
read_file (char *fname)
{
	struct stat sb;
	char *data;
	int i;

	if (stat (fname, &sb) < 0) {
		printf ("cannot stat %s\n", fname);
		return NULL;
	}
	i = open (fname, O_RDONLY);
	if (i < 0) {
		printf ("cannot open %s\n", fname);
		return NULL;
	}
	data = malloc (sb.st_size+1);
	if (!data) {
		close (i);
		printf ("oom\n");
		return NULL;
	}
	if (read (i, data, sb.st_size) != sb.st_size) {
		close (i);
		printf ("error reading %s\n", fname);
		free (data);
		return NULL;
	}
	close (i);
	data[sb.st_size] = 0;
	return data;
}

typedef struct {
	BITMAP *bm;
	short wd, ht;
} image_t;

static long
img_query_cb (widget_t *w, char *url, int *wd, int *ht)
{
	image_t *img = malloc (sizeof (image_t));

	if (!img)
		return (long)NULL;

	img->bm = w_readimg (url, &img->wd, &img->ht);
	if (!img->bm) {
		free (img);
		return NULL;
	}
	*wd = img->wd;
	*ht = img->ht;
	return (long)img;
}

static void
img_place_cb (widget_t *w, long handle, int x, int y)
{
	image_t *img = (image_t *)handle;

	w_putblock (img->bm, 0, 0, img->wd, img->ht, wt_widget2win (w), x, y);
	free (img->bm->data);
	free (img->bm);
	free (img);
}

static void
img_invalidate_cb (widget_t *w, int can_discard_img_data)
{
}

static void
anchor_press_cb (widget_t *w, char *url, int x, int y, int pressed)
{
}

static void
urltext_cb (char *url, int cursor)
{
	char *data = read_file (url);

	if (data) {
		wt_setopt (html,
			WT_LABEL, data,
			WT_EOL);
		free (data);
	}
}

int
main (int argc, char *argv[])
{
	static char urlbuf[128] = "";
	long i, j, k;

	top = wt_init ();
	shell = wt_create (wt_shell_class, top);
	hpane = wt_create (wt_pane_class, shell);

	urlbox = wt_create (wt_box_class, hpane);
	urllabel = wt_create (wt_label_class, urlbox);
	urltext = wt_create (wt_getstring_class, urlbox);

	viewp = wt_create (wt_viewport_class, hpane);
	html = wt_create (wt_html_class, viewp);

	wt_setopt (shell,
		WT_LABEL, " Wetscape ",
		WT_EOL);

	i = AlignLeft;
	wt_setopt (hpane,
		WT_ALIGNMENT, &i,
		WT_EOL);

	i = LabelModeNoBorder;
	wt_setopt (urllabel,
		WT_LABEL, "Goto URL",
		WT_MODE, &i,
		WT_EOL);

	i = 36;
	j = sizeof (urlbuf) - 1;
	k = GetstrModeWithBorder;
	wt_setopt (urltext,
		WT_STRING_ADDRESS, urlbuf,
		WT_STRING_LENGTH, &j,
		WT_STRING_WIDTH, &i,
		WT_MODE, &k,
		WT_ACTION_CB, urltext_cb,
		WT_EOL);

	i = 300;
	j = ViewpModeLifeScroll;
	wt_setopt (viewp,
		WT_HEIGHT, &i,
		WT_MODE, &j,
		WT_EOL);

	j = 1000;
	wt_setopt (html,
		WT_WIDTH, &i,
		WT_HEIGHT, &j,
		WT_LABEL, "<font normal=lucidat10 teletype=cour10>",
		WT_QUERY_CB, img_query_cb,
		WT_PLACE_CB, img_place_cb,
		WT_INVAL_CB, img_invalidate_cb,
		WT_ACTION_CB, anchor_press_cb,
		WT_EOL);

	wt_realize (top);
	wt_run ();
	return 0;
}
