/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.forms;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Vector;
import sunw.hotjava.doc.DocLine;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentFormatter;
import sunw.hotjava.doc.EmptyTagItem;
import sunw.hotjava.doc.Floatable;
import sunw.hotjava.doc.FormatState;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.MeasureState;
import sunw.hotjava.doc.Measurement;
import sunw.hotjava.doc.PrintedLineInfo;
import sunw.hotjava.doc.TagItem;
import sunw.hotjava.forms.FORM;
import sunw.hotjava.forms.FormPanel;
import sunw.hotjava.tags.Align;

public class INPUT
extends EmptyTagItem
implements Floatable {
    private int align;
    private boolean isImage;
    private FORM parentForm;

    public synchronized void init(Document document) {
        this.atts.put("value", this.squeezeOut(this.atts.get("value"), '\n'));
        super.init(document);
        String string = this.atts.get("align");
        if (string != null && string.equals("center")) {
            this.atts.put("align", "middle");
        }
        this.align = Align.getAlign(this.atts);
        this.isImage = false;
        String string2 = this.atts.get("type");
        if (string2 != null && string2.equals("image")) {
            this.isImage = true;
        }
    }

    private String squeezeOut(String string, char c) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (cArray[n2] == c) {
                System.arraycopy(cArray, n2 + 1, cArray, n2, --n - n2);
                --n2;
            }
            ++n2;
        }
        return new String(cArray, 0, n);
    }

    public boolean needsActivation() {
        return true;
    }

    public boolean isHidden(Formatter formatter) {
        FormPanel formPanel = (FormPanel)formatter.getPanel(this);
        if (formPanel != null) {
            return formPanel.isHidden();
        }
        return false;
    }

    public int getWidth(DocStyle docStyle) {
        DocumentFormatter documentFormatter = docStyle.win;
        if (documentFormatter != null) {
            return this.getWidth(documentFormatter, docStyle);
        }
        return 0;
    }

    public int getWidth(Formatter formatter, DocStyle docStyle) {
        FormPanel formPanel = (FormPanel)formatter.getPanel(this);
        if (formPanel != null) {
            Dimension dimension = formPanel.getPreferredSize();
            return dimension.width;
        }
        return 0;
    }

    public boolean format(Formatter formatter, FormatState formatState, FormatState formatState2) {
        if (formatState.state == 2) {
            return true;
        }
        formatState.state = 1;
        FormPanel formPanel = (FormPanel)formatter.getPanel(this);
        if (formPanel == null || this.isHidden(formatter)) {
            formatState.pos += 65536;
            return false;
        }
        Dimension dimension = formPanel.getPreferredSize();
        formPanel.setSize(dimension.width, dimension.height);
        formPanel.validate();
        if (this.isImage && this.alignIsFloating()) {
            boolean bl = false;
            if (!formatter.isFloater(this) && formatState.width + dimension.width > formatState.maxWidth) {
                if (formatState.startPos != formatState.pos) {
                    formatState.below += formatter.getCumulativeFloaterHeight(formatState.y);
                    return true;
                }
                bl = true;
            }
            formatter.queueFloater(formatter, formatState, this, this.getAscent(formatter, formatState) + this.getDescent(formatter, formatState), this.align == 7);
            formatState.pos += 65536;
            return bl;
        }
        int n = formPanel.getAscent();
        if (this.isImage) {
            n = Math.max(Align.getAscent(formatState, this.align, dimension.height), n);
        }
        formatState.ascent = Math.max(formatState.ascent, Math.max(formatState.style.ascent, n));
        formatState.descent = Math.max(formatState.descent, Math.max(formatState.style.descent, dimension.height - n));
        if (formatState.width + dimension.width > formatState.maxWidth) {
            if (formatState.width == 0) {
                dimension.width = formatState.maxWidth - formatState.width;
            } else {
                return true;
            }
        }
        formatState.width += dimension.width;
        formatState.pos += 65536;
        return false;
    }

    private int paintImage(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine) {
        if (this.isHidden(formatter)) {
            return 0;
        }
        FormPanel formPanel = (FormPanel)formatter.getPanel(this);
        if (formPanel != null) {
            Dimension dimension = formPanel.getSize();
            if (this.isImage) {
                if (docLine != null) {
                    n2 += Align.yOffset(docLine, formatter.displayStyle, this.align, dimension.height);
                }
            } else if (docLine != null) {
                n2 += docLine.baseline - docLine.lnascent;
            }
            formPanel.setLocation(n, n2);
            DocStyle docStyle = formatter.displayStyle;
            if (docStyle != null) {
                formPanel.setForeground(docStyle.color);
            }
            formPanel.setBackground(formatter.getFormatterBackgroundColor());
            formPanel.validate();
            formPanel.setVisible(true);
            return dimension.width;
        }
        return 0;
    }

    public int paint(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine) {
        formatter.displayPos += 65536;
        if (this.isImage && this.alignIsFloating()) {
            return 0;
        }
        return this.paintImage(formatter, graphics, n, n2, docLine);
    }

    public int printImage(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine, PrintedLineInfo printedLineInfo) {
        FormPanel formPanel = (FormPanel)formatter.getPanel(this);
        if (formPanel != null) {
            Dimension dimension = formPanel.getSize();
            int n3 = dimension.width;
            int n4 = dimension.height;
            if (this.isImage) {
                if (docLine != null) {
                    n2 += Align.yOffset(docLine, formatter.displayStyle, this.align, dimension.height);
                }
            } else if (docLine != null) {
                n2 += docLine.baseline - docLine.lnascent;
            }
            Graphics graphics2 = graphics.create(n, n2, n3, n4);
            DocStyle docStyle = formatter.displayStyle;
            if (docStyle != null) {
                formPanel.setForeground(docStyle.color);
            }
            try {
                try {
                    formPanel.printAll(graphics2);
                }
                catch (Exception exception) {
                }
                Object var14_13 = null;
                graphics2.dispose();
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                graphics2.dispose();
                throw throwable;
            }
            return dimension.width;
        }
        return 0;
    }

    public int print(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine, PrintedLineInfo printedLineInfo) {
        formatter.displayPos += 65536;
        if (this.alignIsFloating()) {
            return 0;
        }
        return this.printImage(formatter, graphics, n, n2, docLine, printedLineInfo);
    }

    public int paint(Formatter formatter, Graphics graphics, int n, int n2) {
        return this.paintImage(formatter, graphics, n, n2, null);
    }

    public int print(Formatter formatter, Graphics graphics, int n, int n2) {
        return this.printImage(formatter, graphics, n, n2, null, null);
    }

    public int getFormPanel(Formatter formatter, Vector vector) {
        FormPanel formPanel;
        while ((formPanel = (FormPanel)formatter.getPanel(this)) == null && (formatter = formatter.getParentFormatter()) != null) {
        }
        if (formPanel != null) {
            vector.addElement(formPanel);
        }
        return 1;
    }

    public Component createView(Formatter formatter, Document document) {
        this.getAttributes().get("type");
        FormPanel formPanel = new FormPanel(formatter, document, this, null);
        int n = this.getIndex();
        document.change(n << 16, n + 1 << 16);
        return formPanel;
    }

    public boolean measureItem(Formatter formatter, FormatState formatState, Measurement measurement, MeasureState measureState) {
        FormPanel formPanel = (FormPanel)formatter.getPanel(this);
        if (formPanel != null) {
            Dimension dimension = formPanel.getPreferredSize();
            measurement.setMinWidth(dimension.width);
            measurement.setPreferredWidth(dimension.width);
            if (dimension.equals(new Dimension())) {
                measureState.measurementInvalid = true;
            }
        }
        measureState.pos += 65536;
        return false;
    }

    public void setFormParent(TagItem tagItem) {
        if (tagItem == null || !(tagItem instanceof FORM)) {
            return;
        }
        this.parentForm = (FORM)tagItem;
    }

    public TagItem getFormParent() {
        return this.parentForm;
    }

    private boolean alignIsFloating() {
        return this.align == 7 || this.align == 8;
    }

    public int getAscent(Formatter formatter, FormatState formatState) {
        return Align.getAscent(formatState, this.align, this.getHeight(formatter));
    }

    public int getDescent(Formatter formatter, FormatState formatState) {
        return Align.getDescent(formatState, this.align, this.getHeight(formatter));
    }

    private int getHeight(Formatter formatter) {
        FormPanel formPanel = (FormPanel)formatter.getPanel(this);
        if (formPanel != null) {
            Dimension dimension = formPanel.getPreferredSize();
            return dimension.height;
        }
        return 0;
    }
}

