/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.CryptixException;
import cryptix.provider.cipher.NativeLink;
import cryptix.util.core.Debug;
import cryptix.util.core.LinkStatus;
import java.io.PrintWriter;
import java.security.Cipher;
import java.security.Key;
import java.security.KeyException;
import java.security.SymmetricCipher;

public final class LOKI91
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel((String)"LOKI91");
    private static final PrintWriter err = Debug.getOutput();
    private static NativeLink linkStatus = new NativeLink("LOKI91", 2, 3);
    private long native_cookie;
    private Object native_lock;
    private static final int BLOCK_SIZE = 8;
    private static final int ROUNDS = 16;
    private static final byte[] S = new byte[4096];
    private static final int[] P = new int[256];
    private int[] sKey = new int[16];

    private static void debug(String string) {
        err.println("LOKI91: " + string);
    }

    public static LinkStatus getLinkStatus() {
        return linkStatus;
    }

    private void link() {
        NativeLink nativeLink = linkStatus;
        synchronized (nativeLink) {
            block8: {
                try {
                    if (linkStatus.attemptLoad()) {
                        linkStatus.checkVersion(LOKI91.getLibMajorVersion(), LOKI91.getLibMinorVersion());
                        linkStatus.check(this.native_clinit());
                    }
                    if (linkStatus.useNative()) {
                        linkStatus.check(this.native_init());
                        this.native_lock = new Object();
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    linkStatus.fail((Throwable)unsatisfiedLinkError);
                    if (debuglevel <= 2) break block8;
                    LOKI91.debug(unsatisfiedLinkError.getMessage());
                }
            }
            if (debuglevel > 2) {
                LOKI91.debug("Using native library? " + (this.native_lock != null));
            }
            return;
        }
    }

    private static native int getLibMajorVersion();

    private static native int getLibMinorVersion();

    private native String native_clinit();

    private native String native_init();

    private native String native_ks(long var1, byte[] var3);

    private native int native_crypt(long var1, byte[] var3, int var4, byte[] var5, int var6, boolean var7);

    private native String native_finalize();

    private static final byte exp31(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        int n3 = n;
        n = LOKI91.mult(n, n, n2);
        n3 = LOKI91.mult(n3, n, n2);
        n = LOKI91.mult(n, n, n2);
        n3 = LOKI91.mult(n3, n, n2);
        n = LOKI91.mult(n, n, n2);
        n3 = LOKI91.mult(n3, n, n2);
        n = LOKI91.mult(n, n, n2);
        return (byte)LOKI91.mult(n3, n, n2);
    }

    private static final int mult(int n, int n2, int n3) {
        int n4 = 0;
        while (n2 != 0) {
            if ((n2 & 1) != 0) {
                n4 ^= n;
            }
            if ((n <<= 1) > 255) {
                n ^= n3;
            }
            n2 >>>= 1;
        }
        return n4;
    }

    public LOKI91() {
        super(false, false, "Cryptix");
        this.link();
    }

    protected final void finalize() {
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                String string = this.native_finalize();
                if (string != null) {
                    LOKI91.debug(String.valueOf(string) + " in native_finalize");
                }
                return;
            }
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected int engineBlockSize() {
        return 8;
    }

    protected void engineInitEncrypt(Key key) throws KeyException {
        this.makeKey(key);
    }

    protected void engineInitDecrypt(Key key) throws KeyException {
        this.makeKey(key);
    }

    protected int engineUpdate(byte[] object, int n, int n2, byte[] byArray, int n3) {
        Object object2;
        boolean bl;
        if (n2 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n4 = n2 / 8;
        n2 = n4 * 8;
        boolean bl2 = bl = this.getState() == 1;
        if (object == byArray && (n3 >= n && (long)n3 < (long)n + (long)n2 || n >= n3 && (long)n < (long)n3 + (long)n2)) {
            object2 = new byte[n2];
            System.arraycopy(object, n, object2, 0, n2);
            object = object2;
            n = 0;
        }
        if (this.native_lock != null) {
            object2 = this.native_lock;
            synchronized (object2) {
                if (n < 0 || (long)n + (long)n2 > (long)((byte[])object).length || n3 < 0 || (long)n3 + (long)n2 > (long)byArray.length) {
                    throw new ArrayIndexOutOfBoundsException(String.valueOf(this.getAlgorithm()) + ": Arguments to native_crypt would cause a buffer overflow");
                }
                int n5 = 0;
                while (n5 < n4) {
                    if (this.native_crypt(this.native_cookie, (byte[])object, n, byArray, n3, bl) == 0) {
                        throw new CryptixException(String.valueOf(this.getAlgorithm()) + ": Error in native code");
                    }
                    n += 8;
                    n3 += 8;
                    ++n5;
                }
            }
        } else if (bl) {
            int n6 = 0;
            while (n6 < n4) {
                this.blockEncrypt((byte[])object, n, byArray, n3);
                n += 8;
                n3 += 8;
                ++n6;
            }
        } else {
            int n7 = 0;
            while (n7 < n4) {
                this.blockDecrypt((byte[])object, n, byArray, n3);
                n += 8;
                n3 += 8;
                ++n7;
            }
        }
        return n2;
    }

    private synchronized void makeKey(Key key) throws KeyException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new KeyException("Null LOKI91 key");
        }
        if (byArray.length < 8) {
            throw new KeyException("Invalid LOKI91 user key length");
        }
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                try {
                    linkStatus.check(this.native_ks(this.native_cookie, byArray));
                    Object var4_5 = null;
                    return;
                }
                catch (Error error) {
                    this.native_finalize();
                    this.native_lock = null;
                    if (debuglevel > 0) {
                        LOKI91.debug(String.valueOf(error) + ". Will use 100% Java.");
                    }
                }
            }
        }
        this.sKey[0] = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        this.sKey[1] = this.sKey[0] << 12 | this.sKey[0] >>> 20;
        this.sKey[2] = (byArray[4] & 0xFF) << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
        this.sKey[3] = this.sKey[2] << 12 | this.sKey[2] >>> 20;
        int n = 4;
        while (n < 16) {
            this.sKey[n] = this.sKey[n - 3] << 13 | this.sKey[n - 3] >>> 19;
            this.sKey[n + 1] = this.sKey[n] << 12 | this.sKey[n] >>> 20;
            this.sKey[n + 2] = this.sKey[n - 1] << 13 | this.sKey[n - 1] >>> 19;
            this.sKey[n + 3] = this.sKey[n + 2] << 12 | this.sKey[n + 2] >>> 20;
            n += 4;
        }
    }

    private void blockEncrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        int n4 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
        int n5 = 0;
        while (n5 < 16) {
            int n6 = n4 ^ this.sKey[n5++];
            n3 ^= P[S[n6 & 0xFFF] & 0xFF] | P[S[n6 >>> 8 & 0xFFF] & 0xFF] << 1 | P[S[n6 >>> 16 & 0xFFF] & 0xFF] << 2 | P[S[(n6 >>> 24 | n6 << 8) & 0xFFF] & 0xFF] << 3;
            n6 = n3 ^ this.sKey[n5++];
            n4 ^= P[S[n6 & 0xFFF] & 0xFF] | P[S[n6 >>> 8 & 0xFFF] & 0xFF] << 1 | P[S[n6 >>> 16 & 0xFFF] & 0xFF] << 2 | P[S[(n6 >>> 24 | n6 << 8) & 0xFFF] & 0xFF] << 3;
        }
        byArray2[n2++] = (byte)(n4 >>> 24);
        byArray2[n2++] = (byte)(n4 >>> 16);
        byArray2[n2++] = (byte)(n4 >>> 8);
        byArray2[n2++] = (byte)n4;
        byArray2[n2++] = (byte)(n3 >>> 24);
        byArray2[n2++] = (byte)(n3 >>> 16);
        byArray2[n2++] = (byte)(n3 >>> 8);
        byArray2[n2] = (byte)n3;
    }

    private void blockDecrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        int n4 = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
        int n5 = 16;
        while (n5 > 0) {
            int n6 = n4 ^ this.sKey[--n5];
            n3 ^= P[S[n6 & 0xFFF] & 0xFF] | P[S[n6 >>> 8 & 0xFFF] & 0xFF] << 1 | P[S[n6 >>> 16 & 0xFFF] & 0xFF] << 2 | P[S[(n6 >>> 24 | n6 << 8) & 0xFFF] & 0xFF] << 3;
            n6 = n3 ^ this.sKey[--n5];
            n4 ^= P[S[n6 & 0xFFF] & 0xFF] | P[S[n6 >>> 8 & 0xFFF] & 0xFF] << 1 | P[S[n6 >>> 16 & 0xFFF] & 0xFF] << 2 | P[S[(n6 >>> 24 | n6 << 8) & 0xFFF] & 0xFF] << 3;
        }
        byArray2[n2++] = (byte)(n4 >>> 24);
        byArray2[n2++] = (byte)(n4 >>> 16);
        byArray2[n2++] = (byte)(n4 >>> 8);
        byArray2[n2++] = (byte)n4;
        byArray2[n2++] = (byte)(n3 >>> 24);
        byArray2[n2++] = (byte)(n3 >>> 16);
        byArray2[n2++] = (byte)(n3 >>> 8);
        byArray2[n2] = (byte)n3;
    }

    static {
        int[] nArray = new int[]{375, 379, 391, 395, 397, 415, 419, 425, 433, 445, 451, 463, 471, 477, 487, 499};
        int n = 0;
        while (n < 4096) {
            int n2 = n >>> 8 & 0xC | n & 3;
            int n3 = n >>> 2 & 0xFF;
            int n4 = n3 + (n2 * 17 ^ 0xFF) & 0xFF;
            LOKI91.S[n] = LOKI91.exp31(n4, nArray[n2]);
            ++n;
        }
        int[] nArray2 = new int[]{31, 23, 15, 7, 30, 22, 14, 6, 29, 21, 13, 5, 28, 20, 12, 4, 27, 19, 11, 3, 26, 18, 10, 2, 25, 17, 9, 1, 24, 16, 8, 0};
        int n5 = 0;
        while (n5 < 256) {
            int n6 = 0;
            int n7 = 0;
            while (n7 < 32) {
                n6 |= (n5 >>> nArray2[n7] & 1) << 31 - n7;
                ++n7;
            }
            LOKI91.P[n5] = n6;
            ++n5;
        }
    }
}

