/**
*  Class DES - The DES cypher as defined in RFC 2144
*  <P>
*  Coded Mr. Tines &lt;tines@windsong.demon.co.uk&gt; 1998
*  and released into the public domain
*  <P>
* THIS SOFTWARE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
* BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
* WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
* OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
* EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*  <P>
* @author Mr. Tines
* @version 1.0 23-Dec-1998
*/

package uk.co.demon.windsong.crypt.cea;

public class DES implements CEA
{
    static DES_SPboxes sp = null;

    int[] ekeysched = null;
    int[] dkeysched = null;

    public DES()
    {
        if(null == sp) sp = new DES_SPboxes();
    }

    public void init(byte[] key, int offset, boolean triple)
    {
        if(triple) throw new RuntimeException("Use Triple-DES directly");
        ekeysched = new int[DESkeys.LONGS];
        dkeysched = new int[DESkeys.LONGS];

        DESkeys.single(key, offset, DESkeys.EN0, ekeysched, 0);
        DESkeys.single(key, offset, DESkeys.DE1, dkeysched, 0);
    }

    public void ecb(boolean encrypt, byte[] in, int offin, byte[] out,
        int offout)
    {
        if(encrypt)
        {
            DESengine.single(in, offin, out, offout,
                ekeysched, sp );
        }
        else
        {
            DESengine.single(in, offin, out, offout,
                dkeysched, sp );
        }
    }

    public void destroy()
    {
        if(ekeysched != null)
        {
            for(int e=0; e<ekeysched.length; ++e) ekeysched[e] = 0;
        }
        ekeysched = null;
        if(dkeysched != null)
        {
            for(int d=0; d<dkeysched.length; ++d) dkeysched[d] = 0;
        }
        dkeysched = null;
    }

    public int getKeysize()
    {
        return DESkeys.KEYSIZE;
    }

    public int getBlocksize()
    {
        return DESengine.BLOCKSIZE;
    }
}