/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESCipher;
import com.sun.crypto.provider.DESKeyFactory;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class PBEWithMD5AndDESCipher
extends CipherSpi {
    private DESCipher desCipher = new DESCipher("CBC", "PKCS5Padding");

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.desCipher.engineDoFinal(byArray, n, n2);
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.desCipher.engineDoFinal(byArray, n, n2, byArray2, n3);
    }

    protected int engineGetBlockSize() {
        return this.desCipher.engineGetBlockSize();
    }

    protected byte[] engineGetIV() {
        return this.desCipher.engineGetIV();
    }

    protected int engineGetOutputSize(int n) {
        return this.desCipher.engineGetOutputSize(n);
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        throw new InvalidKeyException("Cannot derive key: PBE parameter missing");
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Inappropriate parameter type");
            }
            if (key == null || !key.getAlgorithm().equals("PBE")) {
                throw new InvalidKeyException("No passphrase given");
            }
            byte[] byArray = key.getEncoded();
            byte[] byArray2 = ((PBEParameterSpec)algorithmParameterSpec).getSalt();
            if (byArray2.length != 8) {
                throw new InvalidAlgorithmParameterException("Salt does not have length 8");
            }
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray4 = byArray3;
            int n2 = ((PBEParameterSpec)algorithmParameterSpec).getIterationCount();
            int n3 = 0;
            while (n3 < n2) {
                messageDigest.update(byArray4);
                byArray4 = messageDigest.digest();
                ++n3;
            }
            DESKeySpec dESKeySpec = new DESKeySpec(byArray4, 0);
            DESKeyFactory dESKeyFactory = new DESKeyFactory();
            SecretKey secretKey = null;
            try {
                secretKey = dESKeyFactory.engineGenerateSecret(dESKeySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {}
            DESParameterSpec dESParameterSpec = new DESParameterSpec(byArray4, 8);
            this.desCipher.engineInit(n, secretKey, dESParameterSpec, secureRandom);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException(noSuchAlgorithmException.toString());
        }
    }

    public void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (string != null && !string.equalsIgnoreCase("CBC")) {
            throw new NoSuchAlgorithmException("Invalid cipher mode: " + string);
        }
    }

    public void engineSetPadding(String string) throws NoSuchPaddingException {
        if (string != null && !string.equalsIgnoreCase("PKCS5Padding")) {
            throw new NoSuchPaddingException("Invalid padding scheme: " + string);
        }
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        return this.desCipher.engineUpdate(byArray, n, n2);
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        return this.desCipher.engineUpdate(byArray, n, n2, byArray2, n3);
    }
}

