public class CFBDecryption extends Feedback {

// cipher should be an *encryption* object
public CFBDecryption (BlockTransformation cipher, byte IV[], int IVoff)
{
    this(cipher, IV, IVoff, 0);
}

public CFBDecryption (BlockTransformation cipher, byte IV[], int IVoff,
                      int feedBackSize)
{
    super(cipher, IV, IVoff, feedBackSize);
}

public byte processByte(byte input)
{
    if (counter==FBS)
        doFeedback();
    byte b = (byte)(buffer[counter] ^ input);
    buffer[counter++] = input;
    return (b);
}

public void processBytes(byte inout[])
{
    processBytes(inout, 0, inout.length);
}

public void processBytes(byte inout[], int off, int length)
{
    for (int i=0; i<length; ++i) {
        if (counter==FBS)
            doFeedback();
        byte b = (byte)(buffer[counter] ^ inout[off]);
        buffer[counter++] = inout[off];
        inout[off++] = b;
    }
}

public void sync()
{
    if (counter!=0)
    {
        for (int i=0; i<counter; i++)
            buffer[S-counter+i] = buffer[i];
        System.arraycopy(reg, counter, buffer, 0, S-counter);
	doFeedback();
    }
}


} // CFBDecryption

