.\"
.\" States manual page.
.\" Copyright (c) 1997-1998 Markku Rossi.
.\" Author: Markku Rossi <mtr@iki.fi>
.\"
.\" This file is part of GNU Enscript.
.\"
.\" Enscript is free software: you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation, either version 3 of the License, or
.\" (at your option) any later version.
.\"
.\" Enscript is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with Enscript.  If not, see <http://www.gnu.org/licenses/>.
.\"
.TH STATES 1 "Oct 23, 1998" "STATES" "STATES"

.SH NAME
states \- awk alike text processing tool

.SH SYNOPSIS
.B states
[\f3\-hvV\f1]
[\f3\-D \f2var\f3=\f2val\f1]
[\f3\-f \f2file\f1]
[\f3\-o \f2outputfile\f1]
[\f3\-p \f2path\f1]
[\f3\-s \f2startstate\f1]
[\f3\-W \f2level\f1]
[\f2filename\f1 ...]

.SH DESCRIPTION

\f3States\f1 is an awk-alike text processing tool with some state
machine extensions.  It is designed for program source code
highlighting and to similar tasks where state information helps input
processing.

At a single point of time, \f3States\f1 is in one state, each quite
similar to awk's work environment, they have regular expressions which
are matched from the input and actions which are executed when a match
is found.  From the action blocks, \f3states\f1 can perform state
transitions; it can move to another state from which the processing is
continued.  State transitions are recorded so \f3states\f1 can return
to the calling state once the current state has finished.

The biggest difference between \f3states\f1 and awk, besides state
machine extensions, is that \f3states\f1 is not line-oriented.  It
matches regular expression tokens from the input and once a match is
processed, it continues processing from the current position, not from
the beginning of the next input line.

.SH OPTIONS
.TP 8
.B \-D \f2var\f3=\f2val\f3, \-\-define=\f2var\f3=\f2val\f3
Define variable \f2var\f1 to have string value \f2val\f1.  Command
line definitions overwrite variable definitions found from the config
file.
.TP 8
.B \-f \f2file\f3, \-\-file=\f2file\f3
Read state definitions from file \f2file\f1.  As a default,
\f3states\f1 tries to read state definitions from file \f3states.st\f1
in the current working directory.
.TP 8
.B \-h, \-\-help
Print short help message and exit.
.TP 8
.B \-o \f2file\f3, \-\-output=\f2file\f3
Save output to file \f2file\f1 instead of printing it to
\f3stdout\f1.
.TP 8
.B \-p \f2path\f3, \-\-path=\f2path\f3
Set the load path to \f2path\f1.  The load path defaults to the
directory, from which the state definitions file is loaded.
.TP 8
.B \-s \f2state\f3, \-\-state=\f2state\f3
Start execution from state \f3state\f1.  This definition overwrites
start state resolved from the \f3start\f1 block.
.TP 8
.B \-v, \-\-verbose
Increase the program verbosity.
.TP 8
.B \-V, \-\-version
Print \f3states\f1 version and exit.
.TP 8
.B \-W \f2level\f3, \-\-warning=\f2level\f3
Set the warning level to \f2level\f1.  Possible values for \f2level\f1
are:
.RS 8
.TP 8
.B light
light warnings (default)
.TP 8
.B all
all warnings
.RE

.SH STATES PROGRAM FILES

\f3States\f1 program files can contain on \f2start\f1 block,
\f2startrules\f1 and \f2namerules\f1 blocks to specify the initial
state, \f2state\f1 definitions and \f2expressions\f1.

The \f2start\f1 block is the main() of the \f3states\f1 program, it is
executed on script startup for each input file and it can perform any
initialization the script needs.  It normally also calls the
\f3check_startrules()\f1 and \f3check_namerules()\f1 primitives which
resolve the initial state from the input file name or the data found
from the begining of the input file.  Here is a sample start block
which initializes two variables and does the standard start state
resolving:
.PP
.RS
.nf
start
{
  a = 1;
  msg = "Hello, world!";
  check_startrules ();
  check_namerules ();
}
.fi
.RE
.PP
Once the start block is processed, the input processing is continued
from the initial state.

The initial state is resolved by the information found from the
\f2startrules\f1 and \f2namerules\f1 blocks.  Both blocks contain
regular expression - symbol pairs, when the regular expression is
matched from the name of from the beginning of the input file, the
initial state is named by the corresponding symbol.  For example, the
following start and name rules can distinguish C and Fortran files:
.PP
.RS
.nf
namerules
{
  /\\.(c|h)$/    c;
  /\\.[fF]$/     fortran;
}

startrules
{
  /-\\*- [cC] -\\*-/      c;
  /-\\*- fortran -\\*-/   fortran;
}
.fi
.RE
.PP
If these rules are used with the previously shown start block,
\f3states\f1 first check the beginning of input file.  If it has
string \f3-*- c -*-\f1, the file is assumed to contain C code and the
processing is started from state called \f3c\f1.  If the beginning of
the input file has string \f3-*- fortran -*-\f1, the initial state is
\f3fortran\f1.  If none of the start rules matched, the name of the
input file is matched with the namerules.  If the name ends to suffix
\f3c\f1 or \f3C\f1, we go to state \f3c\f1.  If the suffix is
\f3f\f1 or \f3F\f1, the initial state is fortran.

If both start and name rules failed to resolve the start state,
\f3states\f1 just copies its input to output unmodified.

The start state can also be specified from the command line with
option \f3\-s\f1, \f3\-\-state\f1.

State definitions have the following syntax:

.B state { \f2expr\f1 {\f2statements\f1} ... }

where \f2expr\f1 is: a regular expression, special expression or
symbol and \f2statements\f1 is a list of statements.  When the
expression \f2expr\f1 is matched from the input, the statement block
is executed.  The statement block can call \f3states\f1' primitives,
user-defined subroutines, call other states, etc.  Once the block is
executed, the input processing is continued from the current intput
position (which might have been changed if the statement block called
other states).

Special expressions \f3BEGIN\f1 and \f3END\f1 can be used in the place
of \f2expr\f1.  Expression \f3BEGIN\f1 matches the beginning of the
state, its block is called when the state is entered.  Expression
\f3END\f1 matches the end of the state, its block is executed when
\f3states\f1 leaves the state.

If \f2expr\f1 is a symbol, its value is looked up from the global
environment and if it is a regular expression, it is matched to the
input, otherwise that rule is ignored.

The \f3states\f1 program file can also have top-level expressions,
they are evaluated after the program file is parsed but before any
input files are processed or the \f2start\f1 block is evaluated.

.SH PRIMITIVE FUNCTIONS

.TP 8
.B call (\f2symbol\f3)
Move to state \f2symbol\f1 and continue input file processing from
that state.  Function returns whatever the \f3symbol\f1 state's
terminating \f3return\f1 statement returned.
.TP 8
.B calln (\f2name\f3)
Like \f3call\f1 but the argument \f2name\f1 is evaluated and its value
must be string.  For example, this function can be used to call a
state which name is stored to a variable.
.TP 8
.B check_namerules ()
Try to resolve start state from \f3namerules\f1 rules.  Function
returns \f31\f1 if start state was resolved or \f30\f1 otherwise.
.TP 8
.B check_startrules ()
Try to resolve start state from \f3startrules\f1 rules.  Function
returns \f31\f1 if start state was resolved or \f30\f1 otherwise.
.TP 8
.B concat (\f2str\f3, ...)
Concanate argument strings and return result as a new string.
.TP 8
.B float (\f2any\f3)
Convert argument to a floating point number.
.TP 8
.B getenv (\f2str\f3)
Get value of environment variable \f2str\f1.  Returns an empty string
if variable \f2var\f1 is undefined.
.TP 8
.B int (\f2any\f3)
Convert argument to an integer number.
.TP 8
.B length (\f2item\f3, ...)
Count the length of argument strings or lists.
.TP 8
.B list (\f2any\f3, ...)
Create a new list which contains items \f2any\f1, ...
.TP 8
.B panic (\f2any\f3, ...)
Report a non-recoverable error and exit with status \f31\f1.  Function
never returns.
.TP 8
.B print (\f2any\f3, ...)
Convert arguments to strings and print them to the output.
.TP 8
.B range (\f2source\f3, \f2start\f3, \f2end\f3)
Return a sub\-range of \f2source\f1 starting from position \f2start\f1
(inclusively) to \f2end\f1 (exclusively).  Argument \f2source\f1 can
be string or list.
.TP 8
.B regexp (\f2string\f3)
Convert string \f2string\f1 to a new regular expression.
.TP 8
.B regexp_syntax (\f2char\f3, \f2syntax\f3)
Modify regular expression character syntaxes by assigning new
syntax \f2syntax\f1 for character \f2char\f1.  Possible values for
\f2syntax\f1 are:
.RS 8
.TP 8
.B 'w'
character is a word constituent
.TP 8
.B ' '
character isn't a word constituent
.RE
.TP 8
.B regmatch (\f2string\f3, \f2regexp\f3)
Check if string \f2string\f1 matches regular expression \f2regexp\f1.
Functions returns a boolean success status and sets sub-expression
registers \f3$\f2n\f1.
.TP 8
.B regsub (\f2string\f1, \f2regexp\f3, \f2subst\f3)
Search regular expression \f2regexp\f1 from string \f2string\f1 and
replace the matching substring with string \f2subst\f1.  Returns the
resulting string.  The substitution string \f2subst\f1 can contain
\f3$\f2n\f1 references to the \f2n\f1:th parenthesized
sup-expression.
.TP 8
.B regsuball (\f2string\f1, \f2regexp\f3, \f2subst\f3)
Like \f3regsub\f1 but replace all matches of regular expression
\f2regexp\f1 from string \f2string\f1 with string \f2subst\f1.
.TP 8
.B require_state (\f2symbol\f3)
Check that the state \f2symbol\f1 is defined.  If the required state
is undefined, the function tries to autoload it.  If the loading
fails, the program will terminate with an error message.
.TP 8
.B split (\f2regexp\f3, \f2string\f3)
Split string \f2string\f1 to list considering matches of regular
rexpression \f2regexp\f1 as item separator.
.TP 8
.B sprintf (\f2fmt\f1, ...)
Format arguments according to \f2fmt\f1 and return result as a
string.
.TP 8
.B strcmp (\f2str1\f3, \f2str2\f3)
Perform a case\-sensitive comparision for strings \f2str1\f1 and
\f2str2\f1.  Function returns a value that is:
.RS 8
.TP 8
.B -1
string \f2str1\f1 is less than \f2str2\f1
.TP 8
.B 0
strings are equal
.TP 8
.B 1
string \f2str1\f1 is greater than \f2str2\f1
.RE
.TP 8
.B string (\f2any\f3)
Convert argument to string.
.TP 8
.B strncmp (\f2str1\f3, \f2str2\f3, \f2num\f3)
Perform a case\-sensitive comparision for strings \f2str1\f1 and
\f2str2\f1 comparing at maximum \f2num\f3 characters.
.TP 8
.B substring (\f2str\f3, \f2start\f3, \f2end\f3)
Return a substring of string \f2str\f1 starting from position
\f2start\f1 (inclusively) to \f2end\f1 (exclusively).
.RE

.SH BUILTIN VARIABLES
.TP 8
.B $.
current input line number
.TP 8
.B $\f2n\f3
the \f2n\f1:th parenthesized regular expression sub-expression from the
latest state regular expression or from the \f3regmatch\f1 primitive
.TP 8
.B $`
everything before the matched regular rexpression.  This is usable
when used with the \f3regmatch\f1 primitive; the contents of this
variable is undefined when used in action blocks to refer the data
before the block's regular expression.
.TP 8
.B $B
an alias for \f3$`\f1
.TP 8
.B argv
list of input file names
.TP 8
.B filename
name of the current input file
.TP 8
.B program
name of the program (usually \f3states\f1)
.TP 8
.B version
program version string
.RE

.SH FILES
.nf
.ta 4i
@DATADIR@/enscript/hl/*.st	enscript's states definitions
.fi

.SH SEE ALSO
awk(1), enscript(1)

.SH AUTHOR
Markku Rossi <mtr@iki.fi> <http://www.iki.fi/~mtr/>

GNU Enscript WWW home page: <http://www.iki.fi/~mtr/genscript/>
