(*
$File: Common/INFIXBASIS.sml $
$Date: 1992/01/29 15:01:00 $
$Revision: 1.3 $
$Locker: birkedal $
*)

(*$INFIX_BASIS*)
signature INFIX_BASIS =
  sig
    type id
    type Basis

    val emptyB: Basis

    datatype InfixEntry = NONFIX | INFIX of int | INFIXR of int

    val new: id list * InfixEntry -> Basis
    val lookup: Basis -> id -> InfixEntry

    val compose: Basis * Basis -> Basis

    type Report
    val reportBasis: Basis -> Report

    type StringTree
    val layoutBasis: Basis -> StringTree
  end;
