(* Type information for the match compiler *)

(*
$File: Common/TYPE_INFO.sml $
$Date: 1991/08/26 12:15:38 $
$Revision: 1.11 $
$Locker: birkedal $
*)

(*$TYPE_INFO*)
signature TYPE_INFO =
  sig
    type lab
    type longcon

    datatype info =
	LAB_INFO of {index: int}
			(* Attached to PATROW. Gives the alphabetic
			   index (0..n-1) for the record label. *)

      | CON_INFO of {numCons: int, index: int, functional: bool}
			(* Attached to IDENTatexp, LONGIDatpat, CONSpat.
			   numCons is the number of constructors for this type.
			   The `functional' field tells us if we can just build
			   a constructor object (e.g. `nil') or whether we
			   need to build a function (e.g. `op ::'). *)

      | EXCON_INFO of {functional: bool}
			(* Attached to IDENTatexp. At each EXCON occurring
			   as an atomic expression: TRUE if the excon carries
			   a value (because then we might to fudge a closure
			   if we bind it to a normal identifier). *)

    type StringTree
    val layoutInfo: info -> StringTree
  end;
