(* Grammar for modules (modules version) - Definition v3 pages 12-14 *)

(*
$File: Common/TopdecGrammar.sml $
$Date: 1993/03/05 14:39:13 $
$Revision: 1.19 $
$Locker: birkedal $
*)

(*$TopdecGrammar: DEC_GRAMMAR TOPDEC_GRAMMAR *)

functor TopdecGrammar(structure DecGrammar : DEC_GRAMMAR

		      type strid
		      type longstrid
		      type funid
		      type sigid

		      type id
		      type tyvar
		      type tycon
		      type longtycon
		      type con
		      type excon

		      type GrammarInfo

		      structure WithInfo:
			sig
			  datatype 'a WithInfo = WITH_INFO of GrammarInfo * 'a
			end
		     ): TOPDEC_GRAMMAR =
  struct
    open WithInfo

    type dec = DecGrammar.dec
    type ty  = DecGrammar.ty

    type strid = strid
    type funid = funid
    type sigid = sigid
    type longstrid = longstrid

    type id    = id
    type tyvar = DecGrammar.tyvar
    type tycon = tycon
    type con   = con
    type excon = excon
    type longtycon = longtycon

    type info = GrammarInfo

			    (* Figure 6 *)

    datatype strexp =
      STRUCTstrexp of info * strdec |
      LONGSTRIDstrexp of info * longstrid |
      APPstrexp of info * funid * strexp |
      LETstrexp of info * strdec * strexp

    and strdec =
      DECstrdec of info * dec |
      STRUCTUREstrdec of info * strbind |
      LOCALstrdec of info * strdec * strdec |
      EMPTYstrdec of info |
      SEQstrdec of info * strdec * strdec

    and strbind =
      STRBIND of info * strid * sigexp Option * strexp * strbind Option

    and sigexp =
      SIGsigexp of info * spec |
      SIGIDsigexp of info * sigid

    and sigdec =
      SIGNATUREsigdec of info * sigbind |
      EMPTYsigdec of info |
      SEQsigdec of info * sigdec * sigdec

    and sigbind =
      SIGBIND of info * sigid * sigexp * sigbind Option

			    (* Figure 7 *)

    and spec =
      VALspec of info * valdesc |
      TYPEspec of info * typdesc |
      EQTYPEspec of info * typdesc |
      DATATYPEspec of info * datdesc |
      EXCEPTIONspec of info * exdesc |
      STRUCTUREspec of info * strdesc |
      SHARINGspec of info * shareq |
      LOCALspec of info * spec * spec |
      OPENspec of info * longstrid WithInfo list |
      INCLUDEspec of info * sigid WithInfo list |
      EMPTYspec of info |
      SEQspec of info * spec * spec

    and valdesc =
      VALDESC of info * id * ty * valdesc Option

    and typdesc =
      TYPDESC of info * tyvar list * tycon * typdesc Option

    and datdesc =
      DATDESC of info * tyvar list * tycon * condesc * datdesc Option

    and condesc =
      CONDESC of info * con * ty Option * condesc Option

    and exdesc =
      EXDESC of info * excon * ty Option * exdesc Option

    and strdesc =
      STRDESC of info * strid * sigexp * strdesc Option

    and shareq =
      STRUCTUREshareq of info * longstrid WithInfo list |      (* >= 2 *)
      TYPEshareq of info * longtycon WithInfo list |	       (* >= 2 *)
      ANDshareq of info * shareq * shareq

			    (* Figure 8 *)

    and fundec =
      FUNCTORfundec of info * funbind |
      EMPTYfundec of info |
      SEQfundec of info * fundec * fundec

    and funbind =
      FUNBIND of info * funid * strid * sigexp * sigexp Option * strexp * funbind Option

    and topdec =
      STRtopdec of info * strdec |
      SIGtopdec of info * sigdec |
      FUNtopdec of info * fundec

    local
      fun f res (CONDESC(_, _, tyopt, conopt)) =
	let
	  val res' = 
	    case tyopt of 
	      None => res 
	    | Some ty => (DecGrammar.getExplicitTyVarsTy ty) @ res
	in
	  case conopt of 
	    None => res'
	  | Some condesc => f res' condesc 
	end
    in
      val getExplicitTyVarsCondesc = f []
    end

  end;
