
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

% Memory management: cleaning up of the heap.

gc(Call) :-
%	access(4, cprolog),
	c_gc(Call).
% Can use same trick on bimprolog
%gc(Call) :-
%	access(4, bimprolog),
%	call(Call).

% C-Prolog version:
c_gc(Call) :- one_call(Call), set(1,Call), fail.
c_gc(Call) :- access(1,Call).

% Definition of call to avoid 'real' call:
% Any further arguments of gc/1 must be added here:

one_call(compileproc(A,B,C)) :- compileproc(A,B,C), !.
one_call(compileclause(A,B,C)) :- compileclause(A,B,C), !.
one_call(Call) :- call(Call), !.


% Definitions of set and access:
% (Not necessary when running on the PLM)

:- dynamic('$set_access'/2).
'$set_access'(nothing,nothing).	% Needed for correct operation under Quintus.

set(N,C) :- (retract('$set_access'(N,_)); true), assert('$set_access'(N,C)), !.

access(N,C) :- '$set_access'(N,C), !.
