
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

#include <stream.h>
#include "tags.h"
#include "instr.h"
#include "hash_table.h"
#include "string_table.h"
#include "memory.h"
#include "basics.h"

void wrong_instruction_called()
{
  cerr << "wrong instruction called\n";
  exit(1);
}

 /* conventions: */
 /* a DATA POINTER is stored as an OFFSET from H0 */
 /* a STACK POINTER register is stored by casting it to UNSIGNED */
 /* a CODE POINTER is stored by casting it to UNSIGNED */

inline void get_variable(Cell& Arg1, Cell Arg2) {
  Arg1 = Arg2;
}

void GetVariableX()
{
  get_variable(X[P->arg1], X[P->arg2]);
}
void GetVariableY()
{
  get_variable(E[P->arg1], X[P->arg2]);
}

inline void get_value(Cell Arg1, Cell Arg2) {
  if (! unify(Arg1, Arg2))
    P = FP0;
}

void GetValueX()
{
  get_value(X[P->arg1], X[P->arg2]);
}
void GetValueY()
{
  get_value(E[P->arg1], X[P->arg2]);
}

inline void get_constant(Cell Arg1, Cell Arg2) {
  Arg2 = deref(Arg2);
  if (Arg1 != Arg2) {
    if (get_tag(Arg2) == TAGREF)
      Bind(Arg2, Arg1);
    else
      (P = FP0);
  }
}

void GetConstant()
{
  get_constant(P->arg1, X[P->arg2]);
}

 /* NIL is the internalized atom "[]" */
 /* this is a unique identification */
void GetNil()
{
  get_constant(NIL, X[P->arg1]);
}

void get_structure(Cell atom, Cell var, Cell arity) 
{
  var = deref(var);
  if (get_tag(var) == TAGREF) {
    MODE = MODE_WRITE;
    Bind(var, make_ptr(TAGSTRUCT, H));
    *H++ = atom;
    *H++ = make_int(arity);
  } else if (get_tag(var) == TAGSTRUCT && rvalue(var) == atom) {
    MODE = MODE_READ;
    S = addr(var) + 2;
  } else {
    P = FP0;
  }
}

void GetStructure() {
  get_structure(P->arg1, X[P->arg2], P->arg3);
}

void get_list(Cell Var) 
{
  Var = deref(Var);
  switch (get_tag(Var)) {
  case TAGREF:
    MODE = MODE_WRITE;
    Bind(Var, make_ptr(TAGLIST, H));
    break;
  case TAGLIST:
    MODE = MODE_READ;
    S = addr(Var);
    break;
  default:
    P = FP0;
    break;
  }
}

void GetList() {get_list(X[P->arg1]);}



 /* PUT INSTRUCTIONS */


inline void put_variable_X(Cell& Arg1, Cell& Arg2) 
{
  *H = make_ptr(TAGREF, H);
  Arg2 = Arg1 = *H++;
}

inline void put_variable_Y(Cell& Arg1, Cell& Arg2) 
{
  Arg2 = Arg1 = make_cell(TAGREF, &Arg1);
}

void PutVariableX() 
{
  put_variable_X(X[P->arg1], X[P->arg2]);
}
void PutVariableY() 
{
  put_variable_Y(E[P->arg1], X[P->arg2]);
}

inline void put_value(Cell Arg1, Cell& Arg2) 
{
  Arg2 = Arg1;
}

void PutValueX() 
{
  put_value(X[P->arg1], X[P->arg2]);
}
void PutValueY() 
{
  put_value(E[P->arg1], X[P->arg2]);
}

inline void put_unsafe_value(Cell Arg1, Cell& Arg2) 
{
  Arg1 = deref(Arg1);
  if (get_tag(Arg1) == TAGREF && cellp(Arg1) >= E0) {
    *H = make_ptr(TAGREF, H);
    Bind(Arg1, *H++);
  }
  Arg2 = Arg1;
}
void PutUnsafeValue() 
{
  put_unsafe_value(E[P->arg1], X[P->arg2]);
}

void PutConstant() 
{
  put_value(P->arg1, X[P->arg2]);
}
void PutNil() 
{
  put_value(NIL, X[P->arg1]);
}

inline void put_structure(Cell atom, Cell& Var, Cell arity) 
{
  Var = make_ptr(TAGSTRUCT, H);
  *H++ = atom;
  *H++ = make_int(arity);
}  

void PutStructure() 
{
  put_structure(P->arg1, X[P->arg2], P->arg3);
}

inline void put_list(Cell& Arg1) 
{
  Arg1 = make_ptr(TAGLIST, H);
}

void PutList() 
{
  put_list(X[P->arg1]);
}



 /* UNIFY INSTRUCTIONS */


inline void unify_void_write() 
{
  *H = make_ptr(TAGREF, H); H++;
}

inline void unify_void() 
{
  if (MODE == MODE_READ) {
    S++;
  } else {
    unify_void_write();
  }
}

void UnifyVoid() {unify_void();}
void UnifyVoidWrite() {unify_void_write();}

inline void unify_value_write(Cell Arg1) 
{
  Arg1 = deref(Arg1);
  if (get_tag(Arg1) == TAGREF && cellp(Arg1) >= E0) {
    *H = make_ptr(TAGREF, H);
    Bind(Arg1, *H++);
  } else {
    *H++ = Arg1;
  }
}

inline void unify_value(Cell Arg1) 
{
  if (MODE == MODE_READ) {
    if (! unify(Arg1, *S++)) {
      P = FP0;
    }
  } else {
    unify_value_write(Arg1);
  }
}

void UnifyValueX() {unify_value(X[P->arg1]);}
void UnifyValueY() {unify_value(E[P->arg1]);}
void UnifyValueWriteX() {unify_value_write(X[P->arg1]);}
void UnifyValueWriteY() {unify_value_write(E[P->arg1]);}
void UnifyUnsafeValue() {unify_value(E[P->arg1]);}
void UnifyUnsafeValueWrite() {unify_value_write(E[P->arg1]);}

inline void unify_variable_write(Cell& Var) 
{
  *H = make_ptr(TAGREF, H);
  Var = *H++;
}

inline void unify_variable(Cell& Var) 
{
  if (MODE == MODE_READ) 
    Var = *S++;
  else
    unify_variable_write(Var);
}

void UnifyVariableX() {unify_variable(X[P->arg1]);}
void UnifyVariableY() {unify_variable(E[P->arg1]);}
void UnifyVariableWriteX() {unify_variable_write(X[P->arg1]);}
void UnifyVariableWriteY() {unify_variable_write(E[P->arg1]);}

inline void unify_constant_write(Cell cst) 
{
  *H++ = cst;
}

inline void unify_constant(Cell Arg1) 
{
  if (MODE == MODE_READ) 
    get_constant(Arg1, *S++);
  else
    unify_constant_write(Arg1);
}

void UnifyConstant() {unify_constant(P->arg1);}
void UnifyConstantWrite() {unify_constant_write(P->arg1);}

 /* unify_cdr is no different from unify_variable */

void UnifyNil() {unify_constant(NIL);}
void UnifyNilWrite() {unify_constant_write(NIL);}

inline void get_cdr_list_write() 
{
  *H = make_ptr(TAGLIST, H + 1); H++;
}       

void get_cdr_list() 
{
 if (MODE == MODE_READ) {
      Cell Var = deref(*S++);
      if (get_tag(Var) == TAGLIST) {
	S = addr(Var);
      } else if (get_tag(Var) == TAGREF) {
	MODE = MODE_WRITE;
	Bind(Var, make_ptr(TAGLIST, H));
      } else {
	P = FP0;
      }
    } else {
    get_cdr_list_write();
  }
}
void GetCdrList() {get_cdr_list();}  
void GetCdrListWrite() {get_cdr_list_write();}  
