#ifndef _DPMI10_H
#define _DPMI10_H

typedef struct {
    DWORD   HostPhysicalMemory ;
    DWORD   HostVirtuelMemory ;
    DWORD   HostFreeVirtuelMemory ;
    DWORD   VMVirtuelMemory ;
    DWORD   VMFreeVirtuelMemory ;
    DWORD   ClientVirtuelMemory ;
    DWORD   ClientFreeVirtuelMemory ;
    DWORD   LockedMemory ;
    DWORD   ClientMaxLockedMemory ;
    DWORD   ClientHighestLinearAddress ;
    DWORD   LargestMemoryBlock	;
    DWORD   MinimumUnitValue ;
    DWORD   MemoryAlignValue ;
    BYTE    res[76];
    } DPMI10INFO;

typedef struct {
    WORD    bits;
    WORD    res1;
    WORD    res2;
    } DPMICAP ;

int	GetMultipleDescriptors(WORD, WORD *);
int	SetMultipleDescriptors(WORD, WORD *);
int	GetProtModeExceptionVector32(BYTE, WORD *, DWORD *);
int	GetRealModeExceptionVector32(BYTE, WORD *, DWORD *);
int	SetProtModeExceptionVector32(BYTE, WORD, DWORD);
int	SetRealModeExceptionVector32(BYTE, WORD, DWORD);
int	GetDPMICapabilities(DPMICAP *,BYTE *);
int	AllocLinearMemory(DWORD bytes,DWORD linaddress,DWORD flags,DWORD *handle,DWORD *memaddress);
int	ResizeLinearMemory(DWORD bytes,DWORD handle,DWORD flags,DWORD *newhandle,DWORD *newmemaddress);
int	GetPageAttibutes(DWORD handle,DWORD offs,DWORD bytes,WORD *attr);
int	ModifyPageAttibutes(DWORD handle,DWORD offs,DWORD bytes,void *attr);
int	MapDeviceInMemoryBlock(DWORD handle,DWORD offs,DWORD bytes,DWORD device);
int	GetMemoryBlockData(DWORD handle,DWORD *addr,DWORD *bytes);
int	GetMemoryInfo(DPMI10INFO *);
int	FreePhysicalMapping(DWORD address);

#endif /* _DPMI10_H */
